/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.taterzens.fabric.compatibility.carpet;

import carpet.script.value.Value;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;
import org.samo_lego.taterzens.Taterzens;
import org.samo_lego.taterzens.api.TaterzensAPI;
import org.samo_lego.taterzens.api.professions.TaterzenProfession;
import org.samo_lego.taterzens.commands.NpcCommand;
import org.samo_lego.taterzens.commands.ProfessionCommand;
import org.samo_lego.taterzens.fabric.compatibility.carpet.ScarpetProfession;
import org.samo_lego.taterzens.interfaces.ITaterzenEditor;
import org.samo_lego.taterzens.npc.TaterzenNPC;
import org.samo_lego.taterzens.util.TextUtil;

public class ScarpetTraitCommand {
    public static void register() {
        LiteralCommandNode scarpet = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"scarpetTraits").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.profession.scarpet", Taterzens.config.perms.professionCommandPL))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.profession.scarpet.add", Taterzens.config.perms.professionCommandPL))).then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.word()).executes(ScarpetTraitCommand::addTrait)))).then(class_2170.method_9247((String)"list").executes(ScarpetTraitCommand::listScarpetTraits))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.profession.scarpet.remove", Taterzens.config.perms.professionCommandPL))).then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.word()).suggests(ScarpetTraitCommand::suggestRemovableTraits).executes(ScarpetTraitCommand::removeTrait)))).executes(ScarpetTraitCommand::listScarpetTraits)).build();
        ProfessionCommand.PROFESSION_COMMAND_NODE.addChild((CommandNode)scarpet);
    }

    private static int listScarpetTraits(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        return NpcCommand.selectedTaterzenExecutor(source.method_9229(), taterzen -> {
            TaterzenProfession profession = taterzen.getProfession(ScarpetProfession.ID);
            if (profession instanceof ScarpetProfession) {
                ScarpetProfession scarpetProfession = (ScarpetProfession)profession;
                HashSet<Value> traitIds = scarpetProfession.getTraits();
                class_5250 response = TextUtil.joinText("taterzens.command.trait.list", class_124.field_1075, class_124.field_1054, taterzen.method_5477().getString());
                AtomicInteger i = new AtomicInteger();
                traitIds.forEach(trait -> {
                    int index = i.get() + 1;
                    String id = trait.getString();
                    response.method_10852((class_2561)class_2561.method_43470((String)("\n" + index + "-> " + id + " (")).method_27692(index % 2 == 0 ? class_124.field_1054 : class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)"X").method_27692(class_124.field_1061).method_27692(class_124.field_1067).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)TextUtil.translate("taterzens.tooltip.delete", id))).method_10958(new class_2558(class_2558.class_2559.field_11745, "/trait scarpet remove " + id)))).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1070)));
                    i.incrementAndGet();
                });
                source.method_9226(() -> response, false);
            } else {
                source.method_9213((class_2561)TextUtil.errorText("taterzens.profession.lacking", ScarpetProfession.ID.toString()));
            }
        });
    }

    private static int removeTrait(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        String id = StringArgumentType.getString(context, (String)"id");
        return NpcCommand.selectedTaterzenExecutor(source.method_9229(), taterzen -> {
            TaterzenProfession profession = taterzen.getProfession(ScarpetProfession.ID);
            if (profession instanceof ScarpetProfession) {
                ScarpetProfession scarpetProfession = (ScarpetProfession)profession;
                if (scarpetProfession.removeTrait(id)) {
                    source.method_9226(() -> TextUtil.successText("taterzens.command.trait.remove", id), false);
                } else {
                    ((class_2168)context.getSource()).method_9213((class_2561)TextUtil.errorText("taterzens.command.trait.error.404", id));
                }
            } else {
                source.method_9213((class_2561)TextUtil.errorText("taterzens.profession.lacking", ScarpetProfession.ID.toString()));
            }
        });
    }

    private static int addTrait(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        String id = StringArgumentType.getString(context, (String)"id");
        return NpcCommand.selectedTaterzenExecutor(source.method_9229(), taterzen -> {
            TaterzenProfession profession = taterzen.getProfession(ScarpetProfession.ID);
            if (profession instanceof ScarpetProfession) {
                ScarpetProfession scarpetProfession = (ScarpetProfession)profession;
                scarpetProfession.addTrait(id);
                source.method_9226(() -> TextUtil.successText("taterzens.command.trait.add", id), false);
            } else {
                source.method_9213((class_2561)TextUtil.errorText("taterzens.profession.lacking", ScarpetProfession.ID.toString()));
            }
        });
    }

    private static CompletableFuture<Suggestions> suggestRemovableTraits(CommandContext<class_2168> ctx, SuggestionsBuilder builder) {
        HashSet<Object> traits = new HashSet();
        try {
            TaterzenProfession taterzenProfession;
            Optional<TaterzenNPC> taterzen = ((ITaterzenEditor)((class_2168)ctx.getSource()).method_9207()).getSelectedNpc();
            if (taterzen.isPresent() && (taterzenProfession = taterzen.get().getProfession(ScarpetProfession.ID)) instanceof ScarpetProfession) {
                ScarpetProfession scarpetProfession = (ScarpetProfession)taterzenProfession;
                traits = scarpetProfession.getTraits();
            }
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return class_2172.method_9264(traits.stream().map(Value::getPrettyString), (SuggestionsBuilder)builder);
    }

    static {
        TaterzensAPI.registerProfession(ScarpetProfession.ID, ScarpetProfession::new);
    }
}

