/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.taterzens.mixin.network;

import com.google.gson.JsonParseException;
import com.mojang.brigadier.StringReader;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5250;
import net.minecraft.class_7471;
import org.samo_lego.taterzens.Taterzens;
import org.samo_lego.taterzens.interfaces.ITaterzenEditor;
import org.samo_lego.taterzens.npc.TaterzenNPC;
import org.samo_lego.taterzens.util.TextUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3324.class})
public class ServerGamePacketListenerImplMixin_MsgEditor {
    @Inject(method={"broadcastChatMessage(Lnet/minecraft/network/chat/PlayerChatMessage;Ljava/util/function/Predicate;Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/network/chat/ChatType$Bound;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void taterzens_chatBroadcast(class_7471 playerChatMessage, Predicate<class_3222> predicate, class_3222 player, class_2556.class_7602 bound, CallbackInfo ci) {
        if (player == null) {
            return;
        }
        ITaterzenEditor editor = (ITaterzenEditor)player;
        Optional<TaterzenNPC> taterzen = editor.getSelectedNpc();
        String msg = playerChatMessage.method_46291().getString();
        if (taterzen.isPresent() && ((ITaterzenEditor)player).getEditorMode() == ITaterzenEditor.EditorMode.MESSAGES && !msg.startsWith("/")) {
            if (msg.startsWith("delay")) {
                String[] split = msg.split(" ");
                if (split.length > 1) {
                    try {
                        int delay = Integer.parseInt(split[1]);
                        taterzen.get().setMessageDelay(editor.getEditingMessageIndex(), delay);
                        player.method_7353((class_2561)TextUtil.successText("taterzens.command.message.delay", String.valueOf(delay)), false);
                    }
                    catch (NumberFormatException delay) {}
                }
            } else {
                class_5250 text;
                if (msg.startsWith("{") && msg.endsWith("}") || msg.startsWith("[") && msg.endsWith("]")) {
                    try {
                        text = class_2561.class_2562.method_10879((StringReader)new StringReader(msg));
                    }
                    catch (JsonParseException ignored) {
                        player.method_7353((class_2561)TextUtil.translate("taterzens.error.invalid.text", new Object[0]).method_27692(class_124.field_1061), false);
                        ci.cancel();
                        return;
                    }
                } else {
                    text = class_2561.method_43470((String)msg);
                }
                if (editor.getEditingMessageIndex() != -1) {
                    taterzen.get().editMessage(editor.getEditingMessageIndex(), (class_2561)text);
                    player.method_7353((class_2561)TextUtil.successText("taterzens.command.message.changed", text.getString()), false);
                    if (Taterzens.config.messages.exitEditorAfterMsgEdit) {
                        ((ITaterzenEditor)player).setEditorMode(ITaterzenEditor.EditorMode.NONE);
                        editor.setEditingMessageIndex(-1);
                        player.method_7353((class_2561)TextUtil.translate("taterzens.command.equipment.exit", new Object[0]).method_27692(class_124.field_1076), false);
                    }
                } else {
                    taterzen.get().addMessage((class_2561)text);
                    player.method_7353((class_2561)TextUtil.successText("taterzens.command.message.editor.add", text.getString()), false);
                }
            }
            ci.cancel();
        }
    }
}

