/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.taterzens.mixin.player;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2626;
import net.minecraft.class_2675;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.samo_lego.taterzens.Taterzens;
import org.samo_lego.taterzens.interfaces.ITaterzenEditor;
import org.samo_lego.taterzens.npc.TaterzenNPC;
import org.samo_lego.taterzens.util.TextUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public class ServerPlayerMixinCast_ITaterzenEditor
implements ITaterzenEditor {
    @Unique
    private final class_3222 self = (class_3222)this;
    @Unique
    private TaterzenNPC selectedNpc;
    @Unique
    private int selectedMsgId = -1;
    @Unique
    private byte lastRenderTick;
    @Unique
    private ITaterzenEditor.EditorMode editorMode = ITaterzenEditor.EditorMode.NONE;

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        ITaterzenEditor editor = (ITaterzenEditor)this.self;
        if (editor.getSelectedNpc().isPresent()) {
            byte by = this.lastRenderTick;
            this.lastRenderTick = (byte)(by + 1);
            if (by > 4) {
                if (this.editorMode == ITaterzenEditor.EditorMode.PATH) {
                    ArrayList<class_2338> pathTargets = editor.getSelectedNpc().get().getPathTargets();
                    class_2390 effect = new class_2390(new Vector3f(Taterzens.config.path.color.red / 255.0f, Taterzens.config.path.color.green / 255.0f, Taterzens.config.path.color.blue / 255.0f), 1.0f);
                    for (int i = 0; i < pathTargets.size(); ++i) {
                        class_2338 pos = pathTargets.get(i);
                        class_2338 nextPos = pathTargets.get(i + 1 == pathTargets.size() ? 0 : i + 1);
                        int deltaX = pos.method_10263() - nextPos.method_10263();
                        int deltaY = pos.method_10264() - nextPos.method_10264();
                        int deltaZ = pos.method_10260() - nextPos.method_10260();
                        double distance = Math.sqrt(pos.method_10262((class_2382)nextPos));
                        for (double j = 0.0; j < distance; j += 0.5) {
                            double x = (double)pos.method_10263() - j / distance * (double)deltaX;
                            double y = (double)pos.method_10264() - j / distance * (double)deltaY;
                            double z = (double)pos.method_10260() - j / distance * (double)deltaZ;
                            class_2675 packet = new class_2675((class_2394)effect, true, x + 0.5, y + 1.5, z + 0.5, 0.1f, 0.1f, 0.1f, 1.0f, 1);
                            this.self.field_13987.method_14364((class_2596)packet);
                        }
                    }
                }
                if (this.editorMode != ITaterzenEditor.EditorMode.NONE) {
                    this.self.method_7353((class_2561)TextUtil.successText("taterzens.tooltip.current_editor", String.valueOf((Object)this.editorMode)), true);
                }
                this.lastRenderTick = 0;
            }
        }
    }

    @Override
    public void setEditorMode(ITaterzenEditor.EditorMode mode) {
        ITaterzenEditor editor = (ITaterzenEditor)this.self;
        if (editor.getSelectedNpc().isPresent()) {
            class_1937 world = this.self.method_37908();
            if (this.editorMode == ITaterzenEditor.EditorMode.PATH && mode != ITaterzenEditor.EditorMode.PATH) {
                editor.getSelectedNpc().get().getPathTargets().forEach(blockPos -> this.self.field_13987.method_14364((class_2596)new class_2626(blockPos, world.method_8320(blockPos))));
            } else if (this.editorMode != ITaterzenEditor.EditorMode.PATH && mode == ITaterzenEditor.EditorMode.PATH) {
                editor.getSelectedNpc().get().getPathTargets().forEach(blockPos -> this.self.field_13987.method_14364((class_2596)new class_2626(blockPos, class_2246.field_10002.method_9564())));
            }
            if (this.editorMode == ITaterzenEditor.EditorMode.MESSAGES && mode != ITaterzenEditor.EditorMode.MESSAGES) {
                this.setEditingMessageIndex(-1);
            }
        }
        this.editorMode = mode;
    }

    @Override
    public ITaterzenEditor.EditorMode getEditorMode() {
        return this.editorMode;
    }

    @Override
    public Optional<TaterzenNPC> getSelectedNpc() {
        return Optional.ofNullable(this.selectedNpc);
    }

    @Override
    public boolean selectNpc(@Nullable TaterzenNPC npc) {
        if (npc != null && !npc.allowEditBy((class_1297)this.self) && !Taterzens.getInstance().getPlatform().checkPermission(this.self.method_5671(), "taterzens.npc.select.bypass", Taterzens.config.perms.selectBypassLevel)) {
            return false;
        }
        if (this.getEditorMode() != ITaterzenEditor.EditorMode.NONE) {
            this.setEditorMode(ITaterzenEditor.EditorMode.NONE);
        }
        TaterzenNPC selectedNpc = this.selectedNpc;
        this.selectedNpc = npc;
        if (npc != null) {
            npc.sendProfileUpdates();
        }
        if (selectedNpc != null) {
            selectedNpc.sendProfileUpdates();
        }
        return true;
    }

    @Override
    public void setEditingMessageIndex(int selected) {
        this.selectedMsgId = selected;
    }

    @Override
    public int getEditingMessageIndex() {
        return this.selectedMsgId;
    }
}

