/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.taterzens.npc;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.util.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1331;
import net.minecraft.class_1335;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1355;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1381;
import net.minecraft.class_1400;
import net.minecraft.class_1407;
import net.minecraft.class_1409;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1811;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2613;
import net.minecraft.class_268;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3745;
import net.minecraft.class_3898;
import net.minecraft.class_3965;
import net.minecraft.class_4050;
import net.minecraft.class_4255;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.class_8111;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.samo_lego.taterzens.Taterzens;
import org.samo_lego.taterzens.api.TaterzensAPI;
import org.samo_lego.taterzens.api.professions.TaterzenProfession;
import org.samo_lego.taterzens.interfaces.ITaterzenEditor;
import org.samo_lego.taterzens.interfaces.ITaterzenPlayer;
import org.samo_lego.taterzens.mixin.accessors.AChunkMap;
import org.samo_lego.taterzens.mixin.accessors.AClientboundAddPlayerPacket;
import org.samo_lego.taterzens.mixin.accessors.AEntityTrackerEntry;
import org.samo_lego.taterzens.mixin.accessors.APlayer;
import org.samo_lego.taterzens.npc.NPCData;
import org.samo_lego.taterzens.npc.ai.goal.DirectPathGoal;
import org.samo_lego.taterzens.npc.ai.goal.LazyPathGoal;
import org.samo_lego.taterzens.npc.ai.goal.ReachMeleeAttackGoal;
import org.samo_lego.taterzens.npc.ai.goal.TeamRevengeGoal;
import org.samo_lego.taterzens.npc.ai.goal.TrackEntityGoal;
import org.samo_lego.taterzens.npc.ai.goal.TrackUuidGoal;
import org.samo_lego.taterzens.npc.commands.AbstractTaterzenCommand;
import org.samo_lego.taterzens.npc.commands.CommandGroups;
import org.samo_lego.taterzens.util.TextUtil;

public class TaterzenNPC
extends class_1314
implements class_3745,
class_1603 {
    private final NPCData npcData = new NPCData();
    private final CommandGroups commandGroups;
    private class_3222 fakePlayer;
    private final LinkedHashMap<class_2960, TaterzenProfession> professions = new LinkedHashMap();
    private GameProfile gameProfile;
    public final class_1361 lookPlayerGoal = new class_1361((class_1308)this, class_1657.class, 8.0f);
    public final class_1376 lookAroundGoal = new class_1376((class_1308)this);
    public final class_1379 wanderAroundFarGoal = new class_1379((class_1314)this, 1.0, 30);
    public final class_1347 swimGoal = new class_1347((class_1308)this);
    public final class_1400<class_1309> followTargetGoal = new class_1400((class_1308)this, class_1309.class, 100, false, true, target -> !this.method_5722((class_1297)target));
    public final class_1400<class_1588> followMonstersGoal = new class_1400((class_1308)this, class_1588.class, 100, false, true, target -> !this.method_5722((class_1297)target));
    public final TrackEntityGoal trackLivingGoal = new TrackEntityGoal(this, class_1309.class, target -> !(target instanceof class_3222) && target.method_5805());
    public final TrackEntityGoal trackPlayersGoal = new TrackEntityGoal(this, class_3222.class, target -> !((class_3222)target).method_14239() && target.method_5805());
    public final TrackUuidGoal trackUuidGoal = new TrackUuidGoal(this, entity -> entity.method_5667().equals(this.npcData.follow.targetUuid) && entity.method_5805());
    public final LazyPathGoal pathGoal = new LazyPathGoal(this, 1.0);
    public final DirectPathGoal directPathGoal = new DirectPathGoal(this, 1.0);
    public final class_1381 projectileAttackGoal = new class_1381((class_1603)this, 1.2, 40, 40.0f);
    public final ReachMeleeAttackGoal reachMeleeAttackGoal = new ReachMeleeAttackGoal(this, 1.2, false);
    public final TeamRevengeGoal revengeGoal = new TeamRevengeGoal(this, new Class[0]);
    public final class_1366 attackMonstersGoal = new class_1366((class_1314)this, 1.2, false);
    @Nullable
    private class_243 respawnPosition;
    private UUID lockedUuid;
    private final Map<UUID, Long> commandTimes = new HashMap<UUID, Long>();
    private class_3222 lookTarget;

    public TaterzenNPC(class_1937 world) {
        this(Taterzens.TATERZEN_TYPE.get(), world);
    }

    public TaterzenNPC(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.method_49477(0.6f);
        this.method_5952(true);
        this.method_5880(true);
        this.method_5665(this.method_5477());
        this.method_5684(Taterzens.config.defaults.invulnerable);
        this.method_5971();
        this.field_6194 = 0;
        this.method_6125(0.4f);
        this.gameProfile = new GameProfile(this.method_5667(), this.method_5477().getString());
        this.commandGroups = new CommandGroups(this);
        if (this.fakePlayer == null) {
            this.constructFakePlayer();
        }
        if (!Taterzens.config.defaults.ambientSounds.isEmpty()) {
            this.npcData.ambientSounds = new ArrayList<String>(Taterzens.config.defaults.ambientSounds);
        }
        if (!Taterzens.config.defaults.hurtSounds.isEmpty()) {
            this.npcData.hurtSounds = new ArrayList<String>(Taterzens.config.defaults.hurtSounds);
        }
        if (!Taterzens.config.defaults.deathSounds.isEmpty()) {
            this.npcData.deathSounds = new ArrayList<String>(Taterzens.config.defaults.deathSounds);
        }
    }

    public static class_5132.class_5133 createTaterzenAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23721, 3.25).method_26868(class_5134.field_23724, 2.0).method_26868(class_5134.field_23719, 0.2505).method_26868(class_5134.field_23720, 0.8).method_26868(class_5134.field_23717, 35.0);
    }

    public void constructFakePlayer() {
        this.fakePlayer = new class_3222(this.method_5682(), (class_3218)this.method_37908(), this.gameProfile);
        this.fakePlayer.method_5841().method_12778(APlayer.getPLAYER_MODE_CUSTOMISATION(), (Object)127);
        this.fakePlayer.method_5814(this.method_23317(), this.method_23318(), this.method_23321());
        this.fakePlayer.method_36457(this.method_36455());
        this.fakePlayer.method_36456(this.method_36454());
        this.fakePlayer.method_5847(this.field_6241);
        this.fakePlayer.method_5665(this.method_5476());
    }

    public void addAmbientSound(String ambientSound) {
        this.npcData.ambientSounds.add(ambientSound);
    }

    public void addHurtSound(String hurtSound) {
        this.npcData.hurtSounds.add(hurtSound);
    }

    public void addDeathSound(String deathSound) {
        this.npcData.deathSounds.add(deathSound);
    }

    public void removeAmbientSound(int index) {
        this.npcData.ambientSounds.remove(index);
    }

    public void removeHurtSound(int index) {
        this.npcData.hurtSounds.remove(index);
    }

    public void removeDeathSound(int index) {
        this.npcData.deathSounds.remove(index);
    }

    public boolean addCommand(AbstractTaterzenCommand command) {
        if (command.getType() == AbstractTaterzenCommand.CommandType.BUNGEE && !Taterzens.config.bungee.enableCommands) {
            return false;
        }
        return this.commandGroups.addCommand(command);
    }

    public boolean addCommand(AbstractTaterzenCommand command, int groupIndex) {
        if (command.getType() == AbstractTaterzenCommand.CommandType.BUNGEE && !Taterzens.config.bungee.enableCommands) {
            return false;
        }
        return ((ArrayList)this.commandGroups.get(groupIndex)).add(command);
    }

    public CommandGroups getCommandGroups() {
        return this.commandGroups;
    }

    public ArrayList<AbstractTaterzenCommand> getGroupCommands(int group) {
        return (ArrayList)this.commandGroups.get(group);
    }

    public void removeGroupCommand(int groupIndex, int commandIndex) {
        ((ArrayList)this.commandGroups.get(groupIndex)).remove(commandIndex);
    }

    public void clearAllCommands() {
        this.commandGroups.clear();
    }

    public void clearGroupCommands(int index) {
        this.commandGroups.remove(index);
    }

    protected int method_5691() {
        return this.npcData.permissionLevel;
    }

    public void setPermissionLevel(int newPermissionLevel) {
        this.npcData.permissionLevel = newPermissionLevel;
    }

    public void setMovement(NPCData.Movement movement) {
        this.npcData.movement = movement;
        this.field_6201.method_6280((class_1352)this.wanderAroundFarGoal);
        this.field_6201.method_6280((class_1352)this.directPathGoal);
        this.field_6201.method_6280((class_1352)this.pathGoal);
        this.field_6201.method_6280((class_1352)this.lookPlayerGoal);
        this.field_6201.method_6280((class_1352)this.lookAroundGoal);
        this.field_6201.method_6280((class_1352)this.trackLivingGoal);
        this.field_6201.method_6280((class_1352)this.trackUuidGoal);
        this.field_6201.method_6280((class_1352)this.trackPlayersGoal);
        this.npcData.follow.targetUuid = null;
        this.npcData.follow.type = NPCData.FollowTypes.NONE;
        this.trackPlayersGoal.resetTrackingEntity();
        this.trackLivingGoal.resetTrackingEntity();
        for (TaterzenProfession profession : this.professions.values()) {
            profession.onMovementSet(movement);
        }
        if (movement != NPCData.Movement.NONE && movement != NPCData.Movement.FORCED_LOOK) {
            int priority = 8;
            if (movement == NPCData.Movement.FORCED_PATH) {
                this.field_6201.method_6277(4, (class_1352)this.directPathGoal);
                priority = 5;
            } else if (movement == NPCData.Movement.PATH) {
                this.field_6201.method_6277(4, (class_1352)this.pathGoal);
            } else if (movement == NPCData.Movement.FREE) {
                this.field_6201.method_6277(6, (class_1352)this.wanderAroundFarGoal);
            }
            this.field_6201.method_6277(priority, (class_1352)this.lookPlayerGoal);
            this.field_6201.method_6277(priority + 1, (class_1352)this.lookAroundGoal);
        }
        if (this.getTag("AllowSwimming", Taterzens.config.defaults.allowSwim)) {
            this.field_6201.method_6277(0, (class_1352)this.swimGoal);
        }
    }

    public NPCData.Movement getMovement() {
        return this.npcData.movement;
    }

    public void addPathTarget(class_2338 blockPos) {
        this.npcData.pathTargets.add(blockPos);
        this.method_18408(this.npcData.pathTargets.get(0), 1);
    }

    public class_2945 method_5841() {
        if (this.fakePlayer == null) {
            this.constructFakePlayer();
        }
        return this.fakePlayer.method_5841();
    }

    public void method_5660(boolean sneaking) {
        this.fakePlayer.method_5660(sneaking);
        super.method_5660(sneaking);
    }

    public void method_18380(class_4050 pose) {
        this.fakePlayer.method_18380(pose);
        super.method_18380(pose);
    }

    public void removePathTarget(class_2338 blockPos) {
        this.npcData.pathTargets.remove(blockPos);
    }

    public ArrayList<class_2338> getPathTargets() {
        return this.npcData.pathTargets;
    }

    public void clearPathTargets() {
        this.npcData.pathTargets = new ArrayList();
        this.npcData.currentMoveTarget = 0;
    }

    public void method_6007() {
        if (this.npcData.equipmentEditor != null) {
            return;
        }
        block5: for (TaterzenProfession profession : this.professions.values()) {
            class_1269 result = profession.tickMovement();
            switch (result) {
                case field_21466: {
                    break block5;
                }
                case field_5814: {
                    return;
                }
                case field_5812: {
                    super.method_6007();
                    return;
                }
                default: {
                    continue block5;
                }
            }
        }
        if (this.npcData.movement != NPCData.Movement.NONE && this.npcData.movement != NPCData.Movement.FORCED_LOOK) {
            this.method_36456(this.field_6241);
            class_1309 target = this.method_5968();
            if (!(this.npcData.movement != NPCData.Movement.FORCED_PATH && this.npcData.movement != NPCData.Movement.PATH || this.npcData.pathTargets.isEmpty() || this.method_6150())) {
                if (this.npcData.currentMoveTarget >= this.npcData.pathTargets.size()) {
                    this.npcData.currentMoveTarget = 0;
                }
                if (this.method_18412().method_19770((class_2374)this.method_19538()) < 5.0) {
                    if (++this.npcData.currentMoveTarget >= this.npcData.pathTargets.size()) {
                        this.npcData.currentMoveTarget = 0;
                    }
                    this.method_18408(this.npcData.pathTargets.get(this.npcData.currentMoveTarget), 1);
                }
            }
            super.method_6007();
            if (this.method_6510() && this.getTag("JumpAttack", Taterzens.config.defaults.jumpWhileAttacking) && this.method_24828() && target != null && this.method_5858((class_1297)target) < 4.0 && this.field_5974.method_43048(5) == 0) {
                this.method_6043();
            }
        } else if (this.method_5805() && !this.field_6272) {
            List list = this.method_37908().method_18467(class_1542.class, this.method_5829().method_1009(1.0, 0.0, 1.0));
            for (class_1542 itemEntity : list) {
                if (itemEntity.method_31481() || itemEntity.method_6983().method_7960() || itemEntity.method_6977() || !this.method_20820(itemEntity.method_6983())) continue;
                this.method_5949(itemEntity);
            }
        }
    }

    public void method_5773() {
        super.method_5773();
        class_238 box = this.method_5829().method_1014(4.0);
        List players = this.method_37908().method_18467(class_3222.class, box);
        if (!this.npcData.messages.isEmpty()) {
            for (class_3222 player : players) {
                if (((ITaterzenEditor)player).getEditorMode() == ITaterzenEditor.EditorMode.MESSAGES || this.method_5739((class_1297)player) > Taterzens.config.messages.speakDistance) continue;
                ITaterzenPlayer pl = (ITaterzenPlayer)player;
                int msgPos = pl.getLastMsgPos(this.method_5667());
                if (msgPos >= this.npcData.messages.size()) {
                    msgPos = 0;
                }
                if ((Integer)this.npcData.messages.get(msgPos).getSecond() >= pl.ticksSinceLastMessage(this.method_5667())) continue;
                player.method_43496((class_2561)class_2561.method_43469((String)Taterzens.config.messages.structure, (Object[])new Object[]{this.method_5477().method_27661(), this.npcData.messages.get(msgPos).getFirst()}));
                pl.resetMessageTicks(this.method_5667());
                pl.setLastMsgPos(this.method_5667(), ++msgPos);
            }
        }
        if (!players.isEmpty()) {
            if (this.npcData.movement == NPCData.Movement.FORCED_LOOK) {
                if (this.lookTarget == null || (double)this.method_5739((class_1297)this.lookTarget) > 5.0 || this.lookTarget.method_14239() || !this.lookTarget.method_5805()) {
                    this.lookTarget = (class_3222)players.get(this.field_5974.method_43048(players.size()));
                }
                this.method_5951((class_1297)this.lookTarget, 60.0f, 60.0f);
                this.method_5847(this.method_36454());
            }
            for (TaterzenProfession profession : this.professions.values()) {
                profession.onPlayersNearby(players);
            }
        }
    }

    public class_2596<class_2602> method_18002() {
        class_2613 addPlayerPacket = new class_2613((class_1657)this.fakePlayer);
        AClientboundAddPlayerPacket addPlayerPacketAccessor = (AClientboundAddPlayerPacket)addPlayerPacket;
        addPlayerPacketAccessor.setId(this.method_5628());
        addPlayerPacketAccessor.setUuid(this.method_5667());
        addPlayerPacketAccessor.setX(this.method_23317());
        addPlayerPacketAccessor.setY(this.method_23318());
        addPlayerPacketAccessor.setZ(this.method_23321());
        addPlayerPacketAccessor.setYRot((byte)(this.method_5791() * 256.0f / 360.0f));
        addPlayerPacketAccessor.setXRot((byte)(this.method_36455() * 256.0f / 360.0f));
        return addPlayerPacket;
    }

    public GameProfile getGameProfile() {
        return this.gameProfile;
    }

    public class_2561 getTabListName() {
        if (!Taterzens.config.obscureTabList) {
            return this.method_5477();
        }
        class_5250 component = class_2561.method_43470((String)"").method_27692(class_124.field_1063);
        component.method_10852(this.method_5477());
        component.method_27693(" [NPC]");
        return component;
    }

    public void method_5665(class_2561 name) {
        super.method_5665(name);
        String profileName = "Taterzen";
        if (name != null) {
            profileName = name.getString();
            if (name.getString().length() > 16) {
                profileName = name.getString().substring(0, 16);
            }
        }
        class_2487 skin = null;
        if (this.gameProfile != null) {
            skin = this.writeSkinToTag(this.gameProfile);
        }
        this.gameProfile = new GameProfile(this.method_5667(), profileName);
        if (skin != null) {
            this.setSkinFromTag(skin);
            this.sendProfileUpdates();
        }
    }

    public void sendProfileUpdates() {
        if (this.method_37908().method_8608()) {
            return;
        }
        class_3215 manager = (class_3215)this.method_37908().method_8398();
        class_3898 storage = manager.field_17254;
        AEntityTrackerEntry trackerEntry = (AEntityTrackerEntry)((AChunkMap)storage).getEntityMap().get(this.method_5628());
        if (trackerEntry != null) {
            trackerEntry.getSeenBy().forEach(tracking -> trackerEntry.getPlayer().method_18760(tracking.method_32311()));
        }
    }

    public void applySkin(GameProfile texturesProfile) {
        if (this.gameProfile == null) {
            return;
        }
        this.setSkinFromTag(this.writeSkinToTag(texturesProfile));
        this.sendProfileUpdates();
    }

    public void setSkinFromTag(class_2487 tag) {
        try {
            PropertyMap map = this.gameProfile.getProperties();
            Property skin = (Property)map.get((Object)"textures").iterator().next();
            map.remove((Object)"textures", (Object)skin);
        }
        catch (NoSuchElementException map) {
            // empty catch block
        }
        try {
            String value = tag.method_10558("value");
            String signature = tag.method_10558("signature");
            if (!value.isEmpty() && !signature.isEmpty()) {
                PropertyMap propertyMap = this.gameProfile.getProperties();
                propertyMap.put((Object)"textures", (Object)new Property("textures", value, signature));
            }
        }
        catch (Error error) {
            // empty catch block
        }
    }

    public class_2487 writeSkinToTag(GameProfile profile) {
        class_2487 skinTag = new class_2487();
        try {
            PropertyMap propertyMap = profile.getProperties();
            Property skin = (Property)propertyMap.get((Object)"textures").iterator().next();
            skinTag.method_10582("value", skin.getValue());
            skinTag.method_10582("signature", skin.getSignature());
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return skinTag;
    }

    public void method_5749(class_2487 tag) {
        class_2487 followTag;
        class_2499 deathSounds;
        class_2499 hurtSounds;
        super.method_5749(tag);
        if (tag.method_10545("PresetOverride")) {
            this.loadPresetTag(tag);
            return;
        }
        class_2487 npcTag = tag.method_10562("TaterzenNPCTag");
        class_2487 tags = npcTag.method_10562("Tags");
        for (String key : tags.method_10541()) {
            this.setTag(key, tags.method_10577(key));
        }
        this.setSkinLayers(npcTag.method_10571("SkinLayers"));
        class_2499 ambientSounds = (class_2499)npcTag.method_10580("AmbientSounds");
        if (ambientSounds != null) {
            this.npcData.ambientSounds.clear();
            ambientSounds.forEach(snd -> this.addAmbientSound(snd.method_10714()));
        }
        if ((hurtSounds = (class_2499)npcTag.method_10580("HurtSounds")) != null) {
            this.npcData.hurtSounds.clear();
            hurtSounds.forEach(snd -> this.addHurtSound(snd.method_10714()));
        }
        if ((deathSounds = (class_2499)npcTag.method_10580("DeathSounds")) != null) {
            this.npcData.deathSounds.clear();
            deathSounds.forEach(snd -> this.addDeathSound(snd.method_10714()));
        }
        class_2499 commands = (class_2499)npcTag.method_10580("Commands");
        class_2499 bungeeCommands = (class_2499)npcTag.method_10580("BungeeCommands");
        if (commands != null && bungeeCommands != null) {
            this.commandGroups.fromOldTag(commands, bungeeCommands);
        }
        class_2487 cmds = npcTag.method_10562("CommandGroups");
        this.commandGroups.fromTag(cmds);
        class_2499 pathTargets = (class_2499)npcTag.method_10580("PathTargets");
        if (pathTargets != null && pathTargets.size() > 0) {
            pathTargets.forEach(posTag -> {
                if (posTag instanceof class_2487) {
                    class_2487 pos = (class_2487)posTag;
                    class_2338 target = new class_2338(pos.method_10550("x"), pos.method_10550("y"), pos.method_10550("z"));
                    this.addPathTarget(target);
                }
            });
            this.method_18408(this.npcData.pathTargets.get(0), 1);
        }
        this.npcData.currentMoveTarget = npcTag.method_10550("CurrentMoveTarget");
        class_2499 messages = (class_2499)npcTag.method_10580("Messages");
        if (messages != null && messages.size() > 0) {
            messages.forEach(msgTag -> {
                class_2487 msgCompound = (class_2487)msgTag;
                this.addMessage((class_2561)TextUtil.fromNbtElement(msgCompound.method_10580("Message")), msgCompound.method_10550("Delay"));
            });
        }
        this.setPermissionLevel(npcTag.method_10550("PermissionLevel"));
        if (npcTag.method_10545("Behaviour")) {
            this.setBehaviour(NPCData.Behaviour.valueOf(npcTag.method_10558("Behaviour")));
        } else {
            this.setBehaviour(NPCData.Behaviour.PASSIVE);
        }
        String profileName = this.method_5477().getString();
        if (profileName.length() > 16) {
            profileName = profileName.substring(0, 16);
        }
        this.gameProfile = new GameProfile(this.method_5667(), profileName);
        class_2487 skinTag = npcTag.method_10562("skin");
        this.setSkinFromTag(skinTag);
        class_2499 professions = (class_2499)npcTag.method_10580("Professions");
        if (professions != null && professions.size() > 0) {
            professions.forEach(professionTag -> {
                class_2487 professionCompound = (class_2487)professionTag;
                class_2960 professionId = new class_2960(professionCompound.method_10558("ProfessionType"));
                if (Taterzens.PROFESSION_TYPES.containsKey(professionId)) {
                    TaterzenProfession profession = Taterzens.PROFESSION_TYPES.get(professionId).apply(this);
                    this.addProfession(professionId, profession);
                    profession.readNbt(professionCompound.method_10562("ProfessionData"));
                } else {
                    Taterzens.LOGGER.error("Taterzen {} was saved with profession id {}, but none of the mods provides it.", (Object)this.method_5477().getString(), (Object)professionId);
                }
            });
        }
        if ((followTag = npcTag.method_10562("Follow")).method_10545("Type")) {
            this.setFollowType(NPCData.FollowTypes.valueOf(followTag.method_10558("Type")));
        }
        if (followTag.method_10545("UUID")) {
            this.setFollowUuid(followTag.method_25926("UUID"));
        }
        if (npcTag.method_10545("Pose")) {
            this.method_18380(class_4050.valueOf((String)npcTag.method_10558("Pose")));
        } else {
            this.method_18380(class_4050.field_18076);
        }
        if (npcTag.method_10545("movement")) {
            this.setMovement(NPCData.Movement.valueOf(npcTag.method_10558("movement")));
        } else {
            this.setMovement(NPCData.Movement.NONE);
        }
        if (npcTag.method_10545("LockedBy")) {
            this.lockedUuid = npcTag.method_25926("LockedBy");
        }
        if (npcTag.method_10545("AllowFlight")) {
            this.setAllowFlight(npcTag.method_10577("AllowFlight"));
        }
        if (npcTag.method_10545("AllowSwimming")) {
            this.setAllowSwimming(npcTag.method_10577("AllowSwimming"));
        }
        this.setMinCommandInteractionTime(npcTag.method_10537("MinCommandInteractionTime"));
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        class_2487 npcTag = new class_2487();
        super.method_5880(tag.method_10545("CustomNameVisible"));
        npcTag.method_10582("movement", this.npcData.movement.toString());
        class_2487 tags = new class_2487();
        for (Map.Entry<String, Boolean> entry : this.npcData.booleanTags.entrySet()) {
            tags.method_10556(entry.getKey(), entry.getValue().booleanValue());
        }
        npcTag.method_10566("Tags", (class_2520)tags);
        npcTag.method_10567("SkinLayers", ((Byte)this.fakePlayer.method_5841().method_12789(APlayer.getPLAYER_MODE_CUSTOMISATION())).byteValue());
        class_2499 ambientSounds = new class_2499();
        this.npcData.ambientSounds.forEach(snd -> ambientSounds.add((Object)class_2519.method_23256((String)snd)));
        npcTag.method_10566("AmbientSounds", (class_2520)ambientSounds);
        class_2499 hurtSounds = new class_2499();
        this.npcData.hurtSounds.forEach(snd -> hurtSounds.add((Object)class_2519.method_23256((String)snd)));
        npcTag.method_10566("HurtSounds", (class_2520)hurtSounds);
        class_2499 deathSounds = new class_2499();
        this.npcData.deathSounds.forEach(snd -> deathSounds.add((Object)class_2519.method_23256((String)snd)));
        npcTag.method_10566("DeathSounds", (class_2520)deathSounds);
        class_2487 cmds = new class_2487();
        this.commandGroups.toTag(cmds);
        npcTag.method_10566("CommandGroups", (class_2520)cmds);
        npcTag.method_10566("skin", (class_2520)this.writeSkinToTag(this.gameProfile));
        class_2499 pathTargets = new class_2499();
        this.npcData.pathTargets.forEach(blockPos -> {
            class_2487 pos = new class_2487();
            pos.method_10569("x", blockPos.method_10263());
            pos.method_10569("y", blockPos.method_10264());
            pos.method_10569("z", blockPos.method_10260());
            pathTargets.add((Object)pos);
        });
        npcTag.method_10566("PathTargets", (class_2520)pathTargets);
        npcTag.method_10569("CurrentMoveTarget", this.npcData.currentMoveTarget);
        class_2499 messages = new class_2499();
        this.npcData.messages.forEach((Consumer<Pair<class_2561, Integer>>)((Consumer<Pair>)pair -> {
            class_2487 msg = new class_2487();
            msg.method_10566("Message", TextUtil.toNbtElement((class_2561)pair.getFirst()));
            msg.method_10569("Delay", ((Integer)pair.getSecond()).intValue());
            messages.add((Object)msg);
        }));
        npcTag.method_10566("Messages", (class_2520)messages);
        npcTag.method_10569("PermissionLevel", this.npcData.permissionLevel);
        npcTag.method_10582("Behaviour", this.npcData.behaviour.toString());
        class_2499 professions = new class_2499();
        this.professions.forEach((id, profession) -> {
            class_2487 professionCompound = new class_2487();
            professionCompound.method_10582("ProfessionType", id.toString());
            class_2487 professionData = new class_2487();
            profession.saveNbt(professionData);
            professionCompound.method_10566("ProfessionData", (class_2520)professionData);
            professions.add((Object)professionCompound);
        });
        npcTag.method_10566("Professions", (class_2520)professions);
        class_2487 followTag = new class_2487();
        followTag.method_10582("Type", this.npcData.follow.type.toString());
        if (this.npcData.follow.targetUuid != null) {
            followTag.method_25927("UUID", this.npcData.follow.targetUuid);
        }
        npcTag.method_10566("Follow", (class_2520)followTag);
        npcTag.method_10582("Pose", this.method_18376().toString());
        if (this.lockedUuid != null) {
            npcTag.method_25927("LockedBy", this.lockedUuid);
        }
        npcTag.method_10544("MinCommandInteractionTime", this.npcData.minCommandInteractionTime);
        tag.method_10566("TaterzenNPCTag", (class_2520)npcTag);
    }

    private void loadPresetTag(class_2487 tag) {
        String preset = tag.method_10558("PresetOverride") + ".json";
        File presetFile = new File(Taterzens.getInstance().getPresetDirectory() + "/" + preset);
        if (presetFile.exists()) {
            this.loadFromPresetFile(presetFile, preset);
        }
    }

    public void loadFromPresetFile(File presetFile, String presetName) {
        class_2487 saveTag = TaterzensAPI.loadPresetTag(presetFile);
        saveTag.method_10582("UUID", this.method_5845());
        if (!presetName.isEmpty() && presetName.equals(saveTag.method_10558("PresetOverride"))) {
            saveTag.method_10551("PresetOverride");
            Taterzens.LOGGER.warn("Preset override loop detected in {}. Aborting it.", (Object)presetName);
        }
        class_243 savedPos = this.method_30950(0.0f);
        this.method_5651(saveTag);
        this.method_33574(savedPos);
        class_2487 npcTag = (class_2487)saveTag.method_10580("TaterzenNPCTag");
        if (npcTag != null) {
            String savedTeam = npcTag.method_10558("SavedTeam");
            class_268 team = this.method_37908().method_8428().method_1153(savedTeam);
            if (team != null) {
                this.method_37908().method_8428().method_1172(this.method_5820(), team);
            }
        }
    }

    public void setEquipmentEditor(@Nullable class_1657 player) {
        this.npcData.equipmentEditor = player;
    }

    public boolean isEquipmentEditor(@NotNull class_1657 player) {
        return player.equals((Object)this.npcData.equipmentEditor);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (this.method_37908().method_8608()) {
            return class_1269.field_5811;
        }
        ITaterzenPlayer ipl = (ITaterzenPlayer)player;
        long lastAction = ((class_3222)player).method_14219();
        if (lastAction - ipl.getLastInteractionTime() < 50L) {
            return class_1269.field_5814;
        }
        ipl.setLastInteraction(lastAction);
        for (TaterzenProfession taterzenProfession : this.professions.values()) {
            class_1269 professionResult = taterzenProfession.interactAt(player, player.method_19538(), hand);
            if (professionResult == class_1269.field_5811) continue;
            return professionResult;
        }
        if (this.isEquipmentEditor(player)) {
            class_1799 stack = player.method_5998(hand).method_7972();
            if (stack.method_7960() && player.method_5715()) {
                this.method_6099(this.method_48923().method_48802(player), 1, this.isEquipmentDropsAllowed());
                for (class_1304 slot : class_1304.values()) {
                    this.fakePlayer.method_5673(slot, class_1799.field_8037);
                }
            } else if (player.method_5715()) {
                this.method_5673(class_1304.field_6173, stack);
                this.fakePlayer.method_5673(class_1304.field_6173, stack);
            } else {
                class_1304 class_13042 = TaterzenNPC.method_32326((class_1799)stack);
                this.method_24834(class_13042, stack);
                this.fakePlayer.method_5673(class_13042, stack);
            }
            this.setBehaviour(this.npcData.behaviour);
            return class_1269.field_5811;
        }
        if (player.method_5998(hand).method_7909().equals(class_1802.field_8567) && player.method_5715() && Taterzens.getInstance().getPlatform().checkPermission(player.method_5671(), "taterzens.npc.select", Taterzens.config.perms.npcCommandPermissionLevel)) {
            ((ITaterzenEditor)player).selectNpc(this);
            player.method_43496((class_2561)TextUtil.successText("taterzens.command.select", this.method_5477().getString()));
            return class_1269.field_5811;
        }
        if (((ITaterzenEditor)player).getSelectedNpc().isPresent() && ((ITaterzenEditor)player).getSelectedNpc().get() == this) {
            Taterzens.getInstance().getPlatform().openEditorGui((class_3222)player);
        }
        if (this.npcData.minCommandInteractionTime != -1L) {
            long now = System.currentTimeMillis();
            long diff = (now - this.commandTimes.getOrDefault(player.method_5667(), 0L)) / 1000L;
            if (diff > this.npcData.minCommandInteractionTime || this.npcData.minCommandInteractionTime == 0L) {
                this.commandTimes.put(player.method_5667(), now);
                this.commandGroups.execute((class_3222)player);
            } else {
                player.method_43496((class_2561)TextUtil.errorText(this.npcData.commandCooldownMessage, String.valueOf(this.npcData.minCommandInteractionTime - diff)));
            }
        }
        return this.method_5688(player, hand);
    }

    public void setCooldownMessage(String message) {
        this.npcData.commandCooldownMessage = message;
    }

    public void setMinCommandInteractionTime(long time) {
        this.npcData.minCommandInteractionTime = time;
    }

    protected void method_6099(class_1282 source, int lootingMultiplier, boolean allowDrops) {
        if (this.isEquipmentDropsAllowed()) {
            super.method_6099(source, lootingMultiplier, allowDrops);
        } else {
            for (class_1304 slot : class_1304.values()) {
                this.method_5673(slot, class_1799.field_8037);
            }
        }
    }

    protected boolean method_27071() {
        return this.isEquipmentDropsAllowed();
    }

    public boolean method_6054() {
        return this.isEquipmentDropsAllowed();
    }

    public void addMessage(class_2561 text) {
        this.addMessage(text, Taterzens.config.messages.messageDelay);
    }

    public void addMessage(class_2561 text, int delay) {
        this.npcData.messages.add((Pair<class_2561, Integer>)new Pair((Object)text, (Object)delay));
    }

    public void editMessage(int index, class_2561 text) {
        if (index >= 0 && index < this.npcData.messages.size()) {
            this.npcData.messages.set(index, (Pair<class_2561, Integer>)new Pair((Object)text, (Object)Taterzens.config.messages.messageDelay));
        }
    }

    public class_2561 removeMessage(int index) {
        if (index < this.npcData.messages.size()) {
            return (class_2561)this.npcData.messages.remove(index).getFirst();
        }
        return class_2561.method_43470((String)"");
    }

    public void setMessageDelay(int index, int delay) {
        if (index < this.npcData.messages.size()) {
            Pair newMsg = this.npcData.messages.get(index).mapSecond(previous -> delay);
            this.npcData.messages.set(index, (Pair<class_2561, Integer>)newMsg);
        }
    }

    public void clearMessages() {
        this.npcData.messages.clear();
    }

    public ArrayList<Pair<class_2561, Integer>> getMessages() {
        return this.npcData.messages;
    }

    public void method_5697(class_1297 entity) {
        if (this.getTag("Pushable", Taterzens.config.defaults.pushable)) {
            super.method_5697(entity);
        }
    }

    protected void method_6087(class_1297 entity) {
        if (this.getTag("Pushable", Taterzens.config.defaults.pushable)) {
            super.method_6087(entity);
        }
    }

    public void setPushable(boolean pushable) {
        this.setTag("Pushable", pushable);
    }

    public boolean method_5698(class_1297 attacker) {
        class_1657 pl;
        if (attacker instanceof class_1657 && this.isEquipmentEditor(pl = (class_1657)attacker)) {
            class_1799 main = this.method_6047();
            this.method_6122(class_1268.field_5808, this.method_6079());
            this.method_6122(class_1268.field_5810, main);
            return true;
        }
        for (TaterzenProfession profession : this.professions.values()) {
            if (!profession.handleAttack(attacker)) continue;
            return true;
        }
        return this.method_5655();
    }

    public boolean method_5679(class_1282 damageSource) {
        return this.method_31481() || this.method_5655() && !damageSource.method_49708(class_8111.field_44869);
    }

    protected boolean method_5972() {
        return false;
    }

    public boolean method_5931(class_1657 player) {
        return !this.method_5934() && this.isLeashable();
    }

    private boolean isLeashable() {
        return this.getTag("Leashable", Taterzens.config.defaults.leashable);
    }

    public void setLeashable(boolean leashable) {
        this.setTag("Leashable", leashable);
    }

    public void method_5954(class_1297 entityIn, boolean sendAttachNotification) {
        super.method_5954(entityIn, sendAttachNotification);
    }

    protected void method_5959() {
        this.field_6201.method_6277(2, (class_1352)new class_4255((class_1308)this, true));
    }

    public void method_6078(class_1282 source) {
        class_4050 pose = this.method_18376();
        super.method_6078(source);
        if (this.respawnPosition != null) {
            this.method_37908().method_8421((class_1297)this, (byte)3);
            this.field_6272 = false;
            this.method_6033(this.method_6063());
            this.method_18800(0.0, 0.1, 0.0);
            this.method_33574(this.respawnPosition);
            this.method_18380(pose);
        } else {
            Taterzens.TATERZEN_NPCS.remove(this.method_5667());
            for (TaterzenProfession profession : this.professions.values()) {
                profession.onRemove();
            }
        }
    }

    public void method_5650(class_1297.class_5529 reason) {
        super.method_5650(reason);
        Taterzens.TATERZEN_NPCS.remove(this.method_5667());
        for (TaterzenProfession profession : this.professions.values()) {
            profession.onRemove();
        }
    }

    public void setBehaviour(NPCData.Behaviour level) {
        this.npcData.behaviour = level;
        this.field_6201.method_6280((class_1352)this.reachMeleeAttackGoal);
        this.field_6201.method_6280((class_1352)this.projectileAttackGoal);
        this.field_6201.method_6280((class_1352)this.attackMonstersGoal);
        this.field_6185.method_6280(this.followTargetGoal);
        this.field_6185.method_6280((class_1352)this.revengeGoal);
        this.field_6185.method_6280(this.followMonstersGoal);
        for (TaterzenProfession profession : this.professions.values()) {
            profession.onBehaviourSet(level);
        }
        switch (level) {
            case DEFENSIVE: {
                this.field_6185.method_6277(2, (class_1352)this.revengeGoal);
                this.setAttackGoal();
                break;
            }
            case FRIENDLY: {
                this.field_6185.method_6277(2, (class_1352)this.revengeGoal);
                this.field_6185.method_6277(3, this.followMonstersGoal);
                this.field_6201.method_6277(3, (class_1352)this.attackMonstersGoal);
                this.setAttackGoal();
                break;
            }
            case HOSTILE: {
                this.field_6185.method_6277(2, (class_1352)this.revengeGoal);
                this.field_6185.method_6277(3, this.followTargetGoal);
                this.setAttackGoal();
                break;
            }
        }
    }

    private void setAttackGoal() {
        class_1799 mainHandStack = this.method_6047();
        class_1799 offHandStack = this.method_6079();
        if (mainHandStack.method_7909() instanceof class_1811 || offHandStack.method_7909() instanceof class_1811) {
            this.field_6201.method_6277(3, (class_1352)this.projectileAttackGoal);
        } else {
            this.field_6201.method_6277(3, (class_1352)this.reachMeleeAttackGoal);
        }
    }

    public class_1355 getTargetSelector() {
        return this.field_6185;
    }

    public class_1355 getGoalSelector() {
        return this.field_6201;
    }

    public boolean method_25938(class_1811 weapon) {
        return this.npcData.behaviour != NPCData.Behaviour.PASSIVE;
    }

    public void method_7110(boolean charging) {
    }

    public void method_18811(class_1309 target, class_1799 crossbow, class_1676 projectile, float multiShotSpray) {
        class_1268 weaponHand = class_1675.method_18812((class_1309)this, (class_1792)class_1802.field_8399);
        this.fakePlayer.method_6019(weaponHand);
        this.method_6019(weaponHand);
        this.shootProjectile(target, projectile, multiShotSpray);
    }

    public void method_24651() {
    }

    public void method_7105(class_1309 target, float pullProgress) {
        for (TaterzenProfession profession : this.professions.values()) {
            if (!profession.cancelRangedAttack(target)) continue;
            return;
        }
        class_1268 weaponHand = class_1675.method_18812((class_1309)this, (class_1792)class_1802.field_8102);
        class_1799 bow = this.method_5998(weaponHand);
        class_1799 arrowType = this.method_18808(bow);
        if (arrowType.method_7960()) {
            arrowType = this.method_18808(this.method_5998(class_1675.method_18812((class_1309)this, (class_1792)class_1802.field_8399)));
        }
        class_1665 projectile = class_1675.method_18813((class_1309)this, (class_1799)arrowType.method_7972(), (float)pullProgress);
        this.fakePlayer.method_6019(weaponHand);
        this.method_6019(weaponHand);
        this.shootProjectile(target, (class_1676)projectile, 0.0f);
    }

    private void shootProjectile(class_1309 target, class_1676 projectile, float multishotSpray) {
        double deltaX = target.method_23317() - this.method_23317();
        double y = target.method_23323(0.3333333333333333) - projectile.method_23318();
        double deltaZ = target.method_23321() - this.method_23321();
        double planeDistance = class_3532.method_15355((float)((float)(deltaX * deltaX + deltaZ * deltaZ)));
        Vector3f launchVelocity = this.method_24653((class_1309)this, new class_243(deltaX, y + planeDistance * 0.2, deltaZ), multishotSpray);
        projectile.method_7485((double)launchVelocity.x(), (double)launchVelocity.y(), (double)launchVelocity.z(), 1.6f, 0.0f);
        this.method_5783(class_3417.field_14600, 1.0f, 0.125f);
        this.method_37908().method_8649((class_1297)projectile);
    }

    public boolean method_6121(class_1297 target) {
        for (TaterzenProfession profession : this.professions.values()) {
            if (!profession.cancelMeleeAttack(target)) continue;
            return false;
        }
        return super.method_6121(target);
    }

    protected class_3414 method_5994() {
        if (!this.npcData.allowSounds || this.npcData.ambientSounds.isEmpty()) {
            return null;
        }
        int rnd = this.field_5974.method_43048(this.npcData.ambientSounds.size());
        class_2960 sound = new class_2960(this.npcData.ambientSounds.get(rnd));
        return (class_3414)class_7923.field_41172.method_10223(sound);
    }

    public ArrayList<String> getAmbientSoundData() {
        return this.npcData.ambientSounds;
    }

    public void setAmbientSoundData(ArrayList<String> ambientSounds) {
        this.npcData.ambientSounds = ambientSounds;
    }

    protected class_3414 method_6011(class_1282 source) {
        if (!this.npcData.allowSounds || this.npcData.hurtSounds.isEmpty()) {
            return null;
        }
        int rnd = this.field_5974.method_43048(this.npcData.hurtSounds.size());
        class_2960 sound = new class_2960(this.npcData.hurtSounds.get(rnd));
        return (class_3414)class_7923.field_41172.method_10223(sound);
    }

    public ArrayList<String> getHurtSoundData() {
        return this.npcData.hurtSounds;
    }

    public void setHurtSoundData(ArrayList<String> hurtSounds) {
        this.npcData.hurtSounds = hurtSounds;
    }

    protected class_3414 method_6002() {
        if (!this.npcData.allowSounds || this.npcData.deathSounds.isEmpty()) {
            return null;
        }
        int rnd = this.field_5974.method_43048(this.npcData.deathSounds.size());
        class_2960 sound = new class_2960(this.npcData.deathSounds.get(rnd));
        return (class_3414)class_7923.field_41172.method_10223(sound);
    }

    public ArrayList<String> getDeathSoundData() {
        return this.npcData.deathSounds;
    }

    public void setDeathSoundData(ArrayList<String> deathSounds) {
        this.npcData.deathSounds = deathSounds;
    }

    public float method_6144(class_2338 pos, class_4538 world) {
        return 0.0f;
    }

    protected class_2561 method_23315() {
        return class_2561.method_43470((String)("-" + Taterzens.config.defaults.name + "-"));
    }

    public class_3222 getFakePlayer() {
        return this.fakePlayer;
    }

    public void allowEquipmentDrops(boolean drop) {
        this.setTag("DropsAllowed", drop);
    }

    public boolean isEquipmentDropsAllowed() {
        return this.getTag("DropsAllowed", Taterzens.config.defaults.dropEquipment);
    }

    public void addProfession(class_2960 professionId) {
        if (Taterzens.PROFESSION_TYPES.containsKey(professionId)) {
            this.addProfession(professionId, Taterzens.PROFESSION_TYPES.get(professionId).apply(this));
        } else {
            Taterzens.LOGGER.warn("Trying to add unknown profession {} to taterzen {}.", (Object)professionId, (Object)this.method_5477().getString());
        }
    }

    public void addProfession(class_2960 professionId, TaterzenProfession profession) {
        this.professions.put(professionId, profession);
    }

    public Collection<class_2960> getProfessionIds() {
        return this.professions.keySet();
    }

    public void removeProfession(class_2960 professionId) {
        TaterzenProfession toRemove = this.professions.get(professionId);
        if (toRemove != null) {
            toRemove.onProfessionRemoved();
            this.professions.remove(professionId);
        }
    }

    @Nullable
    public TaterzenProfession getProfession(class_2960 professionId) {
        return this.professions.get(professionId);
    }

    public boolean method_5936() {
        return true;
    }

    protected void method_5949(class_1542 item) {
        class_1799 stack = item.method_6983();
        for (TaterzenProfession profession : this.professions.values()) {
            if (!profession.tryPickupItem(item)) continue;
            this.method_29499(item);
            this.method_6103((class_1297)item, stack.method_7947());
            stack.method_7939(0);
            item.method_31472();
            return;
        }
    }

    public boolean interact(class_2338 pos) {
        if (this.method_19538().method_1022(class_243.method_24953((class_2382)pos)) < 4.0 && !this.method_37908().method_8608()) {
            this.lookAt(pos);
            this.method_6104(class_1268.field_5808);
            this.method_37908().method_8320(pos).method_26174(this.method_37908(), (class_1657)this.fakePlayer, class_1268.field_5808, new class_3965(class_243.method_24953((class_2382)pos), class_2350.field_11033, pos, false));
            this.method_6047().method_7913(this.method_37908(), (class_1657)this.fakePlayer, class_1268.field_5808);
            return true;
        }
        return false;
    }

    public void lookAt(class_2338 target) {
        class_243 vec3d = this.method_19538();
        double d = (double)target.method_10263() - vec3d.field_1352;
        double e = (double)target.method_10264() - vec3d.field_1351;
        double f = (double)target.method_10260() - vec3d.field_1350;
        double g = Math.sqrt(d * d + f * f);
        this.method_36457(class_3532.method_15393((float)((float)(-(class_3532.method_15349((double)e, (double)g) * 57.2957763671875)))));
        this.method_5636(class_3532.method_15393((float)((float)(class_3532.method_15349((double)f, (double)d) * 57.2957763671875) - 90.0f)));
        this.method_5847(this.method_5791());
    }

    public void setPerformAttackJumps(boolean jumpWhileAttacking) {
        this.setTag("JumpAttack", jumpWhileAttacking);
    }

    public void setFollowType(NPCData.FollowTypes followType) {
        if (followType != NPCData.FollowTypes.NONE) {
            this.setMovement(NPCData.Movement.TICK);
        }
        this.npcData.follow.type = followType;
        switch (followType) {
            case MOBS: {
                this.field_6201.method_6277(4, (class_1352)this.trackLivingGoal);
                break;
            }
            case PLAYERS: {
                this.field_6201.method_6277(4, (class_1352)this.trackPlayersGoal);
                break;
            }
            case UUID: {
                this.field_6201.method_6277(4, (class_1352)this.trackUuidGoal);
                break;
            }
        }
    }

    public NPCData.FollowTypes getFollowType() {
        return this.npcData.follow.type;
    }

    public void setFollowUuid(@Nullable UUID followUuid) {
        this.npcData.follow.targetUuid = followUuid;
    }

    @Nullable
    public UUID getFollowUuid() {
        return this.npcData.follow.targetUuid;
    }

    public void setAllowSounds(boolean allowSounds) {
        this.npcData.allowSounds = allowSounds;
    }

    public void setSkinLayers(Byte skinLayers) {
        this.fakePlayer.method_5841().method_12778(APlayer.getPLAYER_MODE_CUSTOMISATION(), (Object)skinLayers);
    }

    public void setRespawnPos(@Nullable class_243 respawnPos) {
        this.respawnPosition = respawnPos;
    }

    public void setAllowFlight(boolean allowFlight) {
        this.setTag("AllowFlight", allowFlight);
        if (allowFlight) {
            this.field_6207 = new class_1331((class_1308)this, 20, false);
            this.field_6189 = new class_1407((class_1308)this, this.method_37908());
            this.method_5942().method_6354(true);
        } else {
            this.field_6207 = new class_1335((class_1308)this);
            this.field_6189 = new class_1409((class_1308)this, this.method_37908());
            ((class_1409)this.method_5942()).method_6363(true);
        }
    }

    public boolean method_5747(float fallDistance, float multiplier, class_1282 source) {
        return !this.getTag("AllowFlight", Taterzens.config.defaults.allowFlight) && super.method_5747(fallDistance, multiplier, source);
    }

    public boolean allowEditBy(class_1297 entity) {
        return this.allowEditBy(entity.method_5667());
    }

    public boolean allowEditBy(UUID uuid) {
        return this.lockedUuid == null || this.lockedUuid.equals(uuid) || this.method_5667().equals(uuid);
    }

    public boolean method_5804(class_1297 entity) {
        if (this.getTag("AllowRiding", Taterzens.config.defaults.allowRiding)) {
            return this.method_5873(entity, false);
        }
        return false;
    }

    public boolean isLocked() {
        return this.lockedUuid != null;
    }

    public void setLocked(class_1297 owner) {
        this.setLocked(owner.method_5667());
    }

    public void setLocked(UUID uuid) {
        this.lockedUuid = uuid;
    }

    public void setAllowRiding(boolean allow) {
        this.setTag("AllowRiding", allow);
    }

    public boolean method_18395(class_1309 target) {
        return (!(target instanceof class_1657) || this.method_37908().method_8407() != class_1267.field_5801 || Taterzens.config.combatInPeaceful) && target.method_33190();
    }

    public void setAllowSwimming(boolean allowSwimming) {
        this.field_6201.method_6280((class_1352)this.swimGoal);
        if (allowSwimming) {
            this.field_6201.method_6277(0, (class_1352)this.swimGoal);
        }
        this.method_5796(this.method_5681() && allowSwimming);
        this.method_5942().method_6354(allowSwimming);
        this.setTag("AllowSwimming", allowSwimming);
    }

    private void setTag(String name, boolean value) {
        this.npcData.booleanTags.put(name, value);
    }

    private void resetTag(String name) {
        this.npcData.booleanTags.remove(name);
    }

    private boolean getTag(String name, boolean defaultValue) {
        if (this.npcData.booleanTags.containsKey(name)) {
            return this.npcData.booleanTags.get(name);
        }
        return defaultValue;
    }
}

