/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.taterzens.npc.commands;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import org.samo_lego.taterzens.Taterzens;
import org.samo_lego.taterzens.npc.TaterzenNPC;
import org.samo_lego.taterzens.npc.commands.AbstractTaterzenCommand;

public class BungeeCommand
extends AbstractTaterzenCommand {
    public static final ArrayList<String> AVAILABLE_SERVERS = new ArrayList();
    public static final class_2960 BUNGEE_CHANNEL = new class_2960("bungeecord", "main");
    private String argument;
    private BungeeMessage proxyMessage;
    private String playername;

    public BungeeCommand(BungeeMessage proxyMessage, String playername, String argument) {
        super(AbstractTaterzenCommand.CommandType.BUNGEE);
        this.proxyMessage = proxyMessage;
        this.playername = playername;
        this.argument = argument;
    }

    public BungeeCommand() {
        super(AbstractTaterzenCommand.CommandType.BUNGEE);
        this.proxyMessage = null;
        this.playername = "";
        this.argument = "";
    }

    @Override
    public void execute(TaterzenNPC npc, class_1657 player) {
        if (!Taterzens.config.bungee.enableCommands) {
            return;
        }
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(this.proxyMessage.getSubchannel());
        out.writeUTF(this.playername.replace("--clicker--", player.method_7334().getName()));
        out.writeUTF(this.argument.replaceAll("--clicker--", player.method_7334().getName()));
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeBytes(out.toByteArray());
        class_2658 packet = new class_2658(BUNGEE_CHANNEL, buf);
        ((class_3222)player).field_13987.method_14364((class_2596)packet);
    }

    @Override
    public String toString() {
        return this.proxyMessage.toString().toLowerCase(Locale.ROOT) + " " + this.playername + " " + this.argument;
    }

    @Override
    public class_2487 toTag(class_2487 tag) {
        super.toTag(tag).method_10582("Proxy", this.proxyMessage.toString());
        tag.method_10582("Player", this.playername);
        tag.method_10582("Argument", this.argument);
        return tag;
    }

    @Override
    public void fromTag(class_2487 cmdTag) {
        this.proxyMessage = BungeeMessage.valueOf(cmdTag.method_10558("Proxy"));
        this.playername = cmdTag.method_10558("Player");
        this.argument = cmdTag.method_10558("Argument");
    }

    public static void sendProxyPacket(class_3244 connection, byte[] data) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeBytes(data);
        class_2658 packet = new class_2658(BUNGEE_CHANNEL, buf);
        connection.method_14364((class_2596)packet);
    }

    public static enum BungeeMessage {
        SERVER("ConnectOther"),
        MESSAGE("Message"),
        MESSAGE_RAW("MessageRaw"),
        KICK("KickPlayer");

        private final String subchannel;

        private BungeeMessage(String subchannel) {
            this.subchannel = subchannel;
        }

        public String getSubchannel() {
            return this.subchannel;
        }
    }
}

