/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.taterzens.npc.commands;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import org.samo_lego.taterzens.npc.TaterzenNPC;
import org.samo_lego.taterzens.npc.commands.AbstractTaterzenCommand;
import org.samo_lego.taterzens.npc.commands.BungeeCommand;
import org.samo_lego.taterzens.npc.commands.MinecraftCommand;

public class CommandGroups
extends ArrayList<ArrayList<AbstractTaterzenCommand>> {
    private int groupIndex;
    private final TaterzenNPC npc;

    public CommandGroups(TaterzenNPC npc) {
        this.npc = npc;
        this.groupIndex = 0;
    }

    public boolean addCommand(AbstractTaterzenCommand command) {
        if (this.groupIndex >= this.size()) {
            this.add(new ArrayList());
        }
        return ((ArrayList)this.get(this.groupIndex)).add(command);
    }

    @Override
    public void clear() {
        super.clear();
        this.groupIndex = 0;
    }

    public void execute(class_3222 player) {
        if (this.isEmpty()) {
            return;
        }
        if (this.groupIndex >= this.size()) {
            this.groupIndex = 0;
        }
        ImmutableList commands = ImmutableList.copyOf((Collection)((Collection)this.get(this.groupIndex)));
        for (AbstractTaterzenCommand cmd : commands) {
            cmd.execute(this.npc, (class_1657)player);
        }
        ++this.groupIndex;
    }

    public void toTag(class_2487 tag) {
        tag.method_10569("GroupIndex", this.groupIndex);
        class_2499 commands = new class_2499();
        for (int i = 0; i < this.size(); ++i) {
            ArrayList cmds = (ArrayList)this.get(i);
            class_2499 cmdList = new class_2499();
            cmds.forEach((? super E cmd) -> cmdList.add((Object)cmd.toTag(new class_2487())));
            commands.add((Object)cmdList);
        }
        tag.method_10566("Contents", (class_2520)commands);
    }

    public void fromTag(class_2487 tag) {
        this.groupIndex = tag.method_10550("GroupIndex");
        class_2499 cmdsArray = (class_2499)tag.method_10580("Contents");
        if (cmdsArray != null) {
            for (class_2520 cmds : cmdsArray) {
                ArrayList<AbstractTaterzenCommand> cmdList = new ArrayList<AbstractTaterzenCommand>();
                for (class_2520 cmd : (class_2499)cmds) {
                    class_2487 cmdTag = (class_2487)cmd;
                    AbstractTaterzenCommand toAdd = AbstractTaterzenCommand.CommandType.valueOf(cmdTag.method_10558("Type")) == AbstractTaterzenCommand.CommandType.BUNGEE ? new BungeeCommand() : new MinecraftCommand();
                    toAdd.fromTag(cmdTag);
                    cmdList.add(toAdd);
                }
                this.add(cmdList);
            }
        }
    }

    @Deprecated
    public void fromOldTag(class_2499 minecraftCommands, class_2499 bungeeCommands) {
        this.groupIndex = 0;
        ArrayList cmds = new ArrayList();
        if (minecraftCommands != null) {
            minecraftCommands.forEach(cmdTag -> cmds.add(new MinecraftCommand(cmdTag.method_10714())));
        }
        if (bungeeCommands != null) {
            bungeeCommands.forEach(cmdTag -> {
                class_2499 cmdList = (class_2499)cmdTag;
                String command = cmdList.method_10534(0).method_10714();
                String player = cmdList.method_10534(1).method_10714();
                String argument = cmdList.method_10534(2).method_10714();
                cmds.add(new BungeeCommand(BungeeCommand.BungeeMessage.valueOf(command), player, argument));
            });
        }
        this.add(cmds);
    }

    public int createGroup() {
        this.add(new ArrayList());
        this.groupIndex = this.size() - 1;
        return this.groupIndex;
    }
}

