/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.taterzens.storage;

import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.samo_lego.config2brigadier.IBrigadierConfigurator;
import org.samo_lego.config2brigadier.annotation.BrigadierDescription;
import org.samo_lego.config2brigadier.annotation.BrigadierExcluded;
import org.samo_lego.taterzens.Taterzens;

public class TaterConfig
implements IBrigadierConfigurator {
    @SerializedName(value="// Language file to use.")
    public final String _comment_language = "";
    @BrigadierExcluded
    public String language = "en_us";
    @SerializedName(value="// After how many ticks Taterzens should be cleared from tablist.")
    public final String _comment_taterzenTablistTimeout0 = "";
    @SerializedName(value="// Some delay is needed, otherwise clients don't fetch their skins.")
    public final String _comment_taterzenTablistTimeout1 = "";
    @SerializedName(value="// If you want them to stay on the tablist, set this to -1.")
    public final String _comment_taterzenTablistTimeout2 = "";
    @BrigadierDescription(defaultOption="30")
    @SerializedName(value="taterzen_tablist_timeout")
    public int taterzenTablistTimeout = 30;
    @SerializedName(value="// Whether to remind you that if FabricTailor mod is installed,")
    public final String _comment_fabricTailorAdvert0 = "";
    @SerializedName(value="// it has some built-in skin swapping functionality for Taterzens as well.")
    public final String _comment_fabricTailorAdvert1 = "";
    @SerializedName(value="post_fabrictailor_advert")
    public boolean fabricTailorAdvert = false;
    @SerializedName(value="// Whether to cancel sending info that Taterzen has executed a command to ops.")
    public final String _comment_hideOpsMessage = "";
    @SerializedName(value="hide_ops_message")
    public boolean hideOpsMessage = true;
    @SerializedName(value="// Whether to automatically lock the taterzen after creating it.")
    public final String _comment_lockAfterCreation = "";
    @BrigadierDescription(defaultOption="true")
    @SerializedName(value="lock_after_creation")
    public boolean lockAfterCreation = true;
    @SerializedName(value="// Obsucre Taterzens' names while they are visible on the tab list.")
    public boolean obscureTabList = true;
    @SerializedName(value="// Default settings for new Taterzens.")
    public final String _comment_defaults = "";
    public Defaults defaults = new Defaults();
    public Path path = new Path();
    public Messages messages = new Messages();
    public Permissions perms = new Permissions();
    public Bungee bungee = new Bungee();
    @SerializedName(value="// Custom model data number that items in GUI should use.")
    public final String _comment_guiItemModelData = "";
    @BrigadierDescription(defaultOption="257")
    @SerializedName(value="gui_item_model_data")
    public int guiItemModelData = 257;
    @SerializedName(value="// Nodes which prefer execution instead of going in submenus in `/npc` gui. (Swaps the right and left click function to these nodes)")
    public final String _comment_prefersExecution = "";
    @SerializedName(value="prefer_execution_nodes")
    public List<String> prefersExecution = List.of("npc edit messages swap", "npc edit equipment");
    @SerializedName(value="// Whether to allow Taterzens to fight players in peaceful mode as well.")
    public final String _comment_combatInPeaceful = "";
    @BrigadierDescription(defaultOption="true")
    @SerializedName(value="combat_in_peaceful")
    public boolean combatInPeaceful = true;
    @SerializedName(value="// Whether give fake glowing effect to Taterzen when selected.")
    public final String _comment_glowSelectedNpc = "";
    @BrigadierDescription(defaultOption="true")
    @SerializedName(value="glow_selected_npc")
    public boolean glowSelectedNpc = true;

    public void save() {
        this.saveConfigFile(Taterzens.getInstance().getConfigFile());
    }

    public static TaterConfig loadConfigFile(File file) {
        TaterConfig config = null;
        if (file.exists()) {
            try (BufferedReader fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
                config = (TaterConfig)Taterzens.GSON.fromJson((Reader)fileReader, TaterConfig.class);
            }
            catch (IOException e) {
                throw new RuntimeException("taterzens Problem occurred when trying to load config: ", e);
            }
        }
        if (config == null) {
            config = new TaterConfig();
        }
        config.saveConfigFile(file);
        return config;
    }

    public void saveConfigFile(File file) {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            Taterzens.GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            Taterzens.LOGGER.error("Problem occurred when saving config: " + e.getMessage());
        }
    }

    public void reload() {
        TaterConfig newConfig = TaterConfig.loadConfigFile(Taterzens.getInstance().getConfigFile());
        this.reload(newConfig);
    }

    public static class Defaults {
        public String name = "Taterzen";
        public boolean leashable = false;
        public boolean pushable = false;
        @SerializedName(value="// How many ticks must pass between each interaction (command triggerings).")
        public final String _comment_minInteractionTime = "";
        @BrigadierDescription(defaultOption="0")
        @SerializedName(value="minimum_interaction_time")
        public long minInteractionTime = 0L;
        @SerializedName(value="// Default cooldown message to be sent to the player. Supports translation as well.")
        public final String _comment_commandCooldownMessage = "";
        @SerializedName(value="command_cooldown_message")
        public String commandCooldownMessage = "taterzens.npc.interact.cooldown";
        @SerializedName(value="// Default command permission level of Taterzen.")
        public final String _comment_commandPermissionLevel = "";
        @SerializedName(value="command_permission_level")
        public int commandPermissionLevel = 4;
        @SerializedName(value="// Default sounds for Taterzens. Set to [] to mute them.")
        public final String _comment_sounds = "";
        @SerializedName(value="death_sounds")
        public List<String> deathSounds = new ArrayList<String>(List.of("entity.player.death"));
        @SerializedName(value="hurt_sounds")
        public List<String> hurtSounds = new ArrayList<String>(List.of("entity.player.hurt"));
        @SerializedName(value="ambient_sounds")
        public List<String> ambientSounds = new ArrayList<String>();
        @SerializedName(value="// Whether Taterzen is invulnerable by default.")
        public final String _comment_invulnerable = "";
        @BrigadierDescription(defaultOption="true")
        public boolean invulnerable = true;
        @BrigadierDescription(defaultOption="true")
        @SerializedName(value="// Enable jumps when Taterzen is in attack mode.")
        public final String _comment_jumpWhileAttacking = "";
        @BrigadierDescription(defaultOption="true")
        @SerializedName(value="jump_while_attacking")
        public boolean jumpWhileAttacking = true;
        @SerializedName(value="// Whether Taterzen is able to fly.")
        public final String _comment_allowFlight = "";
        @BrigadierDescription(defaultOption="false")
        @SerializedName(value="allow_flight")
        public boolean allowFlight = false;
        @SerializedName(value="// Whether Taterzens can be picked up by boats / minecarts.")
        public final String _comment_allowRiding = "";
        @BrigadierDescription(defaultOption="false")
        @SerializedName(value="allow_riding")
        public boolean allowRiding = false;
        @SerializedName(value="// Whether Taterzen is able to swim.")
        public final String _comment_allowSwim = "";
        @BrigadierDescription(defaultOption="true")
        @SerializedName(value="allow_swim")
        public boolean allowSwim = true;
        @SerializedName(value="// Whether Taterzens should drop equipment on death.")
        public final String _comment_dropEquipment = "";
        @SerializedName(value="drop_equipment")
        @BrigadierDescription(defaultOption="false")
        public boolean dropEquipment = false;
    }

    public static class Path {
        @SerializedName(value="// Which color of particles to use in path editor. Use RGB values ( 0 - 255 ).")
        public final String _comment_color = "";
        public Color color = new Color();

        public static class Color {
            public float red = 0.0f;
            public float green = 255.0f;
            public float blue = 255.0f;
        }
    }

    public static class Messages {
        @SerializedName(value="// Default delay between each message, in ticks.")
        public final String _comment_messageDelay = "";
        @SerializedName(value="message_delay")
        public int messageDelay = 100;
        @SerializedName(value="// Whether to exit message editor mode after editing a message.")
        public final String _comment_exitEditorAfterMsgEdit = "";
        @SerializedName(value="exit_editor_after_msg_edit")
        public boolean exitEditorAfterMsgEdit = true;
        @SerializedName(value="// Message format. First %s is replaced with name, second one with message.")
        public final String _comment_structure = "";
        public String structure = "%s -> you: %s";
        @SerializedName(value="// How far can player be for messages start appearing.")
        public final String _comment_speakDistance = "(default: 3.0f)";
        @SerializedName(value="speak_distance")
        public float speakDistance = 3.0f;
    }

    public static class Permissions {
        @SerializedName(value="// Permission level required to execute /npc command.")
        public final String _comment_npcCommandPermissionLevel0 = "";
        @SerializedName(value="// Valid only if LuckPerms isn't present.")
        public final String _comment_npcCommandPermissionLevel1 = "";
        @SerializedName(value="npc_command_permission_level")
        public int npcCommandPermissionLevel = 2;
        @SerializedName(value="// Default permission level for `/profession` command.")
        public final String _comment_professionCommandPermissionLevel = "";
        @SerializedName(value="profession_command_permission_level")
        public int professionCommandPL = 2;
        @SerializedName(value="// Permission level required to execute / taterzens command.")
        public final String _comment_taterzensCommandPermissionLevel0 = "";
        @SerializedName(value="// Again, valid only if LuckPerms isn't present.")
        public final String _comment_taterzensCommandPermissionLevel1 = "";
        @SerializedName(value="taterzens_command_permission_level")
        public int taterzensCommandPermissionLevel = 4;
        @SerializedName(value="// Whether to allow players to set the permission level")
        public final String _comment_allowSettingHigherPermissionLevel0 = "";
        @SerializedName(value="// of Taterzen higher than their own. Careful! This could")
        public final String _comment_allowSettingHigherPermissionLevel1 = "";
        @SerializedName(value="// enable players to bypass their permission level with NPC.")
        public final String _comment_allowSettingHigherPermissionLevel2 = "";
        @SerializedName(value="allow_setting_higher_perm_level")
        public boolean allowSettingHigherPermissionLevel = false;
        @SerializedName(value="// Default permission level to bypass selecting locked npcs.")
        public final String _comment_selectBypassLevel = "";
        @BrigadierDescription(defaultOption="3")
        @SerializedName(value="select_bypass_level")
        public int selectBypassLevel = 3;
    }

    public static class Bungee {
        @SerializedName(value="// Whether to enable bungee commands feature for NPCs.")
        public final String _comment_enableCommands = "";
        @SerializedName(value="enable_commands")
        public boolean enableCommands = false;
    }
}

