/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.taterzens.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.samo_lego.taterzens.Taterzens;

public class LanguageUtil {
    public static final InputStream DEFAULT_LANG_STREAM = Taterzens.class.getResourceAsStream("/data/taterzens/lang/en_us.json");
    public static final List<String> LANG_LIST = new ArrayList<String>();
    private static final String API_URL = "https://api.github.com/repos/samolego/taterzens/contents/common/src/main/resources/data/taterzens/lang";
    private static final String LANG_FILE_URL = "https://raw.githubusercontent.com/samolego/Taterzens/master/common/src/main/resources/data/taterzens/lang/%s.json";

    public static void setupLanguage() {
        String langPath = String.format("/data/taterzens/lang/%s.json", Taterzens.config.language);
        InputStream stream = Taterzens.class.getResourceAsStream(langPath);
        if (stream == null) {
            try {
                URL url = new URL(String.format(LANG_FILE_URL, Taterzens.config.language));
                HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
                int responseCode = conn.getResponseCode();
                if (responseCode == 200) {
                    LanguageUtil.loadLanguageFile(conn.getInputStream());
                } else {
                    LogManager.getLogger((String)"Taterzens").error("Got {} when trying to fetch {} from {}.", (Object)responseCode, (Object)Taterzens.config.language, (Object)url);
                    Taterzens.config.language = "en_us";
                    Taterzens.config.save();
                    Taterzens.lang = LanguageUtil.loadLanguageFile(DEFAULT_LANG_STREAM);
                }
                conn.disconnect();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            Taterzens.lang = LanguageUtil.loadLanguageFile(stream);
        }
    }

    public static JsonObject loadLanguageFile(InputStream inputStream) {
        JsonObject jsonObject;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        try {
            jsonObject = (JsonObject)Taterzens.GSON.fromJson((Reader)reader, JsonObject.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LogManager.getLogger((String)"Taterzens").error("[Taterzens]: Problem occurred when trying to load language: ", (Throwable)e);
                return new JsonObject();
            }
        }
        reader.close();
        return jsonObject;
    }

    static {
        try {
            URL REPO_API_URL = new URL(API_URL);
            String ending = ".json";
            HttpsURLConnection conn = (HttpsURLConnection)REPO_API_URL.openConnection();
            if (conn.getResponseCode() == 200) {
                String reply = IOUtils.toString((Reader)new InputStreamReader(conn.getInputStream()));
                JsonArray json = (JsonArray)Taterzens.GSON.fromJson(reply, JsonArray.class);
                for (JsonElement element : json) {
                    JsonObject file = element.getAsJsonObject();
                    String langName = file.get("name").getAsString();
                    if (!langName.endsWith(ending)) continue;
                    LANG_LIST.add(langName.substring(0, langName.length() - ending.length()));
                }
            }
            conn.disconnect();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

