/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.events;

import de.keksuccino.konkrete.events.EventBase;
import de.keksuccino.konkrete.events.EventContainer;
import de.keksuccino.konkrete.events.EventPriority;
import de.keksuccino.konkrete.events.SubscribeEvent;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventHandler {
    private static final boolean DEBUG = false;
    private Map<String, List<EventContainer>> events = new HashMap<String, List<EventContainer>>();

    public void registerEventsFrom(Object instance) {
        block0: for (Method m : instance.getClass().getDeclaredMethods()) {
            if (!Modifier.isPublic(m.getModifiers()) || !m.isAnnotationPresent(SubscribeEvent.class)) continue;
            EventPriority p = m.getAnnotation(SubscribeEvent.class).priority();
            for (Class<?> cc : m.getParameterTypes()) {
                if (!EventBase.class.isAssignableFrom(cc)) continue;
                if (!this.eventsExistForType(cc)) {
                    this.events.put(cc.getName(), new ArrayList());
                }
                this.events.get(cc.getName()).add(new EventContainer(cc.getName(), m, instance, p));
                continue block0;
            }
        }
    }

    public void registerEventsFrom(Class<?> c) {
        block0: for (Method m : c.getDeclaredMethods()) {
            if (!Modifier.isPublic(m.getModifiers()) || !Modifier.isStatic(m.getModifiers()) || !m.isAnnotationPresent(SubscribeEvent.class)) continue;
            EventPriority p = m.getAnnotation(SubscribeEvent.class).priority();
            for (Class<?> cc : m.getParameterTypes()) {
                if (!EventBase.class.isAssignableFrom(cc)) continue;
                if (!this.eventsExistForType(cc)) {
                    this.events.put(cc.getName(), new ArrayList());
                }
                this.events.get(cc.getName()).add(new EventContainer(cc.getName(), m, c, p));
                continue block0;
            }
        }
    }

    public void callEventsFor(EventBase listener) {
        if (this.eventsExistForType(listener.getClass())) {
            ArrayList<EventContainer> highest = new ArrayList<EventContainer>();
            ArrayList<EventContainer> high = new ArrayList<EventContainer>();
            ArrayList<EventContainer> normal = new ArrayList<EventContainer>();
            ArrayList<EventContainer> low = new ArrayList<EventContainer>();
            ArrayList<EventContainer> lowest = new ArrayList<EventContainer>();
            for (EventContainer c : this.events.get(listener.getClass().getName())) {
                if (c.priority == EventPriority.HIGHEST) {
                    highest.add(c);
                }
                if (c.priority == EventPriority.HIGH) {
                    high.add(c);
                }
                if (c.priority == EventPriority.NORMAL) {
                    normal.add(c);
                }
                if (c.priority == EventPriority.LOW) {
                    low.add(c);
                }
                if (c.priority != EventPriority.LOWEST) continue;
                lowest.add(c);
            }
            for (EventContainer c : highest) {
                this.invokeEvent(c, listener);
            }
            for (EventContainer c : high) {
                this.invokeEvent(c, listener);
            }
            for (EventContainer c : normal) {
                this.invokeEvent(c, listener);
            }
            for (EventContainer c : low) {
                this.invokeEvent(c, listener);
            }
            for (EventContainer c : lowest) {
                this.invokeEvent(c, listener);
            }
        }
    }

    private void invokeEvent(EventContainer c, EventBase listener) {
        try {
            c.event.invoke(c.instance, listener);
        }
        catch (Exception e) {
            System.out.println("################# ERROR [KONKRETE] #################");
            System.out.println("Failed to invoke event!");
            System.out.println("Event Subscription Class: " + c.event.getDeclaringClass());
            System.out.println("Event Subscription Method Name: " + c.event.getName());
            System.out.println("Event Name: " + listener.getClass().getName());
            System.out.println("####################################################");
            System.out.println("");
            e.printStackTrace();
        }
    }

    public boolean eventsExistForType(Class<? extends EventBase> listenerType) {
        return this.events.get(listenerType.getName()) != null;
    }
}

