/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.utils;

import com.mojang.datafixers.util.Either;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_3193;
import net.minecraft.class_3218;
import net.minecraft.class_3230;
import net.minecraft.class_3532;
import net.minecraft.class_3902;
import net.minecraft.class_4538;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkManager {
    @NotNull
    public static class_6880<class_1959> getRoughBiome(class_1937 level, class_2338 pos) {
        class_2791 chunk = ChunkManager.getChunkNow((class_4538)level, pos);
        int x = pos.method_10263() >> 2;
        int y = pos.method_10264() >> 2;
        int z = pos.method_10260() >> 2;
        return chunk != null ? chunk.method_16359(x, y, z) : level.method_22387(x, y, z);
    }

    @NotNull
    public static class_2680 getBlockState(class_1937 level, class_2338 pos) {
        class_2791 chunk = ChunkManager.getChunkNow((class_4538)level, pos);
        return chunk != null ? chunk.method_8320(pos) : class_2246.field_10124.method_9564();
    }

    @Nullable
    public static class_2791 getChunkNow(class_4538 levelReader, class_2338 pos) {
        return ChunkManager.getChunkNow(levelReader, pos.method_10263() >> 4, pos.method_10260() >> 4);
    }

    @Nullable
    public static class_2791 getChunkNow(class_4538 levelReader, int chunkX, int chunkZ) {
        if (levelReader instanceof class_3218) {
            class_3218 level = (class_3218)levelReader;
            return ChunkManager.getChunkFromHolder(ChunkManager.getChunkHolder(level, chunkX, chunkZ));
        }
        return levelReader.method_8402(chunkX, chunkZ, class_2806.field_12803, false);
    }

    @Nullable
    public static class_2818 getChunkFromFuture(CompletableFuture<Either<class_2818, class_3193.class_3724>> chunkFuture) {
        Either either;
        if (chunkFuture == class_3193.field_16429 || (either = (Either)chunkFuture.getNow(null)) == null) {
            return null;
        }
        return either.left().orElse(null);
    }

    @Nullable
    public static class_2818 getChunkFromHolder(class_3193 holder) {
        return holder != null ? ChunkManager.getChunkFromFuture(holder.method_20725()) : null;
    }

    @Nullable
    private static class_3193 getChunkHolder(class_3218 level, int chunkX, int chunkZ) {
        return level.method_14178().method_14131(class_1923.method_8331((int)chunkX, (int)chunkZ));
    }

    public static boolean hasChunk(class_1937 level, class_2338 pos) {
        return ChunkManager.hasChunk(level, pos.method_10263() >> 4, pos.method_10260() >> 4);
    }

    public static boolean hasChunk(class_1937 level, int chunkX, int chunkZ) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            return ChunkManager.hasChunk(ChunkManager.getChunkHolder(serverLevel, chunkX, chunkZ));
        }
        return true;
    }

    public static boolean hasChunk(class_3193 holder) {
        return ChunkManager.getChunkFromHolder(holder) != null;
    }

    public static void disableSpawnChunks(MinecraftServer server) {
        class_3218 level = server.method_30002();
        class_1923 pos = new class_1923(new class_2338(level.method_8401().method_215(), 0, level.method_8401().method_166()));
        level.method_14178().method_17300(class_3230.field_14030, pos, 11, (Object)class_3902.field_17274);
    }

    public static boolean areChunksLoadedForMove(class_3218 level, class_238 box) {
        int minBlockX = class_3532.method_15357((double)(box.field_1323 - 1.0E-7)) - 3;
        int maxBlockX = class_3532.method_15357((double)(box.field_1320 + 1.0E-7)) + 3;
        int minBlockZ = class_3532.method_15357((double)(box.field_1321 - 1.0E-7)) - 3;
        int maxBlockZ = class_3532.method_15357((double)(box.field_1324 + 1.0E-7)) + 3;
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                if (ChunkManager.hasChunk((class_1937)level, chunkX, chunkZ)) continue;
                return false;
            }
        }
        return true;
    }
}

