/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.entity;

import immersive_paintings.Config;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2312;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractImmersiveDecorationEntity
extends class_1297 {
    protected static final Predicate<class_1297> PREDICATE = entity -> entity instanceof AbstractImmersiveDecorationEntity;
    private int obstructionCheckCounter;
    protected class_2338 attachmentPos;
    protected class_2350 facing = class_2350.field_11035;
    protected int rotation = 0;
    private static final Map<class_2350, Byte> DIRECTION_TO_ID = Map.of(class_2350.field_11033, (byte)5, class_2350.field_11036, (byte)4, class_2350.field_11043, (byte)2, class_2350.field_11035, (byte)0, class_2350.field_11039, (byte)1, class_2350.field_11034, (byte)3);
    private static final Map<Byte, class_2350> ID_TO_DIRECTION = Map.of((byte)5, class_2350.field_11033, (byte)4, class_2350.field_11036, (byte)2, class_2350.field_11043, (byte)0, class_2350.field_11035, (byte)1, class_2350.field_11039, (byte)3, class_2350.field_11034);

    protected AbstractImmersiveDecorationEntity(class_1299<? extends class_1297> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected AbstractImmersiveDecorationEntity(class_1299<? extends class_1297> type, class_1937 world, class_2338 pos) {
        this(type, world);
        this.attachmentPos = pos;
    }

    protected void method_5693() {
    }

    public void setFacing(class_2350 facing, int rotation) {
        this.facing = facing;
        this.rotation = rotation;
        if (this.facing.method_10166().method_10179()) {
            this.method_36456(this.facing.method_10161() * 90);
            this.method_36457(0.0f);
        } else {
            this.method_36456(rotation);
            this.method_36457(this.facing == class_2350.field_11036 ? 90.0f : -90.0f);
        }
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
        this.updateAttachmentPosition();
    }

    protected void updateAttachmentPosition() {
        if (this.facing == null) {
            return;
        }
        double x = (double)this.attachmentPos.method_10263() + 0.5;
        double y = (double)this.attachmentPos.method_10264() + 0.5;
        double z = (double)this.attachmentPos.method_10260() + 0.5;
        double ox = this.isEven(this.getWidthPixels());
        double oy = this.isEven(this.getHeightPixels());
        class_2382 front = this.facing.method_10163();
        class_2382 up = this.facing.method_10166().method_10178() ? new class_2382(0, 0, 1) : new class_2382(0, 1, 0);
        class_2382 side = up.method_10259(front);
        if (this.rotation != 0) {
            double cos = Math.cos((double)this.rotation / 180.0 * Math.PI);
            double sin = Math.sin((double)this.rotation / 180.0 * Math.PI);
            up = new class_2382((int)Math.round((double)up.method_10263() * cos - (double)up.method_10260() * sin), up.method_10264(), (int)Math.round((double)up.method_10263() * sin + (double)up.method_10260() * cos));
            side = new class_2382((int)Math.round((double)side.method_10263() * cos - (double)side.method_10260() * sin), side.method_10264(), (int)Math.round((double)side.method_10263() * sin + (double)side.method_10260() * cos));
        }
        double w = (double)this.getWidthPixels() / 32.0;
        double h = (double)this.getHeightPixels() / 32.0;
        double d = 0.03125;
        this.method_23327(x -= (double)this.facing.method_10148() * 7.5 / 16.0 - (double)up.method_10263() * oy - (double)side.method_10263() * ox, y -= (double)this.facing.method_10164() * 7.5 / 16.0 - (double)up.method_10264() * oy - (double)side.method_10264() * ox, z -= (double)this.facing.method_10165() * 7.5 / 16.0 - (double)up.method_10260() * oy - (double)side.method_10260() * ox);
        this.method_5857(new class_238(x - (double)up.method_10263() * h - (double)side.method_10263() * w - (double)front.method_10263() * d, y - (double)up.method_10264() * h - (double)side.method_10264() * w - (double)front.method_10264() * d, z - (double)up.method_10260() * h - (double)side.method_10260() * w - (double)front.method_10260() * d, x + (double)up.method_10263() * h + (double)side.method_10263() * w + (double)front.method_10263() * d, y + (double)up.method_10264() * h + (double)side.method_10264() * w + (double)front.method_10264() * d, z + (double)up.method_10260() * h + (double)side.method_10260() * w + (double)front.method_10260() * d));
    }

    private double isEven(int i) {
        return i % 32 == 0 ? 0.5 : 0.0;
    }

    public void method_5773() {
        if (!this.method_37908().field_9236) {
            this.method_31473();
            if (this.obstructionCheckCounter++ == 100) {
                this.obstructionCheckCounter = 0;
                if (!this.method_31481() && !this.canStayAttached()) {
                    this.method_31472();
                    this.onBreak(null);
                }
            }
        }
    }

    public boolean canStayAttached() {
        if (Config.getInstance().testIfSpaceEmpty && !this.method_37908().method_17892((class_1297)this)) {
            return false;
        }
        class_2338 blockPos = this.attachmentPos.method_10093(this.facing.method_10153());
        class_2680 blockState = this.method_37908().method_8320(blockPos);
        if (!blockState.method_51367() && !class_2312.method_9999((class_2680)blockState)) {
            return false;
        }
        return this.method_37908().method_8333((class_1297)this, this.method_5829(), PREDICATE).stream().noneMatch(v -> ((AbstractImmersiveDecorationEntity)v).facing == this.facing);
    }

    public int getRotation() {
        return this.rotation;
    }

    public boolean method_30948() {
        return Config.getInstance().paintingsHaveCollision;
    }

    public boolean method_5863() {
        return true;
    }

    public boolean method_5698(class_1297 attacker) {
        if (attacker instanceof class_1657) {
            class_1657 playerEntity = (class_1657)attacker;
            if (!this.method_37908().method_8505(playerEntity, this.attachmentPos)) {
                return true;
            }
            return this.method_5643(attacker.method_37908().method_48963().method_48802(playerEntity), 0.0f);
        }
        return false;
    }

    public class_2350 method_5735() {
        return this.facing;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        if (!this.method_31481() && !this.method_37908().field_9236) {
            this.method_5768();
            this.method_5785();
            this.onBreak(source.method_5529());
        }
        return true;
    }

    public void method_5784(class_1313 movementType, class_243 movement) {
        if (!this.method_37908().field_9236 && !this.method_31481() && movement.method_1027() > 0.0) {
            this.method_5768();
            this.onBreak(null);
        }
    }

    public void method_5762(double deltaX, double deltaY, double deltaZ) {
        if (!this.method_37908().field_9236 && !this.method_31481() && deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ > 0.0) {
            this.method_5768();
            this.onBreak(null);
        }
    }

    public void method_5652(class_2487 nbt) {
        nbt.method_10569("TileX", this.attachmentPos.method_10263());
        nbt.method_10569("TileY", this.attachmentPos.method_10264());
        nbt.method_10569("TileZ", this.attachmentPos.method_10260());
        nbt.method_10567("Facing", DIRECTION_TO_ID.get(this.facing).byteValue());
        nbt.method_10569("Rotation", this.rotation);
    }

    public void method_5749(class_2487 nbt) {
        this.attachmentPos = new class_2338(nbt.method_10550("TileX"), nbt.method_10550("TileY"), nbt.method_10550("TileZ"));
        this.facing = ID_TO_DIRECTION.get(nbt.method_10571("Facing"));
        this.rotation = nbt.method_10550("Rotation");
        this.setFacing(this.facing, this.rotation);
    }

    public abstract int getWidthPixels();

    public abstract int getHeightPixels();

    public abstract void onBreak(@Nullable class_1297 var1);

    public abstract void onPlace();

    public class_1542 method_5699(class_1799 stack, float yOffset) {
        class_1542 itemEntity = new class_1542(this.method_37908(), this.method_23317() + (double)this.facing.method_10148() * 0.3, this.method_23318() + (double)this.facing.method_10164() * 0.3 + (double)yOffset, this.method_23321() + (double)this.facing.method_10165() * 0.3, stack);
        itemEntity.method_6988();
        this.method_37908().method_8649((class_1297)itemEntity);
        return itemEntity;
    }

    protected boolean method_5638() {
        return false;
    }

    public void method_5814(double x, double y, double z) {
        this.attachmentPos = class_2338.method_49637((double)x, (double)y, (double)z);
        this.updateAttachmentPosition();
        this.field_6007 = true;
    }

    public float method_5832(class_2470 rotation) {
        if (this.facing.method_10166() != class_2350.class_2351.field_11052) {
            switch (rotation) {
                case field_11464: {
                    this.facing = this.facing.method_10153();
                    break;
                }
                case field_11465: {
                    this.facing = this.facing.method_10160();
                    break;
                }
                case field_11463: {
                    this.facing = this.facing.method_10170();
                }
            }
        }
        float f = class_3532.method_15393((float)this.method_36454());
        switch (rotation) {
            case field_11464: {
                return f + 180.0f;
            }
            case field_11465: {
                return f + 90.0f;
            }
            case field_11463: {
                return f + 270.0f;
            }
        }
        return f;
    }

    public float method_5763(class_2415 mirror) {
        return this.method_5832(mirror.method_10345(this.facing));
    }

    public void method_5800(class_3218 world, class_1538 lightning) {
    }

    public void method_18382() {
    }

    public class_2338 getAttachmentPos() {
        return this.attachmentPos;
    }

    public void setAttachmentPos(class_2338 pos) {
        this.attachmentPos = pos;
        this.updateAttachmentPosition();
    }
}

