/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.network.c2s;

import immersive_paintings.Config;
import immersive_paintings.Main;
import immersive_paintings.cobalt.network.Message;
import immersive_paintings.cobalt.network.NetworkHandler;
import immersive_paintings.network.c2s.UploadPaintingRequest;
import immersive_paintings.network.s2c.PaintingListMessage;
import immersive_paintings.network.s2c.RegisterPaintingResponse;
import immersive_paintings.resources.ByteImage;
import immersive_paintings.resources.Painting;
import immersive_paintings.resources.ServerPaintingManager;
import immersive_paintings.util.Utils;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class RegisterPaintingRequest
extends Message {
    private final String name;
    private final class_2487 painting;

    public RegisterPaintingRequest(String name, Painting painting) {
        this.name = name;
        this.painting = painting.toNbt();
    }

    public RegisterPaintingRequest(class_2540 b) {
        this.name = b.method_19772();
        this.painting = b.method_10798();
    }

    @Override
    public void encode(class_2540 b) {
        b.method_10814(this.name);
        b.method_10794(this.painting);
    }

    @Override
    public void receive(class_1657 e) {
        ByteImage image = UploadPaintingRequest.uploadedImages.get(e.method_5845());
        if (!e.method_5687(Config.getInstance().uploadPermissionLevel)) {
            this.error("no_permission", e, null);
            return;
        }
        if (image.getWidth() > Config.getInstance().maxUserImageWidth || image.getHeight() > Config.getInstance().maxUserImageHeight) {
            this.error("too_large", e, null);
            return;
        }
        long count = ServerPaintingManager.get().getCustomServerPaintings().values().stream().filter(p -> p.author.equals(e.method_7334().getName())).count();
        if (count > (long)Config.getInstance().maxUserImages) {
            this.error("limit_reached", e, null);
            return;
        }
        String id = Utils.escapeString(e.method_7334().getName()) + "/" + Utils.escapeString(this.name);
        class_2960 identifier = Main.locate(id);
        class_2487 nbt = this.painting;
        nbt.method_10582("author", e.method_7334().getName());
        nbt.method_10582("name", this.name);
        Painting painting = Painting.fromNbt(nbt);
        painting.texture.image = image;
        ServerPaintingManager.registerPainting(identifier, painting);
        for (class_3222 player : Objects.requireNonNull(e.method_5682()).method_3760().method_14571()) {
            NetworkHandler.sendToPlayer(new PaintingListMessage(identifier, painting), player);
        }
        this.error("", e, identifier);
    }

    private void error(String error, class_1657 e, class_2960 i) {
        NetworkHandler.sendToPlayer(new RegisterPaintingResponse(error, i), (class_3222)e);
    }
}

