/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block.data;

import de.mrjulsen.mcdragonlib.core.ITranslatableEnum;
import de.mrjulsen.trafficcraft.block.data.IIconEnum;
import java.util.Arrays;
import net.minecraft.class_3542;

public enum TrafficLightModel implements class_3542,
ITranslatableEnum,
IIconEnum
{
    ONE_LIGHT("single", 1, 9.0f, 16.0f, 2, 0),
    TWO_LIGHTS("double", 2, 4.5f, 16.0f, 3, 0),
    THREE_LIGHTS("tripple", 3, -0.5f, 16.0f, 4, 0);

    private String name;
    private byte lightsCount;
    private float hitboxBottom;
    private float hitboxTop;
    private int uMul;
    private int vMul;

    private TrafficLightModel(String name, int lightsCount, float hitboxBottom, float hitboxTop, int u, int v) {
        this.name = name;
        this.lightsCount = (byte)lightsCount;
        this.hitboxBottom = hitboxBottom;
        this.hitboxTop = hitboxTop;
        this.uMul = u;
        this.vMul = v;
    }

    public String getName() {
        return this.name;
    }

    public byte getLightsCount() {
        return this.lightsCount;
    }

    public float getHitboxBottom() {
        return this.hitboxBottom;
    }

    public float getHitboxTop() {
        return this.hitboxTop;
    }

    public float getTotalHitboxHeight() {
        return Math.abs(this.getHitboxTop() - this.getHitboxBottom());
    }

    @Override
    public int getUMultiplier() {
        return this.uMul;
    }

    @Override
    public int getVMultiplier() {
        return this.vMul;
    }

    public static TrafficLightModel getModelByLightsCount(byte lightsCount) {
        return Arrays.stream(TrafficLightModel.values()).filter(x -> x.getLightsCount() == lightsCount).findFirst().orElse(THREE_LIGHTS);
    }

    public String method_15434() {
        return this.name;
    }

    public String getEnumName() {
        return "trafficlightmodel";
    }

    public String getEnumValueName() {
        return this.getName();
    }

    public static byte maxRequiredSlots() {
        return (byte)Arrays.stream(TrafficLightModel.values()).mapToInt(x -> x.getLightsCount()).max().getAsInt();
    }
}

