/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block.entity;

import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.block.SyncedBlockEntity;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import de.mrjulsen.trafficcraft.block.StreetLampBaseBlock;
import de.mrjulsen.trafficcraft.registry.ModBlockEntities;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;

public class StreetLampBlockEntity
extends SyncedBlockEntity {
    private static final String NBT_TURN_ON_TIME = "turnOnTime";
    private static final String NBT_TURN_OFF_TIME = "turnOffTime";
    private int onTimeTicks = 0;
    private int offTimeTicks = 0;

    protected StreetLampBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public StreetLampBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntities.STREET_LAMP_BLOCK_ENTITY.get(), pos, state);
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.onTimeTicks = compound.method_10550(NBT_TURN_ON_TIME);
        this.offTimeTicks = compound.method_10550(NBT_TURN_OFF_TIME);
    }

    protected void method_11007(class_2487 tag) {
        tag.method_10569(NBT_TURN_ON_TIME, this.onTimeTicks);
        tag.method_10569(NBT_TURN_OFF_TIME, this.offTimeTicks);
        super.method_11007(tag);
    }

    public void tick(class_1937 level, class_2338 pos, class_2680 state) {
        if (this.getOffTime() == this.getOnTime()) {
            return;
        }
        if (TimeUtils.isInRange((long)((int)(level.method_8532() % DragonLib.ticksPerDay())), (long)this.onTimeTicks, (long)this.offTimeTicks)) {
            if (!((Boolean)state.method_11654((class_2769)StreetLampBaseBlock.LIT)).booleanValue()) {
                level.method_8501(pos, (class_2680)state.method_11657((class_2769)StreetLampBaseBlock.LIT, (Comparable)Boolean.valueOf(true)));
            }
        } else if (((Boolean)state.method_11654((class_2769)StreetLampBaseBlock.LIT)).booleanValue()) {
            level.method_8501(pos, (class_2680)state.method_11657((class_2769)StreetLampBaseBlock.LIT, (Comparable)Boolean.valueOf(false)));
        }
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, StreetLampBlockEntity blockEntity) {
        blockEntity.tick(level, pos, state);
    }

    public int getOnTime() {
        return this.onTimeTicks;
    }

    public int getOffTime() {
        return this.offTimeTicks;
    }

    public void setOnTime(int time) {
        this.onTimeTicks = class_3532.method_15340((int)time, (int)0, (int)((int)DragonLib.ticksPerDay() - 1));
        this.notifyUpdate();
    }

    public void setOffTime(int time) {
        this.offTimeTicks = class_3532.method_15340((int)time, (int)0, (int)((int)DragonLib.ticksPerDay() - 1));
        this.notifyUpdate();
    }
}

