/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block.entity;

import de.mrjulsen.mcdragonlib.core.Location;
import de.mrjulsen.trafficcraft.TrafficCraft;
import de.mrjulsen.trafficcraft.block.TrafficLightControllerBlock;
import de.mrjulsen.trafficcraft.block.data.TrafficLightColor;
import de.mrjulsen.trafficcraft.block.data.TrafficLightControlType;
import de.mrjulsen.trafficcraft.block.data.TrafficLightIcon;
import de.mrjulsen.trafficcraft.block.data.TrafficLightType;
import de.mrjulsen.trafficcraft.block.entity.ColoredBlockEntity;
import de.mrjulsen.trafficcraft.block.entity.TrafficLightControllerBlockEntity;
import de.mrjulsen.trafficcraft.data.TrafficLightSchedule;
import de.mrjulsen.trafficcraft.data.TrafficLightScheduleEntryData;
import de.mrjulsen.trafficcraft.registry.ModBlockEntities;
import de.mrjulsen.trafficcraft.util.OrderedArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class TrafficLightBlockEntity
extends ColoredBlockEntity {
    private static final String NBT_PHASE_ID = "phaseId";
    private static final String NBT_CONTROL_TYPE = "controlType";
    private static final String NBT_POWERED = "powered";
    private static final String NBT_TICKS = "ticks";
    private static final String NBT_TOTAL_TICKS = "totalTicks";
    private static final String NBT_RUNNING = "running";
    private static final String NBT_SCHEDULE = "schedule";
    private static final String NBT_ICON = "icon";
    private static final String NBT_TYPE = "type";
    private static final String NBT_COLOR_SLOTS = "colorSlots";
    private static final String NBT_ENABLED_COLORS = "enabledColors";
    @Deprecated
    private static final String NBT_LINKED_TO = "linkedTo";
    private int phaseId = 0;
    private TrafficLightControlType controlType = TrafficLightControlType.STATIC;
    private TrafficLightIcon icon = TrafficLightIcon.NONE;
    private TrafficLightType type = TrafficLightType.CAR;
    private final TrafficLightColor[] colorSlots = new TrafficLightColor[]{TrafficLightColor.RED, TrafficLightColor.YELLOW, TrafficLightColor.GREEN};
    private final Collection<TrafficLightColor> enabledColors = new ArrayList<TrafficLightColor>();
    private boolean powered = false;
    private TrafficLightSchedule schedule = new TrafficLightSchedule();
    private int ticker = 0;
    private long totalTicks = 0L;
    private boolean running = true;
    @Deprecated
    private Location linkLocation = null;
    private boolean linkMigrated = false;

    protected TrafficLightBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public TrafficLightBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntities.TRAFFIC_LIGHT_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.phaseId = compound.method_10550(NBT_PHASE_ID);
        this.controlType = TrafficLightControlType.getControlTypeByIndex(compound.method_10540(NBT_COLOR_SLOTS) == 3 ? (byte)compound.method_10550(NBT_CONTROL_TYPE) : compound.method_10571(NBT_CONTROL_TYPE));
        this.powered = compound.method_10577(NBT_POWERED);
        this.ticker = compound.method_10550(NBT_TICKS);
        this.totalTicks = compound.method_10537(NBT_TOTAL_TICKS);
        this.running = compound.method_10577(NBT_RUNNING);
        this.schedule = new TrafficLightSchedule();
        this.schedule.fromNbt(compound.method_10562(NBT_SCHEDULE));
        this.icon = TrafficLightIcon.getIconByIndex(compound.method_10571(NBT_ICON));
        this.type = TrafficLightType.getTypeByIndex(compound.method_10571(NBT_TYPE));
        int[] colorSlots = compound.method_10561(NBT_COLOR_SLOTS);
        for (int i = 0; i < colorSlots.length && i < this.colorSlots.length; ++i) {
            this.colorSlots[i] = TrafficLightColor.getColorByIndex((byte)colorSlots[i]);
        }
        this.enabledColors.clear();
        this.enabledColors.addAll(compound.method_10554(NBT_ENABLED_COLORS, 1).stream().map(x -> TrafficLightColor.getColorByIndex(((class_2481)x).method_10698())).toList());
        this.linkMigration(compound);
    }

    private void linkMigration(class_2487 nbt) {
        if (nbt.method_10545(NBT_LINKED_TO)) {
            TrafficCraft.LOGGER.warn("Traffic Light at position " + this.field_11867.method_23854() + " contains deprecated link data. Trying to convert it.");
            this.linkLocation = Location.fromNbtAsInt((class_2487)nbt.method_10562(NBT_LINKED_TO));
            this.linkMigrated = false;
            return;
        }
        this.linkMigrated = true;
    }

    @Override
    protected void method_11007(class_2487 tag) {
        tag.method_10569(NBT_PHASE_ID, this.phaseId);
        tag.method_10556(NBT_POWERED, this.powered);
        tag.method_10567(NBT_CONTROL_TYPE, this.controlType.getIndex());
        tag.method_10569(NBT_TICKS, this.ticker);
        tag.method_10544(NBT_TOTAL_TICKS, (long)this.ticker);
        tag.method_10556(NBT_RUNNING, this.running);
        tag.method_10566(NBT_SCHEDULE, (class_2520)this.schedule.toNbt());
        tag.method_10539(NBT_COLOR_SLOTS, Arrays.stream(this.colorSlots).mapToInt(x -> x.getIndex()).toArray());
        tag.method_10567(NBT_ICON, this.icon.getIndex());
        tag.method_10567(NBT_TYPE, this.type.getIndex());
        class_2499 enabledColorsTag = new class_2499();
        enabledColorsTag.addAll(this.enabledColors.stream().map(x -> class_2481.method_23233((byte)x.getIndex())).toList());
        tag.method_10566(NBT_ENABLED_COLORS, (class_2520)enabledColorsTag);
        if (!this.linkMigrated && this.linkLocation != null) {
            tag.method_10566(NBT_LINKED_TO, (class_2520)this.linkLocation.toNbt());
        }
        super.method_11007(tag);
    }

    private void tick(class_1937 level, class_2338 pos, class_2680 state) {
        if (level.field_9236) {
            return;
        }
        this.linkMigrationCheck(level, pos, state);
        if (this.running && this.getControlType() == TrafficLightControlType.OWN_SCHEDULE) {
            OrderedArrayList<TrafficLightScheduleEntryData> stateData = this.schedule.shouldChange(this.ticker);
            if (stateData == null) {
                this.ticker = 0;
                if (!this.schedule.isLoop()) {
                    this.setRunning(false);
                }
                return;
            }
            if (stateData.size() >= 0) {
                for (TrafficLightScheduleEntryData entry : stateData) {
                    List<TrafficLightColor> colors = entry.getEnabledColors();
                    if (colors == null) continue;
                    this.enableOnlyColors(colors);
                }
            }
            ++this.ticker;
            ++this.totalTicks;
        }
        if (this.isPowered() && !level.method_49803(pos)) {
            this.setPowered(false);
        }
    }

    private void linkMigrationCheck(class_1937 level, class_2338 pos, class_2680 state) {
        if (this.linkMigrated) {
            return;
        }
        if (this.linkLocation == null) {
            this.linkMigrated = true;
            return;
        }
        if (level.method_8477(this.linkLocation.getLocationBlockPos())) {
            class_2586 class_25862;
            if (level.method_8320(this.linkLocation.getLocationBlockPos()).method_26204() instanceof TrafficLightControllerBlock && (class_25862 = level.method_8321(this.linkLocation.getLocationBlockPos())) instanceof TrafficLightControllerBlockEntity) {
                TrafficLightControllerBlockEntity blockEntity = (TrafficLightControllerBlockEntity)class_25862;
                blockEntity.addTrafficLightLocation(new Location(pos.method_10263(), pos.method_10264(), pos.method_10260(), level.method_27983().method_29177().toString()));
            }
            this.linkMigrated = true;
            return;
        }
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, TrafficLightBlockEntity blockEntity) {
        blockEntity.tick(level, pos, state);
    }

    public void setPhaseId(int id) {
        this.phaseId = id;
        this.notifyUpdate();
    }

    public void setControlType(TrafficLightControlType controlType) {
        this.controlType = controlType;
        this.notifyUpdate();
    }

    public void setSchedule(TrafficLightSchedule schedule) {
        this.schedule = schedule;
        this.notifyUpdate();
    }

    public void setIcon(TrafficLightIcon icon) {
        this.icon = icon;
        this.notifyUpdate();
    }

    public boolean setColorToSlot(int index, TrafficLightColor color) {
        if (index < 0 || index >= this.colorSlots.length) {
            return false;
        }
        this.colorSlots[index] = color;
        this.notifyUpdate();
        return true;
    }

    public void setColorSlots(TrafficLightColor[] colorSlots) {
        for (int i = 0; i < colorSlots.length && i < this.getColorSlotCount(); ++i) {
            this.colorSlots[i] = colorSlots[i];
        }
        this.notifyUpdate();
    }

    public void enableColors(Collection<TrafficLightColor> colors) {
        this.enabledColors.addAll(colors);
        this.enabledColors.stream().distinct().toList();
        this.notifyUpdate();
    }

    public void enableOnlyColors(Collection<TrafficLightColor> colors) {
        this.enabledColors.clear();
        this.enabledColors.addAll(colors);
        this.enabledColors.stream().distinct().toList();
        this.notifyUpdate();
    }

    public void disableColors(Collection<TrafficLightColor> colors) {
        colors.forEach(x -> this.enabledColors.removeIf(y -> x == y));
        this.notifyUpdate();
    }

    public void disableAll(Collection<TrafficLightColor> colors) {
        this.enabledColors.clear();
        this.notifyUpdate();
    }

    public void setType(TrafficLightType type) {
        this.type = type;
        this.notifyUpdate();
    }

    public Collection<TrafficLightColor> getEnabledColors() {
        return this.enabledColors;
    }

    public boolean isColorEnabled(TrafficLightColor color, boolean allowSimilar) {
        return this.enabledColors.stream().anyMatch(x -> allowSimilar && x.isSimilar(color) || x == color);
    }

    public int getPhaseId() {
        return this.phaseId;
    }

    public TrafficLightControlType getControlType() {
        return this.controlType;
    }

    public TrafficLightColor[] getColorSlots() {
        return this.colorSlots;
    }

    public TrafficLightIcon getIcon() {
        return this.icon;
    }

    public TrafficLightType getTLType() {
        return this.type;
    }

    public TrafficLightColor getColorOfSlot(int index) {
        return index >= 0 && index < this.colorSlots.length ? this.colorSlots[index] : TrafficLightColor.NONE;
    }

    public int getColorSlotCount() {
        return this.colorSlots.length;
    }

    public TrafficLightSchedule getSchedule() {
        return this.schedule;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean b) {
        if (b && !this.running) {
            this.ticker = 0;
            this.totalTicks = 0L;
        }
        this.running = b;
        this.notifyUpdate();
    }

    public void startSchedule(boolean forceRestart) {
        if (this.controlType == TrafficLightControlType.OWN_SCHEDULE && (forceRestart || !this.isFirstIteration())) {
            this.ticker = 0;
            this.totalTicks = 0L;
            this.running = true;
        }
        this.notifyUpdate();
    }

    public void stopSchedule() {
        this.running = false;
        this.totalTicks = 0L;
        this.ticker = 0;
        this.notifyUpdate();
    }

    public boolean isFirstIteration() {
        return this.totalTicks == (long)this.ticker;
    }

    public void setPowered(boolean b) {
        this.powered = b;
        this.notifyUpdate();
    }

    public boolean isPowered() {
        return this.powered;
    }
}

