/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block.entity;

import de.mrjulsen.mcdragonlib.block.SyncedBlockEntity;
import de.mrjulsen.mcdragonlib.core.Location;
import de.mrjulsen.trafficcraft.block.TrafficLightBlock;
import de.mrjulsen.trafficcraft.block.data.TrafficLightColor;
import de.mrjulsen.trafficcraft.block.data.TrafficLightControlType;
import de.mrjulsen.trafficcraft.block.entity.TrafficLightBlockEntity;
import de.mrjulsen.trafficcraft.data.TrafficLightSchedule;
import de.mrjulsen.trafficcraft.data.TrafficLightScheduleEntryData;
import de.mrjulsen.trafficcraft.registry.ModBlockEntities;
import de.mrjulsen.trafficcraft.util.OrderedArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class TrafficLightControllerBlockEntity
extends SyncedBlockEntity {
    private static final String NBT_TRAFFIC_LIGHT_LOCATIONS = "LinkedTrafficLights";
    private static final String NBT_TICKS = "ticks";
    private static final String NBT_TOTAL_TICKS = "totalTicks";
    private static final String NBT_POWERED = "powered";
    private static final String NBT_SCHEDULES = "schedules";
    private static final String NBT_RUNNING = "running";
    private List<TrafficLightSchedule> schedules = new ArrayList<TrafficLightSchedule>();
    private int ticks = 0;
    private long totalTicks = 0L;
    private boolean running = true;
    private boolean powered = false;
    private List<Location> trafficLightLocations = new ArrayList<Location>();

    protected TrafficLightControllerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public TrafficLightControllerBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntities.TRAFFIC_LIGHT_CONTROLLER_BLOCK_ENTITY.get(), pos, state);
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.ticks = compound.method_10550(NBT_TICKS);
        this.running = compound.method_10577(NBT_RUNNING);
        this.totalTicks = compound.method_10537(NBT_TOTAL_TICKS);
        this.powered = compound.method_10577(NBT_POWERED);
        class_2499 listTag = compound.method_10554(NBT_SCHEDULES, 10);
        this.schedules.clear();
        for (int i = 0; i < listTag.size(); ++i) {
            TrafficLightSchedule data = new TrafficLightSchedule();
            data.fromNbt(listTag.method_10602(i));
            this.schedules.add(data);
        }
        class_2499 trafficLightsList = compound.method_10554(NBT_TRAFFIC_LIGHT_LOCATIONS, 10);
        this.trafficLightLocations.clear();
        for (int i = 0; i < trafficLightsList.size(); ++i) {
            Location loc = Location.fromNbt((class_2487)trafficLightsList.method_10602(i));
            this.trafficLightLocations.add(loc);
        }
    }

    protected void method_11007(class_2487 tag) {
        class_2499 listTag = new class_2499();
        for (TrafficLightSchedule data : this.schedules) {
            listTag.add((Object)data.toNbt());
        }
        class_2499 trafficLightsList = new class_2499();
        for (Location loc : this.trafficLightLocations) {
            trafficLightsList.add((Object)loc.toNbt());
        }
        tag.method_10569(NBT_TICKS, this.ticks);
        tag.method_10544(NBT_TOTAL_TICKS, this.totalTicks);
        tag.method_10556(NBT_POWERED, this.powered);
        tag.method_10556(NBT_RUNNING, this.running);
        tag.method_10566(NBT_SCHEDULES, (class_2520)listTag);
        tag.method_10566(NBT_TRAFFIC_LIGHT_LOCATIONS, (class_2520)trafficLightsList);
        super.method_11007(tag);
    }

    private void instanceTick(class_1937 level, class_2338 pos, class_2680 state) {
        if (level.field_9236) {
            return;
        }
        if (this.running) {
            TrafficLightSchedule schedule = this.getFirstOrMainSchedule();
            OrderedArrayList<TrafficLightScheduleEntryData> stateData = schedule.shouldChange(this.ticks);
            if (stateData == null) {
                this.ticks = 0;
                if (!schedule.isLoop()) {
                    this.setRunning(false);
                }
                return;
            }
            if (stateData.size() > 0) {
                for (TrafficLightScheduleEntryData entry : stateData) {
                    List<TrafficLightColor> colors = entry.getEnabledColors();
                    int phaseId = entry.getPhaseId();
                    this.trafficLightLocations.removeIf(a -> !level.method_8477(a.getLocationBlockPos()) && !(level.method_8320(a.getLocationBlockPos()).method_26204() instanceof TrafficLightBlock) || !(level.method_8321(a.getLocationBlockPos()) instanceof TrafficLightBlockEntity));
                    this.trafficLightLocations.stream().filter(x -> {
                        TrafficLightBlockEntity blockEntity;
                        class_2586 patt0$temp = level.method_8321(x.getLocationBlockPos());
                        return patt0$temp instanceof TrafficLightBlockEntity && (blockEntity = (TrafficLightBlockEntity)patt0$temp).getControlType() == TrafficLightControlType.REMOTE && blockEntity.getPhaseId() == phaseId;
                    }).forEach(a -> ((TrafficLightBlockEntity)level.method_8321(a.getLocationBlockPos())).enableOnlyColors(colors));
                }
            }
            ++this.ticks;
            ++this.totalTicks;
        }
        if (this.isPowered() && !level.method_49803(pos)) {
            this.setPowered(false);
        }
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, TrafficLightControllerBlockEntity blockEntity) {
        blockEntity.instanceTick(level, pos, state);
    }

    public List<TrafficLightSchedule> getSchedules() {
        return this.schedules;
    }

    public TrafficLightSchedule getFirstOrMainSchedule() {
        if (this.schedules.size() > 0) {
            return this.schedules.get(0);
        }
        return new TrafficLightSchedule();
    }

    public void setFirstOrMainSchedule(TrafficLightSchedule schedule) {
        if (this.schedules.size() > 0) {
            this.schedules.remove(0);
        }
        this.schedules.add(0, schedule);
        this.notifyUpdate();
    }

    public void setSchedules(List<TrafficLightSchedule> schedules) {
        this.schedules.clear();
        this.schedules = schedules;
        this.notifyUpdate();
    }

    public int getCurrentTick() {
        return this.ticks;
    }

    public void setCurrentTick(int t) {
        this.ticks = t;
        this.notifyUpdate();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean b) {
        this.running = b;
        this.notifyUpdate();
    }

    public void startSchedule(boolean forceRestart) {
        if (forceRestart || !this.isFirstIteration()) {
            this.totalTicks = 0L;
            this.ticks = 0;
            this.running = true;
            this.notifyUpdate();
        }
    }

    public void stopSchedule() {
        this.running = false;
        this.totalTicks = 0L;
        this.ticks = 0;
        this.notifyUpdate();
    }

    public boolean isFirstIteration() {
        return this.totalTicks == (long)this.ticks;
    }

    public void setPowered(boolean b) {
        this.powered = b;
        this.notifyUpdate();
    }

    public boolean isPowered() {
        return this.powered;
    }

    public List<Location> getTrafficLightLocations() {
        return this.trafficLightLocations;
    }

    public void addTrafficLightLocation(Location loc) {
        if (!this.trafficLightLocations.contains(loc)) {
            this.trafficLightLocations.add(loc);
            this.notifyUpdate();
        }
    }

    public void removeTrafficLightLocation(Location loc) {
        this.trafficLightLocations.removeIf(x -> x.equals((Object)loc));
        this.notifyUpdate();
    }
}

