/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block.entity;

import de.mrjulsen.mcdragonlib.block.SyncedBlockEntity;
import de.mrjulsen.mcdragonlib.core.Location;
import de.mrjulsen.trafficcraft.block.TrafficLightRequestButtonBlock;
import de.mrjulsen.trafficcraft.block.data.TrafficLightTrigger;
import de.mrjulsen.trafficcraft.block.entity.TrafficLightBlockEntity;
import de.mrjulsen.trafficcraft.block.entity.TrafficLightControllerBlockEntity;
import de.mrjulsen.trafficcraft.registry.ModBlockEntities;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class TrafficLightRequestButtonBlockEntity
extends SyncedBlockEntity {
    private static final String NBT_LISTENING = "listening";
    private static final String NBT_LINKED_TO = "linkedTo";
    private Location linkLocation;
    private boolean listening;

    protected TrafficLightRequestButtonBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public TrafficLightRequestButtonBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntities.TRAFFIC_LIGHT_REQUEST_BUTTON_BLOCK_ENTITY.get(), pos, state);
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.listening = compound.method_10577(NBT_LISTENING);
        if (compound.method_10545(NBT_LINKED_TO)) {
            this.linkLocation = Location.fromNbt((class_2487)compound.method_10562(NBT_LINKED_TO));
        }
    }

    protected void method_11007(class_2487 tag) {
        tag.method_10556(NBT_LISTENING, this.listening);
        if (this.linkLocation != null) {
            tag.method_10566(NBT_LINKED_TO, (class_2520)this.linkLocation.toNbt());
        }
        super.method_11007(tag);
    }

    private void tick(class_1937 level, class_2338 pos, class_2680 state) {
        if (this.listening && !level.field_9236) {
            boolean isRunning = false;
            if (this.linkLocation != null) {
                class_2586 class_25862 = level.method_8321(this.linkLocation.getLocationBlockPos());
                if (class_25862 instanceof TrafficLightBlockEntity) {
                    TrafficLightBlockEntity blockEntity = (TrafficLightBlockEntity)class_25862;
                    isRunning = blockEntity.isFirstIteration();
                } else {
                    class_25862 = level.method_8321(this.linkLocation.getLocationBlockPos());
                    if (class_25862 instanceof TrafficLightControllerBlockEntity) {
                        TrafficLightControllerBlockEntity blockEntity = (TrafficLightControllerBlockEntity)class_25862;
                        isRunning = blockEntity.isFirstIteration();
                    }
                }
            }
            if (!isRunning) {
                this.listening = false;
                level.method_8501(pos, (class_2680)((class_2680)state.method_11657((class_2769)TrafficLightRequestButtonBlock.ACTIVATED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)TrafficLightRequestButtonBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, TrafficLightRequestButtonBlockEntity blockEntity) {
        blockEntity.tick(level, pos, state);
    }

    public void linkTo(Location loc) {
        this.linkLocation = loc;
        this.notifyUpdate();
    }

    public void clearLink() {
        this.linkLocation = null;
        this.notifyUpdate();
    }

    public Location getLinkLocation() {
        return this.linkLocation;
    }

    public boolean isValidLinked() {
        return this.getLinkLocation() != null && (this.field_11863.method_8321(this.linkLocation.getLocationBlockPos()) instanceof TrafficLightControllerBlockEntity || this.field_11863.method_8321(this.linkLocation.getLocationBlockPos()) instanceof TrafficLightBlockEntity);
    }

    public boolean isListening() {
        return this.listening;
    }

    public boolean activate() {
        if (!this.isValidLinked()) {
            return false;
        }
        this.listening = true;
        class_2586 class_25862 = this.field_11863.method_8321(this.linkLocation.getLocationBlockPos());
        if (class_25862 instanceof TrafficLightBlockEntity) {
            TrafficLightBlockEntity blockEntity = (TrafficLightBlockEntity)class_25862;
            if (blockEntity.getSchedule().getTrigger() == TrafficLightTrigger.ON_REQUEST) {
                blockEntity.startSchedule(true);
                return true;
            }
        } else {
            TrafficLightControllerBlockEntity blockEntity;
            class_25862 = this.field_11863.method_8321(this.linkLocation.getLocationBlockPos());
            if (class_25862 instanceof TrafficLightControllerBlockEntity && (blockEntity = (TrafficLightControllerBlockEntity)class_25862).getFirstOrMainSchedule().getTrigger() == TrafficLightTrigger.ON_REQUEST) {
                blockEntity.startSchedule(true);
                return true;
            }
        }
        this.listening = false;
        return false;
    }
}

