/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block.entity;

import de.mrjulsen.mcdragonlib.block.SyncedBlockEntity;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.trafficcraft.TrafficCraft;
import de.mrjulsen.trafficcraft.block.TrafficSignBlock;
import de.mrjulsen.trafficcraft.block.data.TrafficSignShape;
import de.mrjulsen.trafficcraft.data.NamedTrafficSignTextureReference;
import de.mrjulsen.trafficcraft.data.TrafficSignClientTexture;
import de.mrjulsen.trafficcraft.data.TrafficSignTextureData;
import de.mrjulsen.trafficcraft.network.packets.stc.TrafficSignTextureResetPacket;
import de.mrjulsen.trafficcraft.registry.ModBlockEntities;
import dev.architectury.utils.GameInstance;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;

public class TrafficSignBlockEntity
extends SyncedBlockEntity {
    private static final String NBT_LEGACY_TEXTURE = "texture";
    private static final String NBT_TEXTURE = "SignTexture";
    private String textureId;
    private TrafficSignClientTexture texture;

    protected TrafficSignBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public TrafficSignBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntities.TRAFFIC_SIGN_BLOCK_ENTITY.get(), pos, state);
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        if (compound.method_10545(NBT_LEGACY_TEXTURE)) {
            this.migrate(compound.method_10558(NBT_LEGACY_TEXTURE));
        } else if (compound.method_10545(NBT_TEXTURE)) {
            this.setTextureId(compound.method_10558(NBT_TEXTURE));
        }
    }

    private void migrate(String base64) {
        new Thread(() -> {
            while (this.method_10997() == null) {
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.method_10997().field_9236) {
                return;
            }
            GameInstance.getServer().execute(() -> {
                class_2680 state = this.method_10997().method_8320(this.method_11016());
                TrafficSignTextureData data = new TrafficSignTextureData((TrafficSignShape)((Object)((Object)((Object)state.method_11654(TrafficSignBlock.SHAPE)))), Base64.getDecoder().decode(base64), 32, 32, System.currentTimeMillis(), new UUID(0L, 0L));
                data.save();
                this.setTextureId(data.getHash().toString());
            });
        }, "Traffic Sign Migration").start();
    }

    protected void method_11007(class_2487 tag) {
        if (this.textureId != null) {
            tag.method_10582(NBT_TEXTURE, this.getTextureId());
        }
        super.method_11007(tag);
    }

    public void method_11012() {
        super.method_11012();
        this.resetTexture();
    }

    public String getTextureId() {
        return this.textureId;
    }

    public TrafficSignClientTexture getClientTexture() {
        if (this.texture == null) {
            if (this.getTextureId() == null || this.getTextureId().equals("empty")) {
                return TrafficSignClientTexture.EMPTY;
            }
            this.texture = TrafficSignClientTexture.load(this.getTextureId(), true);
        }
        return this.texture;
    }

    public void resetTexture() {
        if (this.field_11863.field_9236) {
            DLUtils.doIfNotNull((Object)this.texture, x -> x.close());
            this.texture = null;
        }
    }

    public void setAndResetTexture(NamedTrafficSignTextureReference texture) {
        this.setTextureId(texture.getTextureId());
        if (!this.field_11863.field_9236) {
            for (class_3222 player : (class_3222[])this.field_11863.method_18456().stream().filter(p -> p instanceof class_3222).toArray(class_3222[]::new)) {
                TrafficCraft.net().sendToPlayer(player, (Object)new TrafficSignTextureResetPacket(this.method_11016()));
            }
        }
    }

    public void setTextureId(String id) {
        this.textureId = id;
        this.notifyUpdate();
    }
}

