/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.client.screen;

import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractImageButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLIconButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLVerticalScrollBar;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.client.util.WidgetsCollection;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.trafficcraft.TrafficCraft;
import de.mrjulsen.trafficcraft.data.PaintColor;
import de.mrjulsen.trafficcraft.network.packets.cts.PaintBrushPacket;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class PaintBrushScreen
extends DLScreen {
    public static final class_2561 title = TextUtils.translate((String)"gui.trafficcraft.paint_brush.title");
    public static final class_2561 titleOpenFileDialog = TextUtils.translate((String)"gui.trafficcraft.signpicker.openfiledialog");
    public static final class_2561 btnDoneText = TextUtils.translate((String)"gui.trafficcraft.signpicker.load");
    public static final class_2561 tooltipImport = TextUtils.translate((String)"gui.trafficcraft.signpicker.tooltip.import");
    private static final int WIDTH = 187;
    private static final int HEIGHT = 171;
    private static final int MAX_ENTRIES_IN_ROW = 9;
    private static final int MAX_ROWS = 6;
    private static final int ICON_BUTTON_WIDTH = 18;
    private static final int ICON_BUTTON_HEIGHT = 18;
    private int guiLeft;
    private int guiTop;
    private class_2960 preview;
    private double scroll;
    private final int paint;
    private final PaintColor color;
    private final int diffuseColor;
    private int patternId;
    private final WidgetsCollection groupPatterns = new WidgetsCollection();
    private DLVerticalScrollBar scrollbar;
    private boolean updateScrollableContent = true;
    private final class_2960[] resources;
    private final int count;

    public PaintBrushScreen(int patternId, int paint, PaintColor color) {
        super(title);
        this.patternId = patternId;
        this.paint = paint;
        this.color = color;
        this.diffuseColor = color.getTextureColor();
        class_2960 path = new class_2960("trafficcraft", "textures/block/sign_blank.png");
        ArrayList<class_2960> locs = new ArrayList<class_2960>();
        for (int i = 1; i <= 324; ++i) {
            locs.add(path);
            path = new class_2960("trafficcraft", "textures/block/patterns/" + i + ".png");
        }
        this.resources = (class_2960[])locs.toArray(class_2960[]::new);
        this.count = this.resources.length;
    }

    public void method_25419() {
        TrafficCraft.net().sendToServer((Object)new PaintBrushPacket(this.patternId));
        super.method_25419();
    }

    public void method_25426() {
        super.method_25426();
        this.guiLeft = this.field_22789 / 2 - 93;
        this.guiTop = this.field_22790 / 2 - 97;
        this.groupPatterns.components.clear();
        for (int i = 0; i < this.count; ++i) {
            int j = i;
            Sprite sprite = new Sprite(this.resources[j], 32, 32, 0, 0, 32, 32, 16, 16);
            DLIconButton btnImport = (DLIconButton)new DLIconButton(DLAbstractImageButton.ButtonType.RADIO_BUTTON, DynamicGuiRenderer.AreaStyle.BROWN, sprite, this.groupPatterns, this.guiLeft + 9, this.guiTop + 36 + j * 18, 18, 18, (class_2561)TextUtils.empty(), button -> {
                this.preview = this.resources[j];
                this.patternId = j;
            }){

                public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
                    GuiUtils.setTint((int)PaintBrushScreen.this.diffuseColor);
                    super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
                    GuiUtils.resetTint();
                }
            }.withAlignment(EAlignment.CENTER);
            if (this.patternId == j) {
                btnImport.select();
                this.preview = this.resources[j];
            }
            this.method_37063((class_364)btnImport);
        }
        this.scrollbar = (DLVerticalScrollBar)this.method_37063((class_364)((DLVerticalScrollBar)((DLVerticalScrollBar)new DLVerticalScrollBar(this.guiLeft + 171, this.guiTop + 16, 8, 110, new GuiAreaDefinition(this.guiLeft + 7, this.guiTop + 16, 164, 110)).withOnValueChanged(v -> {
            this.scroll = v.getScrollValue();
            if (this.updateScrollableContent) {
                this.fillButtons((DLIconButton[])this.groupPatterns.components.toArray(DLIconButton[]::new), this.scroll, this.guiLeft + 8, this.guiTop + 17, this.scrollbar);
            }
            this.updateScrollableContent = true;
        })).setAutoScrollerSize(true)));
        this.fillButtons((DLIconButton[])this.groupPatterns.components.toArray(DLIconButton[]::new), this.scroll, this.guiLeft + 8, this.guiTop + 17, this.scrollbar);
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderScreenBackground(graphics);
        DynamicGuiRenderer.renderWindow((Graphics)graphics, (int)this.guiLeft, (int)this.guiTop, (int)187, (int)171);
        DynamicGuiRenderer.renderArea((Graphics)graphics, (int)(this.guiLeft + 7), (int)(this.guiTop + 16), (int)164, (int)110, (DynamicGuiRenderer.AreaStyle)DynamicGuiRenderer.AreaStyle.BROWN, (DynamicGuiRenderer.ButtonState)DynamicGuiRenderer.ButtonState.DISABLED);
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
        GuiUtils.drawString((Graphics)graphics, (class_327)this.field_22793, (int)(this.guiLeft + 93), (int)(this.guiTop + 6), (class_5348)title, (int)-12566464, (EAlignment)EAlignment.CENTER, (boolean)false);
        if (this.preview != null) {
            GuiUtils.setTint((int)this.diffuseColor);
            GuiUtils.drawTexture((class_2960)this.preview, (Graphics)graphics, (int)(this.guiLeft + 8), (int)(this.guiTop + 130), (int)32, (int)32, (int)0, (int)0, (int)32, (int)32, (int)32, (int)32);
            GuiUtils.resetTint();
        }
        class_5250 textPattern = TextUtils.translate((String)"item.trafficcraft.paint_brush.tooltip.pattern", (Object[])new Object[]{this.patternId});
        class_5250 textColor = TextUtils.translate((String)"item.trafficcraft.paint_brush.tooltip.color", (Object[])new Object[]{TextUtils.translate((String)this.color.getValueTranslationKey("trafficcraft")).getString()});
        class_5250 textPaint = TextUtils.translate((String)"item.trafficcraft.paint_brush.tooltip.paint", (Object[])new Object[]{(int)(0.78125f * (float)this.paint)});
        GuiUtils.drawString((Graphics)graphics, (class_327)this.field_22793, (int)(this.guiLeft + 187 - 7), (int)(this.guiTop + 130), (class_5348)textPattern, (int)-12566464, (EAlignment)EAlignment.RIGHT, (boolean)false);
        Objects.requireNonNull(this.field_22793);
        GuiUtils.drawString((Graphics)graphics, (class_327)this.field_22793, (int)(this.guiLeft + 187 - 7), (int)(this.guiTop + 130 + 9), (class_5348)textColor, (int)-12566464, (EAlignment)EAlignment.RIGHT, (boolean)false);
        Objects.requireNonNull(this.field_22793);
        GuiUtils.drawString((Graphics)graphics, (class_327)this.field_22793, (int)(this.guiLeft + 187 - 7), (int)(this.guiTop + 130 + 9 * 2), (class_5348)textPaint, (int)-12566464, (EAlignment)EAlignment.RIGHT, (boolean)false);
    }

    private void fillButtons(DLIconButton[] buttons, double scrollRow, int defX, int defY, DLVerticalScrollBar scrollbar) {
        if (buttons.length <= 0) {
            return;
        }
        int currentRow = -1;
        for (int i = 0; i < buttons.length; ++i) {
            if (i % 9 == 0) {
                ++currentRow;
            }
            buttons[i].set_x(defX + i % 9 * 18);
            buttons[i].set_y((int)((double)(defY + currentRow * 18) - scrollRow * 18.0));
            buttons[i].set_visible((double)currentRow >= scrollRow && (double)currentRow < scrollRow + 6.0);
        }
        if (scrollbar != null) {
            this.updateScrollableContent = false;
            ((DLVerticalScrollBar)scrollbar.setScreenSize(6)).setMaxScroll(currentRow + 1);
        }
    }
}

