/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.client.screen;

import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractImageButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLItemButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLSlider;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.client.util.WidgetsCollection;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.core.Location;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.trafficcraft.TrafficCraft;
import de.mrjulsen.trafficcraft.block.data.RoadType;
import de.mrjulsen.trafficcraft.config.ModCommonConfig;
import de.mrjulsen.trafficcraft.item.RoadConstructionTool;
import de.mrjulsen.trafficcraft.network.packets.cts.RoadBuilderBuildRoadPacket;
import de.mrjulsen.trafficcraft.network.packets.cts.RoadBuilderDataPacket;
import de.mrjulsen.trafficcraft.network.packets.cts.RoadBuilderResetPacket;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;

public class RoadConstructionToolScreen
extends DLScreen {
    public static final class_2561 title = TextUtils.translate((String)"gui.trafficcraft.road_builder.title");
    private static final class_2960 GUI = new class_2960("trafficcraft", "textures/gui/road_construction_tool.png");
    private static final int GUI_WIDTH = 244;
    private static final int GUI_HEIGHT = 179;
    private static final int WORKING_AREA_X = 7;
    private static final int WORKING_AREA_Y = 17;
    private static final int WORKING_AREA_WIDTH = 230;
    private static final int WORKING_AREA_HEIGHT = 155;
    private static final int WORKING_AREA_BOTTOM = 172;
    private static final int WORKING_AREA_RIGHT = 237;
    private int guiTop;
    private int guiLeft;
    private final WidgetsCollection itemButtonCollection = new WidgetsCollection();
    private DLSlider widthSlider;
    private DLButton buildButton;
    private GuiAreaDefinition pos1Area;
    private GuiAreaDefinition pos2Area;
    private GuiAreaDefinition buildButtonArea;
    private byte roadWidth;
    private boolean replaceExistingBlocks;
    private RoadType roadType = RoadType.ASPHALT;
    private final class_1799 stack;
    private final Location pos1;
    private final Location pos2;
    private int blocksCount;
    private int slopesCount;
    private final class_2561 resetText = TextUtils.translate((String)"gui.trafficcraft.road_builder.reset");
    private final class_2561 buildText = TextUtils.translate((String)"gui.trafficcraft.road_builder.build").method_27692(class_124.field_1065).method_27692(class_124.field_1067);
    private final class_2561 replaceBlocksText = TextUtils.translate((String)"gui.trafficcraft.road_builder.replace_blocks");
    private final class_2561 roadWidthText = TextUtils.translate((String)"gui.trafficcraft.road_builder.road_width");
    private final class_2561 roadBlocksText = TextUtils.translate((String)"gui.trafficcraft.road_builder.road_blocks");
    private final class_2561 requiredResourcesText = TextUtils.translate((String)"gui.trafficcraft.road_builder.required_resources");
    private final class_2561 noPositionDefined = TextUtils.translate((String)"gui.trafficcraft.road_builder.no_pos_defined");
    private final class_2561 tooltipPos1 = TextUtils.translate((String)"gui.trafficcraft.road_builder.tooltip.pos1");
    private final class_2561 tooltipPos2 = TextUtils.translate((String)"gui.trafficcraft.road_builder.tooltip.pos2");
    private final class_2561 tooltipReplaceBlocks = TextUtils.translate((String)"gui.trafficcraft.road_builder.tooltip.replace_blocks");
    private final class_2561 tooltipReset = TextUtils.translate((String)"gui.trafficcraft.road_builder.tooltip.reset");
    private final class_2561 tooltipBuild = TextUtils.translate((String)"gui.trafficcraft.road_builder.tooltip.build");
    private final class_2561 tooltipBuildMissingPos = TextUtils.translate((String)"gui.trafficcraft.road_builder.tooltip.build_missing_pos");

    public RoadConstructionToolScreen(class_1799 stack, int blocksCount, int slopesCount) {
        super(title);
        if (!(stack.method_7909() instanceof RoadConstructionTool)) {
            throw new IllegalArgumentException(stack.method_7954().getString() + " is not a valid item for screen 'RoadBuilderToolScreen'.");
        }
        class_2487 nbt = stack.method_7948();
        this.pos1 = Location.fromNbt((class_2487)nbt.method_10562("Location1"));
        this.pos2 = Location.fromNbt((class_2487)nbt.method_10562("Location2"));
        this.roadWidth = nbt.method_10571("RoadWidth");
        this.replaceExistingBlocks = nbt.method_10577("ReplaceBlocks");
        this.roadType = RoadType.getRoadTypeByIndex(nbt.method_10550("RoadType"));
        this.stack = stack;
        this.blocksCount = blocksCount;
        this.slopesCount = slopesCount;
    }

    public void method_25426() {
        super.method_25426();
        this.guiLeft = this.field_22789 / 2 - 122;
        this.guiTop = this.field_22790 / 2 - 89;
        this.itemButtonCollection.components.clear();
        this.pos1Area = new GuiAreaDefinition(this.guiLeft + 7, this.guiTop + 17, 114, 18);
        this.pos2Area = new GuiAreaDefinition(this.guiLeft + 123, this.guiTop + 17, 114, 18);
        int btnSpace = 76;
        int btnWidth = btnSpace - 2;
        this.addButton(this.guiLeft + 7 + btnSpace * 0, this.guiTop + 172 - 20, btnWidth, 20, this.resetText, p -> {
            TrafficCraft.net().sendToServer((Object)new RoadBuilderResetPacket());
            this.method_25419();
        }, DLTooltip.of((class_5348)this.tooltipReset).withMaxWidth(this.field_22789 / 4));
        this.buildButton = this.addButton(this.guiLeft + 7 + btnSpace * 1 + 2, this.guiTop + 172 - 20, btnWidth, 20, this.buildText, p -> {
            this.updateStackData();
            class_2487 nbt = this.stack.method_7948();
            Location pos1 = Location.fromNbt((class_2487)nbt.method_10562("Location1"));
            Location pos2 = Location.fromNbt((class_2487)nbt.method_10562("Location2"));
            byte roadWidth = nbt.method_10571("RoadWidth");
            boolean replaceBlocks = nbt.method_10577("ReplaceBlocks");
            RoadType roadType = RoadType.getRoadTypeByIndex(nbt.method_10550("RoadType"));
            TrafficCraft.net().sendToServer((Object)new RoadBuilderBuildRoadPacket(pos1, pos2, roadWidth, replaceBlocks, roadType));
            RoadConstructionTool.reset(this.stack);
            TrafficCraft.net().sendToServer((Object)new RoadBuilderResetPacket());
            this.onDone();
        }, null);
        this.buildButton.field_22763 = this.pos1 != null && this.pos2 != null && this.roadWidth > 0;
        this.buildButtonArea = new GuiAreaDefinition(this.buildButton.x(), this.buildButton.y(), this.buildButton.method_25368(), this.buildButton.method_25364());
        this.addButton(this.guiLeft + 7 + btnSpace * 2 + 4, this.guiTop + 172 - 20, btnWidth, 20, class_5244.field_24334, p -> this.onDone(), null);
        this.addOnOffButton(this.guiLeft + 7, this.guiTop + 38, 114, 20, this.replaceBlocksText, this.replaceExistingBlocks, (btn, value) -> {
            this.replaceExistingBlocks = value;
            if (this.pos1 != null && this.pos2 != null) {
                RoadConstructionTool.RoadBuilderCountResult res = RoadConstructionTool.countBlocksNeeded((class_1937)this.field_22787.field_1687, this.pos1.getLocationVec3(), this.pos2.getLocationVec3(), this.roadWidth, this.replaceExistingBlocks);
                this.blocksCount = res.blocksCount;
                this.slopesCount = res.slopesCount;
            }
        }, DLTooltip.of((class_5348)this.tooltipReplaceBlocks).withMaxWidth(this.field_22789 / 4));
        this.widthSlider = this.addSlider(this.guiLeft + 7 + 116, this.guiTop + 38, 114, 20, this.roadWidthText, (class_2561)TextUtils.text((String)""), 1.0, ((Integer)ModCommonConfig.ROAD_BUILDER_MAX_ROAD_WIDTH.get()).intValue(), 1.0, this.roadWidth, true, (slider, value) -> {
            this.roadWidth = value.byteValue();
            if (this.pos1 != null && this.pos2 != null) {
                RoadConstructionTool.RoadBuilderCountResult res = RoadConstructionTool.countBlocksNeeded((class_1937)this.field_22787.field_1687, this.pos1.getLocationVec3(), this.pos2.getLocationVec3(), this.roadWidth, this.replaceExistingBlocks);
                this.blocksCount = res.blocksCount;
                this.slopesCount = res.slopesCount;
            }
        }, null, null);
        int blocksWidth = 228;
        int buttonWidth = blocksWidth / (RoadType.values().length - 1);
        for (int i = 1; i < RoadType.values().length; ++i) {
            RoadType type = RoadType.values()[i];
            DLItemButton btn2 = (DLItemButton)this.method_37063((class_364)((DLItemButton)new DLItemButton(DLAbstractImageButton.ButtonType.RADIO_BUTTON, DynamicGuiRenderer.AreaStyle.BROWN, new class_1799((class_1935)type.getBlock().method_8389()), this.itemButtonCollection, this.guiLeft + 7 + 1 + buttonWidth * (i - 1), this.guiTop + 84, buttonWidth, 18, null, p -> {
                this.roadType = type;
            }).withAlignment(EAlignment.LEFT)));
            if (type != this.roadType) continue;
            btn2.select();
        }
        this.addTooltip(DLTooltip.of((class_5348)this.tooltipPos1).assignedTo(this.pos1Area));
        this.addTooltip(DLTooltip.of((class_5348)this.tooltipPos2).assignedTo(this.pos2Area));
    }

    private void updateStackData() {
        this.roadWidth = (byte)this.widthSlider.getValue();
        class_2487 nbt = this.stack.method_7948();
        nbt.method_10567("RoadWidth", this.roadWidth);
        nbt.method_10556("ReplaceBlocks", this.replaceExistingBlocks);
        nbt.method_10569("RoadType", this.roadType.getIndex());
        TrafficCraft.net().sendToServer((Object)new RoadBuilderDataPacket(this.replaceExistingBlocks, this.roadWidth, this.roadType));
    }

    protected void onDone() {
        this.updateStackData();
        this.method_25419();
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderScreenBackground(graphics);
        GuiUtils.drawTexture((class_2960)GUI, (Graphics)graphics, (int)this.guiLeft, (int)this.guiTop, (int)0, (int)0, (int)244, (int)179);
        GuiUtils.drawString((Graphics)graphics, (class_327)this.field_22793, (int)(this.field_22789 / 2 - this.field_22793.method_27525((class_5348)title) / 2), (int)(this.guiTop + 6), (class_5348)title, (int)-12566464, (EAlignment)EAlignment.LEFT, (boolean)false);
        GuiUtils.drawString((Graphics)graphics, (class_327)this.field_22793, (int)(this.guiLeft + 7), (int)(this.guiTop + 73), (class_5348)this.roadBlocksText, (int)-12566464, (EAlignment)EAlignment.LEFT, (boolean)false);
        GuiUtils.drawString((Graphics)graphics, (class_327)this.field_22793, (int)(this.guiLeft + 7 + 3), (int)(this.guiTop + 107), (class_5348)this.requiredResourcesText, (int)-96, (EAlignment)EAlignment.LEFT, (boolean)false);
        String pos1Text = this.pos1 == null ? this.noPositionDefined.getString() : String.format("%s, %s, %s", MathUtils.round((double)this.pos1.x, (int)2), MathUtils.round((double)this.pos1.y, (int)2), MathUtils.round((double)this.pos1.z, (int)2));
        String pos2Text = this.pos2 == null ? this.noPositionDefined.getString() : String.format("%s, %s, %s", MathUtils.round((double)this.pos2.x, (int)2), MathUtils.round((double)this.pos2.y, (int)2), MathUtils.round((double)this.pos2.z, (int)2));
        GuiUtils.drawString((Graphics)graphics, (class_327)this.field_22793, (int)(this.guiLeft + 7 + 57), (int)(this.guiTop + 22), (String)pos1Text, (int)(this.pos1 == null ? -2285022 : -11184811), (EAlignment)EAlignment.CENTER, (boolean)false);
        GuiUtils.drawString((Graphics)graphics, (class_327)this.field_22793, (int)(this.guiLeft + 7 + 116 + 57), (int)(this.guiTop + 22), (String)pos2Text, (int)(this.pos2 == null ? -2285022 : -11184811), (EAlignment)EAlignment.CENTER, (boolean)false);
        if (this.pos1 != null && this.pos2 != null) {
            String blockCountText = String.format("x %s", this.blocksCount);
            String slopeCountText = String.format("x %s", this.slopesCount);
            int blockDisplayWidth = 20 + this.field_22793.method_1727(blockCountText);
            int slopeDisplayWidth = 20 + this.field_22793.method_1727(slopeCountText);
            int guiCenter = this.guiLeft + 7 + 115;
            graphics.graphics().method_51427(new class_1799((class_1935)this.roadType.getBlock()), guiCenter - 57 - blockDisplayWidth / 2, this.guiTop + 122);
            graphics.graphics().method_51427(new class_1799((class_1935)this.roadType.getSlope()), guiCenter + 57 - slopeDisplayWidth / 2, this.guiTop + 122);
            GuiUtils.drawString((Graphics)graphics, (class_327)this.field_22793, (int)(guiCenter - 57 - blockDisplayWidth / 2 + 20), (int)(this.guiTop + 127), (String)blockCountText, (int)-2368549, (EAlignment)EAlignment.LEFT, (boolean)false);
            GuiUtils.drawString((Graphics)graphics, (class_327)this.field_22793, (int)(guiCenter + 57 - slopeDisplayWidth / 2 + 20), (int)(this.guiTop + 127), (String)slopeCountText, (int)-2368549, (EAlignment)EAlignment.LEFT, (boolean)false);
        }
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
        if (this.buildButtonArea.isInBounds((double)mouseX, (double)mouseY)) {
            if (this.pos1 == null || this.pos2 == null) {
                GuiUtils.renderTooltip((class_437)this, (GuiAreaDefinition)this.buildButtonArea, List.of(this.tooltipBuildMissingPos), (int)(this.field_22789 / 4), (Graphics)graphics, (int)mouseX, (int)mouseY);
            } else {
                GuiUtils.renderTooltip((class_437)this, (class_339)this.buildButton, List.of(this.tooltipBuild), (int)(this.field_22789 / 4), (Graphics)graphics, (int)mouseX, (int)mouseY);
            }
        }
    }
}

