/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.client.screen;

import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractImageButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLIconButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLVerticalScrollBar;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.client.util.WidgetsCollection;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.trafficcraft.block.data.TrafficSignShape;
import de.mrjulsen.trafficcraft.client.screen.TrafficSignWorkbenchGui;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3298;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class SignPickerScreen
extends DLScreen {
    public static final class_2561 title = TextUtils.translate((String)"gui.trafficcraft.signpicker.title");
    public static final class_2561 titleOpenFileDialog = TextUtils.translate((String)"gui.trafficcraft.signpicker.openfiledialog");
    public static final class_2561 btnDoneText = TextUtils.translate((String)"gui.trafficcraft.signpicker.load");
    public static final class_2561 tooltipImport = TextUtils.translate((String)"gui.trafficcraft.signpicker.tooltip.import");
    private static final int WIDTH = 187;
    private static final int HEIGHT = 171;
    private static final int MAX_ENTRIES_IN_ROW = 9;
    private static final int MAX_ROWS = 6;
    private static final int ICON_BUTTON_WIDTH = 18;
    private static final int ICON_BUTTON_HEIGHT = 18;
    private int guiLeft;
    private int guiTop;
    private class_1043 preview;
    private double scroll = 0.0;
    private final class_437 lastScreen;
    private final TrafficSignShape shape;
    private final WidgetsCollection groupPatterns = new WidgetsCollection();
    private DLVerticalScrollBar scrollbar;
    private boolean updateScrollableContent = true;
    private DLButton doneButton;
    private final class_2960[] resources;
    private final int count;
    private final Consumer<class_1011> result;

    public SignPickerScreen(class_437 lastScreen, TrafficSignShape shape, Consumer<class_1011> result) {
        super(title);
        this.lastScreen = lastScreen;
        this.shape = shape;
        this.result = result;
        int i = 1;
        class_2960 path = new class_2960("trafficcraft:textures/block/sign/" + shape.getShape() + "/" + shape.getShape() + i + ".png");
        ArrayList<class_2960> locs = new ArrayList<class_2960>();
        while (class_310.method_1551().method_1478().method_14486(path).isPresent()) {
            locs.add(path);
            path = new class_2960("trafficcraft:textures/block/sign/" + shape.getShape() + "/" + shape.getShape() + ++i + ".png");
        }
        this.resources = (class_2960[])locs.toArray(class_2960[]::new);
        this.count = this.resources.length;
    }

    public void method_25419() {
        if (this.lastScreen != null) {
            this.field_22787.method_1507(this.lastScreen);
        } else {
            super.method_25419();
        }
    }

    public void method_25393() {
        this.doneButton.set_active(this.preview != null);
        super.method_25393();
    }

    public void method_25426() {
        super.method_25426();
        this.guiLeft = this.field_22789 / 2 - 93;
        this.guiTop = this.field_22790 / 2 - 97;
        this.groupPatterns.components.clear();
        this.doneButton = this.addButton(this.guiLeft + 93 - 67 + 20, this.guiTop + 171 - 28, 65, 20, btnDoneText, p -> this.onDone(), null);
        this.addButton(this.guiLeft + 93 + 2 + 20, this.guiTop + 171 - 28, 65, 20, class_5244.field_24335, p -> this.method_25419(), null);
        DLIconButton btn = (DLIconButton)new DLIconButton(DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.BROWN, TrafficSignWorkbenchGui.ButtonIcons.IMPORT.getSprite(), this.groupPatterns, this.guiLeft + 9, this.guiTop + 36 + 0, 18, 18, (class_2561)TextUtils.empty(), button -> {
            this.groupPatterns.performForEach(x -> ((DLIconButton)x).deselect());
            PointerBuffer filterPatterns = MemoryUtil.memAllocPointer((int)5);
            filterPatterns.put(MemoryUtil.memUTF8((CharSequence)"*.png"));
            filterPatterns.put(MemoryUtil.memUTF8((CharSequence)"*.jpg"));
            filterPatterns.put(MemoryUtil.memUTF8((CharSequence)"*.jpeg"));
            filterPatterns.put(MemoryUtil.memUTF8((CharSequence)"*.gif"));
            filterPatterns.put(MemoryUtil.memUTF8((CharSequence)"*.bmp"));
            filterPatterns.flip();
            this.field_22787.method_1483().method_4879();
            String s = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)titleOpenFileDialog.getString(), (CharSequence)null, (PointerBuffer)filterPatterns, (CharSequence)"Image Files", (boolean)false);
            if (s != null) {
                try (InputStream data = DLUtils.scaleImage((InputStream)new FileInputStream(s), (int)32, (int)32);){
                    if (this.preview != null) {
                        this.preview.close();
                        this.preview = null;
                    }
                    class_1011 img = class_1011.method_4309((InputStream)data);
                    Arrays.stream(this.shape.getInvalidPixels()).forEach(c -> {
                        byte[] coords = DLUtils.intToCoords((int)c);
                        byte x = coords[0];
                        byte y = coords[1];
                        img.method_4305((int)x, (int)y, 0);
                    });
                    this.preview = new class_1043(img);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.field_22787.method_1483().method_4880();
        }).withAlignment(EAlignment.CENTER);
        this.addTooltip(DLTooltip.of((class_5348)tooltipImport).assignedTo((class_339)btn)).withMaxWidth(this.field_22789 / 4);
        this.method_37063((class_364)btn);
        int i = 0;
        while (i < this.count) {
            int j = i++;
            Sprite sprite = new Sprite(this.resources[j], 32, 32, 0, 0, 32, 32, 16, 16);
            DLIconButton btnImport = (DLIconButton)new DLIconButton(DLAbstractImageButton.ButtonType.RADIO_BUTTON, DynamicGuiRenderer.AreaStyle.BROWN, sprite, this.groupPatterns, this.guiLeft + 9, this.guiTop + 36 + j * 18, 18, 18, (class_2561)TextUtils.empty(), button -> {
                if (this.preview != null) {
                    this.preview.close();
                    this.preview = null;
                }
                try {
                    this.preview = new class_1043(class_1011.method_4309((InputStream)((class_3298)this.field_22787.method_1478().method_14486(this.resources[j]).get()).method_14482()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }).withAlignment(EAlignment.CENTER);
            this.method_37063((class_364)btnImport);
        }
        this.scrollbar = (DLVerticalScrollBar)this.method_37063((class_364)((DLVerticalScrollBar)((DLVerticalScrollBar)new DLVerticalScrollBar(this.guiLeft + 171, this.guiTop + 16, 8, 110, new GuiAreaDefinition(this.guiLeft + 7, this.guiTop + 16, 164, 110)).withOnValueChanged(v -> {
            this.scroll = v.getScrollValue();
            if (this.updateScrollableContent) {
                this.fillButtons((DLIconButton[])this.groupPatterns.components.toArray(DLIconButton[]::new), this.scroll, this.guiLeft + 8, this.guiTop + 17, this.scrollbar);
            }
            this.updateScrollableContent = true;
        })).setAutoScrollerSize(true)));
        this.fillButtons((DLIconButton[])this.groupPatterns.components.toArray(DLIconButton[]::new), this.scroll, this.guiLeft + 8, this.guiTop + 17, this.scrollbar);
    }

    protected void onDone() {
        class_1011 img = null;
        if (this.preview != null) {
            class_1011 image = this.preview.method_4525();
            Arrays.stream(this.shape.getInvalidPixels()).forEach(c -> {
                byte[] coords = DLUtils.intToCoords((int)c);
                byte x = coords[0];
                byte y = coords[1];
                image.method_4305((int)x, (int)y, 0);
            });
            img = image;
        }
        this.result.accept(img);
        this.method_25419();
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderScreenBackground(graphics);
        DynamicGuiRenderer.renderWindow((Graphics)graphics, (int)this.guiLeft, (int)this.guiTop, (int)187, (int)171);
        DynamicGuiRenderer.renderArea((Graphics)graphics, (int)(this.guiLeft + 7), (int)(this.guiTop + 16), (int)164, (int)110, (DynamicGuiRenderer.AreaStyle)DynamicGuiRenderer.AreaStyle.BROWN, (DynamicGuiRenderer.ButtonState)DynamicGuiRenderer.ButtonState.DOWN);
        GuiUtils.drawString((Graphics)graphics, (class_327)this.field_22793, (int)(this.guiLeft + 93), (int)(this.guiTop + 6), (class_5348)title, (int)-12566464, (EAlignment)EAlignment.CENTER, (boolean)false);
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
        if (this.preview != null) {
            GuiUtils.drawTexture((int)this.preview.method_4624(), (Graphics)graphics, (int)(this.guiLeft + 8), (int)(this.guiTop + 130), (int)32, (int)32, (int)0, (int)0, (int)32, (int)32, (int)32, (int)32);
        }
    }

    private void fillButtons(DLIconButton[] buttons, double scrollRow, int defX, int defY, DLVerticalScrollBar scrollbar) {
        if (buttons.length <= 0) {
            return;
        }
        int currentRow = -1;
        for (int i = 0; i < buttons.length; ++i) {
            if (i % 9 == 0) {
                ++currentRow;
            }
            buttons[i].set_x(defX + i % 9 * 18);
            buttons[i].set_y((int)((double)(defY + currentRow * 18) - scrollRow * 18.0));
            buttons[i].set_visible((double)currentRow >= scrollRow && (double)currentRow < scrollRow + 6.0);
        }
        if (scrollbar != null) {
            this.updateScrollableContent = false;
            ((DLVerticalScrollBar)scrollbar.setScreenSize(6)).setMaxScroll(currentRow + 1);
        }
    }
}

