/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.client.screen;

import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractImageButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLEditBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLIconButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLItemButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.client.util.WidgetsCollection;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.data.Clipboard;
import de.mrjulsen.mcdragonlib.data.INBTSerializable;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.Wikipedia;
import de.mrjulsen.trafficcraft.Constants;
import de.mrjulsen.trafficcraft.TrafficCraft;
import de.mrjulsen.trafficcraft.block.TrafficLightBlock;
import de.mrjulsen.trafficcraft.block.data.TrafficLightColor;
import de.mrjulsen.trafficcraft.block.data.TrafficLightControlType;
import de.mrjulsen.trafficcraft.block.data.TrafficLightIcon;
import de.mrjulsen.trafficcraft.block.data.TrafficLightModel;
import de.mrjulsen.trafficcraft.block.data.TrafficLightType;
import de.mrjulsen.trafficcraft.block.entity.TrafficLightBlockEntity;
import de.mrjulsen.trafficcraft.client.ModGuiUtils;
import de.mrjulsen.trafficcraft.client.TrafficLightTextureManager;
import de.mrjulsen.trafficcraft.client.screen.TrafficLightScheduleEditor;
import de.mrjulsen.trafficcraft.data.TrafficLightSchedule;
import de.mrjulsen.trafficcraft.network.packets.cts.TrafficLightPacket;
import de.mrjulsen.trafficcraft.network.packets.cts.TrafficLightSchedulePacket;
import de.mrjulsen.trafficcraft.registry.ModBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5489;
import net.minecraft.class_6880;

public class TrafficLightConfigScreen
extends DLScreen {
    private static final class_2960 WIDGETS_LOCATION = new class_2960("trafficcraft", "textures/gui/window_arrow.png");
    private static final int WINDOW_WIDTH = 241;
    private static final int WINDOW_HEIGHT = 230;
    private static final int WINDOW_PADDING_LEFT = 69;
    private static final int INNER_PADDING = 7;
    private static final int INNER_TOP_PADDING = 20;
    private static final int TRAFFIC_LIGHT_LIGHT_SIZE = 24;
    private static final int GLOBAL_SETTINGS_INDEX = -1;
    private static final float SMALL_SCALE_VALUE = 0.75f;
    private class_5489 emptyLabel;
    private class_5489 phaseIdDescriptionLabel;
    private DLTooltip trafficLightAreaTooltip;
    private GuiAreaDefinition trafficLightArea;
    private GuiAreaDefinition ctrlWindowArea;
    private GuiAreaDefinition ctrlButtonsArea;
    private GuiAreaDefinition ctrlSettingsArea;
    private GuiAreaDefinition[] trafficLightLightAreas;
    private final WidgetsCollection typeGroup = new WidgetsCollection();
    private final WidgetsCollection modelGroup = new WidgetsCollection();
    private final WidgetsCollection iconGroup = new WidgetsCollection();
    private final WidgetsCollection colorGroup = new WidgetsCollection();
    private final WidgetsCollection controlTypeGroup = new WidgetsCollection();
    private final Collection<DLTooltip> iconTooltips = new ArrayList<DLTooltip>();
    private final Collection<DLTooltip> colorTooltips = new ArrayList<DLTooltip>();
    private final Collection<DLTooltip> modelTooltips = new ArrayList<DLTooltip>();
    private final Collection<DLTooltip> controlTypeTooltips = new ArrayList<DLTooltip>();
    private final Map<TrafficLightControlType, WidgetsCollection> controlTypeTabGroups = new HashMap<TrafficLightControlType, WidgetsCollection>();
    private final Map<TrafficLightControlType, Collection<DLTooltip>> controlTypeTabTooltips = new HashMap<TrafficLightControlType, Collection<DLTooltip>>();
    private final Map<Byte, DLIconButton> indexedColorButtons = new HashMap<Byte, DLIconButton>();
    private final class_1937 level;
    private final class_2338 blockPos;
    private int selectedPart = -2;
    private int guiLeft;
    private int guiTop;
    private DLIconButton pasteButton;
    private final Set<TrafficLightColor> enabledColors = new HashSet<TrafficLightColor>();
    private TrafficLightType type = TrafficLightType.CAR;
    private TrafficLightModel model = TrafficLightModel.THREE_LIGHTS;
    private TrafficLightIcon icon = TrafficLightIcon.NONE;
    private TrafficLightControlType controlType = TrafficLightControlType.STATIC;
    private TrafficLightColor[] colors = new TrafficLightColor[TrafficLightModel.maxRequiredSlots()];
    private int phaseId = 0;
    private boolean scheduleEnabled = true;
    private static final class_2561 textEmpty = TextUtils.translate((String)"gui.trafficcraft.trafficlight.empty");
    private static final class_2561 textGeneralSettings = TextUtils.translate((String)"gui.trafficcraft.trafficlight.general_settings");
    private static final class_2561 textSetSignal = TextUtils.translate((String)"gui.trafficcraft.trafficlight.set_signal");
    private static final class_2561 textAreaTrafficLight = TextUtils.translate((String)"gui.trafficcraft.trafficlight.edit_traffic_light");
    private static final class_2561 textCustomizeSchedule = TextUtils.translate((String)"gui.trafficcraft.trafficlight.edit_schedule");
    private static final class_2561 textSetEnabledColors = TextUtils.translate((String)"gui.trafficcraft.trafficlight.set_enabled_colors");
    private static final class_2561 textSetPhaseId = TextUtils.translate((String)"gui.trafficcraft.trafficlight.set_phase_id");
    private static final class_2561 textPhaseIdDescription = TextUtils.translate((String)"gui.trafficcraft.trafficlight.set_phase_id.description");
    private static final String textStatus = TextUtils.translate((String)"gui.trafficcraft.trafficlight.schedule_status").getString();
    private static final String keyAreaTrafficLightSignal = "gui.trafficcraft.trafficlight.edit_signal_";
    private static final String keyhelpTrafficLight = "gui.trafficcraft.trafficlight.help.traffic_light";
    private static final String keyhelpTrafficLightDescription = "gui.trafficcraft.trafficlight.helpdesc.traffic_light";
    private static final String keyhelpTramTrafficLight = "gui.trafficcraft.trafficlight.help.traffic_light_tram";
    private static final String keyhelpTramTrafficLightDescription = "gui.trafficcraft.trafficlight.helpdesc.traffic_light_tram";

    public TrafficLightConfigScreen(class_1937 level, class_2338 pos) {
        super((class_2561)TextUtils.translate((String)"gui.trafficcraft.trafficlight.title"));
        Object object;
        this.level = level;
        this.blockPos = pos;
        Arrays.fill((Object[])this.colors, (Object)TrafficLightColor.NONE);
        for (TrafficLightControlType type : TrafficLightControlType.values()) {
            this.controlTypeTabTooltips.put(type, new ArrayList());
            this.controlTypeTabGroups.put(type, new WidgetsCollection());
        }
        if (level.method_8320(pos).method_26204() instanceof TrafficLightBlock) {
            this.model = (TrafficLightModel)((Object)level.method_8320(pos).method_11654(TrafficLightBlock.MODEL));
        }
        if ((object = level.method_8321(pos)) instanceof TrafficLightBlockEntity) {
            TrafficLightBlockEntity blockEntity = (TrafficLightBlockEntity)object;
            for (TrafficLightColor color : blockEntity.getEnabledColors()) {
                this.enabledColors.add(color);
            }
            this.type = blockEntity.getTLType();
            this.icon = blockEntity.getIcon();
            this.controlType = blockEntity.getControlType();
            TrafficLightColor[] slots = blockEntity.getColorSlots();
            for (int i = 0; i < slots.length && i < this.colors.length; ++i) {
                this.colors[i] = slots[i];
            }
            this.phaseId = blockEntity.getPhaseId();
            this.scheduleEnabled = blockEntity.isRunning();
        }
    }

    public void method_25419() {
        TrafficCraft.net().sendToServer((Object)new TrafficLightPacket(this.blockPos, this.enabledColors, this.type, this.model, this.icon, this.controlType, this.colors, this.phaseId, this.scheduleEnabled));
        super.method_25419();
    }

    public void method_25393() {
        super.method_25393();
        if (this.pasteButton != null) {
            this.pasteButton.field_22763 = Clipboard.contains(TrafficLightSchedule.class);
        }
    }

    protected void method_25426() {
        DLIconButton b;
        int i;
        super.method_25426();
        this.guiLeft = this.field_22789 / 2 - 120;
        this.guiTop = this.field_22790 / 2 - 115;
        this.typeGroup.clear();
        this.modelGroup.clear();
        this.iconGroup.clear();
        this.colorGroup.clear();
        int typeButtonWidth = 156 / TrafficLightType.values().length;
        for (i = 0; i < TrafficLightType.values().length; ++i) {
            TrafficLightType type = TrafficLightType.values()[i];
            b = (DLIconButton)this.method_37063((class_364)((DLIconButton)new DLIconButton(DLAbstractImageButton.ButtonType.RADIO_BUTTON, DynamicGuiRenderer.AreaStyle.BROWN, type.getSprite(), this.typeGroup, this.guiLeft + 69 + 7 + 1 + i * typeButtonWidth, this.guiTop + 21 + 20, typeButtonWidth, 18, (class_2561)TextUtils.translate((String)type.getTranslationKey()), btn -> {
                this.type = type;
                this.initIconButtons();
                this.initColorButtons();
                for (int k = 0; k < this.colors.length; ++k) {
                    TrafficLightColor color = this.colors[k];
                    if (color.isAllowedFor(type)) continue;
                    this.colors[k] = Arrays.stream(color.getSimilar()).filter(x -> x.isAllowedFor(type)).findFirst().orElse(TrafficLightColor.NONE);
                }
            }).withAlignment(EAlignment.LEFT)));
            this.addTooltip(DLTooltip.of(List.of(TextUtils.translate((String)type.getValueTranslationKey("trafficcraft")).method_27692(class_124.field_1067), TextUtils.translate((String)type.getValueInfoTranslationKey("trafficcraft")).method_27692(class_124.field_1080))).withMaxWidth(this.field_22789 / 4).assignedTo((class_339)b));
            if (this.type != type) continue;
            b.select();
        }
        for (i = 0; i < TrafficLightModel.values().length; ++i) {
            TrafficLightModel model = TrafficLightModel.values()[i];
            b = (DLIconButton)this.method_37063((class_364)new DLIconButton(DLAbstractImageButton.ButtonType.RADIO_BUTTON, DynamicGuiRenderer.AreaStyle.BROWN, model.getSprite(), this.modelGroup, this.guiLeft + 69 + 7 + 1 + i * 18, this.guiTop + 21 + 25 + 20, null, btn -> {
                this.model = model;
                this.initModelButtonAreas();
            }));
            this.addTooltip(DLTooltip.of(List.of(TextUtils.translate((String)model.getValueTranslationKey("trafficcraft")))).withMaxWidth(this.field_22789 / 4).assignedTo((class_339)b));
            if (this.model != model) continue;
            b.select();
        }
        this.emptyLabel = class_5489.method_30891((class_327)this.field_22793, (class_5348)textEmpty, (int)172, (int)10);
        this.initIconButtons();
        this.initModelButtonAreas();
        this.initColorButtons();
        this.switchPartEditor(this.selectedPart);
    }

    private void initIconButtons() {
        this.iconGroup.performForEach(x -> this.method_37066((class_364)x));
        this.iconGroup.clear();
        this.removeTooltips(x -> this.iconTooltips.contains(x));
        TrafficLightIcon[] icons = TrafficLightIcon.getAllowedForType(this.type);
        for (int i = 0; i < icons.length; ++i) {
            TrafficLightIcon icon = icons[i];
            DLIconButton b = (DLIconButton)this.method_37063((class_364)new DLIconButton(DLAbstractImageButton.ButtonType.RADIO_BUTTON, DynamicGuiRenderer.AreaStyle.BROWN, icon.getSprite(this.type), this.iconGroup, this.guiLeft + 69 + 7 + 1 + i * 18, this.guiTop + 21 + 50 + 20, null, btn -> {
                this.icon = icon;
                this.initColorButtons();
            }));
            if (this.type == TrafficLightType.TRAM) {
                String signalName = "h-1";
                switch (icon) {
                    default: {
                        signalName = "f5";
                        break;
                    }
                    case LEFT: {
                        signalName = "f3";
                        break;
                    }
                    case RIGHT: {
                        signalName = "f2";
                        break;
                    }
                    case STRAIGHT: {
                        signalName = "f1";
                    }
                }
                this.iconTooltips.add(this.addTooltip(DLTooltip.of(List.of(TextUtils.translate((String)String.format("enum.%s.%s.%s", "trafficcraft", TrafficLightColor.NONE.getEnumName(), signalName)).method_27692(class_124.field_1067), TextUtils.translate((String)String.format("enum.%s.%s.info.%s", "trafficcraft", TrafficLightColor.NONE.getEnumName(), signalName)).method_27692(class_124.field_1080))).withMaxWidth(this.field_22789 / 4).assignedTo((class_339)b)));
            } else {
                this.iconTooltips.add(this.addTooltip(DLTooltip.of(List.of(TextUtils.translate((String)icon.getValueTranslationKey("trafficcraft")))).withMaxWidth(this.field_22789 / 4).assignedTo((class_339)b)));
            }
            if (this.icon != icon) continue;
            b.select();
        }
        String url = "Q8004";
        class_5250 helpTitle = TextUtils.empty();
        ArrayList<class_2561> helpDescription = new ArrayList<class_2561>();
        if (this.type == TrafficLightType.TRAM && Locale.getDefault().getLanguage().equals("de")) {
            url = "Q2354774";
            helpTitle = TextUtils.translate((String)keyhelpTramTrafficLight).method_27692(class_124.field_1067);
            helpDescription.add((class_2561)TextUtils.translate((String)keyhelpTramTrafficLightDescription).method_27692(class_124.field_1080));
        } else {
            url = "Q8004";
            helpTitle = TextUtils.translate((String)keyhelpTrafficLight).method_27692(class_124.field_1067);
            helpDescription.add((class_2561)TextUtils.translate((String)keyhelpTrafficLightDescription).method_27692(class_124.field_1080));
        }
        ModGuiUtils.HelpButtonComponents data = ModGuiUtils.createHelpButton((class_437)this, this.guiLeft + 241 + 4, this.guiTop + 20, 18, 18, this.iconGroup, DynamicGuiRenderer.AreaStyle.NATIVE, Wikipedia.getArticle((String)url).getArticleUrl(Locale.getDefault().getLanguage()), (class_2561)helpTitle, helpDescription);
        this.method_37063((class_364)data.helpButton());
        this.iconTooltips.add(this.addTooltip(data.tooltip()));
        this.iconGroup.setVisible(this.selectedPart == -1);
    }

    private void initColorButtons() {
        this.colorGroup.performForEach(x -> this.method_37066((class_364)x));
        this.colorGroup.clear();
        this.indexedColorButtons.clear();
        this.removeTooltips(x -> this.colorTooltips.contains(x));
        TrafficLightColor[] colors = TrafficLightColor.getAllowedForType(this.type, true);
        for (int i = 0; i < colors.length; ++i) {
            TrafficLightColor color = colors[i];
            byte j = color.getIndex();
            DLIconButton b = (DLIconButton)this.method_37063((class_364)new DLIconButton(DLAbstractImageButton.ButtonType.RADIO_BUTTON, DynamicGuiRenderer.AreaStyle.BROWN, new Sprite(TrafficLightTextureManager.getResourceLocation(new TrafficLightTextureManager.TrafficLightTextureKey(this.icon, color)), 16, 16, 0, 0, 16, 16), this.colorGroup, this.guiLeft + 69 + 7 + 1 + i * 18, this.guiTop, null, btn -> {
                this.colors[this.selectedPart] = color;
            }));
            if (color == TrafficLightColor.F1_F2_F3_F5) {
                String signalName = "h-1";
                switch (this.icon) {
                    case NONE: {
                        signalName = "f5";
                        break;
                    }
                    case LEFT: {
                        signalName = "f3";
                        break;
                    }
                    case RIGHT: {
                        signalName = "f2";
                        break;
                    }
                    case STRAIGHT: {
                        signalName = "f1";
                        break;
                    }
                }
                this.colorTooltips.add(this.addTooltip(DLTooltip.of(List.of(TextUtils.translate((String)String.format("enum.%s.%s.%s", "trafficcraft", color.getEnumName(), signalName)).method_27692(class_124.field_1067), TextUtils.translate((String)String.format("enum.%s.%s.info.%s", "trafficcraft", color.getEnumName(), signalName)).method_27692(class_124.field_1080))).withMaxWidth(this.field_22789 / 4).assignedTo((class_339)b)));
            } else {
                this.colorTooltips.add(this.addTooltip(DLTooltip.of(List.of(TextUtils.translate((String)color.getValueTranslationKey("trafficcraft")).method_27692(class_124.field_1067), TextUtils.translate((String)color.getValueInfoTranslationKey("trafficcraft")).method_27692(class_124.field_1080))).withMaxWidth(this.field_22789 / 4).assignedTo((class_339)b)));
            }
            this.indexedColorButtons.put(j, b);
        }
        this.colorGroup.setVisible(this.selectedPart >= 0);
        this.initControlTypeStatic();
    }

    private void initModelButtonAreas() {
        this.removeTooltips(x -> this.modelTooltips.contains(x));
        this.trafficLightArea = new GuiAreaDefinition(this.guiLeft - 5, this.guiTop + 20 - 5, 58, (int)(Math.max(this.model.getTotalHitboxHeight(), 16.0f) * 6.0f) + 10);
        this.trafficLightAreaTooltip = DLTooltip.of(List.of(textAreaTrafficLight)).withMaxWidth(this.field_22789 / 4).assignedTo(this.trafficLightArea);
        this.modelTooltips.add(this.trafficLightAreaTooltip);
        this.trafficLightLightAreas = new GuiAreaDefinition[Math.min(this.colors.length, this.model.getLightsCount())];
        for (int i = 0; i < this.trafficLightLightAreas.length; ++i) {
            this.trafficLightLightAreas[i] = new GuiAreaDefinition(12 + this.guiLeft, 9 + 30 * i + this.guiTop + 20, 24, 24);
            this.modelTooltips.add(this.addTooltip(DLTooltip.of(List.of(TextUtils.translate((String)(keyAreaTrafficLightSignal + i)))).withMaxWidth(this.field_22789 / 4).assignedTo(this.trafficLightLightAreas[i])));
        }
        this.initControlTypeAreas();
    }

    private void initControlTypeAreas() {
        this.ctrlWindowArea = new GuiAreaDefinition(this.guiLeft, this.guiTop + 20 + (int)(Math.max(this.model.getTotalHitboxHeight(), 16.0f) * 6.0f) + 10, 241, 100);
        this.ctrlButtonsArea = new GuiAreaDefinition(this.guiLeft + 7, this.guiTop + 20 + (int)(Math.max(this.model.getTotalHitboxHeight(), 16.0f) * 6.0f) + 10 + 20, 227, 20);
        this.ctrlSettingsArea = new GuiAreaDefinition(this.guiLeft + 7, this.guiTop + 20 + (int)(Math.max(this.model.getTotalHitboxHeight(), 16.0f) * 6.0f) + 10 + 20 + 18 + 2, 227, 53);
        this.removeTooltips(x -> this.controlTypeTooltips.contains(x));
        this.controlTypeGroup.clear(x -> this.method_37066((class_364)x));
        this.controlTypeTabTooltips.values().forEach(x -> {
            this.removeTooltips(y -> x.contains(y));
            x.clear();
        });
        this.controlTypeTabGroups.values().forEach(x -> x.clear(y -> this.method_37066((class_364)y)));
        int ctrlBtnW = this.ctrlButtonsArea.getWidth() - 2;
        DLItemButton bt = (DLItemButton)this.method_37063((class_364)((DLItemButton)new DLItemButton(DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.BROWN, this.controlType.getIconStack(), this.controlTypeGroup, this.ctrlButtonsArea.getLeft() + 1, this.ctrlButtonsArea.getTop() + 1, ctrlBtnW, this.ctrlButtonsArea.getHeight() - 2, (class_2561)TextUtils.translate((String)this.controlType.getValueTranslationKey("trafficcraft")), btn -> {
            DLItemButton ibtn = btn;
            this.controlType = (TrafficLightControlType)this.controlType.next();
            this.switchControlType(this.controlType);
            ibtn.withItem(this.controlType.getIconStack());
            btn.method_25355((class_2561)TextUtils.translate((String)this.controlType.getValueTranslationKey("trafficcraft")));
        }).withAlignment(EAlignment.LEFT)).withDefaultItemTooltip(false));
        this.controlTypeTooltips.add(this.addTooltip(DLTooltip.of((String)"trafficcraft", TrafficLightControlType.class).withMaxWidth(this.field_22789 / 4).assignedTo((class_339)bt)));
        this.initControlTypeStatic();
        this.initControlTypeOwnSchedule();
        this.initControlTypeRemote();
    }

    private void initControlTypeStatic() {
        this.removeTooltips(y -> this.controlTypeTabTooltips.get(TrafficLightControlType.STATIC).contains(y));
        this.controlTypeTabTooltips.get(TrafficLightControlType.STATIC).clear();
        this.controlTypeTabGroups.get(TrafficLightControlType.STATIC).clear(y -> this.method_37066((class_364)y));
        TrafficLightColor[] colors = TrafficLightColor.getAllowedForType(this.type, false);
        for (int i = 0; i < colors.length; ++i) {
            TrafficLightColor color = colors[i];
            DLIconButton b = (DLIconButton)this.method_37063((class_364)new DLIconButton(DLAbstractImageButton.ButtonType.TOGGLE_BUTTON, DynamicGuiRenderer.AreaStyle.BROWN, new Sprite(TrafficLightTextureManager.getResourceLocation(new TrafficLightTextureManager.TrafficLightTextureKey(this.icon, color)), 16, 16, 0, 0, 16, 16), this.controlTypeTabGroups.get(TrafficLightControlType.STATIC), this.ctrlSettingsArea.getRight() - 1 - (colors.length - i) * 18, this.ctrlSettingsArea.getTop() + 1, null, btn -> {
                if (btn.isSelected()) {
                    this.enabledColors.add(color);
                } else {
                    this.enabledColors.removeIf(x -> x == color);
                }
            }){

                public void renderImage(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
                    GuiUtils.setTint((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                    super.renderImage(graphics, pMouseX, pMouseY, pPartialTick);
                    GuiUtils.resetTint();
                }
            });
            if (color == TrafficLightColor.F1_F2_F3_F5) {
                String signalName = "h-1";
                switch (this.icon) {
                    case NONE: {
                        signalName = "f5";
                        break;
                    }
                    case LEFT: {
                        signalName = "f3";
                        break;
                    }
                    case RIGHT: {
                        signalName = "f2";
                        break;
                    }
                    case STRAIGHT: {
                        signalName = "f1";
                        break;
                    }
                }
                this.controlTypeTabTooltips.get(TrafficLightControlType.STATIC).add(this.addTooltip(DLTooltip.of(List.of(TextUtils.translate((String)String.format("enum.%s.%s.%s", "trafficcraft", color.getEnumName(), signalName)).method_27692(class_124.field_1067), TextUtils.translate((String)String.format("enum.%s.%s.info.%s", "trafficcraft", color.getEnumName(), signalName)).method_27692(class_124.field_1080))).withMaxWidth(this.field_22789 / 4).assignedTo((class_339)b)));
            } else {
                this.controlTypeTabTooltips.get(TrafficLightControlType.STATIC).add(this.addTooltip(DLTooltip.of(List.of(TextUtils.translate((String)color.getValueTranslationKey("trafficcraft")).method_27692(class_124.field_1067), TextUtils.translate((String)color.getValueInfoTranslationKey("trafficcraft")).method_27692(class_124.field_1080))).withMaxWidth(this.field_22789 / 4).assignedTo((class_339)b)));
            }
            if (!this.enabledColors.stream().anyMatch(x -> x.isSimilar(color))) continue;
            b.select();
        }
        this.controlTypeTabGroups.get(TrafficLightControlType.STATIC).setVisible(this.controlType == TrafficLightControlType.STATIC);
    }

    private void initControlTypeOwnSchedule() {
        this.removeTooltips(y -> this.controlTypeTabTooltips.get(TrafficLightControlType.OWN_SCHEDULE).contains(y));
        this.controlTypeTabTooltips.get(TrafficLightControlType.OWN_SCHEDULE).clear();
        this.controlTypeTabGroups.get(TrafficLightControlType.OWN_SCHEDULE).clear(y -> this.method_37066((class_364)y));
        this.method_37063((class_364)new DLIconButton(DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.GRAY, Sprite.empty(), this.controlTypeTabGroups.get(TrafficLightControlType.OWN_SCHEDULE), this.ctrlSettingsArea.getLeft() + 1, this.ctrlSettingsArea.getTop() + 1, this.ctrlSettingsArea.getWidth() - 2 - 36, 18, textCustomizeSchedule, btn -> DLScreen.setScreen((DLScreen)new TrafficLightScheduleEditor((class_437)this, this.level, this.blockPos))));
        DLIconButton copyBtn = (DLIconButton)this.method_37063((class_364)ModGuiUtils.createCopyButton(this.ctrlSettingsArea.getLeft() + 1 + this.ctrlSettingsArea.getWidth() - 2 - 36, this.ctrlSettingsArea.getTop() + 1, this.controlTypeTabGroups.get(TrafficLightControlType.OWN_SCHEDULE), DynamicGuiRenderer.AreaStyle.GRAY, btn -> {
            class_2586 patt0$temp = this.level.method_8321(this.blockPos);
            if (patt0$temp instanceof TrafficLightBlockEntity) {
                TrafficLightBlockEntity blockEntity = (TrafficLightBlockEntity)patt0$temp;
                Clipboard.put(TrafficLightSchedule.class, (INBTSerializable)blockEntity.getSchedule());
            }
        }));
        this.controlTypeTabTooltips.get(TrafficLightControlType.OWN_SCHEDULE).add(this.addTooltip(DLTooltip.of((class_5348)Constants.textCopy).assignedTo((class_339)copyBtn)));
        this.pasteButton = (DLIconButton)this.method_37063((class_364)ModGuiUtils.createPasteButton(this.ctrlSettingsArea.getLeft() + 1 + this.ctrlSettingsArea.getWidth() - 2 - 18, this.ctrlSettingsArea.getTop() + 1, this.controlTypeTabGroups.get(TrafficLightControlType.OWN_SCHEDULE), DynamicGuiRenderer.AreaStyle.GRAY, btn -> {
            Optional schedule = Clipboard.get(TrafficLightSchedule.class);
            if (schedule.isPresent() && schedule.get() != null) {
                TrafficCraft.net().sendToServer((Object)new TrafficLightSchedulePacket(this.blockPos, List.of((TrafficLightSchedule)schedule.get())));
            }
        }));
        this.pasteButton.field_22763 = false;
        this.controlTypeTabTooltips.get(TrafficLightControlType.OWN_SCHEDULE).add(this.addTooltip(DLTooltip.of((class_5348)Constants.textPaste).assignedTo((class_339)this.pasteButton)));
        this.method_37063((class_364)new DLIconButton(DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.GRAY, Sprite.empty(), this.controlTypeTabGroups.get(TrafficLightControlType.OWN_SCHEDULE), this.ctrlSettingsArea.getLeft() + 1, this.ctrlSettingsArea.getTop() + 1 + 18, this.ctrlSettingsArea.getWidth() - 2, 18, (class_2561)TextUtils.text((String)(textStatus + ": " + (this.scheduleEnabled ? class_5244.field_24332.getString() : class_5244.field_24333.getString()))), btn -> {
            this.scheduleEnabled = !this.scheduleEnabled;
            btn.method_25355((class_2561)TextUtils.text((String)(textStatus + ": " + (this.scheduleEnabled ? class_5244.field_24332.getString() : class_5244.field_24333.getString()))));
        }));
        this.controlTypeTabGroups.get(TrafficLightControlType.OWN_SCHEDULE).setVisible(this.controlType == TrafficLightControlType.OWN_SCHEDULE);
    }

    private void initControlTypeRemote() {
        this.removeTooltips(y -> this.controlTypeTabTooltips.get(TrafficLightControlType.REMOTE).contains(y));
        this.controlTypeTabTooltips.get(TrafficLightControlType.REMOTE).clear();
        this.controlTypeTabGroups.get(TrafficLightControlType.REMOTE).clear(y -> this.method_37066((class_364)y));
        DLEditBox box = this.addEditBox(this.ctrlSettingsArea.getRight() - 2 - 50, this.ctrlSettingsArea.getTop() + 2, 50, 16, String.valueOf(this.phaseId), (class_2561)TextUtils.empty(), true, text -> {
            try {
                this.phaseId = Integer.parseInt(text);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, this.NO_EDIT_BOX_FOCUS_CHANGE_ACTION, null);
        box.method_1890(GuiUtils::editBoxNumberFilter);
        box.method_1880(4);
        this.controlTypeTabGroups.get(TrafficLightControlType.REMOTE).add((class_339)box);
        this.controlTypeTabGroups.get(TrafficLightControlType.REMOTE).setVisible(this.controlType == TrafficLightControlType.REMOTE);
        this.phaseIdDescriptionLabel = class_5489.method_30891((class_327)this.field_22793, (class_5348)textPhaseIdDescription, (int)((int)((float)(this.ctrlSettingsArea.getWidth() - 8) / 0.75f)), (int)10);
    }

    private void switchPartEditor(int partIndex) {
        this.selectedPart = partIndex;
        this.typeGroup.setVisible(false);
        this.modelGroup.setVisible(false);
        this.iconGroup.setVisible(false);
        this.colorGroup.setVisible(false);
        if (this.selectedPart == -1) {
            this.typeGroup.setVisible(true);
            this.modelGroup.setVisible(true);
            this.iconGroup.setVisible(true);
        } else if (this.selectedPart >= 0) {
            this.colorGroup.setVisible(true);
            if (this.selectedPart < this.colors.length && this.indexedColorButtons.containsKey(this.colors[this.selectedPart].getIndex())) {
                this.colorGroup.performForEachOfType(DLIconButton.class, x -> x.deselect());
                this.indexedColorButtons.get(this.colors[this.selectedPart].getIndex()).select();
            }
        }
    }

    private void switchControlType(TrafficLightControlType controlType) {
        this.controlType = controlType;
        this.controlTypeTabGroups.entrySet().stream().filter(x -> x.getValue() instanceof WidgetsCollection).forEach(x -> ((WidgetsCollection)x.getValue()).setVisible(x.getKey() == controlType));
    }

    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        for (int i = 0; i < this.trafficLightLightAreas.length; ++i) {
            if (!this.trafficLightLightAreas[i].isInBounds(pMouseX, pMouseY)) continue;
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            this.switchPartEditor(i);
            return true;
        }
        if (this.trafficLightArea.isInBounds(pMouseX, pMouseY)) {
            this.switchPartEditor(-1);
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            return true;
        }
        return super.method_25402(pMouseX, pMouseY, pButton);
    }

    public void renderMainLayer(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        class_308.method_24210();
        this.renderScreenBackground(graphics);
        GuiUtils.drawString((Graphics)graphics, (class_327)this.field_22793, (int)(this.field_22789 / 2), (int)this.guiTop, (class_5348)this.field_22785, (int)-1, (EAlignment)EAlignment.CENTER, (boolean)false);
        graphics.poseStack().method_22903();
        graphics.poseStack().method_34426();
        graphics.poseStack().method_46416((float)(this.guiLeft + 72), (float)(this.guiTop + 116), 1.0f);
        graphics.poseStack().method_22905(-96.0f, -96.0f, -0.1f);
        class_4597.class_4598 multibuffersource$buffersource = this.field_22787.method_22940().method_23000();
        class_310.method_1551().method_1541().method_3353((class_2680)((class_2248)ModBlocks.TRAFFIC_LIGHT.get()).method_9564().method_11657(TrafficLightBlock.MODEL, (Comparable)((Object)this.model)), graphics.poseStack(), (class_4597)multibuffersource$buffersource, 0xF000F0, class_4608.field_21444);
        multibuffersource$buffersource.method_22993();
        graphics.poseStack().method_22909();
        class_308.method_24211();
        graphics.poseStack().method_22903();
        graphics.poseStack().method_46416(0.0f, 0.0f, 10.0f);
        for (int i = 0; i < this.colors.length && i < this.model.getLightsCount(); ++i) {
            GuiUtils.drawTexture((class_2960)TrafficLightTextureManager.getResourceLocation(new TrafficLightTextureManager.TrafficLightTextureKey(this.icon, this.colors[i])), (Graphics)graphics, (int)(12 + this.guiLeft), (int)(9 + 30 * i + this.guiTop + 20), (int)24, (int)24, (int)0, (int)0, (int)16, (int)16, (int)16, (int)16);
        }
        GuiAreaDefinition lightDef = Arrays.stream(this.trafficLightLightAreas).filter(x -> x.isInBounds((double)pMouseX, (double)pMouseY)).findFirst().orElse(null);
        if (lightDef != null) {
            GuiUtils.drawBox((Graphics)graphics, (GuiAreaDefinition)lightDef, (int)0x55FFFFFF, (int)-1);
        } else if (this.trafficLightArea.isInBounds((double)pMouseX, (double)pMouseY)) {
            GuiUtils.drawBox((Graphics)graphics, (GuiAreaDefinition)this.trafficLightArea, (int)0x55FFFFFF, (int)-1);
        }
        graphics.poseStack().method_22909();
        if (this.selectedPart == -1) {
            this.renderGlobalWindow(graphics, pMouseX, pMouseY, pPartialTick);
        } else if (this.selectedPart >= 0) {
            this.renderPartEditor(graphics, pMouseX, pMouseY, pPartialTick);
        } else {
            this.renderEmptyWindow(graphics, pMouseX, pMouseY, pPartialTick);
        }
        DynamicGuiRenderer.renderWindow((Graphics)graphics, (int)this.ctrlWindowArea.getLeft(), (int)this.ctrlWindowArea.getTop(), (int)this.ctrlWindowArea.getWidth(), (int)this.ctrlWindowArea.getHeight());
        DynamicGuiRenderer.renderArea((Graphics)graphics, (int)this.ctrlButtonsArea.getLeft(), (int)this.ctrlButtonsArea.getTop(), (int)this.ctrlButtonsArea.getWidth(), (int)this.ctrlButtonsArea.getHeight(), (DynamicGuiRenderer.AreaStyle)DynamicGuiRenderer.AreaStyle.GRAY, (DynamicGuiRenderer.ButtonState)DynamicGuiRenderer.ButtonState.DOWN);
        DynamicGuiRenderer.renderContainerBackground((Graphics)graphics, (int)this.ctrlSettingsArea.getLeft(), (int)this.ctrlSettingsArea.getTop(), (int)this.ctrlSettingsArea.getWidth(), (int)this.ctrlSettingsArea.getHeight(), (int)-13158601);
        GuiUtils.drawString((Graphics)graphics, (class_327)this.field_22793, (int)(this.ctrlWindowArea.getLeft() + 7), (int)(this.ctrlWindowArea.getTop() + 7), (class_5348)TextUtils.translate((String)TrafficLightControlType.STATIC.getEnumTranslationKey("trafficcraft")), (int)-12566464, (EAlignment)EAlignment.LEFT, (boolean)false);
        switch (this.controlType) {
            case STATIC: {
                this.renderControlTypeStatic(graphics, pMouseX, pMouseY, pPartialTick);
                break;
            }
            case REMOTE: {
                this.renderControlTypeRemote(graphics, pMouseX, pMouseY, pPartialTick);
                break;
            }
        }
        super.renderMainLayer(graphics, pMouseX, pMouseY, pPartialTick);
    }

    public void renderFrontLayer(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.renderFrontLayer(graphics, pMouseX, pMouseY, pPartialTick);
        if (Arrays.stream(this.trafficLightLightAreas).filter(x -> x.isInBounds((double)pMouseX, (double)pMouseY)).findFirst().orElse(null) == null && this.trafficLightArea.isInBounds((double)pMouseX, (double)pMouseY)) {
            this.trafficLightAreaTooltip.render((class_437)this, graphics, pMouseX, pMouseY);
        }
    }

    public void renderEmptyWindow(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.emptyLabel.method_30889(graphics.graphics(), this.guiLeft + 69 + 86, this.guiTop + 20 + 48 - this.emptyLabel.method_30887() * 5, 10, 0xDBDBDB);
    }

    public void renderGlobalWindow(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        DynamicGuiRenderer.renderWindow((Graphics)graphics, (int)(this.guiLeft + 69), (int)(this.guiTop + 20), (int)172, (int)96);
        GuiUtils.drawTexture((class_2960)WIDGETS_LOCATION, (Graphics)graphics, (int)(this.guiLeft + 69 - 9), (int)(this.guiTop + 20 + 48 - 9), (int)12, (int)18, (int)0, (int)0, (int)12, (int)18, (int)32, (int)32);
        DynamicGuiRenderer.renderArea((Graphics)graphics, (int)(this.guiLeft + 69 + 7), (int)(this.guiTop + 20 + 20), (int)158, (int)20, (DynamicGuiRenderer.AreaStyle)DynamicGuiRenderer.AreaStyle.GRAY, (DynamicGuiRenderer.ButtonState)DynamicGuiRenderer.ButtonState.DOWN);
        DynamicGuiRenderer.renderArea((Graphics)graphics, (int)(this.guiLeft + 69 + 7), (int)(this.guiTop + 20 + 20 + 25), (int)(TrafficLightModel.values().length * 18 + 2), (int)20, (DynamicGuiRenderer.AreaStyle)DynamicGuiRenderer.AreaStyle.GRAY, (DynamicGuiRenderer.ButtonState)DynamicGuiRenderer.ButtonState.DOWN);
        DynamicGuiRenderer.renderArea((Graphics)graphics, (int)(this.guiLeft + 69 + 7), (int)(this.guiTop + 20 + 20 + 50), (int)(TrafficLightIcon.getAllowedForType(this.type).length * 18 + 2), (int)20, (DynamicGuiRenderer.AreaStyle)DynamicGuiRenderer.AreaStyle.GRAY, (DynamicGuiRenderer.ButtonState)DynamicGuiRenderer.ButtonState.DOWN);
        GuiUtils.drawString((Graphics)graphics, (class_327)this.field_22793, (int)(this.guiLeft + 69 + 7), (int)(this.guiTop + 27), (class_5348)textGeneralSettings, (int)-12566464, (EAlignment)EAlignment.LEFT, (boolean)false);
    }

    public void renderPartEditor(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        int windowHeight = 47;
        int yBase = this.guiTop + 20;
        int y = 9 + 30 * this.selectedPart + yBase + 12 - windowHeight / 2;
        DynamicGuiRenderer.renderWindow((Graphics)graphics, (int)(this.guiLeft + 69), (int)y, (int)(TrafficLightColor.getAllowedForType(this.type, true).length * 18 + 2 + 14), (int)windowHeight);
        GuiUtils.drawTexture((class_2960)WIDGETS_LOCATION, (Graphics)graphics, (int)(this.guiLeft + 69 - 9), (int)(y + windowHeight / 2 - 9), (int)12, (int)18, (int)0, (int)0, (int)12, (int)18, (int)32, (int)32);
        this.colorGroup.performForEach(x -> x.method_46419(y + 20 + 1));
        DynamicGuiRenderer.renderArea((Graphics)graphics, (int)(this.guiLeft + 69 + 7), (int)(y + 20), (int)(TrafficLightColor.getAllowedForType(this.type, true).length * 18 + 2), (int)20, (DynamicGuiRenderer.AreaStyle)DynamicGuiRenderer.AreaStyle.GRAY, (DynamicGuiRenderer.ButtonState)DynamicGuiRenderer.ButtonState.DOWN);
        GuiUtils.drawString((Graphics)graphics, (class_327)this.field_22793, (int)(this.guiLeft + 69 + 7), (int)(y + 7), (class_5348)textSetSignal, (int)-12566464, (EAlignment)EAlignment.LEFT, (boolean)false);
    }

    public void renderControlTypeStatic(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        int n = this.ctrlSettingsArea.getLeft() + 4;
        int n2 = this.ctrlSettingsArea.getTop() + 9;
        Objects.requireNonNull(this.field_22793);
        GuiUtils.drawString((Graphics)graphics, (class_327)this.field_22793, (int)n, (int)(n2 - 9 / 2), (class_5348)textSetEnabledColors, (int)-2368549, (EAlignment)EAlignment.LEFT, (boolean)false);
    }

    public void renderControlTypeRemote(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        int n = this.ctrlSettingsArea.getLeft() + 4;
        int n2 = this.ctrlSettingsArea.getTop() + 9;
        Objects.requireNonNull(this.field_22793);
        GuiUtils.drawString((Graphics)graphics, (class_327)this.field_22793, (int)n, (int)(n2 - 9 / 2), (class_5348)textSetPhaseId, (int)-2368549, (EAlignment)EAlignment.LEFT, (boolean)false);
        float scale = 0.75f;
        graphics.poseStack().method_22903();
        graphics.poseStack().method_22905(scale, scale, scale);
        this.phaseIdDescriptionLabel.method_30896(graphics.graphics(), (int)((float)(this.ctrlSettingsArea.getLeft() + 4) / 0.75f), (int)((float)(this.ctrlSettingsArea.getTop() + 18 + 10) / 0.75f), 10, -3421237);
        graphics.poseStack().method_22909();
    }
}

