/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.client.screen;

import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractImageButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLIconButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLItemButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.trafficcraft.TrafficCraft;
import de.mrjulsen.trafficcraft.block.data.TrafficLightTrigger;
import de.mrjulsen.trafficcraft.block.data.TrafficLightType;
import de.mrjulsen.trafficcraft.block.entity.TrafficLightBlockEntity;
import de.mrjulsen.trafficcraft.block.entity.TrafficLightControllerBlockEntity;
import de.mrjulsen.trafficcraft.client.widgets.TrafficLightScheduleContainer;
import de.mrjulsen.trafficcraft.data.TrafficLightSchedule;
import de.mrjulsen.trafficcraft.data.TrafficLightScheduleEntryData;
import de.mrjulsen.trafficcraft.network.packets.cts.TrafficLightSchedulePacket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;

public class TrafficLightScheduleEditor
extends DLScreen {
    public static final class_2960 WIDGETS = new class_2960("trafficcraft", "textures/gui/traffic_light_schedule_icons.png");
    public static final int TEXTURE_WIDTH = 64;
    public static final int TEXTURE_HEIGHT = 64;
    public static final int WINDOW_WIDTH = 240;
    public static final int WINDOW_HEIGHT = 230;
    public static final int PADDING = 7;
    public static final int TOP_PADDING = 20;
    public static final int BOTTOM_PADDING = 30;
    public static final int SCROLLBAR_WIDTH = 8;
    public static final int ENTRY_PADDING = 8;
    public static final int DEFAULT_ENTRY_HEIGHT = 18;
    public static final int TIMELINE_UW = 9;
    public static final int TIMELINE_VH = 9;
    public static final int ENTRY_TIMELINE_COLUMN_WIDTH = 20;
    private static final int HEADER_BUTTON_COUNT = 2;
    private int guiLeft;
    private int guiTop;
    private GuiAreaDefinition areaHeader;
    private GuiAreaDefinition areaWorkspace;
    private TrafficLightScheduleContainer container;
    private final class_437 last;
    private final Map<Integer, TrafficLightType> phaseIdTypes = new HashMap<Integer, TrafficLightType>();
    private final class_2338 pos;
    private final class_1937 level;
    private final boolean isController;
    private final TrafficLightSchedule schedule;
    private static final class_2561 textAddEntry = TextUtils.translate((String)"gui.trafficcraft.trafficlightschedule.add_entry");
    private static final String textLoop = TextUtils.translate((String)"gui.trafficcraft.trafficlightschedule.loop").getString();

    protected TrafficLightScheduleEditor(class_437 last, class_1937 level, class_2338 pos) {
        super((class_2561)TextUtils.translate((String)"gui.trafficcraft.trafficlightschedule.title"));
        class_2586 class_25862;
        this.last = last;
        this.pos = pos;
        this.level = level;
        this.isController = this.isController();
        this.schedule = this.getSchedule().copy();
        if (this.isController()) {
            class_2586 class_25863 = level.method_8321(pos);
            if (class_25863 instanceof TrafficLightControllerBlockEntity) {
                TrafficLightControllerBlockEntity blockEntity = (TrafficLightControllerBlockEntity)class_25863;
                blockEntity.getTrafficLightLocations().stream().filter(x -> level.method_8477(x.getLocationBlockPos()) && level.method_8321(x.getLocationBlockPos()) instanceof TrafficLightBlockEntity).map(x -> (TrafficLightBlockEntity)level.method_8321(x.getLocationBlockPos())).forEach(x -> {
                    int phaseId = x.getPhaseId();
                    TrafficLightType type = x.getTLType();
                    if (this.phaseIdTypes.containsKey(phaseId)) {
                        TrafficLightType savedType = this.phaseIdTypes.get(phaseId);
                        if (savedType != null && savedType != type) {
                            this.phaseIdTypes.remove(phaseId);
                            this.phaseIdTypes.put(phaseId, type);
                        }
                    } else {
                        this.phaseIdTypes.put(phaseId, type);
                    }
                });
            }
        } else if (level.method_8477(pos) && (class_25862 = level.method_8321(pos)) instanceof TrafficLightBlockEntity) {
            TrafficLightBlockEntity blockEntity = (TrafficLightBlockEntity)class_25862;
            this.phaseIdTypes.put(0, blockEntity.getTLType());
        }
    }

    private boolean isController() {
        return this.level.method_8321(this.pos) instanceof TrafficLightControllerBlockEntity;
    }

    private TrafficLightSchedule getSchedule() {
        class_2586 class_25862;
        if (this.isController && (class_25862 = this.level.method_8321(this.pos)) instanceof TrafficLightControllerBlockEntity) {
            TrafficLightControllerBlockEntity blockEntity = (TrafficLightControllerBlockEntity)class_25862;
            return blockEntity.getFirstOrMainSchedule();
        }
        class_25862 = this.level.method_8321(this.pos);
        if (class_25862 instanceof TrafficLightBlockEntity) {
            TrafficLightBlockEntity blockEntity = (TrafficLightBlockEntity)class_25862;
            return blockEntity.getSchedule();
        }
        return new TrafficLightSchedule();
    }

    public Map<Integer, TrafficLightType> getPhaseTypes() {
        return this.phaseIdTypes;
    }

    public void method_25419() {
        if (this.last != null) {
            class_310.method_1551().method_1507(this.last);
            return;
        }
        super.method_25419();
    }

    protected void onDone() {
        super.onDone();
        TrafficCraft.net().sendToServer((Object)new TrafficLightSchedulePacket(this.pos, List.of(this.schedule)));
        this.method_25419();
    }

    protected void method_25426() {
        super.method_25426();
        this.guiLeft = this.field_22789 / 2 - 120;
        this.guiTop = this.field_22790 / 2 - 115;
        this.areaHeader = new GuiAreaDefinition(this.guiLeft + 7, this.guiTop + 20, 226, 20);
        this.areaWorkspace = new GuiAreaDefinition(this.guiLeft + 7, this.guiTop + 20 + this.areaHeader.getHeight(), 226, 210 - this.areaHeader.getHeight() - 30);
        int headerW = (this.areaHeader.getWidth() - 2) / 2;
        DLItemButton bt = (DLItemButton)this.method_37063((class_364)((DLItemButton)new DLItemButton(DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.BROWN, this.schedule.getTrigger().getIconStack(), this.areaHeader.getLeft() + 1, this.areaHeader.getTop() + 1, headerW, this.areaHeader.getHeight() - 2, (class_2561)TextUtils.translate((String)this.schedule.getTrigger().getValueTranslationKey("trafficcraft")), btn -> {
            DLItemButton ibtn = btn;
            this.schedule.setTrigger((TrafficLightTrigger)this.schedule.getTrigger().next());
            ibtn.withItem(this.schedule.getTrigger().getIconStack());
            btn.method_25355((class_2561)TextUtils.translate((String)this.schedule.getTrigger().getValueTranslationKey("trafficcraft")));
        }).withAlignment(EAlignment.LEFT)).withDefaultItemTooltip(false));
        this.addTooltip(DLTooltip.of((String)"trafficcraft", TrafficLightTrigger.class).withMaxWidth(this.field_22789 / 4).assignedTo((class_339)bt));
        this.method_37063((class_364)new DLIconButton(DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.BROWN, Sprite.empty(), null, this.areaHeader.getLeft() + 1 + headerW, this.areaHeader.getTop() + 1, headerW, this.areaHeader.getHeight() - 2, (class_2561)TextUtils.text((String)(textLoop + ": " + (this.schedule.isLoop() ? class_5244.field_24332.getString() : class_5244.field_24333.getString()))), btn -> {
            this.schedule.setLoop(!this.schedule.isLoop());
            btn.method_25355((class_2561)TextUtils.text((String)(textLoop + ": " + (this.schedule.isLoop() ? class_5244.field_24332.getString() : class_5244.field_24333.getString()))));
        }));
        this.addButton(this.guiLeft + 7, this.guiTop + 230 - 7 - 20, 20, 20, (class_2561)TextUtils.text((String)"+"), btn -> this.createNewEntry(), DLTooltip.of((class_5348)textAddEntry));
        this.addButton(this.guiLeft + 240 - 7 - 90, this.guiTop + 230 - 7 - 20, 90, 20, class_5244.field_24335, btn -> this.method_25419(), null);
        this.addButton(this.guiLeft + 240 - 7 - 180 - 4, this.guiTop + 230 - 7 - 20, 90, 20, class_5244.field_24334, btn -> this.onDone(), null);
        this.container = (TrafficLightScheduleContainer)this.method_37063((class_364)new TrafficLightScheduleContainer(this.schedule, this.isController(), this.getPhaseTypes(), this.areaWorkspace.getX(), this.areaWorkspace.getY(), this.areaWorkspace.getWidth(), this.areaWorkspace.getHeight()));
    }

    private void createNewEntry() {
        this.schedule.getEntries().add(new TrafficLightScheduleEntryData());
        this.container.init();
    }

    public void renderMainLayer(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderScreenBackground(graphics);
        DynamicGuiRenderer.renderWindow((Graphics)graphics, (int)this.guiLeft, (int)this.guiTop, (int)240, (int)230);
        DynamicGuiRenderer.renderArea((Graphics)graphics, (GuiAreaDefinition)this.areaHeader, (DynamicGuiRenderer.AreaStyle)DynamicGuiRenderer.AreaStyle.GRAY, (DynamicGuiRenderer.ButtonState)DynamicGuiRenderer.ButtonState.DISABLED);
        GuiUtils.drawString((Graphics)graphics, (class_327)this.field_22793, (int)(this.field_22789 / 2), (int)(this.guiTop + 7), (class_5348)this.field_22785, (int)-12566464, (EAlignment)EAlignment.CENTER, (boolean)false);
        super.renderMainLayer(graphics, pMouseX, pMouseY, pPartialTick);
    }
}

