/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.client.screen;

import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractImageButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLIconButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLVerticalScrollBar;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.client.util.WidgetsCollection;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.trafficcraft.TrafficCraft;
import de.mrjulsen.trafficcraft.block.data.TrafficSignShape;
import de.mrjulsen.trafficcraft.data.NamedTrafficSignTextureReference;
import de.mrjulsen.trafficcraft.data.TrafficSignClientTexture;
import de.mrjulsen.trafficcraft.data.TrafficSignTextureMetadata;
import de.mrjulsen.trafficcraft.item.CreativePatternCatalogueItem;
import de.mrjulsen.trafficcraft.item.PatternCatalogueItem;
import de.mrjulsen.trafficcraft.network.packets.cts.CreativePatternCataloguePacket;
import de.mrjulsen.trafficcraft.network.packets.cts.PatternCatalogueIndexPacket;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1011;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3298;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_5348;

public class TrafficSignPatternSelectionScreen
extends DLScreen {
    public static final class_2561 title = TextUtils.translate((String)"gui.trafficcraft.patternselection.title");
    private static final int WIDTH = 158;
    private static final int HEIGHT = 200;
    private static final int TEXTURE_WIDTH = 158;
    private static final int TEXTURE_HEIGHT = 174;
    private static final int MAX_ENTRIES_IN_ROW = 6;
    private static final int MAX_ROWS = 6;
    private static final int ICON_BUTTON_WIDTH = 18;
    private static final int ICON_BUTTON_HEIGHT = 18;
    private static final int BOOKMARK_U = 158;
    private static final int BOOKMARK_V_UNSELECTED_LEFT = 0;
    private static final int BOOKMARK_V_SELECTED_LEFT = 20;
    private static final int BOOKMARK_V_UNSELECTED_RIGHT = 40;
    private static final int BOOKMARK_V_SELECTED_RIGHT = 60;
    private static final int BOOKMARK_HEIGHT = 20;
    private static final int BOOKMARK_WIDTH = 44;
    private static final int BOOKMARK_SPACING = 2;
    private static final int BOOKMARK_COUNT_PER_SIDE = 6;
    private static final int BOOKMARK_Y_START = 17;
    private static final int BOOKMARK_X_LEFT = -33;
    private static final int BOOKMARK_X_RIGHT = 142;
    private final WidgetsCollection groupPatterns = new WidgetsCollection();
    private DLVerticalScrollBar scrollbar;
    private boolean updateScrollableContent = true;
    private int guiTop;
    private int guiLeft;
    private final Map<NamedTrafficSignTextureReference, TrafficSignClientTexture> cachedTextures = new HashMap<NamedTrafficSignTextureReference, TrafficSignClientTexture>();
    private final TrafficSignShape[] bookmarks = new TrafficSignShape[]{TrafficSignShape.CIRCLE, TrafficSignShape.TRIANGLE, TrafficSignShape.SQUARE, TrafficSignShape.DIAMOND, TrafficSignShape.RECTANGLE, TrafficSignShape.MISC};
    private int selectedBookmark = this.bookmarks.length;
    private double scroll = 0.0;
    private int selectedIndex;
    private final class_1799 stack;
    private final boolean creative;
    private static final class_2960 OVERLAY = new class_2960("trafficcraft", "textures/gui/traffic_sign_workbench_overlay.png");

    public TrafficSignPatternSelectionScreen(class_1799 stack) {
        super(title);
        if (!(stack.method_7909() instanceof PatternCatalogueItem)) {
            throw new IllegalStateException("ItemStack is no PatternCatalogueItem.");
        }
        this.stack = stack;
        this.creative = stack.method_7909() instanceof CreativePatternCatalogueItem;
        this.selectedBookmark = stack.method_7909() instanceof CreativePatternCatalogueItem && CreativePatternCatalogueItem.shouldUseCustomPattern(stack) ? 0 : this.bookmarks.length;
        this.selectedIndex = PatternCatalogueItem.getSelectedIndex(stack);
    }

    public boolean method_25421() {
        return true;
    }

    public void method_25419() {
        if (this.selectedBookmark >= this.bookmarks.length) {
            TrafficCraft.net().sendToServer((Object)new PatternCatalogueIndexPacket(PatternCatalogueItem.getSelectedIndex(this.stack)));
        } else {
            NamedTrafficSignTextureReference data = CreativePatternCatalogueItem.getCustomImage(this.stack);
            if (data != null) {
                TrafficCraft.net().sendToServer((Object)new CreativePatternCataloguePacket(data));
            }
        }
        this.cachedTextures.values().forEach(x -> x.close());
        super.method_25419();
    }

    public void method_25426() {
        super.method_25426();
        this.guiLeft = this.field_22789 / 2 - 79;
        this.guiTop = this.field_22790 / 2 - 100;
        this.scroll = 0.0;
        this.groupPatterns.components.clear();
        if (this.selectedBookmark >= this.bookmarks.length) {
            int count = PatternCatalogueItem.getStoredPatternCount(this.stack);
            int i = 0;
            while (i < count) {
                final int j = i++;
                DLIconButton btn = (DLIconButton)new DLIconButton(DLAbstractImageButton.ButtonType.RADIO_BUTTON, DynamicGuiRenderer.AreaStyle.BROWN, Sprite.empty(), this.groupPatterns, this.guiLeft + 9, this.guiTop + 36 + j * 18, 18, 18, null, button -> {
                    PatternCatalogueItem.setSelectedIndex(this.stack, j);
                    if (this.stack.method_7909() instanceof CreativePatternCatalogueItem) {
                        CreativePatternCatalogueItem.clearCustomImage(this.stack);
                    }
                }){

                    public void renderImage(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
                        NamedTrafficSignTextureReference data = PatternCatalogueItem.getPatternAt(TrafficSignPatternSelectionScreen.this.stack, j);
                        TrafficSignClientTexture tex = TrafficSignPatternSelectionScreen.this.cachedTextures.computeIfAbsent(data, x -> TrafficSignClientTexture.load(data.getTextureId(), false));
                        GuiUtils.drawTexture((class_2960)tex.getTextureLocation(), (Graphics)graphics, (int)(this.x() + 1), (int)(this.y() + 1), (int)16, (int)16, (int)0, (int)0, (int)tex.getRawData().getWidth(), (int)tex.getRawData().getHeight(), (int)tex.getRawData().getWidth(), (int)tex.getRawData().getHeight());
                    }
                }.withAlignment(EAlignment.CENTER);
                this.addTooltip(DLTooltip.of((class_5348)TextUtils.text((String)PatternCatalogueItem.getPatternAt(this.stack, j).getName())).assignedTo((class_339)btn));
                this.method_37063((class_364)btn);
            }
        } else {
            TrafficSignShape[] shapes;
            TrafficSignShape[] trafficSignShapeArray;
            if (this.bookmarks[this.selectedBookmark] == TrafficSignShape.MISC) {
                trafficSignShapeArray = (TrafficSignShape[])Arrays.stream(TrafficSignShape.values()).filter(x -> !Arrays.stream(this.bookmarks).anyMatch(y -> x == y) || x == TrafficSignShape.MISC).toArray(TrafficSignShape[]::new);
            } else {
                TrafficSignShape[] trafficSignShapeArray2 = new TrafficSignShape[1];
                trafficSignShapeArray = trafficSignShapeArray2;
                trafficSignShapeArray2[0] = this.bookmarks[this.selectedBookmark];
            }
            for (TrafficSignShape shape : shapes = trafficSignShapeArray) {
                int a = 1;
                class_2960 path = new class_2960("trafficcraft:textures/block/sign/" + shape.getShape() + "/" + shape.getShape() + a + ".png");
                ArrayList<TrafficSignTextureMetadata> locs = new ArrayList<TrafficSignTextureMetadata>();
                while (class_310.method_1551().method_1478().method_14486(path).isPresent()) {
                    short width = 32;
                    short height = 32;
                    try (class_1011 img = class_1011.method_4309((InputStream)((class_3298)this.field_22787.method_1478().method_14486(path).get()).method_14482());){
                        width = (short)img.method_4307();
                        height = (short)img.method_4323();
                    }
                    catch (IOException e) {
                        TrafficCraft.LOGGER.warn("Unable to determine texture size.", (Throwable)e);
                    }
                    locs.add(new TrafficSignTextureMetadata(path, shape, a, width, height));
                    path = new class_2960("trafficcraft:textures/block/sign/" + shape.getShape() + "/" + shape.getShape() + ++a + ".png");
                }
                int count = locs.size();
                int i = 0;
                while (i < count) {
                    int j = i++;
                    Sprite sprite = new Sprite(((TrafficSignTextureMetadata)locs.get(j)).location(), 32, 32, 0, 0, 32, 32, 16, 16);
                    DLIconButton btn = (DLIconButton)new DLIconButton(DLAbstractImageButton.ButtonType.RADIO_BUTTON, DynamicGuiRenderer.AreaStyle.BROWN, sprite, this.groupPatterns, this.guiLeft + 9, this.guiTop + 36 + j * 18, 18, 18, null, button -> {
                        CreativePatternCatalogueItem.setCustomImage(this.stack, NamedTrafficSignTextureReference.ofBuildIn("", new NamedTrafficSignTextureReference.BuildInTrafficSignCodec(((TrafficSignTextureMetadata)locs.get(j)).shape(), ((TrafficSignTextureMetadata)locs.get(j)).id(), ((TrafficSignTextureMetadata)locs.get(j)).width(), ((TrafficSignTextureMetadata)locs.get(j)).height())));
                        this.selectedIndex = j;
                    }).withAlignment(EAlignment.CENTER);
                    this.method_37063((class_364)btn);
                }
            }
        }
        this.scrollbar = (DLVerticalScrollBar)((DLVerticalScrollBar)((DLVerticalScrollBar)this.method_37063((class_364)new DLVerticalScrollBar(this.guiLeft + 79 + 54, this.guiTop + 45 - 1, 8, 110, new GuiAreaDefinition(this.guiLeft + 79 - 54, this.guiTop + 45, 108, 108)))).setAutoScrollerSize(true)).withOnValueChanged(scrollbar -> {
            this.scroll = scrollbar.getScrollValue();
            if (this.updateScrollableContent) {
                this.fillButtons((DLIconButton[])this.groupPatterns.components.toArray(DLIconButton[]::new), this.scroll, this.guiLeft + 79 - 54 - 1, this.guiTop + 45, this.scrollbar);
            }
            this.updateScrollableContent = true;
        });
        this.scrollbar.field_22764 = this.groupPatterns.components.size() > 36;
        this.fillButtons((DLIconButton[])this.groupPatterns.components.toArray(DLIconButton[]::new), this.scroll, this.guiLeft + 79 - 54 - 1, this.guiTop + 45, this.scrollbar);
    }

    private void fillButtons(DLIconButton[] buttons, double scrollRow, int defX, int defY, DLVerticalScrollBar scrollbar) {
        if (buttons.length <= 0) {
            return;
        }
        int currentRow = -1;
        for (int i = 0; i < buttons.length; ++i) {
            if (i % 6 == 0) {
                ++currentRow;
            }
            buttons[i].set_x(defX + i % 6 * 18);
            buttons[i].set_y((int)((double)(defY + currentRow * 18) - scrollRow * 18.0));
            buttons[i].set_visible((double)currentRow >= scrollRow && (double)currentRow < scrollRow + 6.0);
        }
        if (scrollbar != null) {
            this.updateScrollableContent = false;
            ((DLVerticalScrollBar)scrollbar.setScreenSize(6)).setMaxScroll(currentRow + 1);
        }
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderScreenBackground(graphics);
        GuiUtils.drawTexture((class_2960)OVERLAY, (Graphics)graphics, (int)this.guiLeft, (int)(this.guiTop + 26), (int)158, (int)174, (int)0, (int)0, (int)158, (int)174, (int)256, (int)256);
        if (this.creative) {
            int bookY = this.guiTop + 26;
            int bookmarkIndex = 0;
            for (TrafficSignShape shape : this.bookmarks) {
                bookmarkIndex = this.addBookmark(graphics, mouseX, mouseY, partialTicks, bookY, bookmarkIndex, shape.getIconResourceLocation(), 0, 0, 32, 32, 32, 32);
            }
            bookmarkIndex = this.addBookmark(graphics, mouseX, mouseY, partialTicks, bookY, bookmarkIndex, OVERLAY, 239, 0, 16, 16, 256, 256);
        }
        DynamicGuiRenderer.renderArea((Graphics)graphics, (int)(this.guiLeft + 79 - 54 - 2), (int)(this.guiTop + 45 - 1), (int)110, (int)110, (DynamicGuiRenderer.AreaStyle)DynamicGuiRenderer.AreaStyle.BROWN, (DynamicGuiRenderer.ButtonState)DynamicGuiRenderer.ButtonState.DOWN);
        if (CreativePatternCatalogueItem.hasCustomPattern(this.stack)) {
            NamedTrafficSignTextureReference data = CreativePatternCatalogueItem.getCustomImage(this.stack);
            TrafficSignClientTexture tex = this.cachedTextures.computeIfAbsent(data, x -> TrafficSignClientTexture.load(data.getTextureId(), false));
            NamedTrafficSignTextureReference.BuildInTrafficSignCodec codec = NamedTrafficSignTextureReference.BuildInTrafficSignCodec.decode(data.getTextureId());
            GuiUtils.drawTexture((class_2960)tex.getTextureLocation(), (Graphics)graphics, (int)(this.guiLeft + 15), (int)(this.guiTop + 200 - 15 - 24), (int)24, (int)24, (int)0, (int)0, (int)tex.getRawData().getWidth(), (int)tex.getRawData().getHeight(), (int)tex.getRawData().getWidth(), (int)tex.getRawData().getHeight());
            float scale = 0.75f;
            graphics.poseStack().method_22903();
            graphics.poseStack().method_22905(scale, scale, scale);
            int n = (int)((float)(this.guiLeft + 15 + 30) / scale);
            Objects.requireNonNull(this.field_22793);
            GuiUtils.drawString((Graphics)graphics, (class_327)this.field_22793, (int)n, (int)((int)((float)(this.guiTop + 200 - 15 - 12 - 9 / 2) / scale)), (class_5348)TextUtils.translate((String)"gui.trafficcraft.patternselection.build_in_pattern", (Object[])new Object[]{TextUtils.translate((String)codec.shape().getTranslationKey()).getString(), this.selectedIndex + 1}), (int)-12566464, (EAlignment)EAlignment.LEFT, (boolean)false);
            graphics.poseStack().method_22909();
        } else {
            NamedTrafficSignTextureReference data = PatternCatalogueItem.getSelectedPattern(this.stack);
            if (data != null) {
                TrafficSignClientTexture tex = this.cachedTextures.computeIfAbsent(data, x -> TrafficSignClientTexture.load(data.getTextureId(), false));
                GuiUtils.drawTexture((class_2960)tex.getTextureLocation(), (Graphics)graphics, (int)(this.guiLeft + 15), (int)(this.guiTop + 200 - 15 - 24), (int)24, (int)24, (int)0, (int)0, (int)tex.getRawData().getWidth(), (int)tex.getRawData().getHeight(), (int)tex.getRawData().getWidth(), (int)tex.getRawData().getHeight());
                float scale = 0.75f;
                graphics.poseStack().method_22903();
                graphics.poseStack().method_22905(scale, scale, scale);
                int n = (int)((float)(this.guiLeft + 15 + 30) / scale);
                Objects.requireNonNull(this.field_22793);
                GuiUtils.drawString((Graphics)graphics, (class_327)this.field_22793, (int)n, (int)((int)((float)(this.guiTop + 200 - 15 - 12 - 9 / 2) / scale)), (String)data.getName(), (int)-12566464, (EAlignment)EAlignment.LEFT, (boolean)false);
                graphics.poseStack().method_22909();
            }
        }
        GuiUtils.drawString((Graphics)graphics, (class_327)this.field_22793, (int)(this.field_22789 / 2), (int)this.guiTop, (class_5348)title, (int)-1, (EAlignment)EAlignment.CENTER, (boolean)false);
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
    }

    public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderFrontLayer(graphics, mouseX, mouseY, partialTick);
    }

    private int addBookmark(Graphics graphics, int mouseX, int mouseY, float partialTicks, int bookY, int bookmarkIndex, class_2960 icon, int u, int v, int uW, int vH, int texW, int texH) {
        int bookmarkX;
        int idx = bookmarkIndex % 6;
        int n = bookmarkX = bookmarkIndex / 6 <= 0 ? -33 : 142;
        int bookmarkV = bookmarkIndex / 6 <= 0 ? (this.selectedBookmark == bookmarkIndex ? 20 : 0) : (this.selectedBookmark == bookmarkIndex ? 60 : 40);
        GuiUtils.drawTexture((class_2960)OVERLAY, (Graphics)graphics, (int)(this.guiLeft + bookmarkX), (int)(bookY + 17 + idx * 22), (int)44, (int)20, (int)158, (int)bookmarkV, (int)44, (int)20, (int)256, (int)256);
        GuiUtils.drawTexture((class_2960)icon, (Graphics)graphics, (int)(this.guiLeft + bookmarkX + 14), (int)(bookY + 17 + idx * 22 + 2), (int)16, (int)16, (int)u, (int)v, (int)uW, (int)vH, (int)texW, (int)texH);
        return ++bookmarkIndex;
    }

    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        if (this.creative) {
            int index;
            int bookY = this.guiTop + 26;
            int xLeft = this.guiLeft + -33;
            int xRight = this.guiLeft + 142;
            int y = bookY + 17;
            int h1 = y + Math.min(6, this.bookmarks.length + 1) * 22;
            int h2 = y + (this.bookmarks.length - 6 + 1) * 22;
            if (pMouseX > (double)xLeft && pMouseX < (double)(xLeft + 44) && pMouseY > (double)y && pMouseY < (double)h1) {
                this.selectedBookmark = index = class_3532.method_15340((int)((int)((pMouseY - (double)y) / 22.0)), (int)0, (int)6);
                this.method_37067();
                this.method_25426();
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17481, (float)1.2f));
            }
            if (this.bookmarks.length + 1 > 6 && pMouseX > (double)xRight && pMouseX < (double)(xRight + 44) && pMouseY > (double)y && pMouseY < (double)h2) {
                this.selectedBookmark = index = 6 + class_3532.method_15340((int)((int)((pMouseY - (double)y) / 22.0)), (int)0, (int)6);
                this.method_37067();
                this.method_25426();
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17481, (float)1.2f));
            }
        }
        return super.method_25402(pMouseX, pMouseY, pButton);
    }
}

