/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.client.tooltip;

import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.data.DataCache;
import de.mrjulsen.mcdragonlib.data.Pair;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.trafficcraft.client.tooltip.TrafficSignTooltip;
import de.mrjulsen.trafficcraft.data.NamedTrafficSignTextureReference;
import de.mrjulsen.trafficcraft.data.TrafficSignClientTexture;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2371;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5684;

public class ClientTrafficSignTooltipStack
implements class_5684 {
    private final class_2371<NamedTrafficSignTextureReference> patterns;
    private final NamedTrafficSignTextureReference selectedData;
    private final Map<NamedTrafficSignTextureReference, TrafficSignClientTexture> textures;
    private static final float FONT_SCALE = 0.75f;
    private int lastKnownTexturesCount = 0;
    private final DataCache<Pair<Integer, Integer>, Integer> gridLayout = new DataCache(n -> {
        if (n <= 0) {
            return Pair.of((Object)1, (Object)n);
        }
        int sqrt = (int)Math.sqrt(n.doubleValue());
        int width = (int)Math.ceil((double)n.intValue() / (double)sqrt);
        return Pair.of((Object)width, (Object)sqrt);
    });

    public ClientTrafficSignTooltipStack(TrafficSignTooltip pTrafficSignTooltip) {
        this.patterns = pTrafficSignTooltip.getPatterns();
        this.selectedData = pTrafficSignTooltip.getSelected();
        this.textures = pTrafficSignTooltip.getTextures();
    }

    public int method_32661() {
        int n;
        this.checkGridLayout();
        int n2 = (Integer)((Pair)this.gridLayout.get((Object)this.lastKnownTexturesCount)).getSecond() * 18;
        if (this.selectedData == null) {
            n = 0;
        } else {
            Objects.requireNonNull(class_310.method_1551().field_1772);
            n = 9 * 2 + 24;
        }
        return n2 + n;
    }

    public int method_32664(class_327 pFont) {
        this.checkGridLayout();
        return (Integer)((Pair)this.gridLayout.get((Object)this.lastKnownTexturesCount)).getFirst() * 18;
    }

    private void checkGridLayout() {
        if (this.lastKnownTexturesCount != this.patterns.size()) {
            this.lastKnownTexturesCount = this.patterns.size();
            this.gridLayout.clear();
        }
    }

    public void method_32666(class_327 pFont, int pX, int pY, class_332 guiGraphics) {
        this.checkGridLayout();
        Graphics graphics = new Graphics(guiGraphics, guiGraphics.method_51448());
        Pair grid = (Pair)this.gridLayout.get((Object)this.lastKnownTexturesCount);
        int x = pX;
        int y = pY;
        graphics.poseStack().method_22903();
        graphics.poseStack().method_22905(0.75f, 0.75f, 0.75f);
        graphics.poseStack().method_46416(0.0f, 0.0f, 1000.0f);
        if (this.selectedData != null) {
            graphics.poseStack().method_22903();
            graphics.poseStack().method_46416((float)(x + 5) / 0.75f, (float)y / 0.75f, 0.0f);
            GuiUtils.drawString((Graphics)graphics, (class_327)pFont, (int)0, (int)0, (class_5348)TextUtils.translate((String)"item.trafficcraft.pattern_catalogue.tooltip.selected_texture"), (int)-2368549, (EAlignment)EAlignment.LEFT, (boolean)false);
            Objects.requireNonNull(pFont);
            GuiUtils.drawString((Graphics)graphics, (class_327)pFont, (int)32, (int)(9 + 10), (String)this.selectedData.getName(), (int)-1, (EAlignment)EAlignment.LEFT, (boolean)false);
            graphics.poseStack().method_22909();
        }
        if (this.lastKnownTexturesCount > 0) {
            graphics.poseStack().method_22903();
            class_4587 class_45872 = graphics.poseStack();
            float f = (float)(x + 5) / 0.75f;
            Objects.requireNonNull(pFont);
            class_45872.method_46416(f, (float)(y + 9 + 24) / 0.75f, 0.0f);
            GuiUtils.drawString((Graphics)graphics, (class_327)pFont, (int)0, (int)0, (class_5348)TextUtils.translate((String)"item.trafficcraft.pattern_catalogue.tooltip.saved_textures"), (int)-2368549, (EAlignment)EAlignment.LEFT, (boolean)false);
            graphics.poseStack().method_22909();
        }
        graphics.poseStack().method_22909();
        if (this.selectedData != null) {
            Objects.requireNonNull(pFont);
            this.renderTexture(guiGraphics, x + 10, y + 9, this.selectedData);
        }
        Objects.requireNonNull(pFont);
        y += 9 * 2 + 24;
        int k = 0;
        for (int i = 0; i < (Integer)grid.getFirst() && k < this.lastKnownTexturesCount; ++i) {
            for (int j = 0; j < (Integer)grid.getSecond() && k < this.lastKnownTexturesCount; ++j) {
                int n = k++;
                NamedTrafficSignTextureReference textureData = (NamedTrafficSignTextureReference)this.patterns.get(n);
                this.renderTexture(guiGraphics, x + 10 + i * 18, y + j * 18, textureData);
            }
        }
    }

    private void renderTexture(class_332 guiGraphics, int x, int y, NamedTrafficSignTextureReference data) {
        TrafficSignClientTexture texture = this.textures.get(data);
        if (texture != null) {
            int w = texture.getRawData().getWidth();
            int h = texture.getRawData().getHeight();
            guiGraphics.method_25293(texture.getTextureLocation(), x, y, 16, 16, 0.0f, 0.0f, w, h, w, h);
        }
    }
}

