/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.client.widgets;

import de.mrjulsen.mcdragonlib.client.gui.widgets.DLRenderable;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLScrollableWidgetContainer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLVerticalScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLWidgetContainer;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.trafficcraft.block.data.TrafficLightType;
import de.mrjulsen.trafficcraft.client.screen.TrafficLightScheduleEditor;
import de.mrjulsen.trafficcraft.client.widgets.TrafficLightScheduleEntry;
import de.mrjulsen.trafficcraft.data.TrafficLightSchedule;
import de.mrjulsen.trafficcraft.data.TrafficLightScheduleEntryData;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

public class TrafficLightScheduleContainer
extends DLWidgetContainer {
    public static final int LEFT_PADDING = 8;
    public static final int SPACING = 8;
    public static final int DEFAULT_ENTRY_HEIGHT = 18;
    public static final int TIMELINE_UW = 9;
    public static final int TIMELINE_VH = 9;
    public static final int TIMELINE_WIDTH = 20;
    public final GuiAreaDefinition area = new GuiAreaDefinition(this.x(), this.y(), this.width() - 8, this.height());
    private final TrafficLightScheduleInnerContainer innerContainer;

    public TrafficLightScheduleContainer(TrafficLightSchedule schedule, boolean showIdBox, Map<Integer, TrafficLightType> signalTypes, int x, int y, int width, int height) {
        super(x, y, width, height);
        DLVerticalScrollBar scrollBar = (DLVerticalScrollBar)this.addRenderableWidget((class_364)new DLVerticalScrollBar(this.x() + this.width() - 8, this.y(), 8, this.height(), this.area));
        this.innerContainer = (TrafficLightScheduleInnerContainer)this.addRenderableWidget((class_364)new TrafficLightScheduleInnerContainer(this, schedule, showIdBox, signalTypes, this.x() + 1, this.y() + 1, this.width() - 8 - 2, this.height() - 2, scrollBar));
        scrollBar.setAutoScrollerSize(true);
        scrollBar.setScreenSize(this.height() - 2);
        scrollBar.setStepSize(8);
        scrollBar.withOnValueChanged(bar -> this.innerContainer.setYScrollOffset(bar.getScrollValue()));
        this.init();
    }

    public void init() {
        this.innerContainer.init();
    }

    public double getScrollOffset() {
        return this.innerContainer.getYScrollOffset();
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        DynamicGuiRenderer.renderContainerBackground((Graphics)graphics, (GuiAreaDefinition)this.area, (int)-13158601);
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33785;
    }

    public void method_37020(class_6382 narrationElementOutput) {
    }

    public boolean consumeScrolling(double mouseX, double mouseY) {
        return false;
    }

    private static class TrafficLightScheduleInnerContainer
    extends DLScrollableWidgetContainer {
        private static final class_2561 textStart = TextUtils.translate((String)"gui.trafficcraft.trafficlightschedule.start");
        private static final class_2561 textEnd = TextUtils.translate((String)"gui.trafficcraft.trafficlightschedule.end");
        public static final int LEFT_PADDING = 8;
        public static final int SPACING = 8;
        public static final int DEFAULT_ENTRY_HEIGHT = 18;
        public static final int TIMELINE_UW = 9;
        public static final int TIMELINE_VH = 9;
        public static final int TIMELINE_WIDTH = 20;
        private final TrafficLightSchedule schedule;
        private final DLVerticalScrollBar scrollBar;
        private final Map<Integer, TrafficLightType> signalTypes;
        private final boolean showIdBox;
        private final TrafficLightScheduleContainer parent;
        private int currentY;

        public TrafficLightScheduleInnerContainer(TrafficLightScheduleContainer parent, TrafficLightSchedule schedule, boolean showIdBox, Map<Integer, TrafficLightType> signalTypes, int x, int y, int width, int height, DLVerticalScrollBar scrollBar) {
            super(x, y, width, height);
            this.schedule = schedule;
            this.scrollBar = scrollBar;
            this.signalTypes = signalTypes;
            this.showIdBox = showIdBox;
            this.parent = parent;
            this.init();
        }

        public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
            GuiUtils.drawTexture((class_2960)TrafficLightScheduleEditor.WIDGETS, (Graphics)graphics, (int)(this.x() + 8 + 10 - 4), (int)this.y(), (int)9, (int)this.height(), (int)27, (int)20, (int)9, (int)1, (int)64, (int)64);
            super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
            GuiUtils.fillGradient((Graphics)graphics, (int)this.x(), (int)this.y(), (int)0, (int)this.width(), (int)10, (int)0x77000000, (int)0);
            GuiUtils.fillGradient((Graphics)graphics, (int)this.x(), (int)(this.y() + this.height() - 10), (int)0, (int)this.width(), (int)10, (int)0, (int)0x77000000);
        }

        public void init() {
            this.clearWidgets();
            this.currentY = 1;
            this.currentY += ((TrafficLightScheduleTextEntry)this.addRenderableOnly((class_4068)new TrafficLightScheduleTextEntry(this.x(), this.y() + this.currentY, textStart))).height();
            Iterator iterator = this.schedule.getEntries().iterator();
            while (iterator.hasNext()) {
                TrafficLightScheduleEntryData entry;
                TrafficLightScheduleEntryData dataEntry = entry = (TrafficLightScheduleEntryData)iterator.next();
                this.currentY += ((TrafficLightScheduleEntry)this.addRenderableWidget((class_364)new TrafficLightScheduleEntry(this.parent, this.signalTypes, !this.showIdBox, entry, this.x(), this.y() + this.currentY, this.width(), data -> {
                    this.schedule.getEntries().removeIf(x -> x == dataEntry);
                    this.init();
                }, (e, offset) -> {
                    int len = this.schedule.getEntries().size();
                    int idx = this.schedule.getEntries().indexOf(dataEntry);
                    if (idx < 0) {
                        return;
                    }
                    if (offset > 0 && idx < len - 1) {
                        this.schedule.getEntries().moveForth(idx, 1);
                    } else if (offset < 0 && idx > 0) {
                        this.schedule.getEntries().moveBack(idx, 1);
                    }
                    this.init();
                }))).height();
            }
            this.currentY += ((TrafficLightScheduleTextEntry)this.addRenderableOnly((class_4068)new TrafficLightScheduleTextEntry(this.x(), this.y() + this.currentY, textEnd))).height();
            this.scrollBar.setMaxScroll(this.currentY);
        }

        public class_6379.class_6380 method_37018() {
            return class_6379.class_6380.field_33785;
        }

        public void method_37020(class_6382 narrationElementOutput) {
        }

        public boolean consumeScrolling(double mouseX, double mouseY) {
            return false;
        }
    }

    private static final class TrafficLightScheduleTextEntry
    extends DLRenderable {
        private final class_327 font;
        private static final class_2960 WIDGETS = new class_2960("trafficcraft", "textures/gui/traffic_light_schedule_icons.png");
        private static final int TEXTURE_WIDTH = 64;
        private static final int TEXTURE_HEIGHT = 64;
        private static final int SPACING = 8;
        private static final int LEFT_PADDING = 8;
        private static final int TIMELINE_WIDTH = 20;
        private static final int DEFAULT_ENTRY_HEIGHT = 18;
        private static final int TIMELINE_UW = 9;
        private static final int TIMELINE_VH = 9;
        private final class_2561 text;

        public TrafficLightScheduleTextEntry(int x, int y, class_2561 text) {
            super(x, y, 20 + class_310.method_1551().field_1772.method_27525((class_5348)text) + 8, 26);
            this.font = class_310.method_1551().field_1772;
            this.text = text;
        }

        public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
            DynamicGuiRenderer.renderArea((Graphics)graphics, (int)(this.x() + 8), (int)(this.y() + 4), (int)this.width(), (int)18, (DynamicGuiRenderer.AreaStyle)DynamicGuiRenderer.AreaStyle.GRAY, (DynamicGuiRenderer.ButtonState)DynamicGuiRenderer.ButtonState.BUTTON);
            int n = this.x() + 8 + 20;
            int n2 = this.y() + this.height() / 2;
            Objects.requireNonNull(this.font);
            GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)n, (int)(n2 - 9 / 2), (class_5348)this.text, (int)-12566464, (EAlignment)EAlignment.LEFT, (boolean)false);
            GuiUtils.drawTexture((class_2960)WIDGETS, (Graphics)graphics, (int)(this.x() + 8 + 10 - 4), (int)this.y(), (int)9, (int)this.height(), (int)27, (int)20, (int)9, (int)9, (int)64, (int)64);
            GuiUtils.drawTexture((class_2960)WIDGETS, (Graphics)graphics, (int)(this.x() + 8 + 10 - 4), (int)(this.y() + this.height() / 2 - 4), (int)9, (int)9, (int)0, (int)20, (int)9, (int)9, (int)64, (int)64);
        }
    }
}

