/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.data;

import de.mrjulsen.mcdragonlib.data.INBTSerializable;
import de.mrjulsen.trafficcraft.block.data.TrafficLightColor;
import de.mrjulsen.trafficcraft.block.data.TrafficLightTrigger;
import de.mrjulsen.trafficcraft.data.TrafficLightScheduleEntryData;
import de.mrjulsen.trafficcraft.util.OrderedArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

public class TrafficLightSchedule
implements INBTSerializable {
    private static final String NBT_LOOP = "loop";
    private static final String NBT_ENTRIES = "entries";
    private static final String NBT_TRIGGER = "trigger";
    private OrderedArrayList<TrafficLightScheduleEntryData> entries = new OrderedArrayList();
    private boolean loop = true;
    private TrafficLightTrigger trigger = TrafficLightTrigger.NONE;

    public TrafficLightSchedule copy() {
        TrafficLightSchedule schedule = new TrafficLightSchedule();
        schedule.entries.addAll(this.entries.stream().map(x -> x.copy()).toList());
        schedule.loop = this.loop;
        schedule.trigger = this.trigger;
        return schedule;
    }

    public OrderedArrayList<TrafficLightScheduleEntryData> getEntries() {
        return this.entries;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public TrafficLightTrigger getTrigger() {
        return this.trigger;
    }

    public void setLoop(boolean b) {
        this.loop = b;
    }

    public void setTrigger(TrafficLightTrigger trigger) {
        this.trigger = trigger;
    }

    public int getTotalDurationTicks() {
        return this.entries.stream().mapToInt(x -> x.getDurationTicks()).sum();
    }

    public OrderedArrayList<TrafficLightScheduleEntryData> shouldChange(int currentTick) {
        OrderedArrayList changeEntries = new OrderedArrayList();
        int keyTime = 0;
        for (TrafficLightScheduleEntryData entry : this.entries) {
            if ((keyTime += entry.getDurationTicks()) == currentTick) {
                changeEntries.add(entry);
            }
            if (currentTick >= keyTime) continue;
            return new OrderedArrayList<TrafficLightScheduleEntryData>(changeEntries.stream().distinct().toList());
        }
        return changeEntries.size() <= 0 ? null : new OrderedArrayList(changeEntries.stream().distinct().toList());
    }

    public Collection<TrafficLightColor> getColorsForUpdate(int index) {
        if (index < 0 || index >= this.entries.size()) {
            return Collections.emptyList();
        }
        return ((TrafficLightScheduleEntryData)this.entries.get(index)).getEnabledColors();
    }

    public int getPhaseId(int index) {
        if (index < 0 || index >= this.entries.size()) {
            return Integer.MAX_VALUE;
        }
        return ((TrafficLightScheduleEntryData)this.entries.get(index)).getPhaseId();
    }

    public class_2487 toNbt() {
        class_2487 tag = new class_2487();
        class_2499 listTag = new class_2499();
        for (TrafficLightScheduleEntryData data : this.entries) {
            listTag.add((Object)data.toNbt());
        }
        tag.method_10556(NBT_LOOP, this.loop);
        tag.method_10567(NBT_TRIGGER, this.trigger.getIndex());
        tag.method_10566(NBT_ENTRIES, (class_2520)listTag);
        return tag;
    }

    public void fromNbt(class_2487 tag) {
        this.loop = tag.method_10577(NBT_LOOP);
        this.trigger = TrafficLightTrigger.getTriggerByIndex(tag.method_10540(NBT_TRIGGER) == 3 ? (byte)tag.method_10550(NBT_TRIGGER) : tag.method_10571(NBT_TRIGGER));
        class_2499 listTag = tag.method_10554(NBT_ENTRIES, 10);
        double lastTime = -1.0;
        boolean migration = false;
        for (int i = 0; i < listTag.size(); ++i) {
            TrafficLightScheduleEntryData data = new TrafficLightScheduleEntryData();
            data.fromNbt(listTag.method_10602(i));
            migration = data.shouldMigrate(listTag.method_10602(i));
            if (migration) {
                double lTime = data.getDurationSeconds();
                if (lastTime >= 0.0) {
                    data.setDurationSeconds(lastTime);
                }
                lastTime = lTime;
            }
            this.entries.add(data);
        }
        if (migration && this.entries.size() > 0) {
            ((TrafficLightScheduleEntryData)this.entries.get(0)).setDurationSeconds(lastTime);
        }
    }

    public void toBytes(class_2540 buf) {
        buf.writeBoolean(this.loop);
        buf.writeByte((int)this.trigger.getIndex());
        buf.writeInt(this.entries.size());
        for (TrafficLightScheduleEntryData data : this.entries) {
            data.toBytes(buf);
        }
    }

    public static TrafficLightSchedule fromBytes(class_2540 buf) {
        TrafficLightSchedule schedule = new TrafficLightSchedule();
        schedule.setLoop(buf.readBoolean());
        schedule.setTrigger(TrafficLightTrigger.getTriggerByIndex(buf.readByte()));
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            schedule.entries.add(TrafficLightScheduleEntryData.fromBytes(buf));
        }
        return schedule;
    }

    public class_2487 serializeNbt() {
        return this.toNbt();
    }

    public void deserializeNbt(class_2487 nbt) {
        this.fromNbt(nbt);
    }
}

