/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.data;

import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.data.INBTSerializable;
import de.mrjulsen.trafficcraft.block.data.TrafficLightColor;
import de.mrjulsen.trafficcraft.block.data.compat.TrafficLightMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_3532;

public class TrafficLightScheduleEntryData
implements INBTSerializable {
    private static final String NBT_ID = "id";
    private static final String NBT_TICKS = "ticks";
    private static final String NBT_COLOR = "color";
    @Deprecated
    private static final String NBT_MODE = "mode";
    public static final int MAX_SECONDS = 999;
    public static final int MAX_TICKS = 19980;
    private List<TrafficLightColor> enabledColors = new ArrayList<TrafficLightColor>(TrafficLightColor.values().length);
    private int ticks = 0;
    private int id = 0;

    public TrafficLightScheduleEntryData copy() {
        TrafficLightScheduleEntryData data = new TrafficLightScheduleEntryData();
        data.enabledColors = new ArrayList<TrafficLightColor>(this.enabledColors);
        data.ticks = this.ticks;
        data.id = this.id;
        return data;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TrafficLightScheduleEntryData) {
            TrafficLightScheduleEntryData other = (TrafficLightScheduleEntryData)obj;
            return this.ticks == other.ticks && this.id == other.id && this.enabledColors.size() == other.enabledColors.size() && this.enabledColors.stream().allMatch(x -> other.enabledColors.stream().anyMatch(y -> x == y));
        }
        return false;
    }

    public int getDurationTicks() {
        return this.ticks;
    }

    public double getDurationSeconds() {
        return (double)this.ticks / DragonLib.tps();
    }

    public int getPhaseId() {
        return this.id;
    }

    public List<TrafficLightColor> getEnabledColors() {
        return this.enabledColors;
    }

    public void enableColors(Collection<TrafficLightColor> colors) {
        this.enabledColors.addAll(colors);
        this.enabledColors.stream().distinct().toList();
    }

    public void enableOnlyColors(Collection<TrafficLightColor> colors) {
        this.enabledColors.clear();
        this.enabledColors.addAll(colors);
        this.enabledColors.stream().distinct().toList();
    }

    public void disableColors(Collection<TrafficLightColor> colors) {
        colors.forEach(x -> this.enabledColors.removeIf(y -> x == y));
    }

    public void disableAll(Collection<TrafficLightColor> colors) {
        this.enabledColors.clear();
    }

    public void setDurationTicks(int ticks) {
        this.ticks = class_3532.method_15340((int)ticks, (int)0, (int)19980);
    }

    public void setDurationSeconds(double seconds) {
        this.setDurationTicks((int)(seconds * 20.0));
    }

    public void addDurationTicks(int amount) {
        this.ticks = Math.min(this.ticks + amount, 19980);
    }

    public void addDurationSeconds(int amount) {
        this.addDurationTicks(amount * 20);
    }

    public void subDurationTicks(int amount) {
        this.ticks = Math.max(this.ticks - amount, 0);
    }

    public void subDurationSeconds(int amount) {
        this.subDurationTicks(amount * 20);
    }

    public void setPhaseId(int id) {
        this.id = id;
    }

    public class_2487 toNbt() {
        class_2487 tag = new class_2487();
        tag.method_10569(NBT_ID, this.getPhaseId());
        tag.method_10569(NBT_TICKS, this.getDurationTicks());
        tag.method_10539(NBT_COLOR, this.getEnabledColors().stream().mapToInt(x -> x.getIndex()).toArray());
        return tag;
    }

    public void fromNbt(class_2487 tag) {
        this.id = tag.method_10550(NBT_ID);
        this.ticks = tag.method_10550(NBT_TICKS);
        int[] bArr = tag.method_10561(NBT_COLOR);
        ArrayList<TrafficLightColor> colors = new ArrayList<TrafficLightColor>(bArr.length);
        for (int i = 0; i < bArr.length; ++i) {
            colors.add(TrafficLightColor.getColorByIndex((byte)bArr[i]));
        }
        this.enabledColors = colors;
        this.migrateData(tag);
    }

    private void migrateData(class_2487 nbt) {
        if (this.shouldMigrate(nbt)) {
            this.enableOnlyColors(TrafficLightMode.getModeByIndex(nbt.method_10550(NBT_MODE)).convertToColorList());
        }
    }

    public double migrateTime(TrafficLightScheduleEntryData last) {
        double lastTime = last.getDurationSeconds();
        last.setDurationSeconds(this.getDurationSeconds());
        return lastTime;
    }

    public boolean shouldMigrate(class_2487 nbt) {
        return nbt.method_10545(NBT_MODE);
    }

    public void toBytes(class_2540 buf) {
        buf.writeInt(this.id);
        buf.writeInt(this.ticks);
        TrafficLightColor[] cArr = (TrafficLightColor[])this.getEnabledColors().toArray(TrafficLightColor[]::new);
        byte[] bArr = new byte[cArr.length];
        for (int i = 0; i < bArr.length; ++i) {
            bArr[i] = cArr[i].getIndex();
        }
        buf.method_10813(bArr);
    }

    public static TrafficLightScheduleEntryData fromBytes(class_2540 buf) {
        TrafficLightScheduleEntryData data = new TrafficLightScheduleEntryData();
        data.setPhaseId(buf.readInt());
        data.setDurationTicks(buf.readInt());
        byte[] bArr = buf.method_10795();
        ArrayList<TrafficLightColor> colors = new ArrayList<TrafficLightColor>(bArr.length);
        for (int i = 0; i < bArr.length; ++i) {
            colors.add(TrafficLightColor.getColorByIndex(bArr[i]));
        }
        data.enableOnlyColors(colors);
        return data;
    }

    public class_2487 serializeNbt() {
        return this.toNbt();
    }

    public void deserializeNbt(class_2487 nbt) {
        this.fromNbt(nbt);
    }
}

