/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.data;

import de.mrjulsen.mcdragonlib.data.Pair;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import de.mrjulsen.trafficcraft.TrafficCraft;
import de.mrjulsen.trafficcraft.block.data.TrafficSignShape;
import de.mrjulsen.trafficcraft.data.NamedTrafficSignTextureReference;
import de.mrjulsen.trafficcraft.data.TrafficSignTextureData;
import de.mrjulsen.trafficcraft.registry.ModAccessorTypes;
import dev.architectury.utils.GameInstance;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;

public class TrafficSignClientTexture
implements AutoCloseable {
    public static final class_1043 EMPTY_TEXTURE;
    public static final TrafficSignClientTexture EMPTY;
    public static final class_2960 EMPTY_LOCATION;
    public static final Map<String, Pair.MutablePair<TrafficSignClientTexture, Integer>> cachedTexturesById;
    protected TrafficSignTextureData rawData = TrafficSignTextureData.empty();
    protected class_1043 texture = EMPTY_TEXTURE;
    protected class_1043 backgroundTexture = EMPTY_TEXTURE;
    protected class_2960 textureLocation = EMPTY_LOCATION;
    protected class_2960 backgroundTextureLocation = EMPTY_LOCATION;
    protected final String textureId;
    private boolean isClosed = false;
    private boolean builtIn = false;

    public static int debug_cachedTexturesCount() {
        return cachedTexturesById.size();
    }

    public static int closeAll() {
        int count = cachedTexturesById.size();
        new ArrayList<Pair.MutablePair<TrafficSignClientTexture, Integer>>(cachedTexturesById.values()).stream().map(x -> (TrafficSignClientTexture)x.getFirst()).forEach(x -> x.close());
        cachedTexturesById.clear();
        return count;
    }

    protected TrafficSignClientTexture(String textureId) {
        this.textureId = textureId;
    }

    private synchronized TrafficSignClientTexture init(TrafficSignTextureData rawData, boolean createBg) {
        if (this.isClosed) {
            return this;
        }
        this.rawData = rawData;
        class_1043 tex = EMPTY_TEXTURE;
        if (rawData.getPixelData().length > 0) {
            try {
                tex = new class_1043(class_1011.method_4309((InputStream)new ByteArrayInputStream(rawData.getPixelData())));
            }
            catch (IOException e) {
                TrafficCraft.LOGGER.error("Unable to load texture.", (Throwable)e);
                tex = class_1047.method_4540();
            }
        }
        this.texture = tex;
        this.textureLocation = new class_2960("trafficcraft", "sign_" + rawData.getHash().toString());
        if (createBg && rawData.getShape() == TrafficSignShape.MISC) {
            this.generateBgTexture();
        }
        class_310.method_1551().method_1531().method_4616(this.textureLocation, (class_1044)tex);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateBgTexture() {
        class_1043 originalTexture = EMPTY_TEXTURE;
        try {
            Object idSuffix = "_";
            if (this.isBuiltIn()) {
                NamedTrafficSignTextureReference.BuildInTrafficSignCodec codec = NamedTrafficSignTextureReference.BuildInTrafficSignCodec.decode(this.textureId);
                idSuffix = codec.id() + "_bg";
                originalTexture = new class_1043(class_1011.method_4309((InputStream)((class_3298)class_310.method_1551().method_1478().method_14486(this.getTextureLocation()).get()).method_14482()));
            } else {
                idSuffix = "_bg";
                originalTexture = this.texture;
            }
            if (originalTexture == null || originalTexture == EMPTY_TEXTURE) {
                return;
            }
            class_1011 bg = class_1011.method_4309((InputStream)((class_3298)class_310.method_1551().method_1478().method_14486(new class_2960("trafficcraft", "textures/block/sign/blank.png")).get()).method_14482());
            int width = Math.min(bg.method_4307(), 32);
            int height = Math.min(bg.method_4323(), 32);
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (originalTexture.method_4525().method_4315(x, y) != 0) continue;
                    bg.method_4305(width - 1 - x, y, 0);
                }
            }
            this.backgroundTexture = new class_1043(bg);
            this.backgroundTextureLocation = new class_2960("trafficcraft", "sign_" + String.valueOf(this.isBuiltIn() ? Integer.valueOf(this.rawData.getShape().getIndex()) : this.rawData.getHash().toString()) + (String)idSuffix);
            class_310.method_1551().method_1531().method_4616(this.backgroundTextureLocation, (class_1044)this.backgroundTexture);
        }
        catch (Exception e) {
            TrafficCraft.LOGGER.error("Unable to create traffic sign background texture.", (Throwable)e);
        }
        finally {
            if (this.isBuiltIn() && originalTexture != null && originalTexture != EMPTY_TEXTURE) {
                originalTexture.close();
            }
        }
    }

    public static TrafficSignTextureData createNew(TrafficSignShape shape, class_1011 image, Runnable andThen) {
        TrafficSignTextureData data;
        try {
            data = new TrafficSignTextureData(shape, image.method_24036(), (short)image.method_4307(), (short)image.method_4323(), System.currentTimeMillis(), GameInstance.getClient().field_1724.method_5667());
            DataAccessor.getFromServer((Object)data, ModAccessorTypes.CREATE_NEW_TRAFFIC_SIGN_TEXTURE, $ -> DLUtils.doIfNotNull((Object)andThen, x -> x.run()));
        }
        catch (IOException e) {
            TrafficCraft.LOGGER.error("Unable to create new traffic sign texture.", (Throwable)e);
            data = TrafficSignTextureData.empty();
        }
        return data;
    }

    public static TrafficSignClientTexture load(String id, boolean allowBackground) {
        Pair.MutablePair data = cachedTexturesById.computeIfAbsent(id, x -> {
            TrafficSignClientTexture textureData = new TrafficSignClientTexture(id);
            if (id.startsWith("builtIn")) {
                try {
                    NamedTrafficSignTextureReference.BuildInTrafficSignCodec codec = NamedTrafficSignTextureReference.BuildInTrafficSignCodec.decode(id);
                    textureData.builtIn = true;
                    textureData.texture = EMPTY_TEXTURE;
                    textureData.textureLocation = new class_2960("trafficcraft", String.format("textures/block/sign/%s/%s%s.png", codec.shape().method_15434(), codec.shape().method_15434(), codec.id()));
                    textureData.rawData = new TrafficSignTextureData(codec.shape(), new byte[0], codec.width(), codec.height(), System.currentTimeMillis(), new UUID(0L, 0L));
                }
                catch (Exception e) {
                    TrafficCraft.LOGGER.error("Error while loading TrafficSignClientTexture.", (Throwable)e);
                }
            } else {
                DataAccessor.getFromServer((Object)id, ModAccessorTypes.GET_TRAFFIC_SIGN_TEXTURE, a -> textureData.init((TrafficSignTextureData)a, allowBackground));
            }
            return new Pair.MutablePair((Object)textureData, (Object)0);
        });
        data.setSecond((Object)((Integer)data.getSecond() + 1));
        if (allowBackground && ((TrafficSignClientTexture)data.getFirst()).getRawData().getShape() == TrafficSignShape.MISC && ((TrafficSignClientTexture)data.getFirst()).isFullyLoaded()) {
            ((TrafficSignClientTexture)data.getFirst()).generateBgTexture();
        }
        return (TrafficSignClientTexture)data.getFirst();
    }

    public static void unload(UUID id) {
        TrafficSignClientTexture.unload(id.toString());
    }

    protected static void unload(String id) {
        if (!cachedTexturesById.containsKey(id)) {
            TrafficCraft.LOGGER.warn("There was no cached traffic sign texture with id " + id + ".");
            return;
        }
        Pair.MutablePair<TrafficSignClientTexture, Integer> data = cachedTexturesById.get(id);
        data.setSecond((Object)((Integer)data.getSecond() - 1));
        if ((Integer)data.getSecond() <= 0) {
            ((TrafficSignClientTexture)cachedTexturesById.remove(id).getFirst()).closeInternal();
        }
    }

    public TrafficSignTextureData getRawData() {
        return this.rawData;
    }

    public class_1043 getTexture() {
        if (this.builtIn) {
            throw new IllegalAccessError("Cannot access built-in textures as DynamicTexture.");
        }
        return this.texture;
    }

    public class_2960 getTextureLocation() {
        return this.textureLocation;
    }

    public class_1043 getBackgroundTexture() {
        if (this.builtIn) {
            throw new IllegalAccessError("Cannot access built-in textures as DynamicTexture.");
        }
        return this.backgroundTexture;
    }

    public class_2960 getBackgroundTextureLocation() {
        return this.backgroundTextureLocation;
    }

    public boolean isFullyLoaded() {
        return !this.equals(EMPTY);
    }

    public boolean isDisposed() {
        return this.isClosed;
    }

    public boolean isBuiltIn() {
        return this.builtIn;
    }

    public boolean hasBackground() {
        return this.backgroundTexture != null && this.backgroundTexture != EMPTY_TEXTURE;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TrafficSignClientTexture) {
            TrafficSignClientTexture o = (TrafficSignClientTexture)obj;
            return this.textureLocation.equals((Object)o.textureLocation);
        }
        return super.equals(obj);
    }

    @Override
    public void close() {
        TrafficSignClientTexture.unload(this.textureId);
    }

    private void closeInternal() {
        this.isClosed = true;
        if (this != EMPTY && !this.equals(EMPTY) && !this.isBuiltIn()) {
            DLUtils.doIfNotNull((Object)this.texture, x -> x.close());
            class_310.method_1551().method_1531().method_4615(this.textureLocation);
            if (this.backgroundTexture != null && this.backgroundTexture != EMPTY_TEXTURE) {
                this.backgroundTexture.close();
                class_310.method_1551().method_1531().method_4615(this.backgroundTextureLocation);
            }
        }
    }

    static {
        class_1011 img = new class_1011(1, 1, false);
        img.method_4305(0, 0, 0);
        EMPTY_TEXTURE = new class_1043(img);
        EMPTY_LOCATION = new class_2960("trafficcraft", "empty_sign");
        class_310.method_1551().method_1531().method_4616(EMPTY_LOCATION, (class_1044)EMPTY_TEXTURE);
        EMPTY = new TrafficSignClientTexture("empty");
        cachedTexturesById = new HashMap<String, Pair.MutablePair<TrafficSignClientTexture, Integer>>();
    }
}

