/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.init;

import de.mrjulsen.mcdragonlib.util.ColorUtils;
import de.mrjulsen.mcdragonlib.util.Wikipedia;
import de.mrjulsen.trafficcraft.TrafficCraft;
import de.mrjulsen.trafficcraft.block.data.TrafficSignShape;
import de.mrjulsen.trafficcraft.client.TintedTextures;
import de.mrjulsen.trafficcraft.client.ber.TownSignBlockEntityRenderer;
import de.mrjulsen.trafficcraft.client.ber.TrafficLightBlockEntityRenderer;
import de.mrjulsen.trafficcraft.client.ber.TrafficSignBlockEntityRenderer;
import de.mrjulsen.trafficcraft.client.ber.WritableSignBlockEntityRenderer;
import de.mrjulsen.trafficcraft.client.screen.TrafficSignWorkbenchGui;
import de.mrjulsen.trafficcraft.client.screen.menu.ModMenuTypes;
import de.mrjulsen.trafficcraft.client.tooltip.ClientTrafficSignTooltipStack;
import de.mrjulsen.trafficcraft.client.tooltip.TrafficSignTooltip;
import de.mrjulsen.trafficcraft.data.TrafficSignClientTexture;
import de.mrjulsen.trafficcraft.item.IScrollEventItem;
import de.mrjulsen.trafficcraft.item.RoadConstructionTool;
import de.mrjulsen.trafficcraft.registry.ModBlockEntities;
import de.mrjulsen.trafficcraft.registry.ModBlocks;
import de.mrjulsen.trafficcraft.registry.ModItems;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.injectables.annotations.PlatformOnly;
import dev.architectury.platform.Platform;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.item.ItemPropertiesRegistry;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_322;
import net.minecraft.class_326;
import net.minecraft.class_3917;
import net.minecraft.class_3929;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_746;
import net.minecraft.class_801;
import org.jetbrains.annotations.Nullable;

public class ClientInit {
    private static final int CHECKERBOARD_COLOR_A = -1447447;
    private static final int CHECKERBOARD_COLOR_B = -2500135;
    private static final Map<Class<? extends class_5632>, Function<class_5632, class_5684>> tooltipComponentFactories = new ConcurrentHashMap<Class<? extends class_5632>, Function<class_5632, class_5684>>();
    public static final class_1043[] SHAPE_TEXTURES = new class_1043[TrafficSignShape.values().length];

    @PlatformOnly(value={"fabric"})
    public static <T extends class_5632> void registerTooltipComponentFactory(Class<T> cls, Function<? super T, ? extends class_5684> factory) {
        tooltipComponentFactories.put(cls, factory);
    }

    @PlatformOnly(value={"fabric"})
    @Nullable
    public static class_5684 getClientTooltipComponent(class_5632 component) {
        Function<class_5632, class_5684> factory = tooltipComponentFactories.get(component.getClass());
        return factory == null ? null : factory.apply(component);
    }

    public static int[][] textureToIntArray(class_1043 tex, boolean flipRgb) {
        int[][] a = new int[tex.method_4525().method_4307()][];
        for (int x = 0; x < tex.method_4525().method_4307(); ++x) {
            a[x] = new int[tex.method_4525().method_4323()];
            for (int y = 0; y < tex.method_4525().method_4323(); ++y) {
                a[x][y] = flipRgb ? ColorUtils.swapRedBlue((int)tex.method_4525().method_4315(x, y)) : tex.method_4525().method_4315(x, y);
            }
        }
        return a;
    }

    public static void init() {
        ClientLifecycleEvent.CLIENT_SETUP.register(mc -> {
            Wikipedia.addArticle((String[])new String[]{"Q8004", "Q2354774"});
            class_801.field_4270.add("layer5");
            class_801.field_4270.add("layer6");
            class_801.field_4270.add("layer7");
            class_801.field_4270.add("layer8");
            RenderTypeRegistry.register((class_1921)class_1921.method_23581(), (class_2248[])new class_2248[]{(class_2248)ModBlocks.PAINT_BUCKET.get(), (class_2248)ModBlocks.MANHOLE.get(), (class_2248)ModBlocks.MANHOLE_COVER.get(), (class_2248)ModBlocks.TRAFFIC_SIGN_WORKBENCH.get()});
            RenderTypeRegistry.register((class_1921)class_1921.method_23583(), (class_2248[])new class_2248[]{(class_2248)ModBlocks.ROAD_SALT.get()});
            RenderTypeRegistry.register((class_1921)class_1921.method_23581(), (class_2248[])((class_2248[])ModBlocks.COLORED_BLOCKS.stream().filter(x -> x.getId().toString().contains("pattern")).map(Supplier::get).toArray(class_2248[]::new)));
            BlockEntityRendererRegistry.register((class_2591)((class_2591)ModBlockEntities.TOWN_SIGN_BLOCK_ENTITY.get()), TownSignBlockEntityRenderer::new);
            BlockEntityRendererRegistry.register((class_2591)((class_2591)ModBlockEntities.STREET_SIGN_BLOCK_ENTITY.get()), WritableSignBlockEntityRenderer::new);
            BlockEntityRendererRegistry.register((class_2591)((class_2591)ModBlockEntities.HOUSE_NUMBER_SIGN_BLOCK_ENTITY.get()), WritableSignBlockEntityRenderer::new);
            BlockEntityRendererRegistry.register((class_2591)((class_2591)ModBlockEntities.TRAFFIC_SIGN_BLOCK_ENTITY.get()), TrafficSignBlockEntityRenderer::new);
            BlockEntityRendererRegistry.register((class_2591)((class_2591)ModBlockEntities.TRAFFIC_LIGHT_BLOCK_ENTITY.get()), TrafficLightBlockEntityRenderer::new);
            if (Platform.isFabric()) {
                ClientInit.registerTooltipComponentFactory(TrafficSignTooltip.class, tooltip -> new ClientTrafficSignTooltipStack((TrafficSignTooltip)tooltip));
            }
            class_3929.method_17542((class_3917)((class_3917)ModMenuTypes.TRAFFIC_SIGN_WORKBENCH_MENU.get()), TrafficSignWorkbenchGui::new);
            ItemPropertiesRegistry.register((class_1935)((class_1935)ModItems.PAINT_BRUSH.get()), (class_2960)new class_2960("trafficcraft", "paint"), (itemStack, world, entity, id) -> {
                class_2487 nbt = itemStack.method_7969();
                if (nbt != null) {
                    return nbt.method_10550("paint");
                }
                return 0.0f;
            });
            ItemPropertiesRegistry.register((class_1935)((class_1935)ModItems.TRAFFIC_LIGHT_LINKER.get()), (class_2960)new class_2960("trafficcraft", "mode"), (itemStack, world, entity, id) -> {
                class_2487 nbt = itemStack.method_7969();
                if (nbt != null) {
                    return nbt.method_10550("Mode");
                }
                return 0.0f;
            });
        });
        ClientLifecycleEvent.CLIENT_STARTED.register(mc -> {
            ColorHandlerRegistry.registerBlockColors((class_322)new TintedTextures.TintedBlock(), (Supplier[])((Supplier[])ModBlocks.COLORED_BLOCKS.toArray(RegistrySupplier[]::new)));
            ColorHandlerRegistry.registerItemColors((class_326)new TintedTextures.TintedItem(), (Supplier[])new Supplier[]{ModBlocks.GUARDRAIL, ModItems.PAINT_BRUSH, ModBlocks.TRAFFIC_CONE, ModBlocks.TRAFFIC_BOLLARD, ModBlocks.TRAFFIC_BARREL, ModBlocks.ROAD_BARRIER_FENCE, ModBlocks.CONCRETE_BARRIER, ModItems.COLOR_PALETTE});
            class_1043[] textures = (class_1043[])Arrays.stream(TrafficSignShape.values()).map(v -> {
                class_1011 image = new class_1011(class_1011.class_1012.field_4997, 32, 32, false);
                for (int x = 0; x < image.method_4307(); ++x) {
                    for (int y = 0; y < image.method_4323(); ++y) {
                        if (v.isPixelValid(x, y)) {
                            image.method_4305(x, y, x % 2 == 0 ? (y % 2 == 0 ? -1447447 : -2500135) : (y % 2 == 0 ? -2500135 : -1447447));
                            continue;
                        }
                        image.method_4305(x, y, 0);
                    }
                }
                return new class_1043(image);
            }).toArray(class_1043[]::new);
            for (int i = 0; i < textures.length; ++i) {
                ClientInit.SHAPE_TEXTURES[i] = textures[i];
            }
        });
        ClientTickEvent.CLIENT_LEVEL_POST.register(level -> RoadConstructionTool.clientTick());
        ClientRawInputEvent.MOUSE_SCROLLED.register((mc, delta) -> {
            IScrollEventItem item;
            class_1792 patt0$temp;
            class_1799 stack;
            class_746 player = mc.field_1724;
            if (player == null || delta == 0.0) {
                return EventResult.pass();
            }
            class_1799 class_17992 = stack = player.method_6047() == null ? player.method_6079() : player.method_6047();
            if (stack != null && (patt0$temp = stack.method_7909()) instanceof IScrollEventItem && (item = (IScrollEventItem)patt0$temp).mouseScroll((class_1657)player, stack, delta)) {
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        });
        ClientGuiEvent.DEBUG_TEXT_LEFT.register(list -> list.add(String.format("TC | T: %s", TrafficSignClientTexture.debug_cachedTexturesCount())));
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(player -> {
            TrafficCraft.LOGGER.info("Cleaning up traffic sign texture cache...");
            int count = TrafficSignClientTexture.closeAll();
            TrafficCraft.LOGGER.info("All " + count + " loaded custom traffic sign textures have been closed.");
        });
    }
}

