/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.item;

import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.trafficcraft.block.PaintBucketBlock;
import de.mrjulsen.trafficcraft.block.data.IColorBlockEntity;
import de.mrjulsen.trafficcraft.block.data.IPaintableBlock;
import de.mrjulsen.trafficcraft.client.ClientWrapper;
import de.mrjulsen.trafficcraft.data.PaintColor;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class BrushItem
extends class_1792 {
    public static final String NBT_PATTERN = "pattern";
    public static final String NBT_PAINT = "paint";
    public static final String NBT_COLOR = "color";
    private int paintAmount = 0;

    public BrushItem(class_1792.class_1793 properties, int paintAmount) {
        super(properties.method_7889(1));
        this.paintAmount = paintAmount;
    }

    public boolean method_7885(class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 player) {
        class_2248 class_22482;
        if (player.method_7337() && (class_22482 = state.method_26204()) instanceof IPaintableBlock) {
            IPaintableBlock block = (IPaintableBlock)class_22482;
            block.onRemoveColor(state, worldIn, pos, player);
            return false;
        }
        return true;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        class_2487 nbt = BrushItem.checkNbt(stack);
        stack.method_7980(nbt);
        if (level.field_9236) {
            ClientWrapper.showPaintBrushScreen(nbt.method_10550(NBT_PATTERN), nbt.method_10550(NBT_PAINT), PaintColor.getByIndex(nbt.method_10550(NBT_COLOR)));
        }
        return new class_1271(class_1269.field_5812, (Object)stack);
    }

    public void method_7851(class_1799 stack, class_1937 player, List<class_2561> list, class_1836 flag) {
        super.method_7851(stack, player, list, flag);
        if (stack.method_7985()) {
            PaintColor paintColor = PaintColor.getByIndex(stack.method_7969().method_10550(NBT_COLOR));
            String color = TextUtils.translate((String)paintColor.getValueTranslationKey("trafficcraft")).getString();
            list.add((class_2561)TextUtils.translate((String)"item.trafficcraft.paint_brush.tooltip.pattern", (Object[])new Object[]{"\u00a7f" + stack.method_7969().method_10550(NBT_PATTERN)}).method_27692(class_124.field_1080));
            if (stack.method_7969().method_10550(NBT_PAINT) == 0) {
                list.add((class_2561)TextUtils.translate((String)"item.trafficcraft.paint_brush.tooltip.color", (Object[])new Object[]{TextUtils.translate((String)"item.trafficcraft.paint_brush.tooltip.color_empty")}).method_27692(class_124.field_1080));
            } else {
                list.add((class_2561)TextUtils.translate((String)"item.trafficcraft.paint_brush.tooltip.color", (Object[])new Object[]{TextUtils.text((String)color).method_27696(class_2583.field_24360.method_27706(class_124.field_1068).method_36139(paintColor.getTextureColor()))}).method_27692(class_124.field_1080));
            }
            list.add((class_2561)TextUtils.translate((String)"item.trafficcraft.paint_brush.tooltip.paint", (Object[])new Object[]{"\u00a7f" + (int)(0.78125f * (float)stack.method_7969().method_10550(NBT_PAINT))}).method_27692(class_124.field_1080));
        }
    }

    public boolean method_31567(class_1799 stack) {
        return BrushItem.checkNbt(stack).method_10550(NBT_PAINT) > 0;
    }

    public int method_31569(class_1799 stack) {
        return BrushItem.checkNbt(stack).method_10550(NBT_PAINT) * 13 / 128;
    }

    public int method_31571(class_1799 pStack) {
        return BrushItem.getColor(pStack).getTextureColor();
    }

    public static class_2487 checkNbt(class_1799 stack) {
        class_2487 nbt;
        if (stack.method_7985()) {
            nbt = stack.method_7969();
        } else {
            nbt = new class_2487();
            nbt.method_10569(NBT_PAINT, 0);
            nbt.method_10569(NBT_PATTERN, 0);
            nbt.method_10569(NBT_COLOR, -1);
        }
        return nbt;
    }

    public int getPaintAmount() {
        return this.paintAmount;
    }

    public static PaintColor getColor(class_1799 stack) {
        return PaintColor.getByIndex(BrushItem.checkNbt(stack).method_10550(NBT_COLOR));
    }

    public static int getPatternId(class_1799 stack) {
        return BrushItem.checkNbt(stack).method_10550(NBT_PATTERN);
    }

    public static int getPaint(class_1799 stack) {
        return BrushItem.checkNbt(stack).method_10550(NBT_PAINT);
    }

    public int getMaxPaint() {
        return 128;
    }

    public class_1269 method_7884(class_1838 pContext) {
        class_1937 level = pContext.method_8045();
        class_2487 nbt = BrushItem.checkNbt(pContext.method_8041());
        pContext.method_8041().method_7980(nbt);
        if (nbt.method_10550(NBT_PAINT) <= 0) {
            return class_1269.field_5814;
        }
        class_2338 pos = pContext.method_8037();
        class_2680 state = pContext.method_8045().method_8320(pos);
        class_1657 player = pContext.method_8036();
        if (state.method_26204() instanceof PaintBucketBlock) {
            level.method_8396(null, pos, class_3417.field_15202, class_3419.field_15245, 0.8f, 1.0f);
            return class_1269.field_5812;
        }
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof IPaintableBlock) {
            IColorBlockEntity blockEntity;
            IPaintableBlock block = (IPaintableBlock)class_22482;
            class_2586 class_25862 = level.method_8321(pos);
            if (class_25862 instanceof IColorBlockEntity && (blockEntity = (IColorBlockEntity)class_25862).getColor() == PaintColor.getByIndex(nbt.method_10550(NBT_COLOR))) {
                class_1269 res = block.update(pContext);
                if (res == class_1269.field_21466) {
                    this.removePaint(player, nbt);
                    res = class_1269.field_5812;
                }
                return res;
            }
            class_1269 res = block.onSetColor(pContext);
            if (res == class_1269.field_21466) {
                this.removePaint(player, nbt);
                res = class_1269.field_5812;
            }
            return res;
        }
        return class_1269.field_5811;
    }

    private void removePaint(class_1657 player, class_2487 nbt) {
        if (!player.method_7337()) {
            nbt.method_10569(NBT_PAINT, nbt.method_10550(NBT_PAINT) - 1);
        }
    }
}

