/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.item;

import de.mrjulsen.mcdragonlib.core.ColorObject;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5251;

public class ColorPaletteItem
extends class_1792 {
    public static final int MAX_COLORS = 7;
    public static final String COLORS_TAG = "colors";

    public ColorPaletteItem(class_1792.class_1793 properties) {
        super(properties.method_7889(1));
    }

    public void method_7851(class_1799 stack, class_1937 player, List<class_2561> list, class_1836 flag) {
        super.method_7851(stack, player, list, flag);
        if (!stack.method_7985()) {
            list.add((class_2561)TextUtils.translate((String)"item.trafficcraft.color_palette.no_color").method_27692(class_124.field_1080));
            return;
        }
        class_2487 tag = ColorPaletteItem.checkNbt(stack);
        if (!IntStream.of(tag.method_10561(COLORS_TAG)).anyMatch(x -> x != 0)) {
            list.add((class_2561)TextUtils.translate((String)"item.trafficcraft.color_palette.no_color").method_27692(class_124.field_1080));
        } else {
            for (int i : tag.method_10561(COLORS_TAG)) {
                if (i == 0) {
                    list.add((class_2561)TextUtils.translate((String)"item.trafficcraft.color_palette.color_unset").method_27692(class_124.field_1056).method_27692(class_124.field_1080));
                    continue;
                }
                ColorObject c = ColorObject.fromInt((int)i);
                list.add((class_2561)TextUtils.text((String)String.format("\u2b1b  %s, %s, %s (#%s)", c.getR(), c.getG(), c.getB(), Integer.toHexString(i).toUpperCase())).method_27696(class_2583.field_24360.method_27703(class_5251.method_27717((int)i))));
            }
        }
    }

    public static class_2487 checkNbt(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        if (!nbt.method_10545(COLORS_TAG)) {
            int[] c = new int[7];
            Arrays.fill(c, 0);
            nbt.method_10539(COLORS_TAG, c);
        }
        return nbt;
    }

    public static int getColorAt(class_1799 stack, int index) {
        if (!stack.method_7985()) {
            return 0;
        }
        if (index < 0 || index >= 7) {
            return 0;
        }
        return ColorPaletteItem.checkNbt(stack).method_10561(COLORS_TAG)[index];
    }

    public static boolean setColor(class_1799 stack, int index, int color) {
        if (index < 0 || index >= 7) {
            return false;
        }
        int[] a = ColorPaletteItem.checkNbt(stack).method_10561(COLORS_TAG);
        a[index] = color;
        ColorPaletteItem.checkNbt(stack).method_10539(COLORS_TAG, a);
        return true;
    }
}

