/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.item;

import de.mrjulsen.trafficcraft.client.ClientWrapper;
import de.mrjulsen.trafficcraft.client.tooltip.TrafficSignTooltip;
import de.mrjulsen.trafficcraft.data.NamedTrafficSignTextureReference;
import de.mrjulsen.trafficcraft.data.TrafficSignData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import net.minecraft.class_5632;

public class PatternCatalogueItem
extends class_1792 {
    @Deprecated
    private static final String NBT_LEGACY_PATTERNS = "patterns";
    private static final String NBT_SELECTED_INDEX = "SelectedIndex";
    private static final String NBT_TEXTURES = "TextureIds";
    private static final int MAX_SIGN_PATTERNS = 36;
    private static final Map<class_1799, Optional<class_5632>> tooltips = new HashMap<class_1799, Optional<class_5632>>();

    public PatternCatalogueItem(class_1792.class_1793 properties) {
        super(properties.method_7889(1));
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (level.field_9236) {
            ClientWrapper.showSignPatternSelectionScreen(stack);
        }
        return new class_1271(class_1269.field_5812, (Object)stack);
    }

    public int getMaxPatterns() {
        return 36;
    }

    protected static class_2487 checkNbt(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        if (!nbt.method_10545(NBT_TEXTURES)) {
            nbt.method_10566(NBT_TEXTURES, (class_2520)new class_2499());
        }
        if (nbt.method_10545(NBT_LEGACY_PATTERNS)) {
            nbt.method_10554(NBT_LEGACY_PATTERNS, 10).stream().forEach(x -> nbt.method_10554(NBT_TEXTURES, 10).add((Object)TrafficSignData.migrate((class_2487)x).toNbt()));
            nbt.method_10551(NBT_LEGACY_PATTERNS);
        }
        if (!nbt.method_10545(NBT_SELECTED_INDEX)) {
            nbt.method_10569(NBT_SELECTED_INDEX, 0);
        }
        return nbt;
    }

    public Optional<class_5632> method_32346(class_1799 pStack) {
        Optional tooltip = tooltips.computeIfAbsent(pStack, x -> this.createTooltip((class_1799)x));
        tooltip.ifPresent(x -> ((TrafficSignTooltip)x).initAgeable());
        return tooltip;
    }

    private Optional<class_5632> createTooltip(class_1799 stck) {
        class_1799 stack = stck;
        class_2371 nonnulllist = class_2371.method_10211();
        if (stack.method_7985()) {
            Arrays.stream(PatternCatalogueItem.getStoredPatterns(stack)).forEach(arg_0 -> nonnulllist.add(arg_0));
        }
        return Optional.of(new TrafficSignTooltip((class_2371<NamedTrafficSignTextureReference>)nonnulllist, this.getSelectedImageData(stack), PatternCatalogueItem.getSelectedIndex(stack), () -> {
            if (tooltips.containsKey(stack)) {
                tooltips.remove(stack);
            }
        }));
    }

    public NamedTrafficSignTextureReference getSelectedImageData(class_1799 stack) {
        return PatternCatalogueItem.getSelectedPattern(stack);
    }

    protected static boolean indexInBounds(class_1799 stack, int index) {
        return index >= 0 && index < PatternCatalogueItem.getStoredPatternCount(stack);
    }

    public static int getSelectedIndex(class_1799 stack) {
        return PatternCatalogueItem.checkNbt(stack).method_10550(NBT_SELECTED_INDEX);
    }

    public static short getStoredPatternCount(class_1799 stack) {
        return (short)PatternCatalogueItem.checkNbt(stack).method_10554(NBT_TEXTURES, 10).size();
    }

    public static NamedTrafficSignTextureReference getPatternAt(class_1799 stack, int index) {
        if (!PatternCatalogueItem.indexInBounds(stack, index)) {
            return null;
        }
        return NamedTrafficSignTextureReference.fromNbt(PatternCatalogueItem.checkNbt(stack).method_10554(NBT_TEXTURES, 10).method_10602(index));
    }

    public static NamedTrafficSignTextureReference getSelectedPattern(class_1799 stack) {
        return PatternCatalogueItem.getPatternAt(stack, PatternCatalogueItem.getSelectedIndex(stack));
    }

    public static NamedTrafficSignTextureReference[] getStoredPatterns(class_1799 stack) {
        return (NamedTrafficSignTextureReference[])PatternCatalogueItem.checkNbt(stack).method_10554(NBT_TEXTURES, 10).stream().map(x -> NamedTrafficSignTextureReference.fromNbt((class_2487)x)).toArray(NamedTrafficSignTextureReference[]::new);
    }

    public static boolean setPattern(class_1799 stack, NamedTrafficSignTextureReference pattern) {
        if (PatternCatalogueItem.getStoredPatternCount(stack) >= ((PatternCatalogueItem)stack.method_7909()).getMaxPatterns()) {
            return false;
        }
        class_2499 tag = PatternCatalogueItem.checkNbt(stack).method_10554(NBT_TEXTURES, 10);
        tag.add((Object)pattern.toNbt());
        PatternCatalogueItem.setSelectedIndex(stack, tag.size() - 1);
        return true;
    }

    public static boolean replacePattern(class_1799 stack, NamedTrafficSignTextureReference pattern, int index) {
        if (PatternCatalogueItem.getStoredPatternCount(stack) >= ((PatternCatalogueItem)stack.method_7909()).getMaxPatterns()) {
            return false;
        }
        PatternCatalogueItem.checkNbt(stack).method_10554(NBT_TEXTURES, 10).method_10606(index, (class_2520)pattern.toNbt());
        PatternCatalogueItem.setSelectedIndex(stack, index);
        return true;
    }

    public static boolean removePatternAt(class_1799 stack, int index) {
        if (!PatternCatalogueItem.indexInBounds(stack, index)) {
            return false;
        }
        PatternCatalogueItem.checkNbt(stack).method_10554(NBT_TEXTURES, 10).method_10536(index);
        short count = PatternCatalogueItem.getStoredPatternCount(stack);
        if (index >= count) {
            PatternCatalogueItem.setSelectedIndex(stack, Math.max(0, count - 1));
        }
        return true;
    }

    public static void clearPatterns(class_1799 stack) {
        PatternCatalogueItem.checkNbt(stack).method_10554(NBT_TEXTURES, 10).clear();
        if (PatternCatalogueItem.checkNbt(stack).method_10545(NBT_LEGACY_PATTERNS)) {
            PatternCatalogueItem.checkNbt(stack).method_10554(NBT_LEGACY_PATTERNS, 10).clear();
        }
    }

    public static void setSelectedIndex(class_1799 stack, int index) {
        PatternCatalogueItem.checkNbt(stack).method_10569(NBT_SELECTED_INDEX, class_3532.method_15340((int)index, (int)-1, (int)Math.max(0, PatternCatalogueItem.getStoredPatternCount(stack) - 1)));
    }
}

