/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import de.mrjulsen.mcdragonlib.core.Location;
import de.mrjulsen.mcdragonlib.data.StatusResult;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.trafficcraft.block.data.RoadType;
import de.mrjulsen.trafficcraft.client.ClientWrapper;
import de.mrjulsen.trafficcraft.config.ModCommonConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1834;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.joml.Vector3f;

public class RoadConstructionTool
extends class_1792 {
    public static final String NBT_LOCATION1 = "Location1";
    public static final String NBT_LOCATION2 = "Location2";
    public static final String NBT_ROAD_WIDTH = "RoadWidth";
    public static final String NBT_REPLACE_BLOCKS = "ReplaceBlocks";
    public static final String NBT_ROAD_TYPE = "RoadType";
    public static final boolean DEFAULT_REPLACE_BLOCKS = true;
    public static final byte DEFAULT_ROAD_WIDTH = 7;
    public static final RoadType DEFAULT_ROAD_TYPE = RoadType.ASPHALT;
    private static final int ERROR_TOO_FAR = 1;
    private static final int ERROR_SLOPE_TOO_STEEP = 2;
    public static final int BUILD_DELAY_TICKS = 4;
    private static byte clientTicks;
    private static final byte FAST_GRAPHICS_CLIENT_TICK_DELAY = 8;
    private static final byte FANCY_GRAPHICS_CLIENT_TICK_DELAY = 4;
    private final float attackDamage;
    private final Multimap<class_1320, class_1322> defaultModifiers;

    public RoadConstructionTool(class_1834 tier, class_1792.class_1793 properties) {
        super(properties.method_7889(1).method_7895(tier.method_8025() * 6));
        float attackDamageModifier = 0.5f;
        this.attackDamage = tier.method_8028() + attackDamageModifier;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)class_5134.field_23721, (Object)new class_1322(field_8006, "Tool modifier", (double)this.attackDamage, class_1322.class_1323.field_6328));
        builder.put((Object)class_5134.field_23723, (Object)new class_1322(field_8001, "Tool modifier", -3.0, class_1322.class_1323.field_6328));
        this.defaultModifiers = builder.build();
    }

    public class_1269 method_7884(class_1838 pContext) {
        class_1937 level = pContext.method_8045();
        class_2338 clickedPos = pContext.method_8037();
        class_243 clickedVec = pContext.method_17698();
        class_1657 player = pContext.method_8036();
        if (!player.method_5715()) {
            if (!level.field_9236) {
                class_2487 compound = pContext.method_8041().method_7948();
                Location location = new Location((double)clickedPos.method_10263(), clickedVec.field_1351, (double)clickedPos.method_10260(), level.method_27983().method_29177().toString());
                if (compound.method_10545(NBT_LOCATION1)) {
                    if (RoadConstructionTool.isLineValid(Location.fromNbt((class_2487)compound.method_10562(NBT_LOCATION1)).getLocationVec3(), location.getLocationVec3()).result()) {
                        compound.method_10566(NBT_LOCATION2, (class_2520)location.toNbt());
                    }
                } else {
                    compound.method_10566(NBT_LOCATION1, (class_2520)location.toNbt());
                }
            }
            return class_1269.field_5812;
        }
        return super.method_7884(pContext);
    }

    public void method_7851(class_1799 pStack, class_1937 pLevel, List<class_2561> pTooltipComponents, class_1836 pIsAdvanced) {
    }

    public boolean method_7846() {
        return true;
    }

    public float getAttackDamage() {
        return this.attackDamage;
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 pSlot) {
        return pSlot == class_1304.field_6173 ? this.defaultModifiers : super.method_7844(pSlot);
    }

    public boolean method_7886(class_1799 pStack) {
        class_2487 tag = pStack.method_7969();
        return tag != null && (tag.method_10545(NBT_LOCATION1) || tag.method_10545(NBT_LOCATION2)) || super.method_7886(pStack);
    }

    public static void reset(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        nbt.method_10551(NBT_LOCATION1);
        nbt.method_10551(NBT_LOCATION2);
        nbt.method_10556(NBT_REPLACE_BLOCKS, true);
        nbt.method_10567(NBT_ROAD_WIDTH, (byte)7);
        nbt.method_10569(NBT_ROAD_TYPE, DEFAULT_ROAD_TYPE.getIndex());
    }

    public static void initStackTag(class_1799 stack) {
        if (!stack.method_7969().method_10545(NBT_ROAD_WIDTH)) {
            stack.method_7969().method_10567(NBT_ROAD_WIDTH, (byte)7);
        }
        if (!stack.method_7969().method_10545(NBT_ROAD_TYPE)) {
            stack.method_7969().method_10569(NBT_ROAD_TYPE, DEFAULT_ROAD_TYPE.getIndex());
        }
        if (!stack.method_7969().method_10545(NBT_REPLACE_BLOCKS)) {
            stack.method_7969().method_10556(NBT_REPLACE_BLOCKS, true);
        }
    }

    private static StatusResult isLineValid(class_243 a, class_243 b) {
        boolean flag1 = a.method_1022(b) < (double)((Integer)ModCommonConfig.ROAD_BUILDER_MAX_DISTANCE.get()).intValue();
        boolean flag2 = MathUtils.slope((class_243)a, (class_243)b) >= (Double)ModCommonConfig.ROAD_BUILDER_MAX_SLOPE.get();
        int status = 0;
        if (!flag1) {
            status = 1;
        } else if (!flag2) {
            status = 2;
        }
        return new StatusResult(flag1 && flag2, status, null);
    }

    public class_1271<class_1799> method_7836(class_1937 pLevel, class_1657 pPlayer, class_1268 pUsedHand) {
        class_1799 itemstack = pPlayer.method_5998(pUsedHand);
        RoadConstructionTool.initStackTag(itemstack);
        Location startLoc = Location.fromNbt((class_2487)itemstack.method_7969().method_10562(NBT_LOCATION1));
        Location endLoc = Location.fromNbt((class_2487)itemstack.method_7969().method_10562(NBT_LOCATION2));
        Collection<Object> blockList = new ArrayList();
        if (endLoc != null && startLoc != null) {
            class_243 start = startLoc.getLocationVec3();
            class_243 end = endLoc.getLocationVec3();
            byte roadWidth = itemstack.method_7969().method_10571(NBT_ROAD_WIDTH);
            boolean replaceBlocks = true;
            blockList = RoadConstructionTool.calculateRoad(pLevel, start, end, roadWidth, replaceBlocks);
        }
        if (pLevel.field_9236) {
            ClientWrapper.showRoadConstructionToolScreen(itemstack, (int)blockList.stream().flatMap(x -> x.values().stream()).filter(v -> v <= 0 || v >= 8).count(), blockList.stream().flatMap(x -> x.values().stream()).filter(v -> v > 0 && v < 8).mapToInt(x -> x).sum());
        }
        return class_1271.method_22427((Object)itemstack);
    }

    public static RoadBuilderCountResult countBlocksNeeded(class_1937 level, class_243 start, class_243 end, byte roadWidth, boolean replaceBlocks) {
        Collection<Object> blockList = new ArrayList();
        blockList = RoadConstructionTool.calculateRoad(level, start, end, roadWidth, replaceBlocks);
        return new RoadBuilderCountResult((int)blockList.stream().flatMap(x -> x.values().stream()).filter(v -> v <= 0 || v >= 8).count(), blockList.stream().flatMap(x -> x.values().stream()).filter(v -> v > 0 && v < 8).mapToInt(x -> x).sum());
    }

    public static Collection<Map<class_2338, Integer>> calculateRoad(class_1937 level, class_243 start, class_243 end, byte roadWidth, boolean replaceBlocks) {
        double spacingMul = 2.0;
        if (start.field_1351 > end.field_1351) {
            class_243 temp = end;
            end = start;
            start = temp;
        }
        class_243 vec = new class_243(end.field_1352, end.field_1351, end.field_1350).method_1020(start);
        class_243 rVec = new class_243(vec.field_1350, 0.0, -vec.field_1352).method_1029();
        double lastY = Double.MIN_VALUE;
        ArrayList<Map<class_2338, Integer>> blockList = new ArrayList<Map<class_2338, Integer>>();
        int i = 0;
        while ((double)i <= vec.method_1033() * 2.0) {
            double d;
            double a = d = 1.0 / vec.method_1033() / 2.0 * (double)i;
            HashMap<class_2338, Integer> blockLayer = new HashMap<class_2338, Integer>();
            class_243 vecPos = new class_243(vec.field_1352 * a, vec.field_1351 * a, vec.field_1350 * a).method_1019(start);
            class_243 rightVec = i == 0 ? rVec.method_1029() : new class_243(vec.field_1350 * a, 0.0, -(vec.field_1352 * a)).method_1029();
            lastY = RoadConstructionTool.setLayer(level, lastY, vecPos, rightVec, blockLayer, roadWidth, replaceBlocks);
            blockList.forEach(x -> x.entrySet().removeIf(y -> blockLayer.keySet().stream().anyMatch(z -> ((class_2338)y.getKey()).equals(z))));
            blockList.add(blockLayer);
            ++i;
        }
        return blockList;
    }

    public static RoadBuildingData prepareRoadBuilding(class_1937 pLevel, class_1657 pPlayer, class_1268 pHand, class_1799 pStack, class_243 start, class_243 end, byte roadWidth, boolean replaceBlocks, RoadType roadType) {
        Collection<Map<class_2338, Integer>> blockList = RoadConstructionTool.calculateRoad(pLevel, start, end, roadWidth, replaceBlocks);
        pPlayer.method_7357().method_7906(pStack.method_7909(), blockList.size() * 4);
        if (!pLevel.field_9236) {
            DLUtils.giveAdvancement((class_3222)((class_3222)pPlayer), (String)"trafficcraft", (String)"road_construction_tool", (String)"req");
        }
        return new RoadBuildingData(blockList, pPlayer, pHand, pStack, start, end, roadWidth, replaceBlocks, roadType);
    }

    private static double setLayer(class_1937 pLevel, double lastY, class_243 pos, class_243 normalizedRightVec, Map<class_2338, Integer> blockList, byte roadWidth, boolean replaceBlocks) {
        block8: {
            class_2338 bPos;
            class_243 vec;
            double i;
            double height;
            double halfWidth;
            block7: {
                halfWidth = (double)roadWidth / 2.0 - 0.5;
                double step = 0.5;
                double pixel = 0.0625;
                double slopeHeight = 0.125;
                double d = pos.field_1351 < 0.0 ? pos.field_1351 - (double)((int)pos.field_1351) + (double)(!(Math.abs(pos.field_1351 - (double)((int)pos.field_1351)) <= 0.0) ? 1 : 0) : (height = pos.field_1351 - (double)((int)pos.field_1351));
                if (lastY < (double)((int)pos.field_1351) + 0.125) {
                    for (i = -halfWidth; i < halfWidth + 0.5; i += 0.5) {
                        vec = pos.method_1019(normalizedRightVec.method_1021(i));
                        bPos = new class_2338((int)vec.field_1352, (int)vec.field_1351 - 1, (int)vec.field_1350);
                        if (!replaceBlocks && !pLevel.method_22347(bPos)) continue;
                        if (blockList.containsKey(bPos)) {
                            blockList.remove(bPos);
                        }
                        blockList.put(bPos, 8);
                    }
                }
                if (!(height >= 1.0625)) break block7;
                for (i = -halfWidth; i < halfWidth + 0.5; i += 0.5) {
                    vec = pos.method_1019(normalizedRightVec.method_1021(i));
                    bPos = new class_2338((int)vec.field_1352, (int)vec.field_1351, (int)vec.field_1350);
                    if (!replaceBlocks && !pLevel.method_22347(bPos)) continue;
                    if (blockList.containsKey(bPos)) {
                        blockList.remove(bPos);
                    }
                    blockList.put(bPos, 8);
                }
                break block8;
            }
            if (!(height >= 0.125)) break block8;
            for (i = -halfWidth; i < halfWidth + 0.5; i += 0.5) {
                vec = pos.method_1019(normalizedRightVec.method_1021(i));
                bPos = new class_2338((int)vec.field_1352, (int)vec.field_1351, (int)vec.field_1350);
                if (!replaceBlocks && !pLevel.method_22347(bPos)) continue;
                if (blockList.containsKey(bPos)) {
                    blockList.remove(bPos);
                }
                blockList.put(bPos, (int)(height / 0.125));
            }
        }
        return pos.field_1351;
    }

    @Environment(value=EnvType.CLIENT)
    public static void clientTick() {
        if ((clientTicks = (byte)(clientTicks + 1)) > (class_310.method_1517() ? (byte)4 : 8)) {
            clientTicks = 0;
        }
        class_746 player = class_310.method_1551().field_1724;
        class_638 level = class_310.method_1551().field_1687;
        if (player == null || level == null) {
            return;
        }
        if (class_310.method_1551().field_1755 != null) {
            return;
        }
        if (!(player.method_5998(class_1268.field_5808).method_7909() instanceof RoadConstructionTool) && !(player.method_5998(class_1268.field_5810).method_7909() instanceof RoadConstructionTool)) {
            return;
        }
        class_1799 stack = player.method_5998(class_1268.field_5808).method_7909() instanceof RoadConstructionTool ? player.method_5998(class_1268.field_5808) : player.method_5998(class_1268.field_5810);
        class_2487 nbt = stack.method_7948();
        RoadConstructionTool.initStackTag(stack);
        if (!nbt.method_10545(NBT_LOCATION1)) {
            return;
        }
        class_243 start = Location.fromNbt((class_2487)nbt.method_10562(NBT_LOCATION1)).getLocationVec3().method_1031(0.5, 0.0, 0.5);
        class_243 end = null;
        if (nbt.method_10545(NBT_LOCATION1) && !nbt.method_10545(NBT_LOCATION2)) {
            class_239 lookingAt = player.method_5745(4.5, 0.0f, false);
            class_243 lookAtVec = lookingAt.method_17784();
            if (!level.method_22347(new class_2338((int)lookAtVec.field_1352, (int)lookAtVec.field_1351, (int)lookAtVec.field_1350)) || !level.method_22347(new class_2338((int)lookAtVec.field_1352, (int)(lookAtVec.field_1351 - 0.5), (int)lookAtVec.field_1350))) {
                double blockHeight = level.method_30347(new class_2338((int)lookAtVec.field_1352, (int)lookAtVec.field_1351, (int)lookAtVec.field_1350));
                int vX = lookAtVec.method_10216() > 0.0 ? 1 : -1;
                int vZ = lookAtVec.method_10215() > 0.0 ? 1 : -1;
                end = new class_243((double)((int)lookAtVec.method_10216()) + (double)vX * 0.5, (double)((int)lookAtVec.method_10214()) + (blockHeight <= 0.0 ? 0.0 : blockHeight), (double)((int)lookAtVec.method_10215()) + (double)vZ * 0.5);
            } else {
                end = null;
            }
            player.method_7353((class_2561)TextUtils.translate((String)"item.trafficcraft.road_construction_tool.status_pos1", (Object[])new Object[]{Location.fromNbt((class_2487)nbt.method_10562(NBT_LOCATION1)).getLocationBlockPos().method_23854()}), true);
        } else if (nbt.method_10545(NBT_LOCATION1) && nbt.method_10545(NBT_LOCATION2)) {
            end = Location.fromNbt((class_2487)nbt.method_10562(NBT_LOCATION2)).getLocationVec3().method_1031(0.5, 0.0, 0.5);
            player.method_7353((class_2561)TextUtils.translate((String)"item.trafficcraft.road_construction_tool.status_pos2", (Object[])new Object[]{Location.fromNbt((class_2487)nbt.method_10562(NBT_LOCATION1)).getLocationBlockPos().method_23854(), Location.fromNbt((class_2487)nbt.method_10562(NBT_LOCATION2)).getLocationBlockPos().method_23854()}).method_27692(class_124.field_1060), true);
        }
        if (end == null) {
            return;
        }
        class_243 line = end.method_1020(start);
        double width = nbt.method_10571(NBT_ROAD_WIDTH);
        double halfWidth = width / 2.0;
        double spacing = 0.25;
        if (line.method_1033() <= 0.0) {
            return;
        }
        if (line.method_1033() < 256.0) {
            double mul = 1.0 / Math.min(line.method_1033(), 256.0) * 0.25;
            int lineStatus = RoadConstructionTool.isLineValid(start, end).code();
            switch (lineStatus) {
                case 1: {
                    player.method_7353((class_2561)TextUtils.translate((String)"item.trafficcraft.road_construction_tool.status_too_far").method_27692(class_124.field_1061), true);
                    break;
                }
                case 2: {
                    player.method_7353((class_2561)TextUtils.translate((String)"item.trafficcraft.road_construction_tool.status_slope_too_steep").method_27692(class_124.field_1061), true);
                    break;
                }
            }
            if (clientTicks == 0) {
                for (double d = 0.0; d < 1.0; d += mul) {
                    class_243 vecPos = new class_243(line.field_1352 * d, line.field_1351 * d, line.field_1350 * d).method_1019(start);
                    level.method_8406((class_2394)new class_2390(RoadConstructionTool.isLineValid(start, end).result() ? new Vector3f(0.2f, 0.9f, 0.2f) : new Vector3f(0.9f, 0.2f, 0.2f), 1.0f), vecPos.field_1352, vecPos.field_1351, vecPos.field_1350, 0.0, 0.0, 0.0);
                    class_243 rightVec = vecPos.method_1019(new class_243(line.field_1350 * d, 0.0, -line.field_1352 * d).method_1029().method_1021(halfWidth));
                    level.method_8406((class_2394)new class_2390(new Vector3f(1.0f, 1.0f, 0.6f), 0.5f), rightVec.field_1352, rightVec.field_1351, rightVec.field_1350, 0.0, 0.0, 0.0);
                    class_243 leftVec = vecPos.method_1019(new class_243(-line.field_1350 * d, 0.0, line.field_1352 * d).method_1029().method_1021(halfWidth));
                    level.method_8406((class_2394)new class_2390(new Vector3f(1.0f, 1.0f, 0.6f), 0.5f), leftVec.field_1352, leftVec.field_1351, leftVec.field_1350, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public static class RoadBuilderCountResult {
        public final int blocksCount;
        public final int slopesCount;

        protected RoadBuilderCountResult(int blocksCount, int slopesCount) {
            this.blocksCount = blocksCount;
            this.slopesCount = slopesCount;
        }
    }

    public static class RoadBuildingData {
        public final List<Map<class_2338, Integer>> blocks;
        public final class_1657 player;
        public final class_1268 hand;
        public final class_1799 item;
        public final class_243 start;
        public final class_243 end;
        public final byte roadWidth;
        public final boolean replaceBlocks;
        public final RoadType roadType;

        public RoadBuildingData(Collection<Map<class_2338, Integer>> blocks, class_1657 player, class_1268 hand, class_1799 item, class_243 start, class_243 end, byte roadWidth, boolean replaceBlocks, RoadType roadType) {
            this.blocks = new ArrayList<Map<class_2338, Integer>>(blocks);
            this.player = player;
            this.hand = hand;
            this.item = item;
            this.start = start;
            this.end = end;
            this.roadWidth = roadWidth;
            this.replaceBlocks = replaceBlocks;
            this.roadType = roadType;
        }
    }
}

