/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.item;

import de.mrjulsen.mcdragonlib.core.IIterableEnum;
import de.mrjulsen.mcdragonlib.core.ITranslatableEnum;
import de.mrjulsen.mcdragonlib.core.Location;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.trafficcraft.TrafficCraft;
import de.mrjulsen.trafficcraft.block.TrafficLightRequestButtonBlock;
import de.mrjulsen.trafficcraft.block.entity.TrafficLightControllerBlockEntity;
import de.mrjulsen.trafficcraft.block.entity.TrafficLightRequestButtonBlockEntity;
import de.mrjulsen.trafficcraft.item.ILinkerItem;
import de.mrjulsen.trafficcraft.item.IScrollEventItem;
import de.mrjulsen.trafficcraft.network.packets.cts.LinkerModePacket;
import de.mrjulsen.trafficcraft.registry.ModBlocks;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3542;

public class TrafficLightLinkerItem
extends class_1792
implements ILinkerItem,
IScrollEventItem {
    public static final String NBT_LINK_TARGET = "LinkTargetLocation";
    public static final String NBT_MODE = "Mode";
    public static final String NBT_BLOCK = "Block";
    private static final class_2561 textNoLink = TextUtils.translate((String)"item.trafficcraft.traffic_light_linker.tooltip.nolink").method_27692(class_124.field_1080);
    private static final class_2561 textNotLoaded = TextUtils.translate((String)"item.trafficcraft.traffic_light_linker.use.target_not_loaded").method_27692(class_124.field_1061);
    private static final class_2561 textClear = TextUtils.translate((String)"item.trafficcraft.traffic_light_linker.use.clear");
    private static final class_2561 textTooltipInstruction = TextUtils.translate((String)"item.trafficcraft.traffic_light_linker.tooltip_instruction").method_27692(class_124.field_1056);
    private static final String keySet = "item.trafficcraft.traffic_light_linker.use.set";
    private static final String keyWrongDim = "item.trafficcraft.traffic_light_linker.use.wrong_dimension";
    private static final String keySetLink = "item.trafficcraft.traffic_light_linker.use.link";
    private static final String keyRemoveLink = "item.trafficcraft.traffic_light_linker.use.unlink";
    private static final String keyTooltipLocation = "item.trafficcraft.traffic_light_linker.tooltip_location";
    private static final String keyTooltipBlock = "item.trafficcraft.traffic_light_linker.tooltip_block";
    private static final String keyTooltipMode = "item.trafficcraft.traffic_light_linker.tooltip_mode";

    public TrafficLightLinkerItem(class_1792.class_1793 pProperties) {
        super(pProperties);
    }

    public class_1269 method_7884(class_1838 pContext) {
        class_1937 level = pContext.method_8045();
        class_2338 clickedPos = pContext.method_8037();
        class_1657 player = pContext.method_8036();
        if (!player.method_5715()) {
            class_2248 clickedBlock = pContext.method_8045().method_8320(clickedPos).method_26204();
            class_2487 nbt = this.doesContainValidLinkData(pContext.method_8041());
            if (nbt == null && this.isSourceBlockAccepted(clickedBlock)) {
                if (!level.field_9236) {
                    class_2487 compound = pContext.method_8041().method_7948();
                    compound.method_10566(NBT_LINK_TARGET, (class_2520)new Location(clickedPos.method_10263(), clickedPos.method_10264(), clickedPos.method_10260(), level.method_27983().method_29177().toString()).toNbt());
                    compound.method_10582(NBT_BLOCK, ModBlocks.BLOCKS.getRegistrar().getId((Object)clickedBlock).toString());
                    player.method_7353((class_2561)TextUtils.translate((String)keySet, (Object[])new Object[]{clickedPos.method_23854(), level.method_27983().method_29177()}).method_27692(class_124.field_1075), true);
                }
                return class_1269.field_5812;
            }
            if (this.isTargetBlockAccepted(clickedBlock)) {
                class_2586 class_25862;
                if (nbt == null) {
                    return class_1269.field_5814;
                }
                Location linkLoc = Location.fromNbt((class_2487)nbt.method_10562(NBT_LINK_TARGET));
                LinkerMode mode = LinkerMode.getByIndex(nbt.method_10550(NBT_MODE));
                if (!pContext.method_8045().method_27983().method_29177().toString().equals(linkLoc.dimension)) {
                    player.method_7353((class_2561)TextUtils.translate((String)keyWrongDim).method_27692(class_124.field_1061), true);
                }
                if (clickedBlock instanceof TrafficLightRequestButtonBlock && (class_25862 = pContext.method_8045().method_8321(clickedPos)) instanceof TrafficLightRequestButtonBlockEntity) {
                    TrafficLightRequestButtonBlockEntity blockEntity = (TrafficLightRequestButtonBlockEntity)class_25862;
                    switch (mode.ordinal()) {
                        case 1: {
                            blockEntity.clearLink();
                            player.method_7353((class_2561)TextUtils.translate((String)keyRemoveLink, (Object[])new Object[]{linkLoc.getLocationBlockPos().method_23854(), level.method_27983().method_29177()}).method_27692(class_124.field_1061), true);
                            break;
                        }
                        default: {
                            blockEntity.linkTo(linkLoc);
                            player.method_7353((class_2561)TextUtils.translate((String)keySetLink, (Object[])new Object[]{linkLoc.getLocationBlockPos().method_23854(), level.method_27983().method_29177()}).method_27692(class_124.field_1060), true);
                            break;
                        }
                    }
                } else if (pContext.method_8045().method_8477(linkLoc.getLocationBlockPos()) && this.isSourceBlockAccepted(pContext.method_8045().method_8320(linkLoc.getLocationBlockPos()).method_26204())) {
                    class_2586 class_25863 = pContext.method_8045().method_8321(linkLoc.getLocationBlockPos());
                    if (class_25863 instanceof TrafficLightControllerBlockEntity) {
                        TrafficLightControllerBlockEntity blockEntity = (TrafficLightControllerBlockEntity)class_25863;
                        class_2338 pos = pContext.method_8037();
                        String dim = pContext.method_8045().method_27983().method_29177().toString();
                        switch (mode.ordinal()) {
                            case 1: {
                                blockEntity.removeTrafficLightLocation(new Location(pos.method_10263(), pos.method_10264(), pos.method_10260(), dim));
                                player.method_7353((class_2561)TextUtils.translate((String)keyRemoveLink, (Object[])new Object[]{linkLoc.getLocationBlockPos().method_23854(), level.method_27983().method_29177()}).method_27692(class_124.field_1061), true);
                                break;
                            }
                            default: {
                                blockEntity.addTrafficLightLocation(new Location(pos.method_10263(), pos.method_10264(), pos.method_10260(), dim));
                                player.method_7353((class_2561)TextUtils.translate((String)keySetLink, (Object[])new Object[]{linkLoc.getLocationBlockPos().method_23854(), level.method_27983().method_29177()}).method_27692(class_124.field_1060), true);
                            }
                        }
                    }
                } else {
                    player.method_7353(textNotLoaded, true);
                }
                return class_1269.field_5812;
            }
        }
        return super.method_7884(pContext);
    }

    public class_1271<class_1799> method_7836(class_1937 pLevel, class_1657 pPlayer, class_1268 pUsedHand) {
        class_1799 itemstack = pPlayer.method_5998(pUsedHand);
        if (pPlayer.method_5715()) {
            class_1937 level = pPlayer.method_37908();
            if (!level.field_9236) {
                if (itemstack.method_7969() != null) {
                    class_2487 tag = itemstack.method_7969();
                    tag.method_10551(NBT_LINK_TARGET);
                    tag.method_10551(NBT_BLOCK);
                }
                pPlayer.method_7353(textClear, true);
            }
            return class_1271.method_22427((Object)itemstack);
        }
        return class_1271.method_22431((Object)itemstack);
    }

    public void method_7851(class_1799 pStack, class_1937 pLevel, List<class_2561> pTooltipComponents, class_1836 pIsAdvanced) {
        class_2487 tag = null;
        tag = this.doesContainValidLinkData(pStack);
        if (tag != null) {
            Location loc = Location.fromNbt((class_2487)tag.method_10562(NBT_LINK_TARGET));
            pTooltipComponents.add((class_2561)TextUtils.translate((String)keyTooltipLocation, (Object[])new Object[]{Integer.toString((int)loc.x), Integer.toString((int)loc.y), Integer.toString((int)loc.z), loc.dimension}));
        } else {
            pTooltipComponents.add(textNoLink);
        }
        class_2487 nbt = pStack.method_7948();
        LinkerMode mode = LinkerMode.getByIndex(nbt.method_10550(NBT_MODE));
        if (nbt.method_10545(NBT_BLOCK)) {
            try {
                class_2960 location = new class_2960(nbt.method_10558(NBT_BLOCK));
                pTooltipComponents.add((class_2561)TextUtils.translate((String)keyTooltipBlock, (Object[])new Object[]{((class_2248)ModBlocks.BLOCKS.getRegistrar().get(location)).method_9518().getString()}));
            }
            catch (Exception e) {
                pTooltipComponents.add((class_2561)TextUtils.translate((String)keyTooltipBlock, (Object[])new Object[]{TextUtils.text((String)"ERROR").method_27692(class_124.field_1061)}));
            }
        }
        pTooltipComponents.add((class_2561)TextUtils.translate((String)keyTooltipMode, (Object[])new Object[]{TextUtils.translate((String)mode.getValueTranslationKey("trafficcraft")), TextUtils.translate((String)mode.getValueTranslationKey("trafficcraft"))}));
        pTooltipComponents.add(textTooltipInstruction);
    }

    public boolean method_7886(class_1799 pStack) {
        return this.doesContainValidLinkData(pStack) != null || super.method_7886(pStack);
    }

    public class_2487 doesContainValidLinkData(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        return tag != null && tag.method_10545(NBT_LINK_TARGET) ? tag : null;
    }

    @Override
    public boolean isTargetBlockAccepted(class_2248 block) {
        return block.equals(ModBlocks.TRAFFIC_LIGHT.get()) || block.equals(ModBlocks.TRAFFIC_LIGHT_REQUEST_BUTTON.get());
    }

    @Override
    public boolean isSourceBlockAccepted(class_2248 block) {
        return block.equals(ModBlocks.TRAFFIC_LIGHT_CONTROLLER.get()) || block.equals(ModBlocks.TRAFFIC_LIGHT.get());
    }

    @Override
    public boolean mouseScroll(class_1657 player, class_1799 itemStack, double scrollDelta) {
        if (player.method_18276()) {
            class_2487 compound = itemStack.method_7948();
            LinkerMode mode = LinkerMode.LINK;
            if (scrollDelta > 0.0) {
                mode = (LinkerMode)LinkerMode.getByIndex(compound.method_10550(NBT_MODE)).next();
            } else if (scrollDelta < 0.0) {
                mode = (LinkerMode)LinkerMode.getByIndex(compound.method_10550(NBT_MODE)).previous();
            }
            TrafficLightLinkerItem.setMode(itemStack, mode);
            TrafficCraft.net().sendToServer((Object)new LinkerModePacket(mode));
            player.method_7353((class_2561)TextUtils.translate((String)keyTooltipMode, (Object[])new Object[]{TextUtils.translate((String)LinkerMode.getByIndex(compound.method_10550(NBT_MODE)).getValueTranslationKey("trafficcraft")), TextUtils.translate((String)LinkerMode.getByIndex(compound.method_10550(NBT_MODE)).getValueTranslationKey("trafficcraft"))}), true);
            return true;
        }
        return false;
    }

    public static void setMode(class_1799 item, LinkerMode mode) {
        class_2487 compound = item.method_7948();
        compound.method_10569(NBT_MODE, mode.getIndex());
    }

    public static enum LinkerMode implements class_3542,
    ITranslatableEnum,
    IIterableEnum<LinkerMode>
    {
        LINK(0, "link"),
        UNLINK(1, "unlink");

        private int index;
        private String name;

        private LinkerMode(int index, String name) {
            this.index = index;
            this.name = name;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public static LinkerMode getByIndex(int index) {
            return Arrays.stream(LinkerMode.values()).filter(x -> x.getIndex() == index).findFirst().orElse(LINK);
        }

        public LinkerMode[] getValues() {
            return LinkerMode.values();
        }

        public String getEnumName() {
            return "linkermode";
        }

        public String getEnumValueName() {
            return this.getName();
        }

        public String method_15434() {
            return this.getName();
        }
    }
}

