/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.network.packets.cts;

import de.mrjulsen.mcdragonlib.core.Location;
import de.mrjulsen.mcdragonlib.net.IPacketBase;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.ScheduledTask;
import de.mrjulsen.trafficcraft.block.AsphaltSlope;
import de.mrjulsen.trafficcraft.block.data.RoadType;
import de.mrjulsen.trafficcraft.item.RoadConstructionTool;
import dev.architectury.networking.NetworkManager;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_7134;

public class RoadBuilderBuildRoadPacket
implements IPacketBase<RoadBuilderBuildRoadPacket> {
    private Location pos1;
    private Location pos2;
    private byte roadWidth;
    private boolean replaceBlocks;
    private RoadType roadType;

    public RoadBuilderBuildRoadPacket() {
    }

    public RoadBuilderBuildRoadPacket(Location pos1, Location pos2, byte roadWidth, boolean replaceBlocks, RoadType roadType) {
        this.pos1 = pos1;
        this.pos2 = pos2;
        this.roadWidth = roadWidth;
        this.replaceBlocks = replaceBlocks;
        this.roadType = roadType;
    }

    public void encode(RoadBuilderBuildRoadPacket packet, class_2540 buffer) {
        buffer.method_10794(packet.pos1.toNbt());
        buffer.method_10794(packet.pos2.toNbt());
        buffer.writeByte((int)packet.roadWidth);
        buffer.writeBoolean(packet.replaceBlocks);
        buffer.method_10817((Enum)packet.roadType);
    }

    public RoadBuilderBuildRoadPacket decode(class_2540 buffer) {
        Location pos1 = Location.fromNbt((class_2487)buffer.method_10798());
        Location pos2 = Location.fromNbt((class_2487)buffer.method_10798());
        byte roadWidth = buffer.readByte();
        boolean replaceBlocks = buffer.readBoolean();
        RoadType roadType = (RoadType)buffer.method_10818(RoadType.class);
        return new RoadBuilderBuildRoadPacket(pos1, pos2, roadWidth, replaceBlocks, roadType);
    }

    public void handle(RoadBuilderBuildRoadPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            class_3222 sender = (class_3222)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer();
            class_1937 level = sender.method_37908();
            class_1799 item = null;
            class_1268 hand = null;
            if (sender.method_5998(class_1268.field_5808).method_7909() instanceof RoadConstructionTool) {
                item = sender.method_5998(class_1268.field_5808);
                hand = class_1268.field_5808;
            } else if (sender.method_5998(class_1268.field_5810).method_7909() instanceof RoadConstructionTool) {
                item = sender.method_5998(class_1268.field_5810);
                hand = class_1268.field_5810;
            } else {
                return;
            }
            RoadConstructionTool.RoadBuildingData buildingData = RoadConstructionTool.prepareRoadBuilding(level, (class_1657)sender, hand, item, packet.pos1.getLocationVec3(), packet.pos2.getLocationVec3(), packet.roadWidth, packet.replaceBlocks, packet.roadType);
            ScheduledTask.create((Object)buildingData, (class_1937)level, (int)4, (int)buildingData.blocks.size(), packet::run);
        });
    }

    private boolean run(RoadConstructionTool.RoadBuildingData data, ScheduledTask.ScheduledTaskContext context) {
        boolean[] canContinue = new boolean[]{true};
        for (Map.Entry<class_2338, Integer> block : data.blocks.get(context.iteration()).entrySet()) {
            if (!canContinue[0] || !data.player.method_5805()) {
                return false;
            }
            if (!RoadBuilderBuildRoadPacket.isPlayerCreative(data.player) && data.player.method_31548().method_18861(data.roadType.getSlope().method_8389()) <= 0 && data.player.method_31548().method_18861(data.roadType.getBlock().method_8389()) <= 0) {
                return false;
            }
            if (context.level().method_8320(block.getKey()).method_26204().method_36555() == -1.0f) continue;
            if (block.getValue() > 0 && block.getValue() <= 7 && (RoadBuilderBuildRoadPacket.isPlayerCreative(data.player) || data.player.method_31548().method_18861(data.roadType.getSlope().method_8389()) > 0)) {
                Optional<class_1799> stack;
                int countLeft;
                context.level().method_22352(block.getKey(), !RoadBuilderBuildRoadPacket.isPlayerCreative(data.player));
                int layers = Math.min(block.getValue(), RoadBuilderBuildRoadPacket.isPlayerCreative(data.player) ? Integer.MAX_VALUE : data.player.method_31548().method_18861(data.roadType.getSlope().method_8389()));
                context.level().method_8501(block.getKey(), (class_2680)data.roadType.getSlope().method_9564().method_11657((class_2769)AsphaltSlope.LAYERS, (Comparable)Integer.valueOf(layers)));
                if (RoadBuilderBuildRoadPacket.isPlayerCreative(data.player)) continue;
                for (countLeft = layers; canContinue[0] && countLeft > 0 && (stack = data.player.method_31548().field_7547.stream().filter(x -> x.method_31574(data.roadType.getSlope().method_8389())).findFirst()).isPresent(); countLeft -= Math.min(countLeft, stack.get().method_7947())) {
                    int removeCount = countLeft;
                    stack.get().method_7934(removeCount);
                    data.item.method_7956(1, (class_1309)data.player, player -> {
                        player.method_20235(data.hand == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171);
                        canContinue[0] = false;
                    });
                }
                if (countLeft <= 0) continue;
                canContinue[0] = false;
                continue;
            }
            if (block.getValue() <= 7 || !RoadBuilderBuildRoadPacket.isPlayerCreative(data.player) && data.player.method_31548().method_18861(data.roadType.getBlock().method_8389()) <= 0) continue;
            context.level().method_22352(block.getKey(), !RoadBuilderBuildRoadPacket.isPlayerCreative(data.player));
            context.level().method_8501(block.getKey(), data.roadType.getBlock().method_9564());
            if (RoadBuilderBuildRoadPacket.isPlayerCreative(data.player)) continue;
            Optional<class_1799> stack = data.player.method_31548().field_7547.stream().filter(x -> x.method_31574(data.roadType.getBlock().method_8389())).findFirst();
            if (stack.isPresent()) {
                stack.get().method_7934(1);
            } else {
                canContinue[0] = false;
            }
            data.item.method_7956(1, (class_1309)data.player, player -> {
                player.method_20235(data.hand == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171);
                canContinue[0] = false;
            });
        }
        if (context.iteration() >= data.blocks.size() - 1) {
            if (context.level().method_27983().method_29177().equals((Object)class_7134.field_37667.method_29177())) {
                DLUtils.giveAdvancement((class_3222)((class_3222)data.player), (String)"trafficcraft", (String)"highway_to_hell", (String)"req");
            } else if (context.level().method_27983().method_29177().equals((Object)class_7134.field_37668.method_29177())) {
                DLUtils.giveAdvancement((class_3222)((class_3222)data.player), (String)"trafficcraft", (String)"final_destination", (String)"req");
            }
        }
        return canContinue[0];
    }

    private static boolean isPlayerCreative(class_1657 pPlayer) {
        return pPlayer.method_7337() || pPlayer.method_7325();
    }
}

