/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.network.packets.cts;

import de.mrjulsen.mcdragonlib.net.IPacketBase;
import de.mrjulsen.trafficcraft.block.TownSignBlock;
import de.mrjulsen.trafficcraft.block.data.TownSignVariant;
import de.mrjulsen.trafficcraft.block.entity.TownSignBlockEntity;
import dev.architectury.networking.NetworkManager;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;

public class TownSignPacket
implements IPacketBase<TownSignPacket> {
    private String[] messages;
    private TownSignVariant variant;
    private class_2338 pos;
    private TownSignBlock.ETownSignSide side;

    public TownSignPacket() {
    }

    public TownSignPacket(class_2338 pos, String[] messages, TownSignVariant variant, TownSignBlock.ETownSignSide side) {
        this.pos = pos;
        this.variant = variant;
        this.messages = messages;
        this.side = side;
    }

    public void encode(TownSignPacket packet, class_2540 buffer) {
        buffer.method_10807(packet.pos);
        buffer.writeInt(packet.variant.getIndex());
        buffer.writeInt(packet.side.getIndex());
        buffer.writeInt(packet.messages.length);
        for (int i = 0; i < packet.messages.length; ++i) {
            String message = packet.messages[i];
            int messageLength = packet.messages[i].getBytes(StandardCharsets.UTF_8).length;
            buffer.writeInt(messageLength);
            buffer.method_10788(message, messageLength);
        }
    }

    public TownSignPacket decode(class_2540 buffer) {
        class_2338 pos = buffer.method_10811();
        TownSignVariant variant = TownSignVariant.getVariantByIndex(buffer.readInt());
        TownSignBlock.ETownSignSide side = TownSignBlock.ETownSignSide.getSideByIndex(buffer.readInt());
        int messagesCount = buffer.readInt();
        String[] messages = new String[messagesCount];
        for (int i = 0; i < messagesCount; ++i) {
            int messageLength = buffer.readInt();
            messages[i] = buffer.method_10800(messageLength);
        }
        TownSignPacket instance = new TownSignPacket(pos, messages, variant, side);
        return instance;
    }

    public void handle(TownSignPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            class_2586 patt0$temp;
            class_3222 sender = (class_3222)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer();
            if (sender.method_37908().method_8320(packet.pos).method_26204() instanceof TownSignBlock && (patt0$temp = sender.method_37908().method_8321(packet.pos)) instanceof TownSignBlockEntity) {
                TownSignBlockEntity blockEntity = (TownSignBlockEntity)patt0$temp;
                switch (packet.side) {
                    case BACK: {
                        blockEntity.setBackTexts(packet.messages);
                        break;
                    }
                    default: {
                        blockEntity.setTexts(packet.messages);
                    }
                }
                class_2680 state = sender.method_37908().method_8320(packet.pos);
                sender.method_37908().method_8501(packet.pos, (class_2680)state.method_11657(TownSignBlock.VARIANT, (Comparable)((Object)packet.variant)));
            }
        });
    }
}

