/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.network.packets.cts;

import de.mrjulsen.mcdragonlib.net.IPacketBase;
import de.mrjulsen.trafficcraft.block.TrafficLightBlock;
import de.mrjulsen.trafficcraft.block.data.TrafficLightColor;
import de.mrjulsen.trafficcraft.block.data.TrafficLightControlType;
import de.mrjulsen.trafficcraft.block.data.TrafficLightIcon;
import de.mrjulsen.trafficcraft.block.data.TrafficLightModel;
import de.mrjulsen.trafficcraft.block.data.TrafficLightType;
import de.mrjulsen.trafficcraft.block.entity.TrafficLightBlockEntity;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;

public class TrafficLightPacket
implements IPacketBase<TrafficLightPacket> {
    private class_2338 pos;
    private Collection<TrafficLightColor> enabledColors;
    private TrafficLightType type;
    private TrafficLightModel model;
    private TrafficLightIcon icon;
    private TrafficLightControlType controlType;
    private TrafficLightColor[] colors;
    private int phaseId;
    private boolean scheduleEnabled;

    public TrafficLightPacket() {
    }

    public TrafficLightPacket(class_2338 pos, Collection<TrafficLightColor> enabledColors, TrafficLightType type, TrafficLightModel model, TrafficLightIcon icon, TrafficLightControlType controlType, TrafficLightColor[] colorSlots, int phaseId, boolean scheduleEnabled) {
        this.pos = pos;
        this.enabledColors = enabledColors;
        this.type = type;
        this.model = model;
        this.icon = icon;
        this.controlType = controlType;
        this.colors = colorSlots;
        this.phaseId = phaseId;
        this.scheduleEnabled = scheduleEnabled;
    }

    public void encode(TrafficLightPacket packet, class_2540 buffer) {
        int i;
        buffer.method_10807(packet.pos);
        TrafficLightColor[] enabledColorsArr = (TrafficLightColor[])packet.enabledColors.toArray(TrafficLightColor[]::new);
        buffer.writeBoolean(enabledColorsArr.length > 0);
        if (enabledColorsArr.length > 0) {
            byte[] enColBArr = new byte[enabledColorsArr.length];
            for (i = 0; i < enabledColorsArr.length; ++i) {
                enColBArr[i] = enabledColorsArr[i].getGroupIndex();
            }
            buffer.method_10813(enColBArr);
        }
        buffer.writeByte((int)packet.type.getIndex());
        buffer.writeByte((int)packet.model.getLightsCount());
        buffer.writeByte((int)packet.icon.getIndex());
        buffer.writeByte((int)packet.controlType.getIndex());
        buffer.writeBoolean(packet.colors.length > 0);
        if (packet.colors.length > 0) {
            byte[] colSlBArr = new byte[packet.colors.length];
            for (i = 0; i < packet.colors.length; ++i) {
                colSlBArr[i] = packet.colors[i].getGroupIndex();
            }
            buffer.method_10813(colSlBArr);
        }
        buffer.writeInt(packet.phaseId);
        buffer.writeBoolean(packet.scheduleEnabled);
    }

    public TrafficLightPacket decode(class_2540 buffer) {
        class_2338 pos = buffer.method_10811();
        ArrayList<TrafficLightColor> enabledColors = new ArrayList<TrafficLightColor>();
        byte[] enColBArr = new byte[]{};
        if (buffer.readBoolean()) {
            enColBArr = buffer.method_10795();
        }
        TrafficLightType type = TrafficLightType.getTypeByIndex(buffer.readByte());
        for (byte b : enColBArr) {
            enabledColors.add(TrafficLightColor.getColorByGroupIndex(b, type));
        }
        TrafficLightModel model = TrafficLightModel.getModelByLightsCount(buffer.readByte());
        TrafficLightIcon icon = TrafficLightIcon.getIconByIndex(buffer.readByte());
        TrafficLightControlType controlType = TrafficLightControlType.getControlTypeByIndex(buffer.readByte());
        TrafficLightColor[] colorSlots = new TrafficLightColor[TrafficLightModel.maxRequiredSlots()];
        if (buffer.readBoolean()) {
            byte[] colSlBArr = buffer.method_10795();
            for (int i = 0; i < colSlBArr.length && i < colorSlots.length; ++i) {
                colorSlots[i] = TrafficLightColor.getColorByGroupIndex(colSlBArr[i], type);
            }
        }
        int phaseId = buffer.readInt();
        boolean scheduleEnabled = buffer.readBoolean();
        return new TrafficLightPacket(pos, enabledColors, type, model, icon, controlType, colorSlots, phaseId, scheduleEnabled);
    }

    public void handle(TrafficLightPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            class_1937 level;
            class_3222 player = (class_3222)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer();
            if (player != null && (level = player.method_37908()).method_8477(packet.pos)) {
                class_2586 patt0$temp = level.method_8321(packet.pos);
                if (patt0$temp instanceof TrafficLightBlockEntity) {
                    TrafficLightBlockEntity blockEntity = (TrafficLightBlockEntity)patt0$temp;
                    blockEntity.setRunning(packet.scheduleEnabled);
                    blockEntity.setPhaseId(packet.phaseId);
                    blockEntity.setControlType(packet.controlType);
                    blockEntity.setIcon(packet.icon);
                    blockEntity.setColorSlots(packet.colors);
                    blockEntity.enableOnlyColors(packet.enabledColors);
                    blockEntity.setType(packet.type);
                }
                class_2680 state = level.method_8320(packet.pos);
                level.method_8501(packet.pos, (class_2680)state.method_11657(TrafficLightBlock.MODEL, (Comparable)((Object)packet.model)));
            }
        });
    }
}

