/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.mrjulsen.trafficcraft.recipe.IDamageableCraftingItem;
import de.mrjulsen.trafficcraft.registry.ModItems;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7710;
import net.minecraft.class_8566;

public class DamageableItemRecipe
extends class_1867 {
    public DamageableItemRecipe(class_2960 id, String group, class_7710 category, class_1799 result, class_2371<class_1856> ingredients) {
        super(id, group, category, result, ingredients);
    }

    public class_1865<?> method_8119() {
        return (class_1865)ModItems.DAMAGEABLE_ITEM_RECIPE.get();
    }

    public class_2371<class_1799> getRemainingItems(class_8566 container) {
        class_2371 defaultedList = class_2371.method_10213((int)container.method_5439(), (Object)class_1799.field_8037);
        for (int i = 0; i < defaultedList.size(); ++i) {
            class_1799 stack = container.method_5438(i);
            class_1792 item = stack.method_7909();
            if (item instanceof IDamageableCraftingItem) {
                int newDamage = stack.method_7919() + 1;
                if (newDamage >= stack.method_7936()) continue;
                stack = stack.method_7972();
                stack.method_7974(newDamage);
                defaultedList.set(i, (Object)stack);
                continue;
            }
            if (!item.method_7857()) continue;
            defaultedList.set(i, (Object)new class_1799((class_1935)item.method_7858()));
        }
        return defaultedList;
    }

    public static class Serializer
    implements class_1865<DamageableItemRecipe> {
        public DamageableItemRecipe fromJson(class_2960 recipeId, JsonObject json) {
            String string = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
            class_7710 craftingBookCategory = (class_7710)class_7710.field_40252.method_47920(class_3518.method_15253((JsonObject)json, (String)"category", (String)null), (Enum)class_7710.field_40251);
            class_2371<class_1856> nonNullList = Serializer.itemsFromJson(class_3518.method_15261((JsonObject)json, (String)"ingredients"));
            if (nonNullList.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (nonNullList.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe");
            }
            class_1799 itemStack = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)json, (String)"result"));
            return new DamageableItemRecipe(recipeId, string, craftingBookCategory, itemStack, nonNullList);
        }

        private static class_2371<class_1856> itemsFromJson(JsonArray ingredientArray) {
            class_2371 nonNullList = class_2371.method_10211();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                class_1856 ingredient = class_1856.method_8102((JsonElement)ingredientArray.get(i), (boolean)false);
                if (ingredient.method_8103()) continue;
                nonNullList.add((Object)ingredient);
            }
            return nonNullList;
        }

        public DamageableItemRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
            String string = buffer.method_19772();
            class_7710 craftingBookCategory = (class_7710)buffer.method_10818(class_7710.class);
            int i = buffer.method_10816();
            class_2371 nonNullList = class_2371.method_10213((int)i, (Object)class_1856.field_9017);
            for (int j = 0; j < nonNullList.size(); ++j) {
                nonNullList.set(j, (Object)class_1856.method_8086((class_2540)buffer));
            }
            class_1799 itemStack = buffer.method_10819();
            return new DamageableItemRecipe(recipeId, string, craftingBookCategory, itemStack, (class_2371<class_1856>)nonNullList);
        }

        public void toNetwork(class_2540 buffer, DamageableItemRecipe recipe) {
            buffer.method_10814(recipe.method_8112());
            buffer.method_10817((Enum)recipe.method_45441());
            buffer.method_10804(recipe.method_8117().size());
            for (class_1856 ingredient : recipe.method_8117()) {
                ingredient.method_8088(buffer);
            }
            buffer.method_10793(recipe.method_8110(null));
        }
    }
}

