/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.registry;

import de.mrjulsen.trafficcraft.block.AsphaltBlock;
import de.mrjulsen.trafficcraft.block.AsphaltCurb;
import de.mrjulsen.trafficcraft.block.AsphaltCurbSlope;
import de.mrjulsen.trafficcraft.block.AsphaltSlope;
import de.mrjulsen.trafficcraft.block.ConcreteBarrierBlock;
import de.mrjulsen.trafficcraft.block.DelineatorBlock;
import de.mrjulsen.trafficcraft.block.FluorescentTubeLampBlock;
import de.mrjulsen.trafficcraft.block.GuardrailBlock;
import de.mrjulsen.trafficcraft.block.HouseNumberSignBlock;
import de.mrjulsen.trafficcraft.block.ManholeBlock;
import de.mrjulsen.trafficcraft.block.ManholeCoverBlock;
import de.mrjulsen.trafficcraft.block.PaintBucketBlock;
import de.mrjulsen.trafficcraft.block.PaintedAsphaltBlock;
import de.mrjulsen.trafficcraft.block.PaintedAsphaltSlope;
import de.mrjulsen.trafficcraft.block.ReflectorBlock;
import de.mrjulsen.trafficcraft.block.RoadBarrierFenceBlock;
import de.mrjulsen.trafficcraft.block.RoadSaltBlock;
import de.mrjulsen.trafficcraft.block.StreetLampBaseBlock;
import de.mrjulsen.trafficcraft.block.StreetLightBlock;
import de.mrjulsen.trafficcraft.block.StreetSignBlock;
import de.mrjulsen.trafficcraft.block.TownSignBlock;
import de.mrjulsen.trafficcraft.block.TrafficBarrelBlock;
import de.mrjulsen.trafficcraft.block.TrafficBollardBlock;
import de.mrjulsen.trafficcraft.block.TrafficConeBlock;
import de.mrjulsen.trafficcraft.block.TrafficLightBlock;
import de.mrjulsen.trafficcraft.block.TrafficLightControllerBlock;
import de.mrjulsen.trafficcraft.block.TrafficLightRequestButtonBlock;
import de.mrjulsen.trafficcraft.block.TrafficSignBlock;
import de.mrjulsen.trafficcraft.block.TrafficSignPostBlock;
import de.mrjulsen.trafficcraft.block.TrafficSignWorkbenchBlock;
import de.mrjulsen.trafficcraft.block.data.RoadType;
import de.mrjulsen.trafficcraft.item.WearableBlockItem;
import de.mrjulsen.trafficcraft.registry.ModCreativeModeTab;
import de.mrjulsen.trafficcraft.registry.ModItems;
import dev.architectury.extensions.injected.InjectedItemPropertiesExtension;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.DeferredSupplier;
import dev.architectury.registry.registries.RegistrySupplier;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2431;
import net.minecraft.class_2498;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class ModBlocks {
    public static final DeferredRegister<class_2248> BLOCKS = DeferredRegister.create((String)"trafficcraft", (class_5321)class_7924.field_41254);
    public static List<RegistrySupplier<class_2248>> COLORED_BLOCKS = new ArrayList<RegistrySupplier<class_2248>>();
    public static HashMap<String, RegistrySupplier<class_2248>> ROAD_BLOCKS = new HashMap();
    public static final RegistrySupplier<class_2248> BITUMEN_ORE = ModBlocks.registerBlock("bitumen_ore", () -> new class_2431(class_4970.class_2251.method_9637().method_31710(class_3620.field_16023).method_9632(3.0f).method_29292()), ModCreativeModeTab.MOD_TAB, false);
    public static final RegistrySupplier<class_2248> DEEPSLATE_BITUMEN_ORE = ModBlocks.registerBlock("deepslate_bitumen_ore", () -> new class_2431(class_4970.class_2251.method_9637().method_31710(class_3620.field_33532).method_9632(4.5f).method_29292().method_9626(class_2498.field_29033)), ModCreativeModeTab.MOD_TAB, false);
    public static final RegistrySupplier<class_2248> BITUMEN_BLOCK = ModBlocks.registerBlock("bitumen_block", () -> new class_2248(class_4970.class_2251.method_9637().method_31710(class_3620.field_33532).method_9632(1.5f).method_29292()), ModCreativeModeTab.MOD_TAB, false);
    public static final RegistrySupplier<class_2248> SALT = ModBlocks.registerBlock("salt", () -> new class_2431(class_4970.class_2251.method_9637().method_31710(class_3620.field_16023).method_9632(3.0f).method_9626(class_2498.field_22143).method_29292()), ModCreativeModeTab.MOD_TAB, false);
    public static final RegistrySupplier<class_2248> TRAFFIC_SIGN_WORKBENCH = ModBlocks.registerBlock("traffic_sign_workbench", () -> new TrafficSignWorkbenchBlock(), ModCreativeModeTab.MOD_TAB, false);
    public static final RegistrySupplier<class_2248> ASPHALT = ModBlocks.registerBlock("asphalt", () -> new AsphaltBlock(RoadType.ASPHALT), ModCreativeModeTab.MOD_TAB, false);
    public static final RegistrySupplier<class_2248> CONCRETE = ModBlocks.registerBlock("concrete", () -> new AsphaltBlock(RoadType.CONCRETE), ModCreativeModeTab.MOD_TAB, false);
    public static final RegistrySupplier<class_2248> ASPHALT_SLOPE = ModBlocks.registerBlock("asphalt_slope", () -> new AsphaltSlope(RoadType.ASPHALT), ModCreativeModeTab.MOD_TAB, false);
    public static final RegistrySupplier<class_2248> CONCRETE_SLOPE = ModBlocks.registerBlock("concrete_slope", () -> new AsphaltSlope(RoadType.CONCRETE), ModCreativeModeTab.MOD_TAB, false);
    public static final RegistrySupplier<class_2248> ASPHALT_CURB = ModBlocks.registerBlock("asphalt_curb", () -> new AsphaltCurb(RoadType.ASPHALT), ModCreativeModeTab.MOD_TAB, false);
    public static final RegistrySupplier<class_2248> CONCRETE_CURB = ModBlocks.registerBlock("concrete_curb", () -> new AsphaltCurb(RoadType.CONCRETE), ModCreativeModeTab.MOD_TAB, false);
    public static final RegistrySupplier<class_2248> ASPHALT_CURB_SLOPE = ModBlocks.registerBlock("asphalt_curb_slope", () -> new AsphaltCurbSlope(RoadType.ASPHALT), ModCreativeModeTab.MOD_TAB, false);
    public static final RegistrySupplier<class_2248> CONCRETE_CURB_SLOPE = ModBlocks.registerBlock("concrete_curb_slope", () -> new AsphaltCurbSlope(RoadType.CONCRETE), ModCreativeModeTab.MOD_TAB, false);
    public static final RegistrySupplier<class_2248> ROAD_SALT = ModBlocks.registerBlock("road_salt", () -> new RoadSaltBlock(), ModCreativeModeTab.MOD_TAB, false);
    public static final RegistrySupplier<class_2248> CONCRETE_BARRIER = ModBlocks.registerColoredBlock("concrete_barrier", () -> new ConcreteBarrierBlock(), ModCreativeModeTab.MOD_TAB, false);
    public static final RegistrySupplier<class_2248> MANHOLE;
    public static final RegistrySupplier<class_2248> MANHOLE_COVER;
    public static final RegistrySupplier<class_2248> ROAD_GULLY;
    public static final RegistrySupplier<class_2248> TRAFFIC_SIGN_POST;
    public static final RegistrySupplier<class_2248> TRAFFIC_SIGN;
    public static final RegistrySupplier<class_2248> TOWN_SIGN;
    public static final RegistrySupplier<class_2248> STREET_SIGN;
    public static final RegistrySupplier<class_2248> HOUSE_NUMBER_SIGN;
    public static final RegistrySupplier<class_2248> TRAFFIC_LIGHT;
    public static final RegistrySupplier<class_2248> TRAFFIC_LIGHT_CONTROLLER;
    public static final RegistrySupplier<class_2248> TRAFFIC_LIGHT_REQUEST_BUTTON;
    public static final RegistrySupplier<class_2248> STREET_LAMP;
    public static final RegistrySupplier<class_2248> DOUBLE_STREET_LAMP;
    public static final RegistrySupplier<class_2248> SMALL_STREET_LAMP;
    public static final RegistrySupplier<class_2248> SMALL_DOUBLE_STREET_LAMP;
    public static final RegistrySupplier<class_2248> STREET_LIGHT;
    public static final RegistrySupplier<class_2248> FLUORESCENT_TUBE_LAMP;
    public static final RegistrySupplier<class_2248> WHITE_DELINEATOR;
    public static final RegistrySupplier<class_2248> YELLOW_DELINEATOR;
    public static final RegistrySupplier<class_2248> RED_DELINEATOR;
    public static final RegistrySupplier<class_2248> SMALL_WHITE_DELINEATOR;
    public static final RegistrySupplier<class_2248> SMALL_YELLOW_DELINEATOR;
    public static final RegistrySupplier<class_2248> GUARDRAIL;
    public static final RegistrySupplier<class_2248> PAINT_BUCKET;
    public static final RegistrySupplier<class_2248> TRAFFIC_CONE;
    public static final RegistrySupplier<class_2248> TRAFFIC_BOLLARD;
    public static final RegistrySupplier<class_2248> TRAFFIC_BARREL;
    public static final RegistrySupplier<class_2248> ROAD_BARRIER_FENCE;
    public static final RegistrySupplier<class_2248> REFLECTOR;

    private static <T extends class_2248> RegistrySupplier<T> registerBlockWithoutItem(String name, Supplier<T> block) {
        RegistrySupplier toReturn = BLOCKS.register(name, block);
        return toReturn;
    }

    private static <T extends class_2248> RegistrySupplier<class_2248> registerColoredBlockWithoutItem(String name, Supplier<class_2248> block) {
        RegistrySupplier<class_2248> toReturn = ModBlocks.registerBlockWithoutItem(name, block);
        COLORED_BLOCKS.add(toReturn);
        return toReturn;
    }

    private static <T extends class_2248> RegistrySupplier<class_2248> registerColoredBlock(String name, Supplier<class_2248> block, RegistrySupplier<class_1761> tab, boolean wearable) {
        RegistrySupplier<class_2248> toReturn = ModBlocks.registerBlock(name, block, tab, wearable);
        COLORED_BLOCKS.add(toReturn);
        return toReturn;
    }

    private static <T extends class_2248> RegistrySupplier<T> registerBlock(String name, Supplier<T> block, RegistrySupplier<class_1761> tab, boolean wearable) {
        RegistrySupplier toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn, tab, wearable);
        return toReturn;
    }

    private static <T extends class_2248, I extends class_1747> RegistrySupplier<T> registerBlock(String name, Supplier<T> block, RegistrySupplier<class_1761> tab, Class<I> blockItemClass) {
        RegistrySupplier toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn, tab, blockItemClass);
        return toReturn;
    }

    private static <T extends class_2248> RegistrySupplier<T> registerBlockWithCustomItemId(String name, String itemId, Supplier<T> block, RegistrySupplier<class_1761> tab, boolean wearable) {
        RegistrySupplier toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(itemId, toReturn, tab, wearable);
        return toReturn;
    }

    private static <T extends class_2248> RegistrySupplier<class_1792> registerBlockItem(String name, RegistrySupplier<T> block, RegistrySupplier<class_1761> tab, boolean wearable) {
        if (wearable) {
            return ModItems.ITEMS.register(name, () -> new WearableBlockItem((class_2248)block.get(), ((InjectedItemPropertiesExtension)new class_1792.class_1793()).arch$tab((DeferredSupplier)tab)));
        }
        return ModItems.ITEMS.register(name, () -> new class_1747((class_2248)block.get(), ((InjectedItemPropertiesExtension)new class_1792.class_1793()).arch$tab((DeferredSupplier)tab)));
    }

    private static <T extends class_2248, I extends class_1747> RegistrySupplier<class_1792> registerBlockItem(String name, RegistrySupplier<T> block, RegistrySupplier<class_1761> tab, Class<I> blockItemClass) {
        return ModItems.ITEMS.register(name, () -> {
            try {
                return (class_1792)blockItemClass.getDeclaredConstructor(class_2248.class, class_1792.class_1793.class).newInstance(block.get(), ((InjectedItemPropertiesExtension)new class_1792.class_1793()).arch$tab((DeferredSupplier)tab));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
                return new class_1747((class_2248)block.get(), ((InjectedItemPropertiesExtension)new class_1792.class_1793()).arch$tab((DeferredSupplier)tab));
            }
        });
    }

    public static void register() {
        BLOCKS.register();
    }

    static {
        for (RoadType s : RoadType.values()) {
            if (s == RoadType.NONE) continue;
            for (int i = 0; i < 323; ++i) {
                String id = s.getRoadType() + "_pattern_" + i;
                RegistrySupplier<class_2248> block = ModBlocks.registerColoredBlockWithoutItem(id, () -> new PaintedAsphaltBlock(s, s == RoadType.ASPHALT ? (class_2248)ASPHALT.get() : (class_2248)CONCRETE.get()));
                ROAD_BLOCKS.put(id, block);
                String id2 = s.getRoadType() + "_slope_pattern_" + i;
                RegistrySupplier<class_2248> block2 = ModBlocks.registerColoredBlockWithoutItem(id2, () -> new PaintedAsphaltSlope(s, s == RoadType.ASPHALT ? (class_2248)ASPHALT_SLOPE.get() : (class_2248)CONCRETE_SLOPE.get()));
                ROAD_BLOCKS.put(id2, block2);
            }
        }
        MANHOLE = ModBlocks.registerBlock("manhole", () -> new ManholeBlock(), ModCreativeModeTab.MOD_TAB, false);
        MANHOLE_COVER = ModBlocks.registerBlock("manhole_cover", () -> new ManholeCoverBlock(), ModCreativeModeTab.MOD_TAB, false);
        ROAD_GULLY = ModBlocks.registerBlock("road_gully", () -> new ManholeCoverBlock(), ModCreativeModeTab.MOD_TAB, false);
        TRAFFIC_SIGN_POST = ModBlocks.registerBlock("traffic_sign_post", () -> new TrafficSignPostBlock(), ModCreativeModeTab.MOD_TAB, false);
        TRAFFIC_SIGN = ModBlocks.registerBlock("traffic_sign", () -> new TrafficSignBlock(), ModCreativeModeTab.MOD_TAB, false);
        TOWN_SIGN = ModBlocks.registerBlock("town_sign", () -> new TownSignBlock(), ModCreativeModeTab.MOD_TAB, false);
        STREET_SIGN = ModBlocks.registerColoredBlock("street_sign", () -> new StreetSignBlock(), ModCreativeModeTab.MOD_TAB, false);
        HOUSE_NUMBER_SIGN = ModBlocks.registerColoredBlock("house_number_sign", () -> new HouseNumberSignBlock(), ModCreativeModeTab.MOD_TAB, false);
        TRAFFIC_LIGHT = ModBlocks.registerColoredBlock("traffic_light", () -> new TrafficLightBlock(), ModCreativeModeTab.MOD_TAB, false);
        TRAFFIC_LIGHT_CONTROLLER = ModBlocks.registerBlock("traffic_light_controller", () -> new TrafficLightControllerBlock(), ModCreativeModeTab.MOD_TAB, false);
        TRAFFIC_LIGHT_REQUEST_BUTTON = ModBlocks.registerBlock("traffic_light_request_button", () -> new TrafficLightRequestButtonBlock(), ModCreativeModeTab.MOD_TAB, false);
        STREET_LAMP = ModBlocks.registerBlock("street_lamp", () -> new StreetLampBaseBlock(StreetLampBaseBlock.LampType.NORMAL), ModCreativeModeTab.MOD_TAB, true);
        DOUBLE_STREET_LAMP = ModBlocks.registerBlock("double_street_lamp", () -> new StreetLampBaseBlock(StreetLampBaseBlock.LampType.DOUBLE), ModCreativeModeTab.MOD_TAB, true);
        SMALL_STREET_LAMP = ModBlocks.registerBlock("small_street_lamp", () -> new StreetLampBaseBlock(StreetLampBaseBlock.LampType.SMALL), ModCreativeModeTab.MOD_TAB, true);
        SMALL_DOUBLE_STREET_LAMP = ModBlocks.registerBlock("small_double_street_lamp", () -> new StreetLampBaseBlock(StreetLampBaseBlock.LampType.SMALL_DOUBLE), ModCreativeModeTab.MOD_TAB, true);
        STREET_LIGHT = ModBlocks.registerBlock("street_light", () -> new StreetLightBlock(), ModCreativeModeTab.MOD_TAB, false);
        FLUORESCENT_TUBE_LAMP = ModBlocks.registerBlock("fluorescent_tube_lamp", () -> new FluorescentTubeLampBlock(), ModCreativeModeTab.MOD_TAB, false);
        WHITE_DELINEATOR = ModBlocks.registerBlock("white_delineator", () -> new DelineatorBlock(false), ModCreativeModeTab.MOD_TAB, false);
        YELLOW_DELINEATOR = ModBlocks.registerBlock("yellow_delineator", () -> new DelineatorBlock(false), ModCreativeModeTab.MOD_TAB, false);
        RED_DELINEATOR = ModBlocks.registerBlock("red_delineator", () -> new DelineatorBlock(false), ModCreativeModeTab.MOD_TAB, false);
        SMALL_WHITE_DELINEATOR = ModBlocks.registerBlock("small_white_delineator", () -> new DelineatorBlock(true), ModCreativeModeTab.MOD_TAB, false);
        SMALL_YELLOW_DELINEATOR = ModBlocks.registerBlock("small_yellow_delineator", () -> new DelineatorBlock(true), ModCreativeModeTab.MOD_TAB, false);
        GUARDRAIL = ModBlocks.registerColoredBlock("guardrail", () -> new GuardrailBlock(), ModCreativeModeTab.MOD_TAB, false);
        PAINT_BUCKET = ModBlocks.registerColoredBlock("paint_bucket", () -> new PaintBucketBlock(), ModCreativeModeTab.MOD_TAB, true);
        TRAFFIC_CONE = ModBlocks.registerColoredBlock("traffic_cone", () -> new TrafficConeBlock(), ModCreativeModeTab.MOD_TAB, true);
        TRAFFIC_BOLLARD = ModBlocks.registerColoredBlock("traffic_bollard", () -> new TrafficBollardBlock(), ModCreativeModeTab.MOD_TAB, true);
        TRAFFIC_BARREL = ModBlocks.registerColoredBlock("traffic_barrel", () -> new TrafficBarrelBlock(), ModCreativeModeTab.MOD_TAB, true);
        ROAD_BARRIER_FENCE = ModBlocks.registerColoredBlock("road_barrier_fence", () -> new RoadBarrierFenceBlock(), ModCreativeModeTab.MOD_TAB, false);
        REFLECTOR = ModBlocks.registerColoredBlock("reflector", () -> new ReflectorBlock(), ModCreativeModeTab.MOD_TAB, false);
    }
}

