/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout.editor.actions;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.action.ActionInstance;
import de.keksuccino.fancymenu.customization.action.ActionRegistry;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextListScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.ExtendedEditBox;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildActionScreen
extends class_437 {
    protected final ActionInstance instance;
    protected Consumer<ActionInstance> callback;
    protected Action originalAction = null;
    protected String originalActionValue = null;
    protected ScrollArea actionsListScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ScrollArea actionDescriptionScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ExtendedEditBox searchBar;

    public BuildActionScreen(@Nullable ActionInstance instanceToEdit, @NotNull Consumer<ActionInstance> callback) {
        super((class_2561)(instanceToEdit != null ? class_2561.method_43471((String)"fancymenu.editor.action.screens.edit_action") : class_2561.method_43471((String)"fancymenu.editor.action.screens.add_action")));
        if (instanceToEdit != null) {
            this.originalAction = instanceToEdit.action;
            this.originalActionValue = instanceToEdit.value;
        }
        this.instance = instanceToEdit != null ? instanceToEdit : new ActionInstance(Action.EMPTY, null);
        this.callback = callback;
    }

    protected void method_25426() {
        String oldSearchValue = this.searchBar != null ? this.searchBar.method_1882() : "";
        this.searchBar = new ExtendedEditBox(class_310.method_1551().field_1772, 21, 66, this.field_22789 / 2 - 40 - 2, 18, (class_2561)class_2561.method_43473()){

            @Override
            public void method_48579(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
                super.method_48579(graphics, mouseX, mouseY, partial);
                if (this.method_1882().isBlank() && !this.method_25370()) {
                    class_5250 class_52502 = class_2561.method_43471((String)"fancymenu.actions.build_action.screen.search_action");
                    int n = this.method_46426() + 4;
                    int n2 = this.method_46427() + this.method_25364() / 2;
                    Objects.requireNonNull(this.font);
                    graphics.method_51439(this.font, (class_2561)class_52502, n, n2 - 9 / 2, UIBase.getUIColorTheme().edit_box_text_color_uneditable.getColorInt(), false);
                }
            }
        };
        this.searchBar.method_1852(oldSearchValue);
        this.searchBar.method_1863(s -> this.updateActionsList());
        this.method_37063((class_364)this.searchBar);
        UIBase.applyDefaultWidgetSkinTo(this.searchBar);
        this.actionsListScrollArea.setWidth(this.field_22789 / 2 - 40, true);
        this.actionsListScrollArea.setHeight(this.field_22790 - 85 - 25, true);
        this.actionsListScrollArea.setX(20, true);
        this.actionsListScrollArea.setY(90, true);
        this.actionDescriptionScrollArea.setWidth(this.field_22789 / 2 - 40, true);
        this.actionDescriptionScrollArea.setHeight(Math.max(40, this.field_22790 / 2 - 50 - 25), true);
        this.actionDescriptionScrollArea.setX(this.field_22789 - 20 - this.actionDescriptionScrollArea.getWidthWithBorder(), true);
        this.actionDescriptionScrollArea.setY(65, true);
        int editValueButtonX = this.field_22789 - 20 - 150;
        int editValueButtonY = this.field_22790 - 20 - 20 - 5 - 20 - 15 - 20;
        int cancelButtonX = this.field_22789 - 20 - 150;
        int cancelButtonY = this.field_22790 - 20 - 20 - 5 - 20;
        int doneButtonX = this.field_22789 - 20 - 150;
        int doneButtonY = this.field_22790 - 20 - 20;
        ExtendedButton editValueButton = new ExtendedButton(editValueButtonX, editValueButtonY, 150, 20, (class_2561)class_2561.method_43471((String)"fancymenu.editor.action.screens.build_screen.edit_value"), button -> {
            if (this.instance.action == Action.EMPTY) {
                return;
            }
            this.originalAction = null;
            this.originalActionValue = null;
            this.instance.action.editValue(this, this.instance);
        }).setIsActiveSupplier(consumes -> this.instance.action != Action.EMPTY && this.instance.action.hasValue()).setTooltipSupplier(consumes -> {
            if (this.instance.action != Action.EMPTY && !this.instance.action.hasValue()) {
                return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.editor.action.screens.build_screen.edit_value.desc.no_value", new String[0]));
            }
            return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.editor.action.screens.build_screen.edit_value.desc.normal", new String[0]));
        });
        this.method_37063((class_364)editValueButton);
        UIBase.applyDefaultWidgetSkinTo(editValueButton);
        ExtendedButton doneButton = new ExtendedButton(doneButtonX, doneButtonY, 150, 20, (class_2561)class_2561.method_43471((String)"fancymenu.guicomponents.done"), button -> this.callback.accept(this.instance.action != Action.EMPTY ? this.instance : null)).setIsActiveSupplier(consumes -> {
            if (this.instance.action == Action.EMPTY) {
                return false;
            }
            return this.instance.value != null || !this.instance.action.hasValue();
        }).setTooltipSupplier(consumes -> {
            if (this.instance.action == Action.EMPTY) {
                return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.editor.action.screens.finish.no_action_selected", new String[0]));
            }
            if (this.instance.value == null && this.instance.action.hasValue()) {
                return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.editor.action.screens.build_screen.finish.no_value_set", new String[0]));
            }
            return null;
        });
        this.method_37063((class_364)doneButton);
        UIBase.applyDefaultWidgetSkinTo(doneButton);
        ExtendedButton cancelButton = new ExtendedButton(cancelButtonX, cancelButtonY, 150, 20, (class_2561)class_2561.method_43471((String)"fancymenu.guicomponents.cancel"), button -> this.callback.accept(null));
        this.method_37063((class_364)cancelButton);
        UIBase.applyDefaultWidgetSkinTo(cancelButton);
        this.updateActionsList();
        this.setDescription(this.instance.action);
    }

    public void method_25419() {
        this.callback.accept(null);
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        graphics.method_25294(0, 0, this.field_22789, this.field_22790, UIBase.getUIColorTheme().screen_background_color.getColorInt());
        class_5250 titleComp = this.field_22785.method_27661().method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
        graphics.method_51439(this.field_22793, (class_2561)titleComp, 20, 20, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        graphics.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"fancymenu.editor.action.screens.build_screen.available_actions"), 20, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        class_5250 descLabel = class_2561.method_43471((String)"fancymenu.editor.action.screens.build_screen.action_description");
        int descLabelWidth = this.field_22793.method_27525((class_5348)descLabel);
        graphics.method_51439(this.field_22793, (class_2561)descLabel, this.field_22789 - 20 - descLabelWidth, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        this.actionsListScrollArea.render(graphics, mouseX, mouseY, partial);
        this.actionDescriptionScrollArea.render(graphics, mouseX, mouseY, partial);
        super.method_25394(graphics, mouseX, mouseY, partial);
    }

    protected void setDescription(@Nullable Action action) {
        this.actionDescriptionScrollArea.clearEntries();
        if (action != null && action.getActionDescription() != null) {
            for (class_2561 c : action.getActionDescription()) {
                TextScrollAreaEntry e = new TextScrollAreaEntry(this.actionDescriptionScrollArea, c, entry -> {});
                e.setSelectable(false);
                e.setBackgroundColorHover(e.getBackgroundColorIdle());
                e.setPlayClickSound(false);
                this.actionDescriptionScrollArea.addEntry(e);
            }
        }
    }

    protected boolean actionFitsSearchValue(@NotNull Action action, @Nullable String s) {
        if (s == null || s.isBlank()) {
            return true;
        }
        s = s.toLowerCase();
        if (action.getActionDisplayName().getString().toLowerCase().contains(s)) {
            return true;
        }
        return this.actionDescriptionContains(action, s);
    }

    protected boolean actionDescriptionContains(@NotNull Action action, @NotNull String s) {
        class_2561[] desc;
        for (class_2561 c : desc = Objects.requireNonNullElse(action.getActionDescription(), new class_2561[0])) {
            if (!c.getString().toLowerCase().contains(s)) continue;
            return true;
        }
        return false;
    }

    protected void setContentOfActionsList() {
        String searchValue;
        String string = searchValue = this.searchBar != null ? this.searchBar.method_1882() : "";
        if (searchValue.isBlank()) {
            searchValue = null;
        }
        this.actionsListScrollArea.clearEntries();
        for (Action action : ActionRegistry.getActions()) {
            if (LayoutEditorScreen.getCurrentInstance() != null && !action.shouldShowUpInEditorActionMenu(LayoutEditorScreen.getCurrentInstance()) || !this.actionFitsSearchValue(action, searchValue)) continue;
            ActionScrollEntry e = new ActionScrollEntry(this.actionsListScrollArea, action, entry -> {
                this.instance.action = action;
                this.instance.value = this.originalAction == action ? this.originalActionValue : null;
                this.setDescription(action);
            });
            this.actionsListScrollArea.addEntry(e);
        }
    }

    protected void updateActionsList() {
        this.setContentOfActionsList();
        if (this.instance.action != Action.EMPTY) {
            for (ScrollAreaEntry e : this.actionsListScrollArea.getEntries()) {
                if (!(e instanceof ActionScrollEntry) || ((ActionScrollEntry)e).action != this.instance.action) continue;
                e.setSelected(true);
                break;
            }
        }
    }

    public static class ActionScrollEntry
    extends TextListScrollAreaEntry {
        public Action action;

        public ActionScrollEntry(ScrollArea parent, @NotNull Action action, @NotNull Consumer<TextListScrollAreaEntry> onClick) {
            super(parent, ActionScrollEntry.buildLabel(action), UIBase.getUIColorTheme().listing_dot_color_1.getColor(), onClick);
            this.action = action;
        }

        @NotNull
        private static class_2561 buildLabel(@NotNull Action action) {
            class_5250 c = action.getActionDisplayName().method_27661().method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().description_area_text_color.getColorInt()));
            if (action.isDeprecated()) {
                c = c.method_27696(class_2583.field_24360.method_36140(Boolean.valueOf(true)));
                c = c.method_10852((class_2561)class_2561.method_43470((String)" ").method_10862(class_2583.field_24360.method_36140(Boolean.valueOf(false))));
                c = c.method_10852((class_2561)class_2561.method_43471((String)"fancymenu.editor.actions.deprecated").method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().error_text_color.getColorInt()).method_36140(Boolean.valueOf(false))));
            }
            return c;
        }
    }
}

