/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout.editor.buddy.gui;

import de.keksuccino.fancymenu.customization.layout.editor.buddy.TamagotchiBuddy;
import de.keksuccino.fancymenu.customization.layout.editor.buddy.gui.BuddyGuiButton;
import de.keksuccino.fancymenu.customization.layout.editor.buddy.items.FoodItem;
import de.keksuccino.fancymenu.customization.layout.editor.buddy.items.PlayBall;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.konkrete.input.MouseInput;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuddyGui {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int GUI_WIDTH = 200;
    private static final int GUI_HEIGHT = 200;
    private static final int STATUS_BAR_WIDTH = 150;
    private static final int STATUS_BAR_HEIGHT = 10;
    private static final class_2960 GUI_TEXTURE = new class_2960("fancymenu", "textures/buddy/buddy_gui.png");
    private static final int BORDER_SIZE = 7;
    private final TamagotchiBuddy buddy;
    private boolean isVisible = false;
    private int guiX;
    private int guiY;
    private final List<BuddyGuiButton> buttons = new ArrayList<BuddyGuiButton>();

    public BuddyGui(TamagotchiBuddy buddy) {
        this.buddy = buddy;
        this.initButtons();
    }

    private void initButtons() {
        this.buttons.clear();
        this.buttons.add(new BuddyGuiButton(this.buddy, buddy -> "Feed", () -> {
            int mouseX = MouseInput.getMouseX();
            int mouseY = MouseInput.getMouseY();
            LOGGER.info("Creating food at screen coordinates: ({}, {})", (Object)mouseX, (Object)mouseY);
            FoodItem food = new FoodItem(mouseX, mouseY, this.buddy);
            this.buddy.setDroppedFood(food);
            food.stickToCursor = true;
            this.hide();
        }, () -> this.buddy.getDroppedFood() == null && !this.buddy.isSleeping && !this.buddy.isPlaying && !this.buddy.isEating && !this.buddy.isPooping));
        this.buttons.add(new BuddyGuiButton(this.buddy, buddy -> "Play", () -> {
            int mouseX = MouseInput.getMouseX();
            int mouseY = MouseInput.getMouseY();
            LOGGER.info("Creating play ball at screen coordinates: ({}, {})", (Object)mouseX, (Object)mouseY);
            PlayBall ball = new PlayBall(mouseX, mouseY, this.buddy);
            this.buddy.setPlayBall(ball);
            this.buddy.setChasingBall(true);
            ball.stickToCursor = true;
            this.hide();
        }, () -> !this.buddy.isSleeping && this.buddy.getEnergy() > 20.0f && this.buddy.getPlayBall() == null && !this.buddy.isEating && !this.buddy.isPooping));
        LOGGER.info("Initialized " + this.buttons.size() + " GUI buttons");
    }

    public void show(int screenWidth, int screenHeight) {
        this.isVisible = true;
        this.guiX = (screenWidth - 200) / 2;
        this.guiY = (screenHeight - 200) / 2;
        this.updateButtonPositions();
        LOGGER.info("Showing buddy GUI at ({}, {})", (Object)this.guiX, (Object)this.guiY);
    }

    public void hide() {
        this.isVisible = false;
        LOGGER.info("Hiding buddy GUI");
    }

    private void updateButtonPositions() {
        class_327 font = class_310.method_1551().field_1772;
        Objects.requireNonNull(font);
        int labelHeight = 9;
        int barHeight = 10;
        int verticalGap = 4;
        int totalItemHeight = labelHeight + barHeight + verticalGap;
        int statusBarsEndY = this.guiY + 40 + totalItemHeight * 4;
        int buttonsY = statusBarsEndY + 15;
        int buttonSpacing = 10;
        int totalButtonsWidth = this.buttons.size() * 80 + (this.buttons.size() - 1) * buttonSpacing;
        int startX = this.guiX + (200 - totalButtonsWidth) / 2;
        for (int i = 0; i < this.buttons.size(); ++i) {
            BuddyGuiButton button = this.buttons.get(i);
            int buttonX = startX + i * (80 + buttonSpacing);
            button.setPosition(buttonX, buttonsY);
            button.updateActiveState();
        }
    }

    public void render(class_332 graphics, int mouseX, int mouseY) {
        if (!this.isVisible) {
            return;
        }
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, 400.0f);
        RenderingUtils.blitNineSlicedTexture(graphics, GUI_TEXTURE, this.guiX, this.guiY, 200, 200, 256, 256, 7, 7, 7, 7);
        String title = "Buddy Status";
        class_327 font = class_310.method_1551().field_1772;
        int titleX = this.guiX + (200 - font.method_1727(title)) / 2;
        int titleY = this.guiY + 20;
        graphics.method_25303(font, title, titleX, titleY, -1);
        this.renderStatusBars(graphics);
        for (BuddyGuiButton button : this.buttons) {
            button.updateActiveState();
            button.render(graphics, mouseX, mouseY);
        }
        graphics.method_51448().method_22909();
    }

    private void renderStatusBars(class_332 graphics) {
        int barX = this.guiX + 25;
        int startY = this.guiY + 40;
        class_327 font = class_310.method_1551().field_1772;
        Objects.requireNonNull(font);
        int labelHeight = 9;
        int barHeight = 10;
        int verticalGap = 4;
        int totalItemHeight = labelHeight + barHeight + verticalGap;
        for (int i = 0; i < 4; ++i) {
            String label;
            int currentY = startY + totalItemHeight * i;
            graphics.method_25303(font, label, barX, currentY, switch (i) {
                case 0 -> {
                    label = "Hunger";
                    yield -44976;
                }
                case 1 -> {
                    label = "Happiness";
                    yield -11468976;
                }
                case 2 -> {
                    label = "Energy";
                    yield -11513601;
                }
                case 3 -> {
                    label = "Fun";
                    yield -3649281;
                }
                default -> {
                    label = "";
                    yield -1;
                }
            });
            int barY = currentY + labelHeight + 2;
            float fillAmount = 0.0f;
            DrawableColor barColor = switch (i) {
                case 0 -> {
                    fillAmount = this.buddy.getHunger() / 100.0f;
                    yield DrawableColor.of(255, 80, 80);
                }
                case 1 -> {
                    fillAmount = this.buddy.getHappiness() / 100.0f;
                    yield DrawableColor.of(80, 255, 80);
                }
                case 2 -> {
                    fillAmount = this.buddy.getEnergy() / 100.0f;
                    yield DrawableColor.of(80, 80, 255);
                }
                case 3 -> {
                    fillAmount = this.buddy.getFunLevel() / 100.0f;
                    yield DrawableColor.of(200, 80, 255);
                }
                default -> {
                    fillAmount = 0.0f;
                    yield DrawableColor.of(255, 255, 255);
                }
            };
            graphics.method_25294(barX, barY, barX + 150, barY + barHeight, Integer.MIN_VALUE);
            int fillWidth = Math.max(1, (int)(150.0f * fillAmount));
            if (fillWidth <= 0) continue;
            graphics.method_25294(barX, barY, barX + fillWidth, barY + barHeight, barColor.getColorInt());
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isVisible) {
            return false;
        }
        if (mouseX >= (double)this.guiX && mouseX < (double)(this.guiX + 200) && mouseY >= (double)this.guiY && mouseY < (double)(this.guiY + 200)) {
            for (BuddyGuiButton buddyGuiButton : this.buttons) {
                buddyGuiButton.updateActiveState();
                if (!buddyGuiButton.isActive() || !buddyGuiButton.isMouseOver(mouseX, mouseY)) continue;
                buddyGuiButton.onClick();
                return true;
            }
            return true;
        }
        this.hide();
        return true;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void addButton(@NotNull TamagotchiBuddy buddy, @NotNull BuddyGuiButton.ButtonNameSupplier nameSupplier, @NotNull Runnable action, @Nullable BooleanSupplier activeCondition) {
        this.buttons.add(new BuddyGuiButton(buddy, nameSupplier, action, activeCondition));
        this.updateButtonPositions();
    }
}

