/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.mcef;

import com.cinemamod.mcef.MCEF;
import com.cinemamod.mcef.MCEFBrowser;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.util.mcef.BrowserHandler;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.widget.NavigatableWidget;
import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3419;
import net.minecraft.class_6382;
import net.minecraft.class_757;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.jetbrains.annotations.NotNull;

public class WrappedMCEFBrowser
extends class_339
implements Closeable,
NavigatableWidget {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final MCEFBrowser browser;
    protected final class_310 minecraft = class_310.method_1551();
    protected boolean browserFocused = false;
    protected boolean interactable = true;
    protected float opacity = 1.0f;
    protected boolean autoHandle = true;
    protected volatile float volume = 1.0f;
    protected volatile boolean fullscreenAllVideos = false;
    protected volatile boolean autoPlayAllVideosOnLoad = true;
    protected volatile boolean muteAllMediaOnLoad = false;
    protected volatile boolean loopAllVideos = false;
    protected volatile boolean hideVideoControls = false;
    protected UUID genericIdentifier = UUID.randomUUID();
    protected int lastWidth = -1;
    protected int lastHeight = -1;

    @NotNull
    public static WrappedMCEFBrowser build(@NotNull String url, boolean transparent, boolean autoHandle) {
        WrappedMCEFBrowser b = new WrappedMCEFBrowser(url, transparent);
        b.autoHandle = autoHandle;
        return b;
    }

    @NotNull
    public static WrappedMCEFBrowser build(@NotNull String url, boolean transparent, boolean autoHandle, int x, int y, int width, int height) {
        WrappedMCEFBrowser b = WrappedMCEFBrowser.build(url, transparent, autoHandle);
        b.setSize(width, height);
        b.method_48229(x, y);
        return b;
    }

    protected WrappedMCEFBrowser(@NotNull String url, boolean transparent) {
        super(0, 0, 0, 0, (class_2561)class_2561.method_43473());
        this.browser = MCEF.createBrowser((String)url, (boolean)transparent);
        this.setVolume(this.volume);
        this.setSize(200, 200);
        this.method_48229(0, 0);
        MCEF.getClient().addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(){

            public void onLoadEnd(CefBrowser browser, CefFrame frame, int httpStatusCode) {
                WrappedMCEFBrowser.this.setVolume(WrappedMCEFBrowser.this.volume);
                WrappedMCEFBrowser.this.setFullscreenAllVideos(WrappedMCEFBrowser.this.fullscreenAllVideos);
                WrappedMCEFBrowser.this.setAutoPlayAllVideosOnLoad(WrappedMCEFBrowser.this.autoPlayAllVideosOnLoad);
                WrappedMCEFBrowser.this.setMuteAllMediaOnLoad(WrappedMCEFBrowser.this.muteAllMediaOnLoad);
                WrappedMCEFBrowser.this.setLoopAllVideos(WrappedMCEFBrowser.this.loopAllVideos);
                WrappedMCEFBrowser.this.setHideVideoControls(WrappedMCEFBrowser.this.hideVideoControls);
                super.onLoadEnd(browser, frame, httpStatusCode);
            }
        });
    }

    protected void method_48579(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (this.field_22758 != this.lastWidth || this.field_22759 != this.lastHeight) {
            this.setSize(this.field_22758, this.field_22759);
        }
        this.lastWidth = this.field_22758;
        this.lastHeight = this.field_22759;
        try {
            if (this.autoHandle) {
                BrowserHandler.notifyHandler(this.genericIdentifier.toString(), this);
            }
            RenderSystem.disableDepthTest();
            RenderSystem.setShader(class_757::method_34543);
            RenderSystem.setShaderTexture((int)0, (int)this.browser.getRenderer().getTextureID());
            class_289 t = class_289.method_1348();
            class_287 buffer = t.method_1349();
            buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
            int alpha = (int)(this.opacity * 255.0f);
            buffer.method_22912((double)this.method_46426(), (double)(this.method_46427() + this.method_25364()), 0.0).method_22913(0.0f, 1.0f).method_1336(255, 255, 255, alpha);
            buffer.method_22912((double)(this.method_46426() + this.method_25368()), (double)(this.method_46427() + this.method_25364()), 0.0).method_22913(1.0f, 1.0f).method_1336(255, 255, 255, alpha);
            buffer.method_22912((double)(this.method_46426() + this.method_25368()), (double)this.method_46427(), 0.0).method_22913(1.0f, 0.0f).method_1336(255, 255, 255, alpha);
            buffer.method_22912((double)this.method_46426(), (double)this.method_46427(), 0.0).method_22913(0.0f, 0.0f).method_1336(255, 255, 255, alpha);
            class_286.method_43433((class_287.class_7433)Objects.requireNonNull(buffer.method_1326()));
            RenderSystem.setShaderTexture((int)0, (int)0);
            RenderSystem.enableDepthTest();
            graphics.method_51452();
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to render MCEFBrowser!", (Throwable)ex);
        }
    }

    public void onVolumeUpdated(@NotNull class_3419 soundSource, float newVolume) {
        this.setVolume(this.volume);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_25405(mouseX, mouseY) && this.interactable) {
            this.browserFocused = true;
            this.browser.sendMousePress(this.convertMouseX(mouseX), this.convertMouseY(mouseY), button);
            this.browser.setFocus(true);
            return true;
        }
        this.browserFocused = false;
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.interactable) {
            this.browser.sendMouseRelease(this.convertMouseX(mouseX), this.convertMouseY(mouseY), button);
            this.browser.setFocus(true);
        }
        return false;
    }

    public void method_16014(double mouseX, double mouseY) {
        if (!this.interactable) {
            return;
        }
        this.browser.sendMouseMove(this.convertMouseX(mouseX), this.convertMouseY(mouseY));
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollY) {
        if (this.method_25405(mouseX, mouseY) && this.interactable) {
            this.browser.sendMouseWheel(this.convertMouseX(mouseX), this.convertMouseY(mouseY), scrollY, 0);
            this.browser.setFocus(true);
            return true;
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.interactable && this.browserFocused) {
            this.browser.sendKeyPress(keyCode, (long)scanCode, modifiers);
            this.browser.setFocus(true);
            return true;
        }
        return false;
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (this.interactable && this.browserFocused) {
            this.browser.sendKeyRelease(keyCode, (long)scanCode, modifiers);
            this.browser.setFocus(true);
            return true;
        }
        return false;
    }

    public boolean method_25400(char codePoint, int modifiers) {
        if (this.interactable && this.browserFocused) {
            if (codePoint == '\u0000') {
                return true;
            }
            this.browser.sendKeyTyped(codePoint, modifiers);
            this.browser.setFocus(true);
            return true;
        }
        return false;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return UIBase.isXYInArea(mouseX, mouseY, (double)this.method_46426(), (double)this.method_46427(), (double)this.method_25368(), (double)this.method_25364());
    }

    protected void method_47399(@NotNull class_6382 narrationElementOutput) {
    }

    public void setSize(int width, int height) {
        this.browser.resize(this.convertWidth(width), this.convertHeight(height));
    }

    protected int convertMouseX(double mouseX) {
        return (int)((mouseX - (double)this.method_46426()) * this.minecraft.method_22683().method_4495());
    }

    protected int convertMouseY(double mouseY) {
        return (int)((mouseY - (double)this.method_46427()) * this.minecraft.method_22683().method_4495());
    }

    protected int convertWidth(double width) {
        return (int)(width * this.minecraft.method_22683().method_4495());
    }

    protected int convertHeight(double height) {
        return (int)(height * this.minecraft.method_22683().method_4495());
    }

    public void setVolume(float volume) {
        this.volume = volume;
        String code = "document.querySelectorAll('audio, video').forEach(el => el.volume = " + this.getActualVolume() + ");";
        this.browser.executeJavaScript(code, this.browser.getURL(), 0);
    }

    public float getVolume() {
        return this.volume;
    }

    public float getActualVolume() {
        float actualVolume = this.volume;
        float soundSourceVolume = class_310.method_1551().field_1690.method_1630(class_3419.field_15250);
        return actualVolume *= soundSourceVolume;
    }

    public void setInteractable(boolean interactable) {
        this.interactable = interactable;
        if (!this.interactable) {
            this.browser.setFocus(false);
            this.browserFocused = false;
        }
    }

    public boolean isInteractable() {
        return this.interactable;
    }

    public void setAutoHandle(boolean autoHandle) {
        this.autoHandle = autoHandle;
    }

    public boolean isAutoHandle() {
        return this.autoHandle;
    }

    public void setFullscreenAllVideos(boolean fullscreenAllVideos) {
        this.fullscreenAllVideos = fullscreenAllVideos;
        String code = "document.querySelectorAll('video').forEach(video => {\n    if (video.requestFullscreen) {\n        video.requestFullscreen().catch(err => console.error('Fullscreen error:', err));\n    } else if (video.webkitRequestFullscreen) { // Safari compatibility\n        video.webkitRequestFullscreen().catch(err => console.error('Fullscreen error (webkit):', err));\n    } else if (video.msRequestFullscreen) { // IE/Edge compatibility\n        video.msRequestFullscreen().catch(err => console.error('Fullscreen error (ms):', err));\n    }\n});\n";
        if (this.fullscreenAllVideos) {
            this.browser.executeJavaScript(code, this.browser.getURL(), 0);
        }
    }

    public boolean isFullscreenAllVideos() {
        return this.fullscreenAllVideos;
    }

    public void setAutoPlayAllVideosOnLoad(boolean autoPlayAllVideosOnLoad) {
        this.autoPlayAllVideosOnLoad = autoPlayAllVideosOnLoad;
        String code = "document.querySelectorAll('video').forEach(video => {\n    video.play(); // Start playing the video\n});\n";
        if (this.autoPlayAllVideosOnLoad) {
            this.browser.executeJavaScript(code, this.browser.getURL(), 0);
        }
    }

    public boolean isAutoPlayAllVideosOnLoad() {
        return this.autoPlayAllVideosOnLoad;
    }

    public void setMuteAllMediaOnLoad(boolean muteAllMediaOnLoad) {
        this.muteAllMediaOnLoad = muteAllMediaOnLoad;
        String code = "document.querySelectorAll('audio, video').forEach(media => {\n    media.muted = %muted%; // Mute media\n});\n".replace("%muted%", "" + this.muteAllMediaOnLoad);
        this.browser.executeJavaScript(code, this.browser.getURL(), 0);
    }

    public boolean isMuteAllMediaOnLoad() {
        return this.muteAllMediaOnLoad;
    }

    public void setLoopAllVideos(boolean loopAllVideos) {
        this.loopAllVideos = loopAllVideos;
        String code = "document.querySelectorAll('video').forEach(video => {\n    video.loop = %loop%; // Set video to loop\n});\n".replace("%loop%", "" + this.loopAllVideos);
        this.browser.executeJavaScript(code, this.browser.getURL(), 0);
    }

    public boolean isLoopAllVideos() {
        return this.loopAllVideos;
    }

    public void setHideVideoControls(boolean hideVideoControls) {
        this.hideVideoControls = hideVideoControls;
        String codeRemove = "document.querySelectorAll('video').forEach(video => {\n    video.removeAttribute('controls'); // Hide video controls\n});\n";
        String codeAdd = "document.querySelectorAll('video').forEach(video => {\n    if (!video.hasAttribute('controls')) {\n        video.setAttribute('controls', 'controls'); // Add controls\n    }\n});\n";
        this.browser.executeJavaScript(this.hideVideoControls ? codeRemove : codeAdd, this.browser.getURL(), 0);
    }

    public boolean isHideVideoControls() {
        return this.hideVideoControls;
    }

    public void goBack() {
        if (this.browser.canGoBack()) {
            this.browser.goBack();
        }
        this.setVolume(this.volume);
    }

    public void goForward() {
        if (this.browser.canGoForward()) {
            this.browser.goForward();
        }
        this.setVolume(this.volume);
    }

    public String getUrl() {
        return this.browser.getURL();
    }

    public void setUrl(@NotNull String url) {
        this.browser.loadURL(url);
    }

    public void reload() {
        this.browser.reload();
        this.setVolume(this.volume);
    }

    public void setOpacity(float opacity) {
        this.opacity = opacity;
    }

    @NotNull
    public MCEFBrowser getBrowser() {
        return this.browser;
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void setFocusable(boolean focusable) {
    }

    @Override
    public boolean isNavigatable() {
        return false;
    }

    @Override
    public void setNavigatable(boolean navigatable) {
    }

    @Override
    public void close() throws IOException {
        this.browser.close(true);
    }
}

