/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.widget;

import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinRealmsNotificationsScreen;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4399;
import net.minecraft.class_442;
import org.jetbrains.annotations.NotNull;

public class RealmsNotificationRenderer {
    private static final class_2960 UNSEEN_NOTIFICATION_ICON_LOCATION = new class_2960("minecraft", "textures/gui/unseen_notification.png");
    private static final class_2960 NEWS_ICON_LOCATION = new class_2960("realms", "textures/gui/realms/news_notification_mainscreen.png");
    private static final class_2960 INVITE_ICON_LOCATION = new class_2960("realms", "textures/gui/realms/invite_icon.png");
    private static final class_2960 TRIAL_ICON_LOCATION = new class_2960("realms", "textures/gui/realms/trial_icon.png");
    private final IMixinRealmsNotificationsScreen screenAccess;
    private final class_310 minecraft;
    private final int screenWidth;
    private final int screenHeight;

    public RealmsNotificationRenderer(@NotNull class_4399 screen, int screenWidth, int screenHeight) {
        this.screenAccess = (IMixinRealmsNotificationsScreen)screen;
        this.minecraft = class_310.method_1551();
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    public int getDefaultPositionX() {
        int originalRightPosition = this.screenWidth / 2 + 80;
        return originalRightPosition - this.getTotalWidth();
    }

    public int getDefaultPositionY() {
        int k = this.screenHeight / 4 + 48;
        return k + 48 + 2;
    }

    public int getTotalWidth() {
        int iconCount = 0;
        boolean hasUnseenNotifications = this.hasUnseenNotifications();
        boolean showOldNotifications = this.shouldShowOldNotifications();
        boolean hasUnreadNews = this.hasUnreadNews();
        int pendingInvites = this.getNumberOfPendingInvites();
        boolean trialAvailable = this.isTrialAvailable();
        if (hasUnseenNotifications) {
            ++iconCount;
        }
        if (showOldNotifications) {
            if (hasUnreadNews) {
                ++iconCount;
            }
            if (pendingInvites > 0) {
                ++iconCount;
            }
            if (trialAvailable) {
                ++iconCount;
            }
        }
        return iconCount > 0 ? (iconCount - 1) * 16 + 14 : 0;
    }

    public int getTotalHeight() {
        return 18;
    }

    public void renderIcons(class_332 guiGraphics, int x, int y, int color) {
        boolean hasUnseenNotifications = this.hasUnseenNotifications();
        boolean showOldNotifications = this.shouldShowOldNotifications();
        boolean hasUnreadNews = this.hasUnreadNews();
        int pendingInvites = this.getNumberOfPendingInvites();
        boolean trialAvailable = this.isTrialAvailable();
        int currentX = x;
        RenderingUtils.setShaderColor(guiGraphics, color);
        if (trialAvailable && showOldNotifications) {
            int trialOffset = 0;
            if ((class_156.method_658() / 800L & 1L) == 1L) {
                trialOffset = 8;
            }
            guiGraphics.method_25290(TRIAL_ICON_LOCATION, currentX, y + 4, 0.0f, (float)trialOffset, 8, 8, 8, 16);
            currentX += 16;
        }
        if (pendingInvites > 0 && showOldNotifications) {
            guiGraphics.method_25290(INVITE_ICON_LOCATION, currentX, y + 1, 0.0f, 0.0f, 18, 15, 18, 30);
            currentX += 16;
        }
        if (hasUnreadNews && showOldNotifications) {
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_22905(0.4f, 0.4f, 0.4f);
            guiGraphics.method_25290(NEWS_ICON_LOCATION, (int)((double)currentX * 2.5), (int)((double)y * 2.5), 0.0f, 0.0f, 40, 40, 40, 40);
            guiGraphics.method_51448().method_22909();
            currentX += 16;
        }
        if (hasUnseenNotifications) {
            guiGraphics.method_25290(UNSEEN_NOTIFICATION_ICON_LOCATION, currentX, y + 3, 0.0f, 0.0f, 10, 10, 10, 10);
        }
        RenderingUtils.resetShaderColor(guiGraphics);
    }

    public void renderIcons(class_332 guiGraphics, int color) {
        boolean isValidClient = this.screenAccess.get_validClient_FancyMenu();
        if (isValidClient) {
            this.renderIcons(guiGraphics, this.getDefaultPositionX(), this.getDefaultPositionY(), color);
        }
    }

    public boolean shouldShowOldNotifications() {
        if (RealmsNotificationRenderer.isEditor()) {
            return true;
        }
        boolean isValidClient = this.screenAccess.get_validClient_FancyMenu();
        boolean inTitleScreen = this.minecraft.field_1755 instanceof class_442;
        if (!isValidClient || !inTitleScreen) {
            return false;
        }
        return (Boolean)this.minecraft.field_1690.method_42440().method_41753();
    }

    public int getNumberOfPendingInvites() {
        if (RealmsNotificationRenderer.isEditor()) {
            return 1;
        }
        return this.screenAccess.get_numberOfPendingInvites_FancyMenu();
    }

    public boolean hasUnseenNotifications() {
        if (RealmsNotificationRenderer.isEditor()) {
            return true;
        }
        return this.screenAccess.get_hasUnseenNotifications();
    }

    public boolean hasUnreadNews() {
        if (RealmsNotificationRenderer.isEditor()) {
            return true;
        }
        return this.screenAccess.get_hasUnreadNews_FancyMenu();
    }

    public boolean isTrialAvailable() {
        if (RealmsNotificationRenderer.isEditor()) {
            return true;
        }
        return this.screenAccess.get_trialAvailable_FancyMenu();
    }

    protected static boolean isEditor() {
        return class_310.method_1551().field_1755 instanceof LayoutEditorScreen;
    }
}

