/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.data.v2;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_173;
import net.minecraft.class_176;
import net.minecraft.class_2248;
import net.minecraft.class_2405;
import net.minecraft.class_2438;
import net.minecraft.class_2960;
import net.minecraft.class_39;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7403;
import net.minecraft.class_7701;
import net.minecraft.class_7784;
import net.minecraft.class_7788;
import net.minecraft.class_7789;
import net.minecraft.class_7791;
import net.minecraft.class_7923;
import org.apache.commons.lang3.StringUtils;

public final class AbstractLootProvider {
    public static class_2438 createProvider(class_7784 packOutput, class_7791 provider, class_176 paramSet) {
        return new class_2438(packOutput, Set.of(), List.of(new class_2438.class_7790(() -> provider, paramSet)));
    }

    public static abstract class Simple
    implements class_7791,
    class_2405 {
        private final class_2438 provider;
        protected final Map<class_2960, class_52.class_53> values = Maps.newHashMap();

        public Simple(class_176 paramSet, DataProviderContext context) {
            this(paramSet, context.getPackOutput());
        }

        public Simple(class_176 paramSet, class_7784 packOutput) {
            this.provider = AbstractLootProvider.createProvider(packOutput, this, paramSet);
        }

        public final CompletableFuture<?> method_10319(class_7403 output) {
            return this.provider.method_10319(output);
        }

        public String method_10321() {
            return String.join((CharSequence)" ", StringUtils.splitByCharacterTypeCamelCase((String)this.getClass().getSimpleName()));
        }

        public void method_10399(BiConsumer<class_2960, class_52.class_53> exporter) {
            this.addLootTables();
            this.values.forEach(exporter);
        }

        protected void add(class_2960 table, class_52.class_53 builder) {
            this.values.put(table, builder);
        }

        public abstract void addLootTables();
    }

    public static abstract class EntityTypes
    extends class_7789
    implements class_2405 {
        private final class_2438 provider;
        protected final String modId;
        protected final Map<class_1299<?>, Map<class_2960, class_52.class_53>> map = Maps.newHashMap();

        public EntityTypes(DataProviderContext context) {
            this(context.getModId(), context.getPackOutput());
        }

        public EntityTypes(String modId, class_7784 packOutput) {
            super(class_7701.field_40180.method_45383());
            this.provider = AbstractLootProvider.createProvider(packOutput, (class_7791)this, class_173.field_1173);
            this.modId = modId;
        }

        public final CompletableFuture<?> method_10319(class_7403 output) {
            return this.provider.method_10319(output);
        }

        public String method_10321() {
            return "Entity Type Loot Tables";
        }

        public final void method_10400() {
            this.addLootTables();
        }

        public abstract void addLootTables();

        public void method_10399(BiConsumer<class_2960, class_52.class_53> consumer) {
            this.method_10400();
            HashSet set = Sets.newHashSet();
            for (Map.Entry entry : class_7923.field_41177.method_29722()) {
                class_5321 resourceKey = (class_5321)entry.getKey();
                class_1299 entityType = (class_1299)entry.getValue();
                if (!resourceKey.method_29177().method_12836().equals(this.modId) || !entityType.method_45382(class_7701.field_40180.method_45383())) continue;
                Map<class_2960, class_52.class_53> map = this.map.remove(entityType);
                if (this.canHaveLootTable(entityType)) {
                    class_2960 resourceLocation = entityType.method_16351();
                    if (!(resourceLocation.equals((Object)class_39.field_844) || map != null && map.containsKey(resourceLocation))) {
                        throw new IllegalStateException(String.format(Locale.ROOT, "Missing loot table '%s' for '%s'", resourceLocation, resourceKey.method_29177()));
                    }
                    if (map == null) continue;
                    map.forEach((resourceLocationx, builder) -> {
                        if (!set.add(resourceLocationx)) {
                            throw new IllegalStateException(String.format(Locale.ROOT, "Duplicate loot table '%s' for '%s'", resourceLocationx, resourceKey.method_29177()));
                        }
                        consumer.accept((class_2960)resourceLocationx, (class_52.class_53)builder);
                    });
                    continue;
                }
                if (map == null) continue;
                throw new IllegalStateException(String.format(Locale.ROOT, "Weird loot table(s) '%s' for '%s', not a LivingEntity so should not have loot", map.keySet().stream().map(class_2960::toString).collect(Collectors.joining(",")), resourceKey.method_29177()));
            }
            if (!this.map.isEmpty()) {
                throw new IllegalStateException("Created loot tables for entities not supported by data pack: " + this.map.keySet());
            }
        }

        protected boolean canHaveLootTable(class_1299<?> entityType) {
            return entityType.method_5891() != class_1311.field_17715;
        }
    }

    public static abstract class Blocks
    extends class_7788
    implements class_2405 {
        private final class_2438 provider;
        protected final String modId;

        public Blocks(DataProviderContext context) {
            this(context.getModId(), context.getPackOutput());
        }

        public Blocks(String modId, class_7784 packOutput) {
            super(Collections.emptySet(), class_7701.field_40180.method_45383());
            this.provider = AbstractLootProvider.createProvider(packOutput, (class_7791)this, class_173.field_1172);
            this.modId = modId;
        }

        public final CompletableFuture<?> method_10319(class_7403 output) {
            return this.provider.method_10319(output);
        }

        public String method_10321() {
            return "Block Loot Tables";
        }

        public final void method_10379() {
            this.addLootTables();
        }

        public abstract void addLootTables();

        public void method_10399(BiConsumer<class_2960, class_52.class_53> consumer) {
            this.method_10379();
            HashSet set = Sets.newHashSet();
            for (Map.Entry entry : class_7923.field_41175.method_29722()) {
                class_2960 resourceLocation;
                class_5321 resourceKey = (class_5321)entry.getKey();
                class_2248 block = (class_2248)entry.getValue();
                if (!resourceKey.method_29177().method_12836().equals(this.modId) || !block.method_45382(this.field_40609) || (resourceLocation = block.method_26162()) == class_39.field_844 || !resourceLocation.method_12836().equals(this.modId) || !set.add(resourceLocation)) continue;
                class_52.class_53 builder = (class_52.class_53)this.field_40610.remove(resourceLocation);
                if (builder == null) {
                    throw new IllegalStateException("Missing loot table '%s' for '%s'".formatted(resourceLocation, resourceKey.method_29177()));
                }
                consumer.accept(resourceLocation, builder);
            }
            if (!this.field_40610.isEmpty()) {
                throw new IllegalStateException("Created block loot tables for non-blocks: " + this.field_40610.keySet());
            }
        }

        protected void dropNothing(class_2248 block) {
            this.method_45988(block, Blocks.method_45975());
        }
    }
}

