/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.data.v2.tags;

import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import fuzs.puzzleslib.api.data.v2.tags.AbstractTagAppender;
import fuzs.puzzleslib.impl.core.CommonFactories;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.class_2378;
import net.minecraft.class_2474;
import net.minecraft.class_2960;
import net.minecraft.class_3495;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7784;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;

public abstract class AbstractTagProvider<T>
extends class_2474<T> {
    protected final String modId;

    public AbstractTagProvider(class_5321<? extends class_2378<T>> registryKey, DataProviderContext context) {
        this(registryKey, context.getModId(), context.getPackOutput(), context.getLookupProvider());
    }

    public AbstractTagProvider(class_5321<? extends class_2378<T>> registryKey, String modId, class_7784 packOutput, CompletableFuture<class_7225.class_7874> registries) {
        super(packOutput, registryKey, registries);
        this.modId = modId;
    }

    static <T> AbstractTagAppender<T> tagAppender(class_3495 tagBuilder, class_5321<? extends class_2378<? super T>> registryKey) {
        Optional optional = AbstractTagProvider.getRegistry(registryKey);
        Function<Object, class_5321> keyExtractor = optional.isPresent() ? t -> (class_5321)optional.flatMap(registry -> registry.method_29113(t)).orElseThrow(() -> new IllegalStateException("Missing value in " + registryKey + ": " + t)) : null;
        return CommonFactories.INSTANCE.getTagAppender(tagBuilder, keyExtractor);
    }

    static <T> Optional<class_2378<T>> getRegistry(class_5321<? extends class_2378<? super T>> registryKey) {
        Objects.requireNonNull(registryKey, "registry key is null");
        return class_7923.field_41167.method_31189(registryKey);
    }

    public abstract void method_10514(class_7225.class_7874 var1);

    @ApiStatus.Internal
    public class_2474.class_5124<T> method_10512(class_6862<T> tagKey) {
        throw new UnsupportedOperationException();
    }

    public AbstractTagAppender<T> add(String string) {
        return this.add(ResourceLocationHelper.parse(string));
    }

    public AbstractTagAppender<T> add(class_2960 resourceLocation) {
        return this.add(class_6862.method_40092((class_5321)this.field_40957, (class_2960)resourceLocation));
    }

    public AbstractTagAppender<T> add(class_6862<T> tagKey) {
        return AbstractTagProvider.tagAppender(this.method_27169(tagKey), this.field_40957);
    }
}

