/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.registry;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2396;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_4002;
import net.minecraft.class_5272;
import net.minecraft.class_5616;
import net.minecraft.class_707;
import net.minecraft.class_827;
import net.minecraft.class_897;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.BlockColorProvider;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockRenderView;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.EntityType;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.ItemColorProvider;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.KeyBinding;
import org.mtr.mapping.holder.LivingEntity;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.RenderLayer;
import org.mtr.mapping.holder.SpriteProvider;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.EntityExtension;
import org.mtr.mapping.mapper.EntityRenderer;
import org.mtr.mapping.mapper.ParticleFactoryExtension;
import org.mtr.mapping.registry.BlockEntityTypeRegistryObject;
import org.mtr.mapping.registry.BlockRegistryObject;
import org.mtr.mapping.registry.EntityTypeRegistryObject;
import org.mtr.mapping.registry.EventRegistryClient;
import org.mtr.mapping.registry.ItemRegistryObject;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.registry.ParticleTypeRegistryObject;
import org.mtr.mapping.registry.Registry;
import org.mtr.mapping.tool.DummyClass;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;

public final class RegistryClient
extends DummyClass {
    public static Function<World, ? extends EntityExtension> worldRenderingEntity;
    public final EventRegistryClient eventRegistryClient = new EventRegistryClient();
    private final Registry registry;
    private final List<Runnable> objectsToRegister = new ArrayList<Runnable>();

    @MappedMethod
    public RegistryClient(Registry registry) {
        this.registry = registry;
    }

    @MappedMethod
    public void init() {
        this.objectsToRegister.forEach(Runnable::run);
    }

    @MappedMethod
    public <T extends BlockEntityTypeRegistryObject<U>, U extends BlockEntityExtension> void registerBlockEntityRenderer(T blockEntityType, Function<BlockEntityRenderer.Argument, BlockEntityRenderer<U>> rendererInstance) {
        this.objectsToRegister.add(() -> class_5616.method_32144((class_2591)((class_2591)((BlockEntityType)blockEntityType.get()).data), context -> (class_827)rendererInstance.apply(new BlockEntityRenderer.Argument(context))));
    }

    @MappedMethod
    public <T extends EntityTypeRegistryObject<U>, U extends EntityExtension> void registerEntityRenderer(T entityType, Function<EntityRenderer.Argument, EntityRenderer<U>> rendererInstance) {
        this.objectsToRegister.add(() -> EntityRendererRegistry.register((class_1299)((class_1299)((EntityType)entityType.get()).data), dispatcher -> (class_897)rendererInstance.apply(new EntityRenderer.Argument(dispatcher))));
    }

    @MappedMethod
    public void registerParticleRenderer(ParticleTypeRegistryObject particleTypeRegistryObject, Function<SpriteProvider, ParticleFactoryExtension> factory2) {
        ParticleFactoryRegistry.getInstance().register((class_2396)particleTypeRegistryObject.get().data, spriteProvider -> (class_707)factory2.apply(new SpriteProvider((class_4002)spriteProvider)));
    }

    @MappedMethod
    public void registerBlockRenderType(RenderLayer renderLayer, BlockRegistryObject block) {
        this.objectsToRegister.add(() -> BlockRenderLayerMap.INSTANCE.putBlock((class_2248)block.get().data, (class_1921)renderLayer.data));
    }

    @MappedMethod
    public KeyBinding registerKeyBinding(String translationKey, int key, String categoryKey) {
        return new KeyBinding(KeyBindingHelper.registerKeyBinding((class_304)new class_304(translationKey, class_3675.class_307.field_1668, key, categoryKey)));
    }

    @MappedMethod
    public void registerBlockColors(BlockColorProvider blockColorProvider, BlockRegistryObject ... blocks) {
        Object[] newBlocks = new class_2248[blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            newBlocks[i] = (class_2248)blocks[i].get().data;
        }
        ColorProviderRegistry.BLOCK.register((blockState, blockRenderView, blockPos, tintIndex) -> blockColorProvider.getColor2(new BlockState(blockState), blockRenderView == null ? null : new BlockRenderView(blockRenderView), blockPos == null ? null : new BlockPos(blockPos), tintIndex), newBlocks);
    }

    @MappedMethod
    public void registerItemColors(ItemColorProvider itemColorProvider, ItemRegistryObject ... items) {
        Object[] newItems = new class_1792[items.length];
        for (int i = 0; i < items.length; ++i) {
            newItems[i] = (class_1792)items[i].get().data;
        }
        ColorProviderRegistry.ITEM.register((itemStack, tintIndex) -> itemColorProvider.getColor2(new ItemStack(itemStack), tintIndex), newItems);
    }

    @MappedMethod
    public void registerItemModelPredicate(ItemRegistryObject item, Identifier identifier, ModelPredicateProvider modelPredicateProvider) {
        class_5272.method_27879((class_1792)((class_1792)item.get().data), (class_2960)((class_2960)identifier.data), (itemStack, clientWorld, livingEntity, seed) -> modelPredicateProvider.call(new ItemStack(itemStack), clientWorld == null ? null : new ClientWorld(clientWorld), livingEntity == null ? null : new LivingEntity(livingEntity)));
    }

    @MappedMethod
    public void setupPackets(Identifier identifier) {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)((class_2960)identifier.data), (client, handler, buf, responseSender) -> PacketBufferReceiver.receive((ByteBuf)buf, packetBufferReceiver -> {
            Function<PacketBufferReceiver, ? extends PacketHandler> getInstance = this.registry.packets.get(packetBufferReceiver.readString());
            if (getInstance != null) {
                getInstance.apply((PacketBufferReceiver)packetBufferReceiver).runClient();
            }
        }, arg_0 -> ((class_310)client).execute(arg_0)));
    }

    @MappedMethod
    public <T extends PacketHandler> void sendPacketToServer(T data) {
        if (this.registry.packetsIdentifier != null) {
            PacketBufferSender packetBufferSender = new PacketBufferSender(PacketByteBufs::create);
            packetBufferSender.writeString(data.getClass().getName());
            data.write(packetBufferSender);
            packetBufferSender.send(byteBuf -> ClientPlayNetworking.send((class_2960)((class_2960)this.registry.packetsIdentifier.data), (class_2540)(byteBuf instanceof class_2540 ? (class_2540)byteBuf : new class_2540(byteBuf))), MinecraftClient.getInstance()::execute);
        }
    }

    @FunctionalInterface
    public static interface ModelPredicateProvider {
        @MappedMethod
        public float call(ItemStack var1, @Nullable ClientWorld var2, @Nullable LivingEntity var3);
    }
}

