/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.tool;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.tool.DummyClass;

public final class PacketBufferReceiver
extends DummyClass {
    private int receivedCount;
    private int readIndex;
    private final int count;
    private final ByteBuf[] byteBufArray;
    private final Consumer<PacketBufferReceiver> onComplete;
    private static final Map<Long, PacketBufferReceiver> RECEIVED_PACKETS = new HashMap<Long, PacketBufferReceiver>();

    private PacketBufferReceiver(int count, Consumer<PacketBufferReceiver> onComplete) {
        this.count = count;
        this.onComplete = onComplete;
        this.byteBufArray = new ByteBuf[count];
    }

    @MappedMethod
    public boolean readBoolean() {
        this.read();
        return this.byteBufArray[this.readIndex].readBoolean();
    }

    @MappedMethod
    public char readChar() {
        this.read();
        return this.byteBufArray[this.readIndex].readChar();
    }

    @MappedMethod
    public int readInt() {
        this.read();
        return this.byteBufArray[this.readIndex].readInt();
    }

    @MappedMethod
    public float readFloat() {
        this.read();
        return this.byteBufArray[this.readIndex].readFloat();
    }

    @MappedMethod
    public long readLong() {
        this.read();
        return this.byteBufArray[this.readIndex].readLong();
    }

    @MappedMethod
    public double readDouble() {
        this.read();
        return this.byteBufArray[this.readIndex].readDouble();
    }

    @MappedMethod
    public String readString() {
        int stringLength = this.readInt();
        char[] characters = new char[stringLength];
        for (int i = 0; i < stringLength; ++i) {
            characters[i] = this.readChar();
        }
        return new String(characters);
    }

    private void read() {
        if (this.byteBufArray[this.readIndex].readableBytes() == 0) {
            ++this.readIndex;
        }
    }

    private boolean receive(int index, ByteBuf byteBuf) {
        this.byteBufArray[index] = byteBuf;
        ++this.receivedCount;
        if (this.receivedCount == this.count) {
            this.onComplete.accept(this);
            return true;
        }
        return false;
    }

    @MappedMethod
    public static void receive(ByteBuf byteBuf, Consumer<PacketBufferReceiver> onComplete, Consumer<Runnable> scheduler) {
        ByteBuf byteBufCopy = byteBuf.copy();
        scheduler.accept(() -> {
            long id = byteBufCopy.readLong();
            int index = byteBufCopy.readInt();
            int count = byteBufCopy.readInt();
            if (RECEIVED_PACKETS.computeIfAbsent(id, key -> new PacketBufferReceiver(count, onComplete)).receive(index, byteBufCopy)) {
                RECEIVED_PACKETS.remove(id);
            }
        });
    }
}

