/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod;

import com.mojang.brigadier.arguments.StringArgumentType;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.net.HttpURLConnection;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mtr.core.Main;
import org.mtr.core.data.Position;
import org.mtr.core.operation.DepotOperationByName;
import org.mtr.core.operation.SetTime;
import org.mtr.core.serializer.SerializedDataBase;
import org.mtr.core.servlet.QueueObject;
import org.mtr.core.servlet.Webserver;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.com.google.gson.JsonElement;
import org.mtr.libraries.com.google.gson.JsonParser;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MathHelper;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldSavePath;
import org.mtr.mapping.mapper.GameRule;
import org.mtr.mapping.mapper.MinecraftServerHelper;
import org.mtr.mapping.mapper.WorldHelper;
import org.mtr.mapping.registry.CommandBuilder;
import org.mtr.mapping.registry.Registry;
import org.mtr.mapping.tool.DummyClass;
import org.mtr.mixin.PlayerTeleportationStateAccessor;
import org.mtr.mod.AsciiArt;
import org.mtr.mod.BlockEntityTypes;
import org.mtr.mod.Blocks;
import org.mtr.mod.CreativeModeTabs;
import org.mtr.mod.EntityTypes;
import org.mtr.mod.Items;
import org.mtr.mod.SoundEvents;
import org.mtr.mod.StrayThreadManager;
import org.mtr.mod.config.Config;
import org.mtr.mod.data.ArrivalsCacheServer;
import org.mtr.mod.data.RailActionModule;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.packet.PacketAddBalance;
import org.mtr.mod.packet.PacketBroadcastRailActions;
import org.mtr.mod.packet.PacketCheckRouteIdHasDisabledAnnouncements;
import org.mtr.mod.packet.PacketDeleteData;
import org.mtr.mod.packet.PacketDeleteRailAction;
import org.mtr.mod.packet.PacketDepotClear;
import org.mtr.mod.packet.PacketDepotGenerate;
import org.mtr.mod.packet.PacketDepotInstantDeploy;
import org.mtr.mod.packet.PacketDriveTrain;
import org.mtr.mod.packet.PacketFetchArrivals;
import org.mtr.mod.packet.PacketForwardClientRequest;
import org.mtr.mod.packet.PacketOpenBlockEntityScreen;
import org.mtr.mod.packet.PacketOpenDashboardScreen;
import org.mtr.mod.packet.PacketOpenLiftCustomizationScreen;
import org.mtr.mod.packet.PacketOpenPIDSConfigScreen;
import org.mtr.mod.packet.PacketOpenTicketMachineScreen;
import org.mtr.mod.packet.PacketPressLiftButton;
import org.mtr.mod.packet.PacketRequestData;
import org.mtr.mod.packet.PacketSetRouteIdHasDisabledAnnouncements;
import org.mtr.mod.packet.PacketTurnOnBlockEntity;
import org.mtr.mod.packet.PacketUpdateData;
import org.mtr.mod.packet.PacketUpdateEyeCandyConfig;
import org.mtr.mod.packet.PacketUpdateKeyDispenserConfig;
import org.mtr.mod.packet.PacketUpdateLastRailStyles;
import org.mtr.mod.packet.PacketUpdateLiftTrackFloorConfig;
import org.mtr.mod.packet.PacketUpdatePIDSConfig;
import org.mtr.mod.packet.PacketUpdateRailwaySignConfig;
import org.mtr.mod.packet.PacketUpdateSignalConfig;
import org.mtr.mod.packet.PacketUpdateTrainAnnouncerConfig;
import org.mtr.mod.packet.PacketUpdateTrainScheduleSensorConfig;
import org.mtr.mod.packet.PacketUpdateTrainSensorConfig;
import org.mtr.mod.packet.PacketUpdateVehicleRidingEntities;
import org.mtr.mod.packet.PacketUpdateVehiclesLifts;
import org.mtr.mod.servlet.MinecraftOperationProcessor;
import org.mtr.mod.servlet.RequestHelper;

public final class Init
implements Utilities {
    private static Main main;
    private static int serverPort;
    private static Runnable sendWorldTimeUpdate;
    private static boolean canSendWorldTimeUpdate;
    private static boolean isDedicatedServer;
    private static int serverTick;
    private static long lastSavedMillis;
    private static Consumer<Webserver> webserverSetup;
    public static final String MOD_ID = "mtr";
    public static final String MOD_ID_NTE = "mtrsteamloco";
    public static final Logger LOGGER;
    public static final Registry REGISTRY;
    public static final int SECONDS_PER_MC_HOUR = 50;
    public static final int AUTOSAVE_INTERVAL = 30000;
    public static final RequestHelper REQUEST_HELPER;
    private static final int MILLIS_PER_MC_DAY = 1200000;
    private static final Object2ObjectArrayMap<ServerWorld, RailActionModule> RAIL_ACTION_MODULES;
    private static final ObjectArrayList<String> WORLD_ID_LIST;
    private static final Object2ObjectAVLTreeMap<UUID, Runnable> RIDING_PLAYERS;

    public static void init() {
        LOGGER.info("Starting Minecraft with arguments:\n{}", (Object)String.join((CharSequence)"\n", ManagementFactory.getRuntimeMXBean().getInputArguments()));
        AsciiArt.print();
        Blocks.init();
        Items.init();
        BlockEntityTypes.init();
        EntityTypes.init();
        CreativeModeTabs.init();
        SoundEvents.init();
        DummyClass.enableLogging();
        REGISTRY.setupPackets(new Identifier(MOD_ID, "packet"));
        REGISTRY.registerPacket(PacketAddBalance.class, PacketAddBalance::new);
        REGISTRY.registerPacket(PacketBroadcastRailActions.class, PacketBroadcastRailActions::new);
        REGISTRY.registerPacket(PacketCheckRouteIdHasDisabledAnnouncements.class, PacketCheckRouteIdHasDisabledAnnouncements::new);
        REGISTRY.registerPacket(PacketDeleteData.class, PacketDeleteData::new);
        REGISTRY.registerPacket(PacketDeleteRailAction.class, PacketDeleteRailAction::new);
        REGISTRY.registerPacket(PacketDepotClear.class, PacketDepotClear::new);
        REGISTRY.registerPacket(PacketDepotInstantDeploy.class, PacketDepotInstantDeploy::new);
        REGISTRY.registerPacket(PacketDepotGenerate.class, PacketDepotGenerate::new);
        REGISTRY.registerPacket(PacketDriveTrain.class, PacketDriveTrain::new);
        REGISTRY.registerPacket(PacketFetchArrivals.class, PacketFetchArrivals::new);
        REGISTRY.registerPacket(PacketForwardClientRequest.class, PacketForwardClientRequest::new);
        REGISTRY.registerPacket(PacketUpdateKeyDispenserConfig.class, PacketUpdateKeyDispenserConfig::new);
        REGISTRY.registerPacket(PacketOpenBlockEntityScreen.class, PacketOpenBlockEntityScreen::new);
        REGISTRY.registerPacket(PacketOpenDashboardScreen.class, PacketOpenDashboardScreen::new);
        REGISTRY.registerPacket(PacketOpenLiftCustomizationScreen.class, PacketOpenLiftCustomizationScreen::new);
        REGISTRY.registerPacket(PacketOpenPIDSConfigScreen.class, PacketOpenPIDSConfigScreen::new);
        REGISTRY.registerPacket(PacketOpenTicketMachineScreen.class, PacketOpenTicketMachineScreen::new);
        REGISTRY.registerPacket(PacketPressLiftButton.class, PacketPressLiftButton::new);
        REGISTRY.registerPacket(PacketRequestData.class, PacketRequestData::new);
        REGISTRY.registerPacket(PacketSetRouteIdHasDisabledAnnouncements.class, PacketSetRouteIdHasDisabledAnnouncements::new);
        REGISTRY.registerPacket(PacketTurnOnBlockEntity.class, PacketTurnOnBlockEntity::new);
        REGISTRY.registerPacket(PacketUpdateData.class, PacketUpdateData::new);
        REGISTRY.registerPacket(PacketUpdateEyeCandyConfig.class, PacketUpdateEyeCandyConfig::new);
        REGISTRY.registerPacket(PacketUpdateLastRailStyles.class, PacketUpdateLastRailStyles::new);
        REGISTRY.registerPacket(PacketUpdateLiftTrackFloorConfig.class, PacketUpdateLiftTrackFloorConfig::new);
        REGISTRY.registerPacket(PacketUpdatePIDSConfig.class, PacketUpdatePIDSConfig::new);
        REGISTRY.registerPacket(PacketUpdateRailwaySignConfig.class, PacketUpdateRailwaySignConfig::new);
        REGISTRY.registerPacket(PacketUpdateSignalConfig.class, PacketUpdateSignalConfig::new);
        REGISTRY.registerPacket(PacketUpdateTrainAnnouncerConfig.class, PacketUpdateTrainAnnouncerConfig::new);
        REGISTRY.registerPacket(PacketUpdateTrainScheduleSensorConfig.class, PacketUpdateTrainScheduleSensorConfig::new);
        REGISTRY.registerPacket(PacketUpdateTrainSensorConfig.class, PacketUpdateTrainSensorConfig::new);
        REGISTRY.registerPacket(PacketUpdateVehiclesLifts.class, PacketUpdateVehiclesLifts::new);
        REGISTRY.registerPacket(PacketUpdateVehicleRidingEntities.class, PacketUpdateVehicleRidingEntities::new);
        REGISTRY.registerCommand(MOD_ID, commandBuilderMtr -> {
            commandBuilderMtr.then("generate", commandBuilderGenerate -> Init.depotOperationFromCommand(commandBuilderGenerate, DepotOperation.GENERATE));
            commandBuilderMtr.then("clear", commandBuilderClear -> Init.depotOperationFromCommand(commandBuilderClear, DepotOperation.CLEAR));
            commandBuilderMtr.then("instantDeploy", commandBuilderInstantDeploy -> Init.depotOperationFromCommand(commandBuilderInstantDeploy, DepotOperation.INSTANT_DEPLOY));
            commandBuilderMtr.then("restoreWorld", commandBuilderRestoreWorld -> {
                commandBuilderRestoreWorld.permissionLevel(4);
                commandBuilderRestoreWorld.then("worldDirectory", StringArgumentType.string(), innerCommandBuilder1 -> innerCommandBuilder1.then("backupDirectory", StringArgumentType.string(), innerCommandBuilder2 -> innerCommandBuilder2.executes(contextHandler -> {
                    Path runPath = contextHandler.getServer().getRunDirectory().toPath();
                    Path worldDirectory = runPath.resolve(contextHandler.getString("worldDirectory"));
                    Path backupDirectory = runPath.resolve(contextHandler.getString("backupDirectory"));
                    boolean worldDirectoryExists = Files.isDirectory(worldDirectory, new LinkOption[0]);
                    boolean backupDirectoryExists = Files.isDirectory(backupDirectory, new LinkOption[0]);
                    if (worldDirectoryExists && backupDirectoryExists) {
                        try {
                            if (main != null) {
                                main.stop();
                            }
                            contextHandler.sendSuccess(String.format("Restoring world backup from %s to %s...", backupDirectory, worldDirectory), true, new Object[0]);
                            FileUtils.deleteDirectory((File)worldDirectory.toFile());
                            contextHandler.sendSuccess("Deleting world complete", true, new Object[0]);
                            FileUtils.copyDirectory((File)backupDirectory.toFile(), (File)worldDirectory.toFile());
                            contextHandler.sendSuccess("Restoring world backup complete", true, new Object[0]);
                            System.exit(0);
                            return 1;
                        }
                        catch (Exception e) {
                            contextHandler.sendFailure("Restoring world backup failed", new Object[0]);
                            LOGGER.error("", (Throwable)e);
                            return -1;
                        }
                    }
                    if (backupDirectoryExists) {
                        contextHandler.sendFailure("World directory not found", new Object[0]);
                    } else if (worldDirectoryExists) {
                        contextHandler.sendFailure("Backup directory not found", new Object[0]);
                    } else {
                        contextHandler.sendFailure("Directories not found", new Object[0]);
                    }
                    return -1;
                })));
            });
        }, "minecrafttransitrailway");
        Init.REGISTRY.eventRegistry.registerServerStarted(minecraftServer -> {
            RAIL_ACTION_MODULES.clear();
            WORLD_ID_LIST.clear();
            MinecraftServerHelper.iterateWorlds(minecraftServer, serverWorld -> {
                RAIL_ACTION_MODULES.put((ServerWorld)serverWorld, new RailActionModule((ServerWorld)serverWorld));
                WORLD_ID_LIST.add(Init.getWorldId(new World((class_1937)serverWorld.data)));
            });
            Config.init(minecraftServer.getRunDirectory());
            int defaultPort = Config.getServer().getWebserverPort();
            serverPort = defaultPort <= 0 ? -1 : Init.findFreePort(defaultPort);
            main = new Main(minecraftServer.getSavePath(WorldSavePath.getRootMapped()).resolve(MOD_ID), serverPort, Config.getServer().getUseThreadedSimulation(), Config.getServer().getUseThreadedFileLoading(), webserverSetup, WORLD_ID_LIST.toArray(new String[0]));
            serverTick = 0;
            lastSavedMillis = System.currentTimeMillis();
            sendWorldTimeUpdate = () -> {
                if (canSendWorldTimeUpdate) {
                    canSendWorldTimeUpdate = false;
                    Init.sendMessageC2S("set_time", minecraftServer, null, new SetTime((WorldHelper.getTimeOfDay(minecraftServer.getOverworld()) + 6000L) * 50L, 1200000L, GameRule.DO_DAYLIGHT_CYCLE.getBooleanGameRule((MinecraftServer)minecraftServer)), response -> {
                        canSendWorldTimeUpdate = true;
                    }, SerializedDataBase.class);
                } else {
                    Main.LOGGER.error("Transport Simulation Core not responding; stopping Minecraft server!");
                    minecraftServer.stop(false);
                    canSendWorldTimeUpdate = true;
                }
            };
            LOGGER.info("Starting server as a {} server", (Object)(isDedicatedServer ? "dedicated" : "non-dedicated"));
            if (isDedicatedServer && Config.getServer().forceShutDownStrayThreads()) {
                StrayThreadManager.register(minecraftServer);
            }
        });
        Init.REGISTRY.eventRegistry.registerServerStopping(minecraftServer -> {
            if (main != null) {
                main.stop();
            }
            serverPort = 0;
            RIDING_PLAYERS.clear();
        });
        Init.REGISTRY.eventRegistry.registerStartServerTick(() -> {
            if (sendWorldTimeUpdate != null && serverTick % 500 == 0) {
                sendWorldTimeUpdate.run();
            }
            ArrivalsCacheServer.tickAll();
            ++serverTick;
            if (main != null) {
                long currentMillis;
                if (!Config.getServer().getUseThreadedSimulation()) {
                    main.manualTick();
                }
                if ((currentMillis = System.currentTimeMillis()) - lastSavedMillis > 30000L) {
                    main.save();
                    lastSavedMillis = currentMillis;
                }
            }
            RIDING_PLAYERS.values().forEach(Runnable::run);
        });
        Init.REGISTRY.eventRegistry.registerEndWorldTick(serverWorld -> {
            RailActionModule railActionModule = RAIL_ACTION_MODULES.get(serverWorld);
            if (railActionModule != null) {
                railActionModule.tick();
            }
            if (main != null) {
                String dimension = Init.getWorldId(new World((class_1937)serverWorld.data));
                main.processMessagesS2C(WORLD_ID_LIST.indexOf(dimension), queueObject -> MinecraftOperationProcessor.process(queueObject, serverWorld, dimension));
            }
        });
        Init.REGISTRY.eventRegistry.registerPlayerJoin((minecraftServer, serverPlayerEntity) -> Init.updatePlayer(serverPlayerEntity, false));
        Init.REGISTRY.eventRegistry.registerPlayerDisconnect((minecraftServer, serverPlayerEntity) -> RIDING_PLAYERS.remove(serverPlayerEntity.getUuid()));
        REGISTRY.init();
    }

    public static void getRailActionModule(ServerWorld serverWorld, Consumer<RailActionModule> consumer) {
        RailActionModule railActionModule = RAIL_ACTION_MODULES.get(serverWorld);
        if (railActionModule != null) {
            consumer.accept(railActionModule);
        }
    }

    public static int getServerPort() {
        return serverPort;
    }

    public static <T extends SerializedDataBase> void sendMessageC2S(String key, @Nullable MinecraftServer minecraftServer, @Nullable World world, SerializedDataBase data, @Nullable Consumer<T> consumer, @Nullable Class<T> responseDataClass) {
        if (main != null) {
            main.sendMessageC2S(world == null ? null : Integer.valueOf(WORLD_ID_LIST.indexOf(Init.getWorldId(world))), new QueueObject(key, data, consumer == null || minecraftServer == null ? null : responseData -> minecraftServer.execute(() -> consumer.accept(responseData)), responseDataClass));
        }
    }

    public static BlockPos positionToBlockPos(Position position) {
        return new BlockPos((int)position.getX(), (int)position.getY(), (int)position.getZ());
    }

    public static Position blockPosToPosition(BlockPos blockPos) {
        return new Position(blockPos.getX(), blockPos.getY(), blockPos.getZ());
    }

    public static BlockPos newBlockPos(double x, double y, double z) {
        return new BlockPos(MathHelper.floor(x), MathHelper.floor(y), MathHelper.floor(z));
    }

    public static boolean isChunkLoaded(World world, BlockPos blockPos) {
        return world.getChunkManager().getWorldChunk(blockPos.getX() / 16, blockPos.getZ() / 16) != null && world.isRegionLoaded(blockPos, blockPos);
    }

    public static void updateRidingEntity(ServerPlayerEntity serverPlayerEntity, boolean dismount) {
        if (dismount) {
            RIDING_PLAYERS.remove(serverPlayerEntity.getUuid());
            Init.updatePlayer(serverPlayerEntity, false);
        } else {
            RIDING_PLAYERS.put(serverPlayerEntity.getUuid(), () -> Init.updatePlayer(serverPlayerEntity, true));
        }
    }

    public static String getWorldId(World world) {
        Identifier identifier = MinecraftServerHelper.getWorldId(world);
        return String.format("%s/%s", identifier.getNamespace(), identifier.getPath());
    }

    public static int findFreePort(int startingPort) {
        int i = Math.max(1024, startingPort);
        while (i <= 65535) {
            int n;
            ServerSocket serverSocket = new ServerSocket(i == 1024 ? 80 : i);
            try {
                int port = serverSocket.getLocalPort();
                LOGGER.info("Found available port: {}", (Object)port);
                n = port;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        serverSocket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    ++i;
                }
            }
            serverSocket.close();
            return n;
        }
        return 0;
    }

    public static void openConnectionSafe(String url, Consumer<InputStream> callback, String ... requestProperties) {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setUseCaches(false);
            for (int i = 0; i < requestProperties.length / 2; ++i) {
                connection.setRequestProperty(requestProperties[2 * i], requestProperties[2 * i + 1]);
            }
            try (InputStream inputStream2 = connection.getInputStream();){
                callback.accept(inputStream2);
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public static void openConnectionSafeJson(String url, Consumer<JsonElement> callback, String ... requestProperties) {
        Init.openConnectionSafe(url, inputStream2 -> {
            try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream2, StandardCharsets.UTF_8);){
                callback.accept(JsonParser.parseReader(inputStreamReader));
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
        }, requestProperties);
    }

    public static void writeFromClient() {
        isDedicatedServer = false;
    }

    public static void createWebserverSetup(Consumer<Webserver> webserverSetup) {
        Init.webserverSetup = webserverSetup;
    }

    public static String randomString() {
        return Integer.toHexString(new Random().nextInt());
    }

    private static void depotOperationFromCommand(CommandBuilder<?> commandBuilder, DepotOperation depotOperation) {
        commandBuilder.permissionLevel(2);
        commandBuilder.executes(contextHandler -> {
            contextHandler.sendSuccess(depotOperation.translationHolderAll.key, true, new Object[0]);
            return Init.depotOperationFromCommand(contextHandler.getWorld(), "", depotOperation);
        });
        commandBuilder.then("name", StringArgumentType.greedyString(), innerCommandBuilder -> innerCommandBuilder.executes(contextHandler -> {
            String filter = contextHandler.getString("name");
            contextHandler.sendSuccess(depotOperation.translationHolderName.key, true, filter);
            return Init.depotOperationFromCommand(contextHandler.getWorld(), filter, depotOperation);
        }));
    }

    private static int depotOperationFromCommand(World world, String filter, DepotOperation depotOperation) {
        DepotOperationByName depotOperationByName = new DepotOperationByName();
        depotOperationByName.setFilter(filter);
        Init.sendMessageC2S(depotOperation.operation, world.getServer(), world, depotOperationByName, null, null);
        return 1;
    }

    private static void updatePlayer(ServerPlayerEntity serverPlayerEntity, boolean isRiding) {
        serverPlayerEntity.setFallDistanceMapped(0.0f);
        serverPlayerEntity.setNoGravity(isRiding);
        serverPlayerEntity.setNoClipMapped(isRiding);
        ((PlayerTeleportationStateAccessor)serverPlayerEntity.data).setInTeleportationState(isRiding);
    }

    static {
        canSendWorldTimeUpdate = true;
        isDedicatedServer = true;
        LOGGER = LogManager.getLogger((String)"MinecraftTransitRailway");
        REGISTRY = new Registry();
        REQUEST_HELPER = new RequestHelper();
        RAIL_ACTION_MODULES = new Object2ObjectArrayMap();
        WORLD_ID_LIST = new ObjectArrayList();
        RIDING_PLAYERS = new Object2ObjectAVLTreeMap();
    }

    private static enum DepotOperation {
        GENERATE(TranslationProvider.COMMAND_MTR_GENERATE_ALL, TranslationProvider.COMMAND_MTR_GENERATE_FILTER, "generate_by_depot_name"),
        CLEAR(TranslationProvider.COMMAND_MTR_CLEAR_ALL, TranslationProvider.COMMAND_MTR_CLEAR_FILTER, "clear_by_depot_name"),
        INSTANT_DEPLOY(TranslationProvider.COMMAND_MTR_INSTANT_DEPLOY_ALL, TranslationProvider.COMMAND_MTR_INSTANT_DEPLOY_FILTER, "instant_deploy_by_depot_name");

        private final TranslationProvider.TranslationHolder translationHolderAll;
        private final TranslationProvider.TranslationHolder translationHolderName;
        private final String operation;

        private DepotOperation(TranslationProvider.TranslationHolder translationHolderAll, TranslationProvider.TranslationHolder translationHolderName, String operation) {
            this.translationHolderAll = translationHolderAll;
            this.translationHolderName = translationHolderName;
            this.operation = operation;
        }
    }
}

