/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.packet;

import org.mtr.libraries.it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;
import org.mtr.mod.Init;
import org.mtr.mod.block.BlockSignalBase;

public final class PacketUpdateSignalConfig
extends PacketHandler {
    private final BlockPos blockPos;
    private final IntAVLTreeSet signalColors;
    private final boolean isBackSide;

    public PacketUpdateSignalConfig(PacketBufferReceiver packetBufferReceiver) {
        this.blockPos = BlockPos.fromLong(packetBufferReceiver.readLong());
        int signalColorCount = packetBufferReceiver.readInt();
        this.signalColors = new IntAVLTreeSet();
        for (int i = 0; i < signalColorCount; ++i) {
            this.signalColors.add(packetBufferReceiver.readInt());
        }
        this.isBackSide = packetBufferReceiver.readBoolean();
    }

    public PacketUpdateSignalConfig(BlockPos blockPos, IntAVLTreeSet signalColors, boolean isBackSide) {
        this.blockPos = blockPos;
        this.signalColors = signalColors;
        this.isBackSide = isBackSide;
    }

    @Override
    public void write(PacketBufferSender packetBufferSender) {
        packetBufferSender.writeLong(this.blockPos.asLong());
        packetBufferSender.writeInt(this.signalColors.size());
        this.signalColors.forEach(packetBufferSender::writeInt);
        packetBufferSender.writeBoolean(this.isBackSide);
    }

    @Override
    public void runServer(MinecraftServer minecraftServer, ServerPlayerEntity serverPlayerEntity) {
        if (!Init.isChunkLoaded(serverPlayerEntity.getEntityWorld(), this.blockPos)) {
            return;
        }
        BlockEntity entity = serverPlayerEntity.getEntityWorld().getBlockEntity(this.blockPos);
        if (entity != null && entity.data instanceof BlockSignalBase.BlockEntityBase) {
            ((BlockSignalBase.BlockEntityBase)((Object)entity.data)).setData(this.signalColors, this.isBackSide);
        }
    }
}

